/*
 * Decompiled with CFR 0.152.
 */
package de.hannse.netobjects.datalayer;

import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.objectstore.ObjectStore;
import de.hannse.netobjects.session.Session;
import de.hannse.netobjects.tools.FileManager;
import de.hannse.netobjects.tools.StringHelper;
import de.hannse.netobjects.user.User;
import de.hannse.netobjects.user.UserManager;
import de.hannse.netobjects.util.Log;
import de.hannse.netobjects.util.MilliSpender;
import de.hannse.netobjects.util.MyDate;
import java.io.File;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import mausoleum.extras.MoveResultsToMResults;
import mausoleum.helper.DatumFormat;
import mausoleum.helper.Zeile;
import mausoleum.util.PathStore;

public class GroupFileManager {
    private static final String BACKUP_DIRNAME = "backups";
    private static final String DISABLED_GROUPS_NAME = "dagr.txt";
    public static final String DATA_SUBDIR = "data";
    private static final String PROT_SUBDIR = "protocols";
    private static final String DOCS_SUBDIR = "docs";
    private static final String RESULTS_SUBDIR = "results";
    private static final String USER_SPEC_SUBDIR = "userspecific";
    private static final String MISC_SUBDIR = "misc";
    private static final String TASKS_SUBDIR = "tasks";
    private static final String OLD_SAFETIES_SUB_DIR = "usedsatfiles";
    private static final String REPORTS_SUB_DIR = "reports";
    private static final String CONFIG_SUB_DIR = "config";
    private static final String[] GROUP_SUB_DIRS = new String[]{"data", "protocols", "docs", "results", "userspecific", "misc", "usedsatfiles", "tasks", "reports", "config"};
    private static final String PROT_SUFFIX = ".prot";
    public static final String DATA_FILE_SUFFIX = ".data";
    private static final String GROUP_STANDARD_TASK_PATH = "standardtasks.stxt";
    private static final String DELETED_TASKS_FILENAME = "deletedtasks.stxt";
    private static final String SURROGATE_FILENAME = "surrogate.txt";
    public static final String INDEX_SUFFIX = ".idx";
    private static final String INDEX_FILENAME = "mouse.idx";
    private static final String TEMP_INDEX_FILENAME = "mouse.tidx";
    private static final String TEMP_INDEX_FILENAME_2 = "mouse.t2idx";
    private static final String DEF_LISTS_FILENAME = "deflists.stxt";
    private static final String REPORT_PREFIX = "report_";
    private static final String REPORT_SUFFIX = "_.stxt";
    private static final String REPORT_STATISTICS_FILENAME = "report_YEAR_.stxt";
    public static final String SAFETY_SUFFIX = ".sat";
    public static final String TRAFFIC_NAME = "traffic";
    private static final String KILLED_WITHOUT_STRESS_INPUT = "killedWOSInp.stxt";
    private static final String EARTAG_PREFIX = "let_";
    private static final String EARTAG_PRE_PREFIX = "letpf_";
    private static final String EARTAG_SUFFIX = ".stxt";
    private static final String EARTAG_FILENAME = "let_UID.stxt";
    private static final String EARTAG_PRE_FILENAME = "letpf_UID.stxt";
    private static final String PREFERENCES_SUFFIX = ".def";
    private static final String PRO_SEARCH_SETTINGS_SUFFIX = ".ssd";
    private static final String MULTIDIM_SETTINGS_SUFFIX = ".mdd";
    private static final String SORT_SETTINGS_SUFFIX = "_s.def";
    private static final String KILLED_THIRD_PARTY_SUFFIX = "_killed.stxt";
    static /* synthetic */ Class class$0;

    public static Vector initAndGetGroupnames() {
        FileManager.prepareDirs(PathStore.getServerDir());
        FileManager.prepareDirs(String.valueOf(PathStore.getServerDir()) + "/" + BACKUP_DIRNAME);
        Vector<String> groupNames = new Vector<String>();
        String serverDir = PathStore.getServerDir();
        String nullPath = String.valueOf(serverDir) + "/" + "null";
        if (new File(nullPath).exists()) {
            FileManager.deleteDir(nullPath, true);
        }
        String[] files = new File(serverDir).list();
        int i = 0;
        while (i < files.length) {
            if (new File(String.valueOf(serverDir) + "/" + files[i]).isDirectory() && !files[i].equals(BACKUP_DIRNAME)) {
                groupNames.addElement(files[i]);
            }
            ++i;
        }
        Iterator iterator = groupNames.iterator();
        while (iterator.hasNext()) {
            String group = (String)iterator.next();
            GroupFileManager.prepareGroupDir(group);
        }
        return groupNames;
    }

    public static void prepareGroupDir(String group) {
        if (group != null && !group.equalsIgnoreCase("null")) {
            String string = "Preparing Dir for group " + group;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("de.hannse.netobjects.datalayer.GroupFileManager");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Log.log(string, clazz);
            String groupDir = GroupFileManager.getGroupDir(group);
            FileManager.prepareDirs(groupDir);
            int i = 0;
            while (i < GROUP_SUB_DIRS.length) {
                FileManager.prepareDirs(String.valueOf(GroupFileManager.getGroupDir(group)) + "/" + GROUP_SUB_DIRS[i]);
                ++i;
            }
            String[] files = new File(groupDir).list();
            int i2 = 0;
            while (i2 < files.length) {
                if (files[i2].startsWith("mice_") && files[i2].endsWith(REPORT_SUFFIX)) {
                    FileManager.move(String.valueOf(groupDir) + "/" + files[i2], String.valueOf(groupDir) + "/" + MISC_SUBDIR + "/" + files[i2]);
                } else if (files[i2].startsWith("cages_") && files[i2].endsWith(REPORT_SUFFIX)) {
                    FileManager.move(String.valueOf(groupDir) + "/" + files[i2], String.valueOf(groupDir) + "/" + MISC_SUBDIR + "/" + files[i2]);
                } else if (files[i2].endsWith(PROT_SUFFIX)) {
                    FileManager.move(String.valueOf(groupDir) + "/" + files[i2], String.valueOf(GroupFileManager.getProtocolsPath(group)) + "/" + files[i2]);
                } else if (files[i2].startsWith(EARTAG_PREFIX) && files[i2].endsWith(EARTAG_SUFFIX) || files[i2].endsWith(PREFERENCES_SUFFIX) || files[i2].endsWith(PRO_SEARCH_SETTINGS_SUFFIX) || files[i2].endsWith(SORT_SETTINGS_SUFFIX) || files[i2].endsWith(KILLED_THIRD_PARTY_SUFFIX)) {
                    FileManager.move(String.valueOf(groupDir) + "/" + files[i2], String.valueOf(groupDir) + "/" + USER_SPEC_SUBDIR + "/" + files[i2]);
                } else if (files[i2].endsWith(DATA_FILE_SUFFIX) || files[i2].endsWith(SAFETY_SUFFIX) || files[i2].equals(SURROGATE_FILENAME)) {
                    FileManager.move(String.valueOf(groupDir) + "/" + files[i2], String.valueOf(groupDir) + "/" + DATA_SUBDIR + "/" + files[i2]);
                } else if (files[i2].equals(GROUP_STANDARD_TASK_PATH) || files[i2].equals(DELETED_TASKS_FILENAME)) {
                    FileManager.move(String.valueOf(groupDir) + "/" + files[i2], String.valueOf(groupDir) + "/" + TASKS_SUBDIR + "/" + files[i2]);
                } else if (files[i2].startsWith(REPORT_PREFIX) && files[i2].endsWith(REPORT_SUFFIX)) {
                    FileManager.move(String.valueOf(groupDir) + "/" + files[i2], String.valueOf(groupDir) + "/" + REPORTS_SUB_DIR + "/" + files[i2]);
                } else if (files[i2].equals(DEF_LISTS_FILENAME)) {
                    FileManager.move(String.valueOf(groupDir) + "/" + files[i2], String.valueOf(groupDir) + "/" + CONFIG_SUB_DIR + "/" + files[i2]);
                }
                ++i2;
            }
            int thisYear = new MyDate((GregorianCalendar)new GregorianCalendar()).ivJahr;
            String protPath = GroupFileManager.getProtocolsPath(group);
            files = new File(protPath).list();
            HashMap<Integer, Vector[]> oldFilesByYear = new HashMap<Integer, Vector[]>();
            int i3 = 0;
            while (i3 < files.length) {
                Zeile z;
                int year;
                if (files[i3].endsWith(PROT_SUFFIX) && (year = (z = new Zeile(files[i3].substring(0, files[i3].length() - PROT_SUFFIX.length()), '_')).getInt(1, Integer.MAX_VALUE)) < thisYear) {
                    Integer key = new Integer(year);
                    Vector[] varr = (Vector[])oldFilesByYear.get(key);
                    if (varr == null) {
                        varr = new Vector[]{new Vector(), new Vector()};
                        oldFilesByYear.put(key, varr);
                    }
                    varr[0].add(String.valueOf(protPath) + "/" + files[i3]);
                    varr[1].add(files[i3]);
                }
                ++i3;
            }
            Iterator iterator = oldFilesByYear.keySet().iterator();
            while (iterator.hasNext()) {
                Vector[] varr;
                Integer year = (Integer)iterator.next();
                String zippath = String.valueOf(protPath) + "/" + year + "_" + MilliSpender.getMillis() + ".zip";
                if (!FileManager.zipFiles(zippath, (varr = (Vector[])oldFilesByYear.get(year))[0], varr[1])) continue;
                Iterator iterator2 = varr[0].iterator();
                while (iterator2.hasNext()) {
                    String path = (String)iterator2.next();
                    FileManager.deleteFile(path);
                }
            }
            MoveResultsToMResults.moveIt(group);
        }
    }

    public static String getBackupsPath() {
        return String.valueOf(PathStore.getServerDir()) + "/" + BACKUP_DIRNAME;
    }

    public static String getBackupsDirName() {
        return BACKUP_DIRNAME;
    }

    public static String getDisabledGroupsPath() {
        return String.valueOf(PathStore.getServerDir()) + "/" + DISABLED_GROUPS_NAME;
    }

    public static String getGroupDir(String group) {
        if (group == null) {
            String dir = "temp/maverick_" + DatumFormat.getBackupDateTimeString(new GregorianCalendar());
            FileManager.prepareDirs(dir);
            return dir;
        }
        return String.valueOf(PathStore.getServerDir()) + "/" + group;
    }

    public static String getMiscDir(String group) {
        return String.valueOf(GroupFileManager.getGroupDir(group)) + "/" + MISC_SUBDIR;
    }

    public static void addToCommandProtocol(String group, String commandLines, Session sess) {
        User usi;
        String dir = String.valueOf(GroupFileManager.getGroupDir(group)) + "/" + PROT_SUBDIR;
        MyDate md = new MyDate(new GregorianCalendar());
        String path = String.valueOf(dir) + "/commands_" + md.ivJahr + "_" + md.ivMonat + PROT_SUFFIX;
        StringBuilder msb = new StringBuilder();
        msb.append("-------------------\n");
        msb.append(DatumFormat.getProtDateTimeString(md)).append("\n");
        if (sess != null && (usi = (User)ObjectStore.getObjectDeadOrAlive(6, sess.getLong("SES_USER"), sess.getGroup(), null, false)) != null) {
            msb.append("User: ").append(usi.getBrowseName()).append("\n");
        }
        msb.append("-------------------\n");
        msb.append(commandLines);
        msb.append("\n");
        FileManager.appendStringToServerFile(path, msb.toString());
    }

    public static String getStandardTaskPath(String group) {
        return String.valueOf(GroupFileManager.getGroupDir(group)) + "/" + TASKS_SUBDIR + "/" + GROUP_STANDARD_TASK_PATH;
    }

    public static String getTypeProtocolPath(String group, String typeString) {
        return GroupFileManager.getTypeProtocolPath(group, typeString, new MyDate(new GregorianCalendar()));
    }

    public static String getTypeProtocolPath(String group, String typeString, MyDate md) {
        return String.valueOf(GroupFileManager.getProtocolsPath(group)) + "/" + GroupFileManager.getTypeProtocolFilename(typeString, md);
    }

    public static String getTypeProtocolFilename(String typeString, MyDate md) {
        return String.valueOf(typeString) + "_" + md.ivJahr + "_" + md.ivMonat + PROT_SUFFIX;
    }

    public static String getDataDirPath(String group) {
        return String.valueOf(GroupFileManager.getGroupDir(group)) + "/" + DATA_SUBDIR;
    }

    public static String getDataFilePath(String group, String typeString) {
        return String.valueOf(GroupFileManager.getGroupDir(group)) + "/" + DATA_SUBDIR + "/" + typeString + DATA_FILE_SUFFIX;
    }

    public static String getSurrogateFilePath(String group) {
        return String.valueOf(GroupFileManager.getGroupDir(group)) + "/" + DATA_SUBDIR + "/" + SURROGATE_FILENAME;
    }

    public static String getIndexFilePath(String group) {
        return String.valueOf(GroupFileManager.getGroupDir(group)) + "/" + DATA_SUBDIR + "/" + INDEX_FILENAME;
    }

    public static String getIndexFilename() {
        return INDEX_FILENAME;
    }

    public static String getIndexTEMPFilePath(String group) {
        return String.valueOf(GroupFileManager.getGroupDir(group)) + "/" + TEMP_INDEX_FILENAME;
    }

    public static String getIndexTEMP2FilePath(String group) {
        return String.valueOf(GroupFileManager.getGroupDir(group)) + "/" + TEMP_INDEX_FILENAME_2;
    }

    public static String getReportsDir(String group) {
        return String.valueOf(GroupFileManager.getGroupDir(group)) + "/" + REPORTS_SUB_DIR;
    }

    public static String getUserSpecDir() {
        return GroupFileManager.getUserSpecDir(UserManager.getUserGroupWithoutDisguise());
    }

    public static String getUserSpecDir(String group) {
        return String.valueOf(GroupFileManager.getGroupDir(group)) + "/" + USER_SPEC_SUBDIR;
    }

    public static String getUserSortDefPath() {
        return String.valueOf(GroupFileManager.getUserSpecDir()) + "/" + UserManager.getUserIDWithoutDisguise() + SORT_SETTINGS_SUFFIX;
    }

    public static String getKilledThirdPartyFilename(String group, long userID) {
        return String.valueOf(GroupFileManager.getUserSpecDir(group)) + "/" + userID + KILLED_THIRD_PARTY_SUFFIX;
    }

    public static String getProSearchSettingsPath() {
        return String.valueOf(GroupFileManager.getUserSpecDir()) + "/" + UserManager.getUserIDWithoutDisguise() + PRO_SEARCH_SETTINGS_SUFFIX;
    }

    public static String getMultiDimDefPath() {
        return String.valueOf(GroupFileManager.getUserSpecDir()) + "/" + UserManager.getUserIDWithoutDisguise() + MULTIDIM_SETTINGS_SUFFIX;
    }

    public static String getKilledWithoutStressInputPath(String group) {
        return String.valueOf(GroupFileManager.getReportsDir(group)) + "/" + KILLED_WITHOUT_STRESS_INPUT;
    }

    public static String getPreferencesPath(String group, long uid) {
        return String.valueOf(GroupFileManager.getGroupDir(group)) + "/" + USER_SPEC_SUBDIR + "/" + uid + PREFERENCES_SUFFIX;
    }

    public static String getDocsPath(String group) {
        return String.valueOf(GroupFileManager.getGroupDir(group)) + "/" + DOCS_SUBDIR;
    }

    public static String getOldSafetiesPath(String group) {
        return String.valueOf(GroupFileManager.getGroupDir(group)) + "/" + OLD_SAFETIES_SUB_DIR;
    }

    public static String getProtocolsPath(String group) {
        return String.valueOf(GroupFileManager.getGroupDir(group)) + "/" + PROT_SUBDIR;
    }

    public static String getDocsDirWithoutGroup() {
        return DOCS_SUBDIR;
    }

    public static String getLastEartagPath() {
        return GroupFileManager.getLastEartagPath(EARTAG_FILENAME);
    }

    public static String getLastEartagPrefixPath() {
        return GroupFileManager.getLastEartagPath(EARTAG_PRE_FILENAME);
    }

    private static String getLastEartagPath(String muster) {
        return String.valueOf(GroupFileManager.getUserSpecDir()) + "/" + StringHelper.gSub(muster, "UID", Long.toString(UserManager.getUserIDWithoutDisguise()), true);
    }

    public static String getDeletedTaskPath(IDObject ido) {
        return GroupFileManager.getDeletedTaskPath(ido.getGroup());
    }

    public static String getDeletedTaskPath(String group) {
        if (group != null) {
            return String.valueOf(GroupFileManager.getGroupDir(group)) + "/" + TASKS_SUBDIR + "/" + DELETED_TASKS_FILENAME;
        }
        return null;
    }

    public static String getListDefFilePath(String group) {
        return String.valueOf(GroupFileManager.getConfigDirPath(group)) + "/" + DEF_LISTS_FILENAME;
    }

    public static String getConfigDirPath(String group) {
        return String.valueOf(GroupFileManager.getGroupDir(group)) + "/" + CONFIG_SUB_DIR;
    }

    public static String getResultsPath(String group) {
        return String.valueOf(GroupFileManager.getGroupDir(group)) + "/" + RESULTS_SUBDIR;
    }

    public static String getReportsFileNamePattern() {
        return REPORT_STATISTICS_FILENAME;
    }

    public static String getNewSafetyFilePath(String group) {
        return String.valueOf(GroupFileManager.getDataDirPath(group)) + "/" + MilliSpender.getMillis() + SAFETY_SUFFIX;
    }

    public static String getMiscPath(String group) {
        return String.valueOf(GroupFileManager.getGroupDir(group)) + "/" + MISC_SUBDIR;
    }

    public static Vector collectSafetyFileNames(String group) {
        Vector<String> safetyFilePaths = new Vector<String>();
        String dir = GroupFileManager.getDataDirPath(group);
        File f = new File(dir);
        if (f.exists() && f.isDirectory()) {
            String[] files = f.list();
            int i = 0;
            while (i < files.length) {
                String file = files[i];
                if (file.endsWith(SAFETY_SUFFIX)) {
                    safetyFilePaths.addElement(file);
                }
                ++i;
            }
        }
        return safetyFilePaths;
    }
}

