/*
 * Decompiled with CFR 0.152.
 */
package de.hannse.netobjects.datalayer.dfa;

import de.hannse.netobjects.datalayer.DataLayer;
import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.objectstore.ObjectIndex;
import de.hannse.netobjects.objectstore.ObjectPortal;
import de.hannse.netobjects.objectstore.ObjectProvider;
import de.hannse.netobjects.objectstore.ObjectRequest;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import mausoleum.db.DBAssistant;
import mausoleum.main.ProcessDefinition;
import mausoleum.objectstore.IndexChecker;

public class IntermediaerHelfer {
    public static String getIndex(String group, Long id) {
        return ObjectIndex.getOIIndex(group, id);
    }

    public static HashSet getIndexIds(int indexCol, String group, Object key) {
        return ObjectIndex.getIndexIds(indexCol, group, key);
    }

    public static void giveIndicesToChecker(IndexChecker rep, String group) {
        ObjectIndex.giveIndicesToChecker(rep, group);
    }

    public static void getGenealogy(ObjectRequest or, String group, long id, boolean parents, int runden) {
        if (DataLayer.USE_DB) {
            DBAssistant.getGenealogy(or, group, id, parents, runden);
        } else {
            ObjectIndex.getGenealogy(or, group, id, parents, runden);
        }
    }

    public static int getActualObjectCount(String group, int typ) {
        if (DataLayer.USE_DB) {
            return DBAssistant.getActualObjectCount(group, typ);
        }
        ObjectProvider oprov = ObjectPortal.getObjectProvider(group, typ);
        if (oprov != null) {
            return oprov.getAnzActualObjects();
        }
        return 0;
    }

    public static Iterator getActualObjectsITER(int type, String group) {
        if (DataLayer.USE_DB) {
            return DBAssistant.getAllActualObjects(group, type).values().iterator();
        }
        ObjectProvider op = ObjectPortal.getObjectProvider(group, type);
        if (op != null) {
            return op.getActualObjectsIter();
        }
        return null;
    }

    public static Vector getActualObjects(int type, String group) {
        if (ProcessDefinition.isServer()) {
            Vector<Object> v = new Vector<Object>(200);
            if (DataLayer.USE_DB) {
                Hashtable ht = DBAssistant.getAllActualObjects(group, type);
                v.addAll(ht.values());
                ht.clear();
                ht = null;
            } else {
                ObjectProvider op = ObjectPortal.getObjectProvider(group, type);
                if (op != null) {
                    Enumeration en = op.getActualObjects();
                    while (en.hasMoreElements()) {
                        v.add(en.nextElement());
                    }
                }
            }
            return v;
        }
        return null;
    }

    public static Iterator getActualObjectsIter(int type, String group) {
        if (ProcessDefinition.isServer()) {
            if (DataLayer.USE_DB) {
                Hashtable ht = DBAssistant.getAllActualObjects(group, type);
                return ht.values().iterator();
            }
            ObjectProvider op = ObjectPortal.getObjectProvider(group, type);
            if (op != null) {
                return op.getActualObjectsIter();
            }
        }
        return null;
    }

    public static IDObject getObjectDeadOrAlive(String group, int type, long id, boolean onlyActual, boolean evenNonExisteds) {
        if (DataLayer.USE_DB) {
            IDObject ido = DBAssistant.getObject(group, type, id, onlyActual);
            if (ido != null && (ido.existed() || evenNonExisteds)) {
                return ido;
            }
        } else {
            ObjectProvider op = ObjectPortal.getObjectProvider(group, type);
            if (op != null) {
                return op.getObjectDeadOrAlive(id, onlyActual, evenNonExisteds);
            }
        }
        return null;
    }

    public static char getIndexSeparator() {
        return ' ';
    }

    public static int getLineCol() {
        return 7;
    }

    public static int getLicenseCol() {
        return 6;
    }

    public static int getResultsCol() {
        return 10;
    }

    public static int getStartCol() {
        return 3;
    }

    public static int getEndCol() {
        return 5;
    }

    public static int getBirthdayCol() {
        return 4;
    }

    public static int getParentsCol() {
        return 2;
    }

    public static int getSexCol() {
        return 1;
    }

    public static int getStrainsCol() {
        return 8;
    }
}

