/*
 * Decompiled with CFR 0.152.
 */
package de.hannse.netobjects.java;

import de.hannse.netobjects.java.CreatorByteStep;
import de.hannse.netobjects.java.CreatorClassStep;
import de.hannse.netobjects.java.CreatorCodeAttribute;
import de.hannse.netobjects.java.CreatorFieldStep;
import de.hannse.netobjects.java.CreatorInvokeStep;
import de.hannse.netobjects.java.CreatorShortStep;
import de.hannse.netobjects.java.CreatorSingleStep;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class CreatorOpcodes {
    private static final int NIX = 0;
    private static final int SINGLE = 1;
    private static final int BYTE = 2;
    private static final int SHORT = 3;
    private static final int JUMP = 4;
    private static final int INVOKE = 5;
    private static final int FIELD = 6;
    private static final int CLASS = 7;
    private static final int CONST = 8;
    private static Hashtable cvOpcodes = new Hashtable();
    private static Hashtable cvInvOpcodes = new Hashtable();
    private static Hashtable cvOpmodes = new Hashtable();

    static {
        CreatorOpcodes.enterOpcode((byte)0, "nop", 1);
        CreatorOpcodes.enterOpcode((byte)1, "aconst_null", 1);
        CreatorOpcodes.enterOpcode((byte)2, "iconst_m1", 1);
        CreatorOpcodes.enterOpcode((byte)3, "iconst_0", 1);
        CreatorOpcodes.enterOpcode((byte)4, "iconst_1", 1);
        CreatorOpcodes.enterOpcode((byte)5, "iconst_2", 1);
        CreatorOpcodes.enterOpcode((byte)6, "iconst_3", 1);
        CreatorOpcodes.enterOpcode((byte)7, "iconst_4", 1);
        CreatorOpcodes.enterOpcode((byte)8, "iconst_5", 1);
        CreatorOpcodes.enterOpcode((byte)9, "lconst_0", 1);
        CreatorOpcodes.enterOpcode((byte)10, "lconst_1", 1);
        CreatorOpcodes.enterOpcode((byte)11, "fconst_0", 1);
        CreatorOpcodes.enterOpcode((byte)12, "fconst_1", 1);
        CreatorOpcodes.enterOpcode((byte)13, "fconst_2", 1);
        CreatorOpcodes.enterOpcode((byte)14, "dconst_0", 1);
        CreatorOpcodes.enterOpcode((byte)15, "dconst_1", 1);
        CreatorOpcodes.enterOpcode((byte)16, "bipush", 2);
        CreatorOpcodes.enterOpcode((byte)17, "sipush", 3);
        CreatorOpcodes.enterOpcode((byte)18, "ldc", 8);
        CreatorOpcodes.enterOpcode((byte)19, "ldc_w", 0);
        CreatorOpcodes.enterOpcode((byte)20, "ldc2_w", 0);
        CreatorOpcodes.enterOpcode((byte)21, "iload", 0);
        CreatorOpcodes.enterOpcode((byte)22, "lload", 0);
        CreatorOpcodes.enterOpcode((byte)23, "fload", 0);
        CreatorOpcodes.enterOpcode((byte)24, "dload", 0);
        CreatorOpcodes.enterOpcode((byte)25, "aload", 0);
        CreatorOpcodes.enterOpcode((byte)26, "iload_0", 1);
        CreatorOpcodes.enterOpcode((byte)27, "iload_1", 1);
        CreatorOpcodes.enterOpcode((byte)28, "iload_2", 1);
        CreatorOpcodes.enterOpcode((byte)29, "iload_3", 1);
        CreatorOpcodes.enterOpcode((byte)30, "lload_0", 1);
        CreatorOpcodes.enterOpcode((byte)31, "lload_1", 1);
        CreatorOpcodes.enterOpcode((byte)32, "lload_2", 1);
        CreatorOpcodes.enterOpcode((byte)33, "lload_3", 1);
        CreatorOpcodes.enterOpcode((byte)34, "fload_0", 1);
        CreatorOpcodes.enterOpcode((byte)35, "fload_1", 1);
        CreatorOpcodes.enterOpcode((byte)36, "fload_2", 1);
        CreatorOpcodes.enterOpcode((byte)37, "fload_3", 1);
        CreatorOpcodes.enterOpcode((byte)38, "dload_0", 1);
        CreatorOpcodes.enterOpcode((byte)39, "dload_1", 1);
        CreatorOpcodes.enterOpcode((byte)40, "dload_2", 1);
        CreatorOpcodes.enterOpcode((byte)41, "dload_3", 1);
        CreatorOpcodes.enterOpcode((byte)42, "aload_0", 1);
        CreatorOpcodes.enterOpcode((byte)43, "aload_1", 1);
        CreatorOpcodes.enterOpcode((byte)44, "aload_2", 1);
        CreatorOpcodes.enterOpcode((byte)45, "aload_3", 1);
        CreatorOpcodes.enterOpcode((byte)46, "iaload", 1);
        CreatorOpcodes.enterOpcode((byte)47, "laload", 1);
        CreatorOpcodes.enterOpcode((byte)48, "faload", 1);
        CreatorOpcodes.enterOpcode((byte)49, "daload", 1);
        CreatorOpcodes.enterOpcode((byte)50, "aaload", 1);
        CreatorOpcodes.enterOpcode((byte)51, "baload", 1);
        CreatorOpcodes.enterOpcode((byte)52, "caload", 1);
        CreatorOpcodes.enterOpcode((byte)53, "saload", 1);
        CreatorOpcodes.enterOpcode((byte)54, "istore", 0);
        CreatorOpcodes.enterOpcode((byte)55, "lstore", 0);
        CreatorOpcodes.enterOpcode((byte)56, "fstore", 0);
        CreatorOpcodes.enterOpcode((byte)57, "dstore", 0);
        CreatorOpcodes.enterOpcode((byte)58, "astore", 0);
        CreatorOpcodes.enterOpcode((byte)59, "istore_0", 1);
        CreatorOpcodes.enterOpcode((byte)60, "istore_1", 1);
        CreatorOpcodes.enterOpcode((byte)61, "istore_2", 1);
        CreatorOpcodes.enterOpcode((byte)62, "istore_3", 1);
        CreatorOpcodes.enterOpcode((byte)63, "lstore_0", 0);
        CreatorOpcodes.enterOpcode((byte)64, "lstore_1", 0);
        CreatorOpcodes.enterOpcode((byte)65, "lstore_2", 0);
        CreatorOpcodes.enterOpcode((byte)66, "lstore_3", 0);
        CreatorOpcodes.enterOpcode((byte)67, "fstore_0", 0);
        CreatorOpcodes.enterOpcode((byte)68, "fstore_1", 0);
        CreatorOpcodes.enterOpcode((byte)69, "fstore_2", 0);
        CreatorOpcodes.enterOpcode((byte)70, "fstore_3", 0);
        CreatorOpcodes.enterOpcode((byte)71, "dstore_0", 0);
        CreatorOpcodes.enterOpcode((byte)72, "dstore_1", 0);
        CreatorOpcodes.enterOpcode((byte)73, "dstore_2", 0);
        CreatorOpcodes.enterOpcode((byte)74, "dstore_3", 0);
        CreatorOpcodes.enterOpcode((byte)75, "astore_0", 1);
        CreatorOpcodes.enterOpcode((byte)76, "astore_1", 1);
        CreatorOpcodes.enterOpcode((byte)77, "astore_2", 1);
        CreatorOpcodes.enterOpcode((byte)78, "astore_3", 1);
        CreatorOpcodes.enterOpcode((byte)79, "iastore", 1);
        CreatorOpcodes.enterOpcode((byte)80, "lastore", 1);
        CreatorOpcodes.enterOpcode((byte)81, "fastore", 1);
        CreatorOpcodes.enterOpcode((byte)82, "dastore", 1);
        CreatorOpcodes.enterOpcode((byte)83, "aastore", 1);
        CreatorOpcodes.enterOpcode((byte)84, "bastore", 1);
        CreatorOpcodes.enterOpcode((byte)85, "castore", 1);
        CreatorOpcodes.enterOpcode((byte)86, "sastore", 1);
        CreatorOpcodes.enterOpcode((byte)87, "pop", 1);
        CreatorOpcodes.enterOpcode((byte)88, "pop2", 1);
        CreatorOpcodes.enterOpcode((byte)89, "dup", 1);
        CreatorOpcodes.enterOpcode((byte)90, "dup_x1", 1);
        CreatorOpcodes.enterOpcode((byte)91, "dup_x2", 1);
        CreatorOpcodes.enterOpcode((byte)92, "dup2", 1);
        CreatorOpcodes.enterOpcode((byte)93, "dup2_x1", 1);
        CreatorOpcodes.enterOpcode((byte)94, "dup2_x2", 1);
        CreatorOpcodes.enterOpcode((byte)95, "swap", 1);
        CreatorOpcodes.enterOpcode((byte)96, "iadd", 1);
        CreatorOpcodes.enterOpcode((byte)97, "ladd", 1);
        CreatorOpcodes.enterOpcode((byte)98, "fadd", 1);
        CreatorOpcodes.enterOpcode((byte)99, "dadd", 1);
        CreatorOpcodes.enterOpcode((byte)100, "isub", 1);
        CreatorOpcodes.enterOpcode((byte)101, "lsub", 1);
        CreatorOpcodes.enterOpcode((byte)102, "fsub", 1);
        CreatorOpcodes.enterOpcode((byte)103, "dsub", 1);
        CreatorOpcodes.enterOpcode((byte)104, "imul", 1);
        CreatorOpcodes.enterOpcode((byte)105, "lmul", 1);
        CreatorOpcodes.enterOpcode((byte)106, "fmul", 1);
        CreatorOpcodes.enterOpcode((byte)107, "dmul", 1);
        CreatorOpcodes.enterOpcode((byte)108, "idiv", 1);
        CreatorOpcodes.enterOpcode((byte)109, "ldiv", 1);
        CreatorOpcodes.enterOpcode((byte)110, "fdiv", 1);
        CreatorOpcodes.enterOpcode((byte)111, "ddiv", 1);
        CreatorOpcodes.enterOpcode((byte)112, "irem", 1);
        CreatorOpcodes.enterOpcode((byte)113, "lrem", 1);
        CreatorOpcodes.enterOpcode((byte)114, "frem", 1);
        CreatorOpcodes.enterOpcode((byte)115, "drem", 1);
        CreatorOpcodes.enterOpcode((byte)116, "ineg", 1);
        CreatorOpcodes.enterOpcode((byte)117, "lneg", 1);
        CreatorOpcodes.enterOpcode((byte)118, "fneg", 1);
        CreatorOpcodes.enterOpcode((byte)119, "dneg", 1);
        CreatorOpcodes.enterOpcode((byte)120, "ishl", 1);
        CreatorOpcodes.enterOpcode((byte)121, "lshl", 1);
        CreatorOpcodes.enterOpcode((byte)122, "ishr", 1);
        CreatorOpcodes.enterOpcode((byte)123, "lshr", 1);
        CreatorOpcodes.enterOpcode((byte)124, "iushr", 1);
        CreatorOpcodes.enterOpcode((byte)125, "lushr", 1);
        CreatorOpcodes.enterOpcode((byte)126, "iand", 1);
        CreatorOpcodes.enterOpcode((byte)127, "land", 1);
        CreatorOpcodes.enterOpcode((byte)-128, "ior", 1);
        CreatorOpcodes.enterOpcode((byte)-127, "lor", 1);
        CreatorOpcodes.enterOpcode((byte)-126, "ixor", 1);
        CreatorOpcodes.enterOpcode((byte)-125, "lxor", 1);
        CreatorOpcodes.enterOpcode((byte)-124, "iinc", 0);
        CreatorOpcodes.enterOpcode((byte)-123, "i2l", 1);
        CreatorOpcodes.enterOpcode((byte)-122, "i2f", 1);
        CreatorOpcodes.enterOpcode((byte)-121, "i2d", 1);
        CreatorOpcodes.enterOpcode((byte)-120, "l2i", 1);
        CreatorOpcodes.enterOpcode((byte)-119, "l2f", 1);
        CreatorOpcodes.enterOpcode((byte)-118, "l2d", 1);
        CreatorOpcodes.enterOpcode((byte)-117, "f2i", 1);
        CreatorOpcodes.enterOpcode((byte)-116, "f2l", 1);
        CreatorOpcodes.enterOpcode((byte)-115, "f2d", 1);
        CreatorOpcodes.enterOpcode((byte)-114, "d2i", 1);
        CreatorOpcodes.enterOpcode((byte)-113, "d2l", 1);
        CreatorOpcodes.enterOpcode((byte)-112, "d2f", 1);
        CreatorOpcodes.enterOpcode((byte)-111, "i2b", 1);
        CreatorOpcodes.enterOpcode((byte)-110, "i2c", 1);
        CreatorOpcodes.enterOpcode((byte)-109, "i2s", 1);
        CreatorOpcodes.enterOpcode((byte)-108, "lcmp", 0);
        CreatorOpcodes.enterOpcode((byte)-107, "fcmpl", 0);
        CreatorOpcodes.enterOpcode((byte)-106, "fcmpg", 0);
        CreatorOpcodes.enterOpcode((byte)-105, "dcmpl", 0);
        CreatorOpcodes.enterOpcode((byte)-104, "dcmpg", 0);
        CreatorOpcodes.enterOpcode((byte)-103, "ifeq", 4);
        CreatorOpcodes.enterOpcode((byte)-102, "ifne", 4);
        CreatorOpcodes.enterOpcode((byte)-101, "iflt", 4);
        CreatorOpcodes.enterOpcode((byte)-100, "ifge", 4);
        CreatorOpcodes.enterOpcode((byte)-99, "ifgt", 4);
        CreatorOpcodes.enterOpcode((byte)-98, "ifle", 4);
        CreatorOpcodes.enterOpcode((byte)-97, "if_icmpeq", 4);
        CreatorOpcodes.enterOpcode((byte)-96, "if_icmpne", 4);
        CreatorOpcodes.enterOpcode((byte)-95, "if_icmplt", 4);
        CreatorOpcodes.enterOpcode((byte)-94, "if_icmpge", 4);
        CreatorOpcodes.enterOpcode((byte)-93, "if_icmpgt", 4);
        CreatorOpcodes.enterOpcode((byte)-92, "if_icmple", 4);
        CreatorOpcodes.enterOpcode((byte)-91, "if_acmpeq", 4);
        CreatorOpcodes.enterOpcode((byte)-90, "if_acmpne", 4);
        CreatorOpcodes.enterOpcode((byte)-89, "goto", 4);
        CreatorOpcodes.enterOpcode((byte)-88, "jsr", 4);
        CreatorOpcodes.enterOpcode((byte)-87, "ret", 1);
        CreatorOpcodes.enterOpcode((byte)-86, "tableswitch", 0);
        CreatorOpcodes.enterOpcode((byte)-85, "lookupswitch", 0);
        CreatorOpcodes.enterOpcode((byte)-84, "ireturn", 1);
        CreatorOpcodes.enterOpcode((byte)-83, "lreturn", 1);
        CreatorOpcodes.enterOpcode((byte)-82, "freturn", 1);
        CreatorOpcodes.enterOpcode((byte)-81, "dreturn", 1);
        CreatorOpcodes.enterOpcode((byte)-80, "areturn", 1);
        CreatorOpcodes.enterOpcode((byte)-79, "return", 1);
        CreatorOpcodes.enterOpcode((byte)-78, "getstatic", 6);
        CreatorOpcodes.enterOpcode((byte)-77, "putstatic", 6);
        CreatorOpcodes.enterOpcode((byte)-76, "getfield", 6);
        CreatorOpcodes.enterOpcode((byte)-75, "putfield", 6);
        CreatorOpcodes.enterOpcode((byte)-74, "invokevirtual", 5);
        CreatorOpcodes.enterOpcode((byte)-73, "invokespecial", 5);
        CreatorOpcodes.enterOpcode((byte)-72, "invokestatic", 5);
        CreatorOpcodes.enterOpcode((byte)-71, "invokeinterface", 5);
        CreatorOpcodes.enterOpcode((byte)-70, "xxxunusedxxx1", 0);
        CreatorOpcodes.enterOpcode((byte)-69, "new", 7);
        CreatorOpcodes.enterOpcode((byte)-68, "newarray", 2);
        CreatorOpcodes.enterOpcode((byte)-67, "anewarray", 7);
        CreatorOpcodes.enterOpcode((byte)-66, "arraylength", 1);
        CreatorOpcodes.enterOpcode((byte)-65, "athrow", 0);
        CreatorOpcodes.enterOpcode((byte)-64, "checkcast", 0);
        CreatorOpcodes.enterOpcode((byte)-63, "instanceof", 0);
        CreatorOpcodes.enterOpcode((byte)-62, "monitorenter", 0);
        CreatorOpcodes.enterOpcode((byte)-61, "monitorexit", 0);
        CreatorOpcodes.enterOpcode((byte)-60, "wide", 0);
        CreatorOpcodes.enterOpcode((byte)-59, "multianewarray", 0);
        CreatorOpcodes.enterOpcode((byte)-58, "ifnull", 4);
        CreatorOpcodes.enterOpcode((byte)-57, "ifnonnull", 4);
        CreatorOpcodes.enterOpcode((byte)-56, "goto_w", 0);
        CreatorOpcodes.enterOpcode((byte)-55, "jsr_w", 0);
        CreatorOpcodes.enterOpcode((byte)-54, "breakpoint", 0);
        CreatorOpcodes.enterOpcode((byte)-2, "impdep1", 0);
        CreatorOpcodes.enterOpcode((byte)-1, "impdep2", 0);
    }

    private static void enterOpcode(byte b, String o, int mode) {
        cvOpcodes.put(o, new Byte(b));
        cvOpmodes.put(o, new Integer(mode));
        cvInvOpcodes.put(new Byte(b), o);
    }

    public static byte getCommand(String opcode) {
        Byte bytti = (Byte)cvOpcodes.get(opcode);
        if (bytti == null) {
            return 0;
        }
        return bytti;
    }

    public static void addLine(CreatorCodeAttribute cca, String line) {
        StringTokenizer st = new StringTokenizer(line, " ");
        String comm = st.nextToken();
        Integer inti = (Integer)cvOpmodes.get(comm);
        int mode = inti;
        if (mode == 0) {
            System.out.println("NIXMODE " + comm);
            return;
        }
        byte toc = CreatorOpcodes.getCommand(comm);
        int tv = 0;
        switch (mode) {
            case 1: {
                cca.ivSteps.addElement(new CreatorSingleStep(toc));
                ++cca.ivStepCount;
                break;
            }
            case 2: {
                tv = Integer.parseInt(st.nextToken());
                cca.ivSteps.addElement(new CreatorByteStep(toc, tv));
                cca.ivStepCount += 2;
                break;
            }
            case 3: {
                tv = Integer.parseInt(st.nextToken());
                cca.ivSteps.addElement(new CreatorShortStep(toc, tv));
                cca.ivStepCount += 3;
                break;
            }
            case 4: {
                tv = Integer.parseInt(st.nextToken());
                cca.ivSteps.addElement(new CreatorShortStep(toc, tv - cca.ivStepCount));
                cca.ivStepCount += 3;
                break;
            }
            case 5: {
                cca.ivSteps.addElement(new CreatorInvokeStep(toc, st.nextToken(), st.nextToken(), st.nextToken()));
                cca.ivStepCount += 3;
                break;
            }
            case 6: {
                cca.ivSteps.addElement(new CreatorFieldStep(toc, st.nextToken(), st.nextToken(), st.nextToken()));
                cca.ivStepCount += 3;
                break;
            }
            case 7: {
                cca.ivSteps.addElement(new CreatorClassStep(toc, st.nextToken()));
                cca.ivStepCount += 3;
                break;
            }
        }
    }
}

