/*
 * Decompiled with CFR 0.152.
 */
package de.hannse.netobjects.network;

import de.hannse.netobjects.network.Communicator;
import de.hannse.netobjects.objectstore.requesthandler.ObjectRequestHandler;
import de.hannse.netobjects.util.Log;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OptionalDataException;
import java.net.SocketException;

public abstract class NetReceiver
extends Thread {
    public static final byte COM_TIME = 1;
    public static final byte COM_KILL = 2;
    public static final int MAX_EOF_IN_ROW = 5;
    private DataInputStream ivInputStream;
    private ObjectInputStream ivObjectInputStream;
    protected Communicator ivCommunicator;
    protected boolean ivShouldRun = true;
    protected ObjectRequestHandler ivRequestHandler;
    protected int ivEOFZaehler = 0;
    protected boolean ivShouldReceive = true;
    static /* synthetic */ Class class$0;

    public NetReceiver(Communicator communicator, InputStream is) {
        this.ivCommunicator = communicator;
        try {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("de.hannse.netobjects.network.NetReceiver");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Log.log("Using DataInputStream for communication", clazz);
            this.ivInputStream = is != null ? (DataInputStream)is : new DataInputStream(this.ivCommunicator.ivSocket.getInputStream());
        }
        catch (Throwable e) {
            Log.error("IOException while Starting NetReceiver using socket: " + this.getSocketIdentifier(), e, this);
        }
    }

    public void setShouldRun(boolean shouldRun) {
        this.ivShouldRun = shouldRun;
    }

    public void commitSuicide() {
        if (this.ivShouldRun) {
            this.ivShouldRun = false;
            this.ivCommunicator = null;
            try {
                this.ivInputStream.close();
            }
            catch (Throwable e) {
                Log.error("IOException while committing suicide using socket: " + this.getSocketIdentifier(), e, this);
            }
        }
    }

    public void setShouldReceive(boolean shouldReceive) {
        this.ivShouldReceive = shouldReceive;
    }

    public void endYourSession() {
    }

    protected Object getNextObject() throws ClassNotFoundException, OptionalDataException, IOException, EOFException, Throwable {
        if (!this.ivShouldRun || !this.ivShouldReceive) {
            return null;
        }
        int objectSize = 0;
        try {
            objectSize = this.ivInputStream.readInt();
        }
        catch (EOFException e) {
            if (!this.ivShouldRun) {
                return null;
            }
            throw e;
        }
        catch (SocketException e) {
            if (!this.ivShouldRun) {
                return null;
            }
            throw e;
        }
        catch (Throwable e) {
            if (this.ivShouldRun) {
                Log.error("Problem while trying to receive data using socket: " + this.getSocketIdentifier(), e, this);
                throw e;
            }
            return null;
        }
        if (!this.ivShouldRun) {
            return null;
        }
        switch (objectSize) {
            case 1: {
                return new Byte(this.ivInputStream.readByte());
            }
            case 8: {
                return new Long(this.ivInputStream.readLong());
            }
        }
        if (!this.ivShouldRun) {
            return null;
        }
        byte[] tb = new byte[objectSize];
        this.ivInputStream.readFully(tb);
        ByteArrayInputStream bis = new ByteArrayInputStream(tb);
        ObjectInputStream ois = new ObjectInputStream(bis);
        Object erg = ois.readObject();
        ois.close();
        bis.close();
        return erg;
    }

    private String getSocketIdentifier() {
        String socketIdentifier = "<no socket information>";
        if (this.ivCommunicator != null && this.ivCommunicator.ivSocket != null && this.ivCommunicator.ivSocket.getInetAddress() != null) {
            socketIdentifier = "Socket to computer <" + this.ivCommunicator.ivSocket.getInetAddress().toString() + ">";
        }
        return socketIdentifier;
    }
}

