/*
 * Decompiled with CFR 0.152.
 */
package de.hannse.netobjects.network;

import de.hannse.netobjects.network.Communicator;
import de.hannse.netobjects.network.SendQueue;
import de.hannse.netobjects.network.client.TimeMachine;
import de.hannse.netobjects.network.server.ServerCommunicator;
import de.hannse.netobjects.util.Log;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import mausoleum.alert.Alert;
import mausoleum.main.MausoleumClient;
import mausoleum.main.ProcessDefinition;

public class NetSender
extends Thread {
    public static final boolean NEW_STYLE = false;
    public static final String TODESWECKER = "***&&&FERTIG";
    private static final int RESET_TRIGGER = 50;
    private final Communicator ivCommunicator;
    private final SendQueue ivSendQueue;
    private DataOutputStream ivOutput;
    private ObjectOutputStream ivObjectOutput;
    private boolean ivShouldRun;
    private boolean ivShouldSend;
    private int ivResetCounter;
    static /* synthetic */ Class class$0;

    public static void sendString(OutputStream os, String s) throws Exception {
        if (os instanceof ObjectOutputStream) {
            ObjectOutputStream oos = (ObjectOutputStream)os;
            oos.writeObject(s);
            oos.flush();
        } else if (os instanceof DataOutputStream) {
            DataOutputStream dos = (DataOutputStream)os;
            dos.writeUTF(s);
            dos.flush();
        }
    }

    public static String receiveString(InputStream is) throws Exception {
        if (is instanceof ObjectInputStream) {
            ObjectInputStream oos = (ObjectInputStream)is;
            return (String)oos.readObject();
        }
        if (is instanceof DataInputStream) {
            DataInputStream dis = (DataInputStream)is;
            return dis.readUTF();
        }
        return null;
    }

    public NetSender(Communicator tc, OutputStream os) {
        block8: {
            this.ivSendQueue = new SendQueue();
            this.ivOutput = null;
            this.ivObjectOutput = null;
            this.ivShouldRun = true;
            this.ivShouldSend = true;
            this.ivResetCounter = 0;
            this.ivCommunicator = tc;
            try {
                if (this.ivCommunicator == null || this.ivCommunicator.ivSocket == null) break block8;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("de.hannse.netobjects.network.NetSender");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Log.log("Using DataOutputStream for communication", clazz);
                this.ivOutput = os != null ? (DataOutputStream)os : new DataOutputStream(this.ivCommunicator.ivSocket.getOutputStream());
            }
            catch (Throwable e) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("de.hannse.netobjects.network.NetSender");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Log.warn("IOException while opening/using Outputstream ", e, clazz);
            }
        }
        this.ivShouldRun = this.ivOutput != null;
    }

    public void stopSending() {
        this.ivShouldSend = false;
    }

    public void commitSuicide() {
        if (this.ivShouldRun) {
            this.ivShouldRun = false;
            try {
                if (this.ivShouldSend) {
                    this.sendObject(TODESWECKER);
                    while (this.isAlive()) {
                        try {
                            Thread.sleep(200L);
                        }
                        catch (Throwable e) {
                            Log.error("Exception while waiting for Thread termination", e, this);
                        }
                    }
                }
                this.ivOutput.close();
                this.ivOutput = null;
            }
            catch (Throwable e) {
                Log.warn("Throwable beim Selbstmord!", e, this);
            }
        }
    }

    public void checkIt() throws Exception {
        if (this.ivOutput != null) {
            this.ivOutput.writeInt(1);
            this.ivOutput.writeByte(TimeMachine.COMMAND.intValue());
            this.ivOutput.flush();
        }
    }

    public void run() {
        while (this.ivShouldRun) {
            Object obj = this.ivSendQueue.get();
            try {
                if (obj == null) continue;
                if (obj instanceof String && obj.equals(TODESWECKER)) {
                    if (this.ivCommunicator != null) {
                        this.ivCommunicator.setWillBeKilled();
                    }
                    this.ivShouldSend = false;
                    return;
                }
                this.doSendObjectNow(obj);
            }
            catch (Throwable e) {
                if (this.ivCommunicator != null) {
                    this.ivCommunicator.setWillBeKilled();
                }
                if (!this.ivShouldSend || !this.ivShouldRun) {
                    return;
                }
                this.ivShouldSend = false;
                if (this.ivCommunicator != null) {
                    this.ivCommunicator.setWillBeKilled();
                }
                if (ProcessDefinition.isServer()) {
                    String commu = this.ivCommunicator != null ? this.ivCommunicator.toString() : "[UNCLEAR COMMUNICATOR]";
                    Log.error("Problem sending object: " + (obj != null ? obj.getClass().getName() : "?") + " using " + commu, e, this);
                    if (this.ivCommunicator != null && this.ivCommunicator instanceof ServerCommunicator) {
                        ServerCommunicator.killSpecificCommunicator((ServerCommunicator)this.ivCommunicator, false);
                    }
                    return;
                }
                if (!ProcessDefinition.isClient()) continue;
                Alert.showAlert("The Network connection is down. Try again later...", null, null, true);
                MausoleumClient.exit();
            }
        }
    }

    public synchronized void doSendObjectNow(Object obj) throws Throwable {
        if (this.ivShouldRun && this.ivShouldSend && this.ivOutput != null) {
            if (obj instanceof Byte) {
                Byte bbb = (Byte)obj;
                this.ivOutput.writeInt(1);
                this.ivOutput.flush();
                this.ivOutput.writeByte(bbb.intValue());
                this.ivOutput.flush();
            } else if (obj instanceof Long) {
                Long bbb = (Long)obj;
                this.ivOutput.writeInt(8);
                this.ivOutput.flush();
                this.ivOutput.writeLong(bbb);
                this.ivOutput.flush();
            } else {
                byte[] arr = null;
                arr = obj instanceof byte[] ? (byte[])obj : this.getObjectAsBytearray(obj);
                if (arr == null) {
                    Log.error("Couldn't send " + obj, null, this);
                } else if (this.ivOutput != null) {
                    this.ivOutput.writeInt(arr.length);
                    this.ivOutput.flush();
                    this.ivOutput.write(arr);
                    this.ivOutput.flush();
                }
            }
        }
    }

    private byte[] getObjectAsBytearray(Object obj) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(obj);
            oos.flush();
            return baos.toByteArray();
        }
        catch (Throwable e) {
            Log.error("Exception while converting Object to ByteArray ", e, this);
            return null;
        }
    }

    public synchronized void sendObject(Object obj) {
        if (this.ivShouldSend) {
            try {
                this.ivSendQueue.put(obj);
            }
            catch (Throwable e) {
                Log.error("Exception while sending Object ", e, this);
            }
        }
    }
}

