/*
 * Decompiled with CFR 0.152.
 */
package de.hannse.netobjects.network.client;

import de.hannse.netobjects.java.MCLK;
import de.hannse.netobjects.network.Communicator;
import de.hannse.netobjects.network.NetSender;
import de.hannse.netobjects.network.client.NetReceiverClient;
import de.hannse.netobjects.objectstore.ObjectRequestListener;
import de.hannse.netobjects.util.Log;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.net.Socket;
import mausoleum.alert.Alert;
import mausoleum.requester.InitializationProgress;
import mausoleum.ui.MausoleumViewPortUI;

public class ClientCommunicator
extends Communicator {
    private static ClientCommunicator cvInstance = null;
    private static boolean cvInitialized = false;
    static /* synthetic */ Class class$0;

    public static void init() {
        if (!cvInitialized) {
            cvInstance = new ClientCommunicator();
        }
        if (!cvInitialized) {
            cvInstance = null;
        }
    }

    public static ClientCommunicator getCommunicator() {
        return cvInstance;
    }

    public static void send(Object obj) {
        if (ClientCommunicator.getCommunicator() != null && !ClientCommunicator.getCommunicator().willBeKilled()) {
            ClientCommunicator.getCommunicator().sendObject(obj);
        }
    }

    public void commitSuicide() {
        cvInitialized = false;
        super.commitSuicide();
        if (this.ivSender != null) {
            this.ivSender.commitSuicide();
            this.ivSender = null;
        }
        if (this.ivReceiver != null) {
            this.ivReceiver.commitSuicide();
            this.ivReceiver = null;
        }
    }

    public boolean isUp() {
        StringBuilder msb = new StringBuilder();
        msb.append("Checking Clientcommunicator:\n");
        msb.append("  Result: ").append(cvInitialized && this.ivSender != null && this.ivReceiver != null && this.ivSocket != null && this.ivSocket.isConnected()).append("\n");
        msb.append("  Initialized: ").append(cvInitialized).append("\n");
        msb.append("  Sender: ").append(this.ivSender).append("\n");
        msb.append("  Receiver: ").append(this.ivReceiver).append("\n");
        msb.append("  Socket: ").append(this.ivSocket).append("\n");
        msb.append("    Socket connected: ").append(this.ivSocket == null ? "---" : "" + this.ivSocket.isConnected()).append("\n");
        msb.append("    Socket closed: ").append(this.ivSocket == null ? "---" : "" + this.ivSocket.isClosed()).append("\n");
        String string = msb.toString();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("de.hannse.netobjects.network.client.ClientCommunicator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Log.log(string, clazz);
        return cvInitialized && this.ivSender != null && this.ivReceiver != null && this.ivSocket != null && this.ivSocket.isConnected();
    }

    private ClientCommunicator() {
        try {
            DataOutputStream os = null;
            DataInputStream is = null;
            try {
                this.ivSocket = new Socket(MCLK.h, MCLK.p);
            }
            catch (Exception e) {
                Alert.showAlert("The server is not responding. Try again later...", null, null, true);
                System.exit(0);
            }
            try {
                os = new DataOutputStream(this.ivSocket.getOutputStream());
                is = new DataInputStream(this.ivSocket.getInputStream());
                NetSender.sendString(os, "NCS");
                String servSig = NetSender.receiveString(is);
                if ("Uze7".equals(servSig)) {
                    Alert.showAlert("The license pool is exhausted. Try again later...", null, null, true);
                    System.exit(0);
                } else if ("iid92".equals(servSig)) {
                    Alert.showAlert("The server is about to shut down. Try again later...", null, null, true);
                    System.exit(0);
                } else if (!"ppe8".equals(servSig)) {
                    Alert.showAlert("Server answer does not match. Check your installation.", null, null, true);
                    System.exit(0);
                }
            }
            catch (Exception ex) {
                Alert.showAlert("The Network connection is down or the licenses are exhausted [3567]. Try again later...", null, null, true);
                System.exit(0);
            }
            if (this.ivSocket == null) {
                InitializationProgress.dismiss();
                Alert.showAlert("The Network connection is down or the licenses are exhausted [8257]. Try again later...", null, null, true);
                System.exit(0);
            }
            try {
                this.ivSender = new NetSender(this, os);
                this.ivSender.start();
                this.ivReceiver = new NetReceiverClient(this, is);
                this.ivReceiver.start();
                if (!this.ivReceiver.isAlive()) {
                    InitializationProgress.dismiss();
                    Alert.showAlert("The Network connection is down or the licenses are exhausted [1815]. Try again later...", null, null, true);
                    System.exit(0);
                }
            }
            catch (Exception e) {
                InitializationProgress.dismiss();
                Alert.showAlert("The Network connection is down or the licenses are exhausted [4184]. Try again later...", null, null, true);
                System.exit(0);
            }
            cvInitialized = true;
            try {
                this.ivSender.checkIt();
            }
            catch (Throwable e) {
                Alert.showAlert("The Network connection is down or the licenses are exhausted [1269]. Try again later...", null, null, true);
                System.exit(0);
            }
            if (MCLK.ec.contains("demo")) {
                MausoleumViewPortUI.cvDemo = true;
            }
        }
        catch (Exception e) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("de.hannse.netobjects.network.client.ClientCommunicator");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Log.error("Problem beim ClientCommunicator ", e, clazz);
            Alert.showAlert("The Network connection is down. Try again later...", null, null, true);
            cvInitialized = false;
        }
    }

    public void addObjectRequestListener(ObjectRequestListener obrl, String magic) {
        ((NetReceiverClient)this.ivReceiver).addObjectRequestListener(obrl, magic);
    }

    public void removeObjectRequestListener(String magic) {
        ((NetReceiverClient)this.ivReceiver).removeObjectRequestListener(magic);
    }
}

