/*
 * Decompiled with CFR 0.152.
 */
package de.hannse.netobjects.network.client;

import de.hannse.netobjects.network.Communicator;
import de.hannse.netobjects.network.NetReceiver;
import de.hannse.netobjects.network.client.NetReceiverClientCommandManager;
import de.hannse.netobjects.network.client.TimeMachine;
import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.objectstore.ObjectManager;
import de.hannse.netobjects.objectstore.ObjectRequest;
import de.hannse.netobjects.objectstore.ObjectRequestListener;
import de.hannse.netobjects.objectstore.ObjectStoreClient;
import de.hannse.netobjects.objectstore.requesthandler.ObjectRequestHandlerClient;
import de.hannse.netobjects.session.UndoRedoState;
import de.hannse.netobjects.util.Babel;
import de.hannse.netobjects.util.Log;
import java.io.EOFException;
import java.io.InputStream;
import java.io.OptionalDataException;
import java.net.SocketException;
import mausoleum.alert.Alert;
import mausoleum.inspector.Inspector;

public class NetReceiverClient
extends NetReceiver {
    public static final String TODES_KUSS = "Halt ihn fest, dass er nicht fall!";
    private boolean ivSocketDead = false;
    private boolean ivStarted = false;

    public NetReceiverClient(Communicator tc, InputStream is) {
        super(tc, is);
        this.ivRequestHandler = new ObjectRequestHandlerClient();
    }

    public boolean isDead() {
        return this.ivSocketDead;
    }

    public void run() {
        Log.log("Starting up NetReceiverClient", this);
        while (this.ivShouldRun && this.ivRequestHandler != null) {
            try {
                Object obj = this.ivShouldRun && this.ivShouldReceive ? this.getNextObject() : null;
                this.ivStarted = true;
                if (this.ivRequestHandler == null || !this.ivShouldRun || obj == null) continue;
                this.ivEOFZaehler = 0;
                if (obj instanceof ObjectRequest) {
                    ObjectRequest mobr = (ObjectRequest)obj;
                    if (this.ivRequestHandler == null) continue;
                    this.ivRequestHandler.handleObjectRequest(mobr);
                    continue;
                }
                if (obj instanceof IDObject) {
                    IDObject ido = (IDObject)obj;
                    ObjectManager manager = ObjectStoreClient.getManager(ido.getTyp());
                    if (manager == null) continue;
                    manager.doHandleNewObject(ido, true);
                    continue;
                }
                if (obj instanceof Long) {
                    TimeMachine.takeMillis((Long)obj);
                    continue;
                }
                if (obj instanceof UndoRedoState) {
                    Inspector.setUndoRedoState((UndoRedoState)obj);
                    continue;
                }
                if (!(obj instanceof String)) continue;
                if (obj.equals(TODES_KUSS)) {
                    new Thread(new Runnable(){

                        public void run() {
                            NetReceiverClient.this.nachTodesKuss();
                        }
                    }).start();
                    return;
                }
                NetReceiverClientCommandManager.commandArrived((String)obj);
            }
            catch (ClassNotFoundException e) {
                Log.error("Communicator Problem: " + e, null, this);
            }
            catch (OptionalDataException e) {
                Log.error("Communicator Problem: " + e, null, this);
            }
            catch (SocketException e) {
                if (!this.ivStarted) {
                    this.ivSocketDead = true;
                    this.ivStarted = true;
                    this.ivShouldRun = false;
                    continue;
                }
                if (!this.ivShouldReceive || !this.ivShouldRun) continue;
                ++this.ivEOFZaehler;
                Log.error("EOFException Nr: " + this.ivEOFZaehler, null, this);
                if (this.ivEOFZaehler <= 5) continue;
                Log.error("Zuviele EOFExceptions am Stueck. Fahre runter " + this.ivEOFZaehler, null, this);
                Alert.showAlert("The Network connection is down. Try again later...", null, null, true);
                System.exit(0);
            }
            catch (EOFException e) {
                if (!this.ivStarted) {
                    this.ivSocketDead = true;
                    this.ivStarted = true;
                    this.ivShouldRun = false;
                    continue;
                }
                if (!this.ivShouldReceive || !this.ivShouldRun) continue;
                ++this.ivEOFZaehler;
                Log.error("EOFException Nr: " + this.ivEOFZaehler, null, this);
                if (this.ivEOFZaehler <= 5) continue;
                Log.error("Zuviele EOFExceptions am Stueck. Fahre runter " + this.ivEOFZaehler, null, this);
                Alert.showAlert("The Network connection is down. Try again later...", null, null, true);
                System.exit(0);
            }
            catch (Throwable e) {
                if (!this.ivShouldRun) continue;
                Log.error("Communicator Problem: ", e, this);
                this.shutDown();
                Alert.showAlert("The Network connection is down. Try again later...", null, null, true);
                System.exit(0);
            }
        }
    }

    private void nachTodesKuss() {
        this.ivShouldRun = false;
        this.ivRequestHandler = null;
        this.ivSocketDead = true;
        new Thread(new Runnable(){

            public void run() {
                try {
                    Thread.sleep(10000L);
                    System.exit(0);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }).start();
        Alert.showAlert(Babel.get("EXTERNAL_SHUTDOWN"), null, null, true);
        System.exit(0);
    }

    private void shutDown() {
        this.ivRequestHandler = null;
        this.ivSocketDead = true;
        if (this.ivCommunicator != null) {
            this.ivCommunicator.commitSuicide();
        }
        this.commitSuicide();
    }

    public void addObjectRequestListener(ObjectRequestListener obrl, String magic) {
        ((ObjectRequestHandlerClient)this.ivRequestHandler).addObjectRequestListener(obrl, magic);
    }

    public void removeObjectRequestListener(String magic) {
        ((ObjectRequestHandlerClient)this.ivRequestHandler).removeObjectRequestListener(magic);
    }
}

