/*
 * Decompiled with CFR 0.152.
 */
package de.hannse.netobjects.network.client;

import de.hannse.netobjects.tools.FileManager;
import de.hannse.netobjects.util.MilliSpender;
import java.util.HashSet;
import mausoleum.definitionlists.ListDefinition;
import mausoleum.tables.MausoleumTableFrame;
import mausoleum.tables.TableFrameTasks;

public class NetReceiverClientCommandManager
implements Runnable {
    public static final String COM_STANDARD_TASKS_CHANGED = "COM_STANDARD_TASKS_CHANGED";
    public static final String COM_LIST_DEFS_CHANGED = "COM_LIST_DEFS_CHANGED";
    private static final HashSet OWN_COMMANDS = new HashSet();
    private final String ivCommand;

    public static void saveContentToServer(String commandPrefix, String group, String path, String content) {
        String command = String.valueOf(commandPrefix) + "|" + group + "|" + MilliSpender.getMillis();
        OWN_COMMANDS.add(command);
        FileManager.saveStringContentToServer(path, content, command, group);
    }

    public static void commandArrived(String command) {
        if (OWN_COMMANDS.contains(command)) {
            OWN_COMMANDS.remove(command);
        } else {
            new NetReceiverClientCommandManager(command);
        }
    }

    private NetReceiverClientCommandManager(String command) {
        this.ivCommand = command;
        new Thread(this).start();
    }

    public void run() {
        if (this.ivCommand.startsWith(COM_STANDARD_TASKS_CHANGED)) {
            TableFrameTasks.standardsChanged(this.ivCommand);
        } else if (this.ivCommand.startsWith(COM_LIST_DEFS_CHANGED)) {
            ListDefinition.reinitForCommand(this.ivCommand);
            MausoleumTableFrame.updateDefinitionlistsIfPresent();
        }
    }
}

