/*
 * Decompiled with CFR 0.152.
 */
package de.hannse.netobjects.network.server;

import de.hannse.netobjects.network.NetReceiver;
import de.hannse.netobjects.network.server.ServerCommunicator;
import de.hannse.netobjects.objectstore.ObjectRequest;
import de.hannse.netobjects.objectstore.requesthandler.ObjectRequestHandlerServer;
import de.hannse.netobjects.session.Session;
import de.hannse.netobjects.util.Log;
import java.io.EOFException;
import java.io.InputStream;
import java.io.OptionalDataException;
import java.net.SocketException;
import java.util.HashSet;

public class NetReceiverServer
extends NetReceiver {
    public boolean ivNormalClientSession = false;
    public boolean ivServiceCaretakerSession = false;
    public HashSet ivInterestedGroups = null;

    public NetReceiverServer(ServerCommunicator communicator, InputStream is) {
        super(communicator, is);
        this.ivRequestHandler = new ObjectRequestHandlerServer(communicator);
    }

    public void endYourSession() {
        ObjectRequestHandlerServer orhs = (ObjectRequestHandlerServer)this.ivRequestHandler;
        orhs.endYourSession();
    }

    public void stopReceiving() {
        this.ivShouldReceive = false;
    }

    public String getGroupName() {
        return this.ivRequestHandler != null ? ((ObjectRequestHandlerServer)this.ivRequestHandler).ivGroupName : "?";
    }

    public boolean isInterstedInGroup(String groupName) {
        if (groupName != null) {
            ObjectRequestHandlerServer orhs = (ObjectRequestHandlerServer)this.ivRequestHandler;
            if (groupName.equals(orhs.ivGroupName)) {
                return true;
            }
            if (orhs.ivGroupNameHOSExtra != null && groupName.equals(orhs.ivGroupNameHOSExtra)) {
                return true;
            }
            Session session = orhs.ivSession;
            if (session != null && session.ivIsServiceSession && session.ivGroupNames != null) {
                return session.ivGroupNames.contains(groupName);
            }
        }
        return false;
    }

    public String getUserName() {
        return this.ivRequestHandler != null ? ((ObjectRequestHandlerServer)this.ivRequestHandler).ivUserName : "?";
    }

    public int getNumCommands() {
        return this.ivRequestHandler != null ? ((ObjectRequestHandlerServer)this.ivRequestHandler).getNumSessionCommands() : 0;
    }

    public Session getSession() {
        return this.ivRequestHandler != null ? ((ObjectRequestHandlerServer)this.ivRequestHandler).ivSession : null;
    }

    public void run() {
        while (this.ivShouldRun) {
            try {
                Object obj;
                Object object = obj = this.ivShouldRun ? this.getNextObject() : null;
                if (obj != null && this.ivCommunicator != null) {
                    this.ivEOFZaehler = 0;
                    if (obj instanceof ObjectRequest) {
                        if (this.ivCommunicator != null) {
                            ObjectRequest or = (ObjectRequest)obj;
                            this.ivCommunicator.ivIsBusy = true;
                            this.ivRequestHandler.handleObjectRequest(or);
                            this.ivCommunicator.ivIsBusy = false;
                        }
                    } else if (obj instanceof Byte) {
                        switch (((Byte)obj).intValue()) {
                            case 1: {
                                ((ServerCommunicator)this.ivCommunicator).sendObjectAndUR(new Long(System.currentTimeMillis()), false);
                                break;
                            }
                            case 2: {
                                this.fahrRunter();
                                break;
                            }
                            default: {
                                break;
                            }
                        }
                    }
                }
            }
            catch (ClassNotFoundException e) {
                Log.error("Communicator Problem using " + (this.ivCommunicator != null ? this.ivCommunicator.toString() : ""), e, this);
            }
            catch (OptionalDataException e) {
                Log.error("Communicator Problem using " + (this.ivCommunicator != null ? this.ivCommunicator.toString() : ""), e, this);
            }
            catch (SocketException e) {
                this.ivCommunicator.setWillBeKilled();
                if (this.ivShouldRun) {
                    Log.error("Communicator Problem using " + (this.ivCommunicator != null ? this.ivCommunicator.toString() : ""), e, this);
                    this.ivShouldReceive = false;
                    this.fahrRunter();
                }
                return;
            }
            catch (EOFException e) {
                this.ivCommunicator.setWillBeKilled();
                if (this.ivShouldRun) {
                    Log.debug("EOFException... must be a Mac. Using " + (this.ivCommunicator != null ? this.ivCommunicator.toString() : ""), this);
                }
                this.fahrRunter();
            }
            catch (Throwable e) {
                this.ivCommunicator.setWillBeKilled();
                if (this.ivShouldRun) {
                    Log.error("Communicator Problem using " + (this.ivCommunicator != null ? this.ivCommunicator.toString() : ""), e, this);
                }
                this.fahrRunter();
            }
            if (this.ivCommunicator == null) continue;
            this.ivCommunicator.ivIsBusy = false;
        }
    }

    public String toString() {
        return "Netreceiver for " + this.ivCommunicator;
    }

    public void fahrRunter() {
        if (this.ivShouldRun) {
            this.ivShouldRun = false;
            if (this.ivCommunicator != null) {
                ServerCommunicator.killSpecificCommunicator((ServerCommunicator)this.ivCommunicator, false);
                this.ivCommunicator = null;
            }
        }
    }

    public synchronized void commitSuicide() {
        super.commitSuicide();
        this.ivCommunicator = null;
        if (this.ivRequestHandler != null) {
            ((ObjectRequestHandlerServer)this.ivRequestHandler).endYourSession();
            this.ivRequestHandler = null;
        }
    }
}

