/*
 * Decompiled with CFR 0.152.
 */
package de.hannse.netobjects.network.server;

import de.hannse.netobjects.network.Communicator;
import de.hannse.netobjects.network.NetSender;
import de.hannse.netobjects.network.server.NetReceiverServer;
import de.hannse.netobjects.network.server.ServerCommunicatorInfo;
import de.hannse.netobjects.network.server.ServerPortal;
import de.hannse.netobjects.objectstore.ObjectStore;
import de.hannse.netobjects.session.Session;
import de.hannse.netobjects.session.UndoRedoState;
import de.hannse.netobjects.util.Log;
import java.io.EOFException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import mausoleum.main.MausoleumServer;
import mausoleum.main.ProcessDefinition;
import mausoleum.room.Room;

public class ServerCommunicator
extends Communicator {
    public static final int STATUS_NEW = 1;
    public static final int STATUS_LOGGEDIN = 2;
    public static final int STATUS_READY = 3;
    public static final int STATUS_INACTIVE = 4;
    public static final int STATUS_DORMANT = 5;
    private static final int MIN_STATUS = 1;
    private static final int MAX_STATUS = 5;
    private int ivStatus = 1;
    private boolean ivAdministrator = false;
    private String ivNetAddress = null;
    static /* synthetic */ Class class$0;

    public static String getAllCommunicatorsDescr(ServerCommunicator ich) {
        StringBuffer msb = new StringBuffer();
        if (ProcessDefinition.isServer() && MausoleumServer.isInitialized()) {
            Enumeration en = ServerPortal.getCommunicators();
            while (en.hasMoreElements()) {
                ServerCommunicator sc;
                msb.append(ServerCommunicatorInfo.getTransportString(sc, (sc = (ServerCommunicator)en.nextElement()) == ich)).append("\n");
            }
        }
        return msb.toString();
    }

    public static void killAllCommunicatorsOfGroup(String group) {
        if (ProcessDefinition.isServer() && MausoleumServer.isInitialized()) {
            Vector<ServerCommunicator> toKill = new Vector<ServerCommunicator>();
            Enumeration en = ServerPortal.getCommunicators();
            while (en.hasMoreElements()) {
                ServerCommunicator sc = (ServerCommunicator)en.nextElement();
                if (!group.equals(sc.getGroupName())) continue;
                toKill.add(sc);
            }
            Iterator iterator = toKill.iterator();
            while (iterator.hasNext()) {
                ServerCommunicator sc = (ServerCommunicator)iterator.next();
                ServerCommunicator.killCommunicator(sc.ivID, null);
            }
        }
    }

    public static boolean killCommunicator(long id, ServerCommunicator ich) {
        if (ProcessDefinition.isServer() && MausoleumServer.isInitialized() && (ich == null || ich.ivID != id)) {
            Enumeration en = ServerPortal.getCommunicators();
            while (en.hasMoreElements()) {
                ServerCommunicator sc = (ServerCommunicator)en.nextElement();
                if (sc.ivID != id) continue;
                ServerCommunicator.killSpecificCommunicator(sc, true);
                return true;
            }
        }
        return false;
    }

    public static void killSpecificCommunicator(ServerCommunicator sc, boolean mitTodeskuss) {
        if (ProcessDefinition.isServer() && MausoleumServer.isInitialized() && sc != null) {
            sc.setWillBeKilled();
            String commu = sc.toString();
            String string = "Try to kill " + commu;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("de.hannse.netobjects.network.server.ServerCommunicator");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Log.debug(string, clazz);
            if (sc.ivReceiver != null) {
                ((NetReceiverServer)sc.ivReceiver).stopReceiving();
            }
            String string2 = "Receiver stopped receiving " + commu;
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("de.hannse.netobjects.network.server.ServerCommunicator");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Log.debug(string2, clazz2);
            if (mitTodeskuss) {
                try {
                    sc.ivSender.doSendObjectNow("Halt ihn fest, dass er nicht fall!");
                    String string3 = "Sender received farewell kiss " + commu;
                    Class<?> clazz3 = class$0;
                    if (clazz3 == null) {
                        try {
                            clazz3 = class$0 = Class.forName("de.hannse.netobjects.network.server.ServerCommunicator");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    Log.log(string3, clazz3);
                }
                catch (Throwable e) {
                    Class<?> clazz4 = class$0;
                    if (clazz4 == null) {
                        try {
                            clazz4 = class$0 = Class.forName("de.hannse.netobjects.network.server.ServerCommunicator");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    Log.error("Problem sending death message ", e, clazz4);
                }
            }
            sc.ivSender.stopSending();
            String string4 = "Sender stopped sending " + commu;
            Class<?> clazz5 = class$0;
            if (clazz5 == null) {
                try {
                    clazz5 = class$0 = Class.forName("de.hannse.netobjects.network.server.ServerCommunicator");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Log.debug(string4, clazz5);
            while (sc.ivIsBusy) {
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            sc.endYourSession();
            String string5 = "Ended session " + commu;
            Class<?> clazz6 = class$0;
            if (clazz6 == null) {
                try {
                    clazz6 = class$0 = Class.forName("de.hannse.netobjects.network.server.ServerCommunicator");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Log.debug(string5, clazz6);
            sc.commitSuicide();
            String string6 = "Communicator commited suicide " + commu;
            Class<?> clazz7 = class$0;
            if (clazz7 == null) {
                try {
                    clazz7 = class$0 = Class.forName("de.hannse.netobjects.network.server.ServerCommunicator");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Log.debug(string6, clazz7);
        }
    }

    public ServerCommunicator(Socket socket, InputStream is, OutputStream os) {
        this.ivSocket = socket;
        if (this.ivSocket != null) {
            this.ivNetAddress = this.ivSocket.getInetAddress().toString();
        }
        this.ivSender = new NetSender(this, os);
        this.ivSender.start();
        this.ivReceiver = new NetReceiverServer(this, is);
        this.ivReceiver.start();
    }

    public String getNetAddress() {
        return this.ivNetAddress;
    }

    public UndoRedoState getUndoRedoState() {
        NetReceiverServer nrs;
        Session sess;
        UndoRedoState erg = new UndoRedoState();
        if (this.ivReceiver != null && (sess = (nrs = (NetReceiverServer)this.ivReceiver).getSession()) != null) {
            erg.ivU = sess.isUndoPossible();
            erg.ivR = sess.isRedoPossible();
        }
        return erg;
    }

    public Session getSession() {
        if (this.ivReceiver != null) {
            NetReceiverServer nrs = (NetReceiverServer)this.ivReceiver;
            return nrs.getSession();
        }
        return null;
    }

    public String getRoomName(String defVal) {
        Room room;
        Session sess = this.getSession();
        if (sess != null && sess.ivServiceRoomID > 0L && (room = (Room)ObjectStore.getObjectDeadOrAlive(10, sess.ivServiceRoomID, "service", null, false)) != null) {
            return room.getName();
        }
        return defVal;
    }

    public String getStatusString() {
        switch (this.ivStatus) {
            case 3: {
                return "READY";
            }
            case 4: {
                return "INACTIVE";
            }
            case 1: {
                return "NEW";
            }
            case 2: {
                return "LOGGED_IN";
            }
            case 5: {
                return "DORMANT";
            }
        }
        return "undefined";
    }

    public int getStatus() {
        return this.ivStatus;
    }

    public void setIsAdministrator(boolean isAdmin) {
        this.ivAdministrator = isAdmin;
    }

    public boolean isAdministrator() {
        return this.ivAdministrator;
    }

    public void setStatus(int status) {
        if (status < 1 || status > 5) {
            throw new IllegalArgumentException("Status " + status + " not defined");
        }
        if (!(status == 3 && this.ivStatus == 5 || status == 5 && this.ivStatus == 3 || status >= this.ivStatus)) {
            throw new IllegalArgumentException("Statuschange from " + this.ivStatus + " to " + status + " not allowed");
        }
        this.ivStatus = status;
    }

    public String getGroupName() {
        return this.ivReceiver != null ? ((NetReceiverServer)this.ivReceiver).getGroupName() : "?";
    }

    public boolean isInterstedInGroup(String groupName) {
        return this.ivReceiver != null && !this.willBeKilled() && ((NetReceiverServer)this.ivReceiver).isInterstedInGroup(groupName);
    }

    public String getUserName() {
        return this.ivReceiver != null ? ((NetReceiverServer)this.ivReceiver).getUserName() : "?";
    }

    public int getNumCommands() {
        return ((NetReceiverServer)this.ivReceiver).getNumCommands();
    }

    public void endYourSession() {
        if (this.ivReceiver != null) {
            this.ivReceiver.endYourSession();
        }
    }

    public synchronized void commitSuicide() {
        this.setWillBeKilled();
        try {
            ServerPortal.removeCommunicatorToClient(this);
            if (this.ivReceiver != null) {
                this.ivReceiver.commitSuicide();
                this.ivReceiver = null;
            }
            if (this.ivSender != null) {
                this.ivSender.commitSuicide();
                this.ivSender = null;
            }
            if (this.ivSocket != null) {
                this.ivSocket.close();
                this.ivSocket = null;
            }
        }
        catch (EOFException eOFException) {
        }
        catch (Exception e) {
            Log.warn("Communicator Problem: ", e, this);
        }
    }

    public void fahrRunter() {
        this.setWillBeKilled();
        if (this.ivReceiver != null) {
            ((NetReceiverServer)this.ivReceiver).fahrRunter();
        }
    }

    public void sendObjectAndUR(Object o, boolean mitUndoRedo) {
        if (this.willBeKilled()) {
            Log.debug("Communicator [" + this + "] will be killed. Will not send object", this);
        }
        if (!this.willBeKilled() && o != null) {
            this.sendObject(o);
        }
        if (this.willBeKilled()) {
            Log.debug("Communicator [" + this + "] will be killed. Will not send UndoRedoState", this);
        }
        if (!this.willBeKilled() && this.getStatus() == 3) {
            this.sendObject(this.getUndoRedoState());
        }
    }

    public String toString() {
        StringBuilder msb = new StringBuilder();
        msb.append("Communicator to client (Status: ").append(this.getStatusString()).append(", ");
        msb.append("Address: ").append(this.getNetAddress()).append(", ");
        msb.append("Group: ").append(this.getGroupName()).append(", ");
        msb.append("User: ").append(this.getUserName()).append(")");
        return msb.toString();
    }
}

