/*
 * Decompiled with CFR 0.152.
 */
package de.hannse.netobjects.network.server;

import de.hannse.netobjects.network.server.ServerCommunicator;
import de.hannse.netobjects.tools.Base64Manager;
import mausoleum.helper.Zeile;

public class ServerCommunicatorInfo {
    public final long ivID;
    public final String ivUserName;
    public final String ivGroupName;
    public final String ivRoomName;
    public final String ivAddressName;
    public final String ivStatus;
    public final int ivNumCommands;
    public final boolean ivBinIch;

    public ServerCommunicatorInfo(String transportString) {
        Zeile z = new Zeile(transportString, '|');
        int col = 0;
        this.ivID = z.getLong(col++, 0L);
        this.ivUserName = z.getStringB64(col++, "");
        this.ivGroupName = z.getStringB64(col++, "");
        this.ivRoomName = z.getStringB64(col++, "");
        this.ivAddressName = z.getStringB64(col++, "");
        this.ivStatus = z.getString(col++, "");
        this.ivNumCommands = z.getInt(col++, 0);
        this.ivBinIch = z.getBoolean(col++, "1", "0", false);
    }

    public static String getTransportString(ServerCommunicator sc, boolean binIch) {
        StringBuffer msb = new StringBuffer();
        msb.append(sc.ivID).append("|");
        ServerCommunicatorInfo.append(sc.getUserName(), true, msb);
        ServerCommunicatorInfo.append(sc.getGroupName(), true, msb);
        ServerCommunicatorInfo.append(sc.getRoomName(""), true, msb);
        ServerCommunicatorInfo.append(sc.getNetAddress(), true, msb);
        ServerCommunicatorInfo.append(sc.getStatusString(), false, msb);
        msb.append(sc.getNumCommands()).append("|");
        msb.append(binIch ? "1" : "0").append("|");
        return msb.toString();
    }

    private static void append(String s, boolean mitBase64, StringBuffer msb) {
        if (s != null && s.length() != 0) {
            if (mitBase64) {
                msb.append(Base64Manager.encodeBase64(s));
            } else {
                msb.append(s);
            }
        }
        msb.append("|");
    }
}

