/*
 * Decompiled with CFR 0.152.
 */
package de.hannse.netobjects.objectstore;

import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.objectstore.NULLObject;
import de.hannse.netobjects.objectstore.ObjectStoreServer;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import mausoleum.helper.Zeile;
import mausoleum.main.ProcessDefinition;

public class DoObject {
    public final HashSet ivTouchedGroups = new HashSet();
    private final HashSet ivTouchedObjectIdentifiers = new HashSet();
    private final HashSet ivCreatedObjectIdentifiers = new HashSet();
    private final HashMap ivOrigValues = new HashMap();
    private final HashMap ivChangedValues = new HashMap();

    private static IDObject getObject(String key, Hashtable objectBag, long[] objectIDMerker) {
        Zeile z = new Zeile(key, '|');
        if (z.size() == 3) {
            String groupName = z.getString(0);
            int objectType = z.getInt(1, 0);
            objectIDMerker[0] = z.getLong(2, 0L);
            return ObjectStoreServer.getObjectDeadOrAlive(objectType, objectIDMerker[0], groupName, objectBag, false, true);
        }
        return null;
    }

    public boolean containsSameTouchedObjects(DoObject doo) {
        Iterator iterator = this.ivTouchedObjectIdentifiers.iterator();
        while (iterator.hasNext()) {
            if (!doo.ivTouchedObjectIdentifiers.contains(iterator.next())) continue;
            return true;
        }
        return false;
    }

    public void manageNewObject(IDObject idObject) {
        this.ivCreatedObjectIdentifiers.add(idObject.getIdentifierString());
    }

    public void manageIDObjectFormObjectBag(IDObject idObject) {
        if (ProcessDefinition.isServer()) {
            this.ivTouchedGroups.add(idObject.getGroup());
            String objectIdentifier = idObject.getIdentifierString();
            this.ivTouchedObjectIdentifiers.add(objectIdentifier);
            HashMap<String, String> originalValues = new HashMap<String, String>();
            HashMap changedValues = new HashMap();
            idObject.fillOriginalAndChangeds(originalValues, changedValues);
            if (originalValues.get("IDO_ID") != null && originalValues.get("IDO_ID") instanceof NULLObject) {
                this.ivCreatedObjectIdentifiers.add(objectIdentifier);
            }
            originalValues.put("IDO_GROUP", idObject.getGroup());
            this.ivOrigValues.put(objectIdentifier, originalValues);
            this.ivChangedValues.put(objectIdentifier, changedValues);
        }
    }

    public boolean hasTouchedObjects() {
        return !this.ivTouchedObjectIdentifiers.isEmpty();
    }

    public void makeUNDO(Hashtable objectBag) {
        long[] objectIDMerker = new long[1];
        Iterator iter = this.ivOrigValues.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            IDObject uobj = DoObject.getObject(key, objectBag, objectIDMerker);
            if (uobj == null) continue;
            HashMap val = (HashMap)this.ivOrigValues.get(key);
            val.remove("IDO_VERSION");
            Date startDate = (Date)uobj.get("IDO_START_DATE");
            Iterator iterator = val.keySet().iterator();
            while (iterator.hasNext()) {
                String key2 = (String)iterator.next();
                Object val2 = val.get(key2);
                if (val2 instanceof NULLObject) {
                    uobj.set(key2, null);
                    continue;
                }
                uobj.set(key2, val2);
            }
            if (!this.ivCreatedObjectIdentifiers.contains(key)) continue;
            uobj.set("IDO_END_DATE", new Date());
            uobj.set("IDO_NEVER_EXISTED", new Boolean(true));
            uobj.setLong("IDO_ID", objectIDMerker[0]);
            uobj.set("IDO_START_DATE", startDate);
        }
    }

    public void makeREDO(Hashtable objectBag) {
        long[] objectIDMerker = new long[1];
        Iterator iter = this.ivChangedValues.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            IDObject uobj = DoObject.getObject(key, objectBag, objectIDMerker);
            if (uobj == null) continue;
            HashMap val = (HashMap)this.ivChangedValues.get(key);
            val.remove("IDO_VERSION");
            uobj.setValuesWithoutCommit(val);
            if (!this.ivCreatedObjectIdentifiers.contains(key)) continue;
            uobj.set("IDO_END_DATE", null);
            uobj.set("IDO_NEVER_EXISTED", null);
        }
    }

    public String toString() {
        StringBuilder msb = new StringBuilder();
        msb.append("DOOBJECT\n");
        msb.append("Created Objects: ").append(this.ivCreatedObjectIdentifiers).append("\n");
        msb.append("Touched Objects: ").append(this.ivTouchedObjectIdentifiers).append("\n");
        msb.append("Changed values: ").append(this.ivChangedValues).append("\n");
        msb.append("Original values: ").append(this.ivOrigValues).append("\n");
        return msb.toString();
    }
}

