/*
 * Decompiled with CFR 0.152.
 */
package de.hannse.netobjects.objectstore;

import de.hannse.netobjects.datalayer.DataLayer;
import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.objectstore.IndexObject;
import de.hannse.netobjects.objectstore.NULLObject;
import de.hannse.netobjects.tools.Base64Manager;
import de.hannse.netobjects.tools.StringHelper;
import de.hannse.netobjects.util.Log;
import java.awt.Color;
import java.awt.Font;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.image.BufferedImage;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import mausoleum.factsheets.multidimreport.MultiDimAnalyzer;
import mausoleum.gui.MusterColor;
import mausoleum.gui.PralineColor;
import mausoleum.helper.ImageHelper;
import mausoleum.helper.Zeile;
import mausoleum.locus.LocusAndAlleles;
import mausoleum.mail.Mail;
import mausoleum.mouse.Mouse;
import mausoleum.mouse.Task;
import mausoleum.mouse.TaskExtended;
import mausoleum.mouse.tierschutz.StressRule;
import mausoleum.rack.RackPos;
import mausoleum.result.GPSCoordinates;
import mausoleum.result.MResult;
import mausoleum.result.Result;
import mausoleum.result.ResultObjectImage;
import mausoleum.visit.Visit;

public class IDObjectXMLHandler {
    public static final String MS_TAG = "MausoleumBackup";
    public static final String M_IDO_TAG = "I";
    public static final String M_CLASS_TAG = "cl";
    public static final String M_GENERAL_INFO_TAG = "Ig";
    public static final String M_SESSION_TAG = "Is";
    public static final String M_IDO_OPEN_TAG = "<I";
    private static final String TRENNER1 = "@";
    private static final String TRENNER2 = "|";
    private static final String TRENNER3 = "$";
    private static final char TRENNER2_CHAR = '|';
    private static final char TRENNER3_CHAR = '$';
    private static final String MARK_INT = "I";
    private static final String MARK_INT_ARR = "I[";
    private static final String MARK_DOUBLE_ARR = "D[";
    public static final String MARK_DOUBLE = "D";
    public static final String MARK_LONG = "L";
    public static final String MARK_STRING = "S";
    private static final String MARK_STRING_ARR = "S[";
    private static final String MARK_DATE = "DT";
    private static final String MARK_BOOLEAN = "B";
    private static final String MARK_BOOLEAN_ARR = "B[";
    private static final String MARK_CHARACTER = "C";
    private static final String MARK_LONG_ARR = "L[";
    private static final String MARK_TASK_ARR = "TK[";
    private static final String MARK_TASK_EXT_ARR = "TKX[";
    private static final String MARK_VISIT_ARR = "V[";
    private static final String MARK_RACKPOS = "RP";
    private static final String MARK_COLOR = "CL";
    private static final String MARK_INDEXOBJECT_ARR = "IO[";
    private static final String MARK_LOCANDALL = "LAA";
    public static final String MARK_LOCANDALL_ARR = "LAA[";
    private static final String MARK_OBJECT_ARR = "O[";
    private static final String MARK_ROI = "ROI";
    private static final String MARK_GPS = "GPS";
    private static final String MARK_POINT = "PT";
    private static final String MARK_FONT = "FONT";
    private static final String MARK_POLYGON = "POLY";
    private static final String MARK_IMAGE = "IMAGE";
    private static final String MARK_MRESULT = "MRES";
    private static final String MARK_VECTOR = "V";
    private static final String MARK_HASHMAP = "HAM";
    private static final String MARK_HASHSET = "HAS";
    private static final String MARK_TREEMAP = "TRM";
    private static final String MARK_TREESET = "TRS";
    private static final String MARK_HASHTABLE = "HAT";
    private static final String MARK_NULL_OBJECT = "NO";
    private static final String MARK_MULTIDIMKEY = "MDK";
    private static final String MARK_MULTIDIMANALYZER = "MDA";
    private static final String MARK_STRESS_RULE = "STRU";
    private static final String ORIGINAL_GROUP_DICT_TAG = "iog";
    private static final HashMap KEY_DICT_HIN = new HashMap(200);
    public static final HashMap KEY_DICT_HER = new HashMap(200);
    private static final HashMap CLASS_DICT_HIN = new HashMap(40);
    private static final HashMap CLASS_DICT_HER = new HashMap(40);
    private static final HashSet EXCLUDE_KEYS = new HashSet(10);
    private static final HashMap INTERPRETERS = new HashMap();
    private static final HashMap INTERPRETER_TAGS_BY_CLASS_STRING = new HashMap();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;
    static /* synthetic */ Class class$9;
    static /* synthetic */ Class class$10;
    static /* synthetic */ Class class$11;
    static /* synthetic */ Class class$12;
    static /* synthetic */ Class class$13;
    static /* synthetic */ Class class$14;
    static /* synthetic */ Class class$15;
    static /* synthetic */ Class class$16;
    static /* synthetic */ Class class$17;
    static /* synthetic */ Class class$18;
    static /* synthetic */ Class class$19;
    static /* synthetic */ Class class$20;
    static /* synthetic */ Class class$21;
    static /* synthetic */ Class class$22;
    static /* synthetic */ Class class$23;
    static /* synthetic */ Class class$24;
    static /* synthetic */ Class class$25;
    static /* synthetic */ Class class$26;
    static /* synthetic */ Class class$27;
    static /* synthetic */ Class class$28;
    static /* synthetic */ Class class$29;
    static /* synthetic */ Class class$30;
    static /* synthetic */ Class class$31;
    static /* synthetic */ Class class$32;
    static /* synthetic */ Class class$33;
    static /* synthetic */ Class class$34;
    static /* synthetic */ Class class$35;
    static /* synthetic */ Class class$36;
    static /* synthetic */ Class class$37;
    static /* synthetic */ Class class$38;

    static {
        IDObjectXMLHandler.addKeyEntry("IDO_NEVER_EXISTED", "ne");
        IDObjectXMLHandler.addKeyEntry("IDO_VISIBLE", "vis");
        IDObjectXMLHandler.addKeyEntry("IDO_UNIQUELONG", "ul");
        IDObjectXMLHandler.addKeyEntry("IDO_OGROUP", ORIGINAL_GROUP_DICT_TAG);
        IDObjectXMLHandler.addKeyEntry("SES_USER", "Su");
        IDObjectXMLHandler.addKeyEntry("SES_ADRESS", "Sa");
        IDObjectXMLHandler.addKeyEntry("SES_COMMAND", "Sc");
        IDObjectXMLHandler.addKeyEntry("USR_MODE", "Um");
        IDObjectXMLHandler.addKeyEntry("USR_PASSWORD", "Up");
        IDObjectXMLHandler.addKeyEntry("USR_NAME", "Un");
        IDObjectXMLHandler.addKeyEntry("USR_EMAIL", "Ue");
        IDObjectXMLHandler.addKeyEntry("USR_LANGUAGE", "Ul");
        IDObjectXMLHandler.addKeyEntry("USR_COLOR", "Uc");
        IDObjectXMLHandler.addKeyEntry("MOS_BIRTHDAY", "Mb");
        IDObjectXMLHandler.addKeyEntry("MOS_STARTMODE", "Msm");
        IDObjectXMLHandler.addKeyEntry("MOS_ENDMODE", "Mem");
        IDObjectXMLHandler.addKeyEntry("MOS_OWNER", "Mo");
        IDObjectXMLHandler.addKeyEntry("MOS_VISIT", "Mv");
        IDObjectXMLHandler.addKeyEntry("MOS_STRAIN", "Ms");
        IDObjectXMLHandler.addKeyEntry("MOS_LINEID", "Ml");
        IDObjectXMLHandler.addKeyEntry("MOS_COMMENT", "Mc");
        IDObjectXMLHandler.addKeyEntry("MOS_ACTCAGE", "Mac");
        IDObjectXMLHandler.addKeyEntry("MOS_EARTAG", "Me");
        IDObjectXMLHandler.addKeyEntry(Mouse.getSexTag(), "Mx");
        IDObjectXMLHandler.addKeyEntry("MOS_FATHER", "Mf");
        IDObjectXMLHandler.addKeyEntry("MOS_MOTHER", "Mm");
        IDObjectXMLHandler.addKeyEntry("MOS_LOCUSGENOTYPES", "Mg");
        IDObjectXMLHandler.addKeyEntry("MOS_FLAG", "Mfl");
        IDObjectXMLHandler.addKeyEntry("MOS_PLUGDATE", "Mpd");
        IDObjectXMLHandler.addKeyEntry("MOS_ALLPLUGDATES", "Mapd");
        IDObjectXMLHandler.addKeyEntry("MOS_PLUGALERT", "Mpa");
        IDObjectXMLHandler.addKeyEntry("MOS_TASKS", "Mt");
        IDObjectXMLHandler.addKeyEntry("MOS_TASKSEXT", "Mtx");
        IDObjectXMLHandler.addKeyEntry("CAG_VISIT", "Cv");
        IDObjectXMLHandler.addKeyEntry("CAG_FLAG", "Cf");
        IDObjectXMLHandler.addKeyEntry("CAG_POS", "Cp");
        IDObjectXMLHandler.addKeyEntry("CAG_PSEUDOID", "Ci");
        IDObjectXMLHandler.addKeyEntry("CAG_COMMENT", "Cc");
        IDObjectXMLHandler.addKeyEntry("CAG_SUPERCAGE", "Cs");
        IDObjectXMLHandler.addKeyEntry("CAG_SUBCAGEL", "Cl");
        IDObjectXMLHandler.addKeyEntry("CAG_SUBCAGER", "Cr");
        IDObjectXMLHandler.addKeyEntry("CAG_SIDE", "Csi");
        IDObjectXMLHandler.addKeyEntry("CAG_ISMATINGCAGE", "Cm");
        IDObjectXMLHandler.addKeyEntry("CAG_LICENSEID", "Cli");
        IDObjectXMLHandler.addKeyEntry("LIN_NAME", "Ln");
        IDObjectXMLHandler.addKeyEntry("LIN_COLOR", "Lc");
        IDObjectXMLHandler.addKeyEntry("LIN_ENTERER", "Le");
        IDObjectXMLHandler.addKeyEntry("LIN_DESCRIPTION", "Ld");
        IDObjectXMLHandler.addKeyEntry("LIN_CHANGE", "Lh");
        IDObjectXMLHandler.addKeyEntry("LIN_LOCIALLELES", "Ll");
        IDObjectXMLHandler.addKeyEntry("STR_NAME", "STn");
        IDObjectXMLHandler.addKeyEntry("STR_ENTERER", "STe");
        IDObjectXMLHandler.addKeyEntry("STR_DESCRIPTION", "STd");
        IDObjectXMLHandler.addKeyEntry("ROM_NAME", "ROn");
        IDObjectXMLHandler.addKeyEntry("ROM_DESC", "ROd");
        IDObjectXMLHandler.addKeyEntry("RCK_SIDES", "Rs");
        IDObjectXMLHandler.addKeyEntry("RCK_ROWS", "Rr");
        IDObjectXMLHandler.addKeyEntry("RCK_COLUMNS", "Rc");
        IDObjectXMLHandler.addKeyEntry("RCK_CAGES", "Rg");
        IDObjectXMLHandler.addKeyEntry("RCK_ROOM", "Ro");
        IDObjectXMLHandler.addKeyEntry("RCK_NAME", "Rn");
        IDObjectXMLHandler.addKeyEntry("RES_EXPERIMENT", "REx");
        IDObjectXMLHandler.addKeyEntry("RES_EXPERIMENTTYPE", "REt");
        IDObjectXMLHandler.addKeyEntry("RES_MOUSE", "REm");
        IDObjectXMLHandler.addKeyEntry("RES_RESULT", "REr");
        IDObjectXMLHandler.addKeyEntry("RES_PERFORMER", "REp");
        IDObjectXMLHandler.addKeyEntry("MAI_SENDER", "MAs");
        IDObjectXMLHandler.addKeyEntry("MAI_SGROUP", "MAsg");
        IDObjectXMLHandler.addKeyEntry("MAI_OWNER", "MAo");
        IDObjectXMLHandler.addKeyEntry("MAI_OGROUP", "MAog");
        IDObjectXMLHandler.addKeyEntry("MAI_RECEIVER", "MAr");
        IDObjectXMLHandler.addKeyEntry("MAI_RGROUP", "MArg");
        IDObjectXMLHandler.addKeyEntry("MAI_SUBJECT", "MAsu");
        IDObjectXMLHandler.addKeyEntry("MAI_TEXT", "MAt");
        IDObjectXMLHandler.addKeyEntry("MAI_ATTACHMENT", "MAa");
        IDObjectXMLHandler.addKeyEntry("MAI_ATTINFO", "MAai");
        IDObjectXMLHandler.addKeyEntry("MAI_READ", "MArd");
        IDObjectXMLHandler.addKeyEntry("MAI_EXTRACTED", "MAx");
        IDObjectXMLHandler.addKeyEntry("MAI_WANTSREC", "MAw");
        IDObjectXMLHandler.addKeyEntry("MAI_SENDER_ID", "MAsid");
        IDObjectXMLHandler.addKeyEntry("MAI_OWNER_ID", "MAoid");
        IDObjectXMLHandler.addKeyEntry("MAI_RECEIVER_ID", "MArid");
        IDObjectXMLHandler.addKeyEntry("LOC_NAME", "LOn");
        IDObjectXMLHandler.addKeyEntry("LOC_ENSEMBL_NAME", "LOe");
        IDObjectXMLHandler.addKeyEntry("LOC_MGI_NAME", "LOm");
        IDObjectXMLHandler.addKeyEntry("LOC_ENTERER", "LOei");
        IDObjectXMLHandler.addKeyEntry("LOC_AUTOSOMAL", "LOau");
        IDObjectXMLHandler.addKeyEntry("LOC_ALLELES", "LOa");
        IDObjectXMLHandler.addKeyEntry("LOC_DESCRIPTION", "LOd");
        IDObjectXMLHandler.addKeyEntry("LOC_ALLEL_DESC", "LOad");
        IDObjectXMLHandler.addKeyEntry("LOC_WT_ALLEL", "LOw");
        IDObjectXMLHandler.addClassEntry(IDObject.C_Session, "s");
        IDObjectXMLHandler.addClassEntry(IDObject.C_User, "u");
        IDObjectXMLHandler.addClassEntry(IDObject.C_Cage, "c");
        IDObjectXMLHandler.addClassEntry(IDObject.C_Experiment, "x");
        IDObjectXMLHandler.addClassEntry(IDObject.C_Line, "l");
        IDObjectXMLHandler.addClassEntry(IDObject.C_Locus, "lo");
        IDObjectXMLHandler.addClassEntry(IDObject.C_Mail, "ma");
        IDObjectXMLHandler.addClassEntry(IDObject.C_Mouse, "m");
        IDObjectXMLHandler.addClassEntry(IDObject.C_Rack, "r");
        IDObjectXMLHandler.addClassEntry(IDObject.C_Result, "re");
        IDObjectXMLHandler.addClassEntry(IDObject.C_Room, "ro");
        IDObjectXMLHandler.addClassEntry(IDObject.C_Strain, "st");
        IDObjectXMLHandler.addClassEntry(IDObject.C_Task, "t");
        IDObjectXMLHandler.addClassEntry(IDObject.C_Wedding, "w");
        EXCLUDE_KEYS.add("IDO_TYPE_ID");
        EXCLUDE_KEYS.add("IDO_ID");
        EXCLUDE_KEYS.add("IDO_VERSION");
        EXCLUDE_KEYS.add("IDO_START_DATE");
        EXCLUDE_KEYS.add("IDO_END_DATE");
        EXCLUDE_KEYS.add("IDO_GROUP");
        EXCLUDE_KEYS.add(M_GENERAL_INFO_TAG);
        EXCLUDE_KEYS.add(M_CLASS_TAG);
        EXCLUDE_KEYS.add(M_SESSION_TAG);
        EXCLUDE_KEYS.add("IDO_SERVID");
        EXCLUDE_KEYS.add("IDO_UGROUPS");
        EXCLUDE_KEYS.add("IDO_UGROUPIDS");
        EXCLUDE_KEYS.add("MOS_ROOM");
        EXCLUDE_KEYS.add("CAG_ROOM");
        EXCLUDE_KEYS.add("RCK_OCC");
        INTERPRETERS.put("I", new IOI_INT());
        INTERPRETERS.put(MARK_INT_ARR, new IOI_INT_ARR());
        INTERPRETERS.put(MARK_DOUBLE, new IOI_DOUBLE());
        INTERPRETERS.put(MARK_LONG, new IOI_LONG());
        INTERPRETERS.put(MARK_STRING, new IOI_STRING());
        INTERPRETERS.put(MARK_STRING_ARR, new IOI_STRING_ARR());
        INTERPRETERS.put(MARK_DATE, new IOI_DATE());
        INTERPRETERS.put(MARK_BOOLEAN, new IOI_BOOLEAN());
        INTERPRETERS.put(MARK_BOOLEAN_ARR, new IOI_BOOLEAN_ARR());
        INTERPRETERS.put(MARK_CHARACTER, new IOI_CHARACTER());
        INTERPRETERS.put(MARK_LONG_ARR, new IOI_LONG_ARR());
        INTERPRETERS.put(MARK_DOUBLE_ARR, new IOI_DOUBLE_ARR());
        INTERPRETERS.put(MARK_TASK_ARR, new IOI_TASK_ARR());
        INTERPRETERS.put(MARK_TASK_EXT_ARR, new IOI_TASK_EXT_ARR());
        INTERPRETERS.put(MARK_VISIT_ARR, new IOI_VISIT_ARR());
        INTERPRETERS.put(MARK_RACKPOS, new IOI_RACKPOS());
        INTERPRETERS.put(MARK_COLOR, new IOI_COLOR());
        INTERPRETERS.put(MARK_INDEXOBJECT_ARR, new IOI_INDEXOBJECT_ARR());
        INTERPRETERS.put(MARK_LOCANDALL, new IOI_LOCANDALL());
        INTERPRETERS.put(MARK_LOCANDALL_ARR, new IOI_LOCANDALL_ARR());
        INTERPRETERS.put(MARK_OBJECT_ARR, new IOI_OBJECT_ARR());
        INTERPRETERS.put(MARK_ROI, new IOI_ROI());
        INTERPRETERS.put(MARK_GPS, new IOI_GPS());
        INTERPRETERS.put(MARK_POINT, new IOI_POINT());
        INTERPRETERS.put(MARK_FONT, new IOI_FONT());
        INTERPRETERS.put(MARK_POLYGON, new IOI_POLYGON());
        INTERPRETERS.put(MARK_IMAGE, new IOI_IMAGE());
        INTERPRETERS.put(MARK_VECTOR, new IOI_VECTOR());
        INTERPRETERS.put(MARK_HASHMAP, new IOI_HASHMAP());
        INTERPRETERS.put(MARK_HASHSET, new IOI_HASHSET());
        INTERPRETERS.put(MARK_TREEMAP, new IOI_TREEMAP());
        INTERPRETERS.put(MARK_TREESET, new IOI_TREESET());
        INTERPRETERS.put(MARK_HASHTABLE, new IOI_HASHTABLE());
        INTERPRETERS.put(MARK_NULL_OBJECT, new IOI_NULLOBJECT());
        INTERPRETERS.put(MARK_MRESULT, new IOI_MResult());
        INTERPRETERS.put(MARK_MULTIDIMKEY, new IOI_MultiDimKey());
        INTERPRETERS.put(MARK_MULTIDIMANALYZER, new IOI_MultiDimAnalyzer());
        INTERPRETERS.put(MARK_STRESS_RULE, new IOI_StressRuleArray());
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        INTERPRETER_TAGS_BY_CLASS_STRING.put(clazz.getName(), "I");
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("[I");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        INTERPRETER_TAGS_BY_CLASS_STRING.put(clazz2.getName(), MARK_INT_ARR);
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("java.lang.Double");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        INTERPRETER_TAGS_BY_CLASS_STRING.put(clazz3.getName(), MARK_DOUBLE);
        Class<?> clazz4 = class$3;
        if (clazz4 == null) {
            try {
                clazz4 = class$3 = Class.forName("java.lang.Long");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        INTERPRETER_TAGS_BY_CLASS_STRING.put(clazz4.getName(), MARK_LONG);
        Class<?> clazz5 = class$4;
        if (clazz5 == null) {
            try {
                clazz5 = class$4 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        INTERPRETER_TAGS_BY_CLASS_STRING.put(clazz5.getName(), MARK_STRING);
        Class<?> clazz6 = class$5;
        if (clazz6 == null) {
            try {
                clazz6 = class$5 = Class.forName("[Ljava.lang.String;");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        INTERPRETER_TAGS_BY_CLASS_STRING.put(clazz6.getName(), MARK_STRING_ARR);
        Class<?> clazz7 = class$6;
        if (clazz7 == null) {
            try {
                clazz7 = class$6 = Class.forName("java.util.Date");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        INTERPRETER_TAGS_BY_CLASS_STRING.put(clazz7.getName(), MARK_DATE);
        Class<?> clazz8 = class$7;
        if (clazz8 == null) {
            try {
                clazz8 = class$7 = Class.forName("java.lang.Boolean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        INTERPRETER_TAGS_BY_CLASS_STRING.put(clazz8.getName(), MARK_BOOLEAN);
        Class<?> clazz9 = class$8;
        if (clazz9 == null) {
            try {
                clazz9 = class$8 = Class.forName("[Z");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        INTERPRETER_TAGS_BY_CLASS_STRING.put(clazz9.getName(), MARK_BOOLEAN_ARR);
        Class<?> clazz10 = class$9;
        if (clazz10 == null) {
            try {
                clazz10 = class$9 = Class.forName("java.lang.Character");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        INTERPRETER_TAGS_BY_CLASS_STRING.put(clazz10.getName(), MARK_CHARACTER);
        Class<?> clazz11 = class$10;
        if (clazz11 == null) {
            try {
                clazz11 = class$10 = Class.forName("[J");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        INTERPRETER_TAGS_BY_CLASS_STRING.put(clazz11.getName(), MARK_LONG_ARR);
        Class<?> clazz12 = class$11;
        if (clazz12 == null) {
            try {
                clazz12 = class$11 = Class.forName("[D");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        INTERPRETER_TAGS_BY_CLASS_STRING.put(clazz12.getName(), MARK_DOUBLE_ARR);
        Class<?> clazz13 = class$12;
        if (clazz13 == null) {
            try {
                clazz13 = class$12 = Class.forName("[Lmausoleum.mouse.Task;");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        INTERPRETER_TAGS_BY_CLASS_STRING.put(clazz13.getName(), MARK_TASK_ARR);
        Class<?> clazz14 = class$13;
        if (clazz14 == null) {
            try {
                clazz14 = class$13 = Class.forName("[Lmausoleum.mouse.TaskExtended;");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        INTERPRETER_TAGS_BY_CLASS_STRING.put(clazz14.getName(), MARK_TASK_EXT_ARR);
        Class<?> clazz15 = class$14;
        if (clazz15 == null) {
            try {
                clazz15 = class$14 = Class.forName("[Lmausoleum.visit.Visit;");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        INTERPRETER_TAGS_BY_CLASS_STRING.put(clazz15.getName(), MARK_VISIT_ARR);
        Class<?> clazz16 = class$15;
        if (clazz16 == null) {
            try {
                clazz16 = class$15 = Class.forName("mausoleum.rack.RackPos");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        INTERPRETER_TAGS_BY_CLASS_STRING.put(clazz16.getName(), MARK_RACKPOS);
        Class<?> clazz17 = class$16;
        if (clazz17 == null) {
            try {
                clazz17 = class$16 = Class.forName("java.awt.Color");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        INTERPRETER_TAGS_BY_CLASS_STRING.put(clazz17.getName(), MARK_COLOR);
        Class<?> clazz18 = class$17;
        if (clazz18 == null) {
            try {
                clazz18 = class$17 = Class.forName("[Lde.hannse.netobjects.objectstore.IndexObject;");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        INTERPRETER_TAGS_BY_CLASS_STRING.put(clazz18.getName(), MARK_INDEXOBJECT_ARR);
        Class<?> clazz19 = class$18;
        if (clazz19 == null) {
            try {
                clazz19 = class$18 = Class.forName("mausoleum.locus.LocusAndAlleles");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        INTERPRETER_TAGS_BY_CLASS_STRING.put(clazz19.getName(), MARK_LOCANDALL);
        Class<?> clazz20 = class$19;
        if (clazz20 == null) {
            try {
                clazz20 = class$19 = Class.forName("[Lmausoleum.locus.LocusAndAlleles;");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        INTERPRETER_TAGS_BY_CLASS_STRING.put(clazz20.getName(), MARK_LOCANDALL_ARR);
        Class<?> clazz21 = class$20;
        if (clazz21 == null) {
            try {
                clazz21 = class$20 = Class.forName("[Ljava.lang.Object;");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        INTERPRETER_TAGS_BY_CLASS_STRING.put(clazz21.getName(), MARK_OBJECT_ARR);
        Class<?> clazz22 = class$21;
        if (clazz22 == null) {
            try {
                clazz22 = class$21 = Class.forName("mausoleum.result.ResultObjectImage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        INTERPRETER_TAGS_BY_CLASS_STRING.put(clazz22.getName(), MARK_ROI);
        Class<?> clazz23 = class$22;
        if (clazz23 == null) {
            try {
                clazz23 = class$22 = Class.forName("mausoleum.result.GPSCoordinates");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        INTERPRETER_TAGS_BY_CLASS_STRING.put(clazz23.getName(), MARK_GPS);
        Class<?> clazz24 = class$23;
        if (clazz24 == null) {
            try {
                clazz24 = class$23 = Class.forName("java.awt.Point");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        INTERPRETER_TAGS_BY_CLASS_STRING.put(clazz24.getName(), MARK_POINT);
        Class<?> clazz25 = class$24;
        if (clazz25 == null) {
            try {
                clazz25 = class$24 = Class.forName("java.awt.Font");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        INTERPRETER_TAGS_BY_CLASS_STRING.put(clazz25.getName(), MARK_FONT);
        Class<?> clazz26 = class$25;
        if (clazz26 == null) {
            try {
                clazz26 = class$25 = Class.forName("java.awt.Polygon");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        INTERPRETER_TAGS_BY_CLASS_STRING.put(clazz26.getName(), MARK_POLYGON);
        Class<?> clazz27 = class$26;
        if (clazz27 == null) {
            try {
                clazz27 = class$26 = Class.forName("java.awt.Image");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        INTERPRETER_TAGS_BY_CLASS_STRING.put(clazz27.getName(), MARK_IMAGE);
        Class<?> clazz28 = class$27;
        if (clazz28 == null) {
            try {
                clazz28 = class$27 = Class.forName("java.util.Vector");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        INTERPRETER_TAGS_BY_CLASS_STRING.put(clazz28.getName(), MARK_VECTOR);
        Class<?> clazz29 = class$28;
        if (clazz29 == null) {
            try {
                clazz29 = class$28 = Class.forName("java.util.HashMap");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        INTERPRETER_TAGS_BY_CLASS_STRING.put(clazz29.getName(), MARK_HASHMAP);
        Class<?> clazz30 = class$29;
        if (clazz30 == null) {
            try {
                clazz30 = class$29 = Class.forName("java.util.HashSet");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        INTERPRETER_TAGS_BY_CLASS_STRING.put(clazz30.getName(), MARK_HASHSET);
        Class<?> clazz31 = class$30;
        if (clazz31 == null) {
            try {
                clazz31 = class$30 = Class.forName("java.util.TreeMap");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        INTERPRETER_TAGS_BY_CLASS_STRING.put(clazz31.getName(), MARK_TREEMAP);
        Class<?> clazz32 = class$31;
        if (clazz32 == null) {
            try {
                clazz32 = class$31 = Class.forName("java.util.TreeSet");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        INTERPRETER_TAGS_BY_CLASS_STRING.put(clazz32.getName(), MARK_TREESET);
        Class<?> clazz33 = class$32;
        if (clazz33 == null) {
            try {
                clazz33 = class$32 = Class.forName("java.util.Hashtable");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        INTERPRETER_TAGS_BY_CLASS_STRING.put(clazz33.getName(), MARK_HASHTABLE);
        Class<?> clazz34 = class$33;
        if (clazz34 == null) {
            try {
                clazz34 = class$33 = Class.forName("de.hannse.netobjects.objectstore.NULLObject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        INTERPRETER_TAGS_BY_CLASS_STRING.put(clazz34.getName(), MARK_NULL_OBJECT);
        Class<?> clazz35 = class$34;
        if (clazz35 == null) {
            try {
                clazz35 = class$34 = Class.forName("mausoleum.result.MResult");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        INTERPRETER_TAGS_BY_CLASS_STRING.put(clazz35.getName(), MARK_MRESULT);
        Class<?> clazz36 = class$35;
        if (clazz36 == null) {
            try {
                clazz36 = class$35 = Class.forName("mausoleum.factsheets.multidimreport.MultiDimAnalyzer$MDKey");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        INTERPRETER_TAGS_BY_CLASS_STRING.put(clazz36.getName(), MARK_MULTIDIMKEY);
        Class<?> clazz37 = class$36;
        if (clazz37 == null) {
            try {
                clazz37 = class$36 = Class.forName("mausoleum.factsheets.multidimreport.MultiDimAnalyzer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        INTERPRETER_TAGS_BY_CLASS_STRING.put(clazz37.getName(), MARK_MULTIDIMANALYZER);
        Class<?> clazz38 = class$37;
        if (clazz38 == null) {
            try {
                clazz38 = class$37 = Class.forName("[Lmausoleum.mouse.tierschutz.StressRule;");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        INTERPRETER_TAGS_BY_CLASS_STRING.put(clazz38.getName(), MARK_STRESS_RULE);
    }

    private static void addKeyEntry(String longKey, String shortKey) {
        if (KEY_DICT_HIN.containsKey(longKey)) {
            System.out.println("Doppelte Belegung im Key Hin-dict " + longKey);
        }
        if (KEY_DICT_HER.containsKey(shortKey)) {
            System.out.println("Doppelte Belegung im Key Her-dict " + shortKey);
        }
        KEY_DICT_HIN.put(longKey, shortKey);
        KEY_DICT_HER.put(shortKey, longKey);
    }

    private static void addClassEntry(String longKey, String shortKey) {
        CLASS_DICT_HIN.put(longKey, shortKey);
        CLASS_DICT_HER.put(shortKey, longKey);
    }

    public static String getXMLString(IDObject ido, String group) {
        return IDObjectXMLHandler.getXMLString(ido, null, true, true, group, false);
    }

    public static String getExportXML(IDObject ido, HashSet wantedKeys) {
        return IDObjectXMLHandler.getXMLString(ido, wantedKeys, false, false, null, false);
    }

    public static String getXMLString(IDObject ido, HashSet wantedKeys, boolean wantSessions, boolean mailExtra, String groupForMailWennMailExtra, boolean wantsAllKeys) {
        StringBuilder msb = new StringBuilder(10000);
        try {
            String cl = ido.getClass().getName();
            String xcl = (String)CLASS_DICT_HIN.get(cl);
            if (xcl != null) {
                cl = xcl;
            }
            msb.append(M_IDO_OPEN_TAG).append(" ").append(M_CLASS_TAG).append("=").append(cl).append(" ");
            msb.append(M_GENERAL_INFO_TAG).append("=");
            msb.append(ido.getID()).append(TRENNER2);
            msb.append(ido.getInt("IDO_VERSION")).append(TRENNER2);
            Date d = ido.getDate("IDO_START_DATE");
            if (d != null) {
                msb.append(d.getTime() / 1000L);
            }
            msb.append(TRENNER2);
            d = ido.getDate("IDO_END_DATE");
            if (d != null) {
                msb.append(d.getTime() / 1000L);
            }
            msb.append(" ");
            Enumeration en = ido.ivProperties.keys();
            while (en.hasMoreElements()) {
                Object key = en.nextElement();
                boolean takeit = false;
                if (wantsAllKeys) {
                    takeit = true;
                } else if (wantedKeys != null) {
                    takeit = wantedKeys.contains(key);
                } else {
                    boolean bl = takeit = !EXCLUDE_KEYS.contains(key);
                }
                if (!takeit) continue;
                String rk = (String)KEY_DICT_HIN.get(key);
                String xml = IDObjectXMLHandler.getTransport(ido.ivProperties.get(key), false, true);
                if (xml != null && xml.length() != 0) {
                    msb.append((Object)(rk != null ? rk : key)).append("=").append(xml).append(" ");
                    continue;
                }
                String string = "getXMLString Folge LEERER WERT bei Key " + key + " in Object " + ido.ivProperties;
                Class<?> clazz = class$38;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("de.hannse.netobjects.objectstore.IDObjectXMLHandler");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Log.warn(string, null, clazz);
            }
            if (wantSessions) {
                TreeSet ts = ido.getSessions();
                if (ts != null && !ts.isEmpty()) {
                    msb.append(M_SESSION_TAG).append("=");
                    msb.append(IDObjectXMLHandler.getSessionString(ts));
                }
                msb.append(" ");
            }
            if (ido instanceof Mail && mailExtra) {
                String xml = IDObjectXMLHandler.getTransport(ido.getGroup(), false, true);
                if ((xml == null || xml.length() == 0) && groupForMailWennMailExtra != null && groupForMailWennMailExtra.length() != 0) {
                    xml = IDObjectXMLHandler.getTransport(groupForMailWennMailExtra, false, true);
                }
                if (xml != null && xml.length() != 0) {
                    msb.append(ORIGINAL_GROUP_DICT_TAG).append("=").append(xml);
                } else {
                    String string = "[DON'T WORRY!!!] getXMLString LEERER WERT (Bereich mailExtra) bei ORIGINAL_GROUP_DICT_TAG in Object " + ido.ivProperties;
                    Class<?> clazz = class$38;
                    if (clazz == null) {
                        try {
                            clazz = class$38 = Class.forName("de.hannse.netobjects.objectstore.IDObjectXMLHandler");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    Log.info(string, clazz);
                }
            }
            msb.append("/>\n");
        }
        catch (Throwable e) {
            String string = "getXMLString Problem " + msb.toString();
            Class<?> clazz = class$38;
            if (clazz == null) {
                try {
                    clazz = class$38 = Class.forName("de.hannse.netobjects.objectstore.IDObjectXMLHandler");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Log.error(string, e, clazz);
        }
        return msb.toString();
    }

    public static TreeSet getSessionTreset(String compr) {
        TreeSet ts2 = new TreeSet();
        IDObjectXMLHandler.appendToSessionTreeset(compr, ts2);
        return ts2;
    }

    public static void appendToSessionTreeset(String sessDef, TreeSet target) {
        if (sessDef != null && sessDef.length() != 0) {
            Zeile z = new Zeile(sessDef, '|');
            int i = 0;
            while (i < z.size()) {
                String s = z.getString(i, null);
                if (s != null) {
                    int ind = s.indexOf("/");
                    if (ind == -1) {
                        target.add(new Long(s));
                    } else {
                        long s1 = Long.parseLong(s.substring(0, ind));
                        long e1 = Long.parseLong(s.substring(ind + 1, s.length()));
                        long k = s1;
                        while (k <= e1) {
                            target.add(new Long(k));
                            ++k;
                        }
                    }
                }
                ++i;
            }
        }
    }

    public static String getSessionString(TreeSet ts) {
        long last;
        if (ts == null || ts.isEmpty()) {
            return "";
        }
        StringBuilder msb = new StringBuilder(ts.size() * 5);
        long start = last = Long.MIN_VALUE;
        boolean alapp = false;
        Iterator iterator = ts.iterator();
        while (iterator.hasNext()) {
            long val = (Long)iterator.next();
            if (val - last == 1L) {
                last = val;
                continue;
            }
            if (last != Long.MIN_VALUE) {
                if (start == last) {
                    if (alapp) {
                        msb.append(TRENNER2);
                    }
                    msb.append(start);
                    alapp = true;
                } else {
                    if (alapp) {
                        msb.append(TRENNER2);
                    }
                    msb.append(start).append("/").append(last);
                    alapp = true;
                }
            }
            start = val;
            last = val;
        }
        if (last != Integer.MIN_VALUE) {
            if (start == last) {
                if (alapp) {
                    msb.append(TRENNER2);
                }
                msb.append(start);
            } else {
                if (alapp) {
                    msb.append(TRENNER2);
                }
                msb.append(start).append("/").append(last);
            }
        }
        return msb.toString();
    }

    public static String getMark(Object val) {
        String mark = null;
        if (val instanceof Integer) {
            mark = "I";
        } else if (val instanceof Double) {
            mark = MARK_DOUBLE;
        } else if (val instanceof Long) {
            mark = MARK_LONG;
        } else if (val instanceof String) {
            mark = MARK_STRING;
        } else if (val instanceof Date) {
            mark = MARK_DATE;
        } else if (val instanceof Boolean) {
            mark = MARK_BOOLEAN;
        } else if (val instanceof Character) {
            mark = MARK_CHARACTER;
        } else if (val instanceof long[]) {
            mark = MARK_LONG_ARR;
        } else if (val instanceof boolean[]) {
            mark = MARK_BOOLEAN_ARR;
        } else if (val instanceof TaskExtended[]) {
            mark = MARK_TASK_EXT_ARR;
        } else if (val instanceof StressRule[]) {
            mark = MARK_STRESS_RULE;
        } else if (val instanceof Visit[]) {
            mark = MARK_VISIT_ARR;
        } else if (val instanceof RackPos) {
            mark = MARK_RACKPOS;
        } else if (val instanceof Color) {
            mark = MARK_COLOR;
        } else if (val instanceof int[]) {
            mark = MARK_INT_ARR;
        } else if (val instanceof double[]) {
            mark = MARK_DOUBLE_ARR;
        } else if (val instanceof String[]) {
            mark = MARK_STRING_ARR;
        } else if (val instanceof IndexObject[]) {
            mark = MARK_INDEXOBJECT_ARR;
        } else if (val instanceof LocusAndAlleles) {
            mark = MARK_LOCANDALL;
        } else if (val instanceof LocusAndAlleles[]) {
            mark = MARK_LOCANDALL_ARR;
        } else if (val instanceof Object[]) {
            mark = MARK_OBJECT_ARR;
        } else if (val instanceof ResultObjectImage) {
            mark = MARK_ROI;
        } else if (val instanceof GPSCoordinates) {
            mark = MARK_GPS;
        } else if (val instanceof MResult) {
            mark = MARK_MRESULT;
        } else if (val instanceof Font) {
            mark = MARK_FONT;
        } else if (val instanceof Polygon) {
            mark = MARK_POLYGON;
        } else if (val instanceof BufferedImage) {
            mark = MARK_IMAGE;
        } else if (val instanceof Point) {
            mark = MARK_POINT;
        } else if (val instanceof Vector) {
            mark = MARK_VECTOR;
        } else if (val instanceof TreeSet) {
            mark = MARK_TREESET;
        } else if (val instanceof HashMap) {
            mark = MARK_HASHMAP;
        } else if (val instanceof HashSet) {
            mark = MARK_HASHSET;
        } else if (val instanceof TreeMap) {
            mark = MARK_TREEMAP;
        } else if (val instanceof Hashtable) {
            mark = MARK_HASHTABLE;
        } else if (val instanceof NULLObject) {
            mark = MARK_NULL_OBJECT;
        } else if (val instanceof MultiDimAnalyzer.MDKey) {
            mark = MARK_MULTIDIMKEY;
        } else if (val instanceof MultiDimAnalyzer) {
            mark = MARK_MULTIDIMANALYZER;
        }
        return mark;
    }

    public static IOXInterpret getInterpreter(String mark) {
        if (mark != null) {
            return (IOXInterpret)INTERPRETERS.get(mark);
        }
        return null;
    }

    public static String getTransport(Object val, boolean mitEncoding, boolean withMark) {
        StringBuilder msb;
        block10: {
            if (val == null) {
                return "";
            }
            msb = new StringBuilder();
            try {
                String mark = IDObjectXMLHandler.getMark(val);
                if (mark != null) {
                    IDObjectXMLHandler.getInterpreter(mark).append(val, msb, withMark);
                    break block10;
                }
                String string = "Unknown class " + val.getClass().getName();
                Class<?> clazz = class$38;
                if (clazz == null) {
                    try {
                        clazz = class$38 = Class.forName("de.hannse.netobjects.objectstore.IDObjectXMLHandler");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Log.warn(string, null, clazz);
            }
            catch (Throwable e) {
                String string = "Problem bei " + val;
                Class<?> clazz = class$38;
                if (clazz == null) {
                    try {
                        clazz = class$38 = Class.forName("de.hannse.netobjects.objectstore.IDObjectXMLHandler");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Log.error(string, e, clazz);
            }
        }
        return mitEncoding && msb.length() != 0 ? Base64Manager.encodeBase64(msb.toString()) : msb.toString();
    }

    public static IDObject initSimpleObjectFromXMLString(String line, String group) {
        return IDObjectXMLHandler.initSimpleObjectFromXMLString(line, group, false);
    }

    public static IDObject initSimpleObjectFromXMLString(String line, String group, boolean ignoreExcludes) {
        String si;
        if ((line = line.trim()).endsWith("/>")) {
            line = line.substring(0, line.length() - 2);
        }
        Hashtable<String, String> dict = new Hashtable<String, String>(20);
        Vector lv = StringHelper.splitStringByAny(line, " ");
        Iterator iter = lv.iterator();
        while (iter.hasNext()) {
            String part = (String)iter.next();
            int ind = part.indexOf("=");
            if (ind == -1) continue;
            dict.put(part.substring(0, ind), part.substring(ind + 1, part.length()));
        }
        String cn = (String)dict.get(M_CLASS_TAG);
        if (cn == null) {
            String string = "Could not find classname Attribute " + line;
            Class<?> clazz = class$38;
            if (clazz == null) {
                try {
                    clazz = class$38 = Class.forName("de.hannse.netobjects.objectstore.IDObjectXMLHandler");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Log.warn(string, null, clazz);
            return null;
        }
        String xcn = (String)CLASS_DICT_HER.get(cn);
        if (xcn != null) {
            cn = xcn;
        }
        dict.remove(M_CLASS_TAG);
        IDObject erg = null;
        try {
            erg = (IDObject)Class.forName(cn).newInstance();
        }
        catch (ClassNotFoundException cnfe) {
            String string = "Could not find class " + cn;
            Class<?> clazz = class$38;
            if (clazz == null) {
                try {
                    clazz = class$38 = Class.forName("de.hannse.netobjects.objectstore.IDObjectXMLHandler");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Log.warn(string, cnfe, clazz);
            return null;
        }
        catch (Throwable e) {
            String string = "Initialization crashed " + cn;
            Class<?> clazz = class$38;
            if (clazz == null) {
                try {
                    clazz = class$38 = Class.forName("de.hannse.netobjects.objectstore.IDObjectXMLHandler");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Log.warn(string, e, clazz);
            return null;
        }
        String gi = (String)dict.get(M_GENERAL_INFO_TAG);
        if (gi != null) {
            Vector v = StringHelper.splitStringByAny(gi, TRENNER2);
            erg.setLong("IDO_ID", Long.parseLong((String)v.elementAt(0)));
            erg.setInt("IDO_VERSION", Integer.parseInt((String)v.elementAt(1)));
            String t = ((String)v.elementAt(2)).trim();
            if (t.length() != 0) {
                erg.set("IDO_START_DATE", new Date(Long.parseLong(t) * 1000L));
            }
            if ((t = ((String)v.elementAt(3)).trim()).length() != 0) {
                erg.set("IDO_END_DATE", new Date(Long.parseLong(t) * 1000L));
            }
            dict.remove(M_GENERAL_INFO_TAG);
        }
        if ((si = (String)dict.get(M_SESSION_TAG)) != null) {
            try {
                erg.setSessions(IDObjectXMLHandler.getSessionTreset(si));
            }
            catch (Exception e) {
                erg.setSessions(null);
            }
            dict.remove(M_SESSION_TAG);
        }
        Enumeration aen = dict.keys();
        while (aen.hasMoreElements()) {
            Object val;
            String key = (String)aen.nextElement();
            if (!ignoreExcludes && EXCLUDE_KEYS.contains(key) || (val = IDObjectXMLHandler.getObject((String)dict.get(key), group, false)) == null) continue;
            String fkey = (String)KEY_DICT_HER.get(key);
            if (fkey == null) {
                fkey = key;
            }
            erg.set(fkey, val);
        }
        erg.commit(false);
        TaskExtended.polishTaskArray(erg);
        return erg;
    }

    public static IDObject initObjectFromXMLString(String line, String group, DataLayer datalayer) {
        Object o;
        IDObject erg = IDObjectXMLHandler.initSimpleObjectFromXMLString(line, group);
        if (erg instanceof Mail) {
            String ogroup = erg.getString("IDO_OGROUP");
            if (ogroup != null) {
                String og;
                String rg;
                String sg = erg.getString("MAI_SGROUP");
                if (sg != null && sg.equals(ogroup)) {
                    erg.set("MAI_SGROUP", group);
                }
                if ((rg = erg.getString("MAI_RGROUP")) != null && rg.equals(ogroup)) {
                    erg.set("MAI_RGROUP", group);
                }
                if ((og = erg.getString("MAI_OGROUP")) != null && og.equals(ogroup)) {
                    erg.set("MAI_OGROUP", group);
                }
            }
            erg.set("IDO_OGROUP", null);
            erg.commit(true);
        }
        if (erg instanceof Result && (o = erg.get("RES_RESULT")) != null && o instanceof ResultObjectImage) {
            long id = erg.getID();
            ResultObjectImage roi = (ResultObjectImage)o;
            try {
                Vector thumbv = datalayer.loadThumbImage(group, Long.toString(id));
                if (thumbv != null) {
                    roi.ivThumbData = (int[])thumbv.elementAt(0);
                }
            }
            catch (Throwable e) {
                Class<?> clazz = class$38;
                if (clazz == null) {
                    try {
                        clazz = class$38 = Class.forName("de.hannse.netobjects.objectstore.IDObjectXMLHandler");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Log.error("Loading Thumb for ROI crashed ", e, clazz);
            }
        }
        return erg;
    }

    public static Object getObject(String s) {
        return IDObjectXMLHandler.getObject(s, null, false);
    }

    public static Object getObject(String s, String group, boolean mitEncoding) {
        if (s != null && s.length() != 0) {
            int ind;
            if (mitEncoding) {
                s = Base64Manager.getDecodedString(s);
            }
            return IDObjectXMLHandler.getObject((ind = s.indexOf(TRENNER1)) == -1 ? s : s.substring(0, ind), ind == -1 ? null : s.substring(ind + 1, s.length()), group);
        }
        return null;
    }

    public static Object getObject(String mark, String value, String group) {
        try {
            IOXInterpret ioxi = (IOXInterpret)INTERPRETERS.get(mark);
            if (ioxi != null) {
                return ioxi.holObject(value, group);
            }
            String string = "getObject Unknown Type " + mark;
            Class<?> clazz = class$38;
            if (clazz == null) {
                try {
                    clazz = class$38 = Class.forName("de.hannse.netobjects.objectstore.IDObjectXMLHandler");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Log.error(string, null, clazz);
        }
        catch (Throwable e) {
            String string = "getObject Problem with coding String: mark " + mark + " value " + value;
            Class<?> clazz = class$38;
            if (clazz == null) {
                try {
                    clazz = class$38 = Class.forName("de.hannse.netobjects.objectstore.IDObjectXMLHandler");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Log.error(string, e, clazz);
        }
        return null;
    }

    public static String getMarkByClassSTring(String classId) {
        return (String)INTERPRETER_TAGS_BY_CLASS_STRING.get(classId);
    }

    public static class IOI_BOOLEAN
    implements IOXInterpret {
        public Object holObject(String v, String group) {
            return new Boolean(v.equals("1"));
        }

        public void append(Object val, StringBuilder msb, boolean withMark) {
            if (withMark) {
                msb.append(IDObjectXMLHandler.MARK_BOOLEAN).append(IDObjectXMLHandler.TRENNER1);
            }
            msb.append((Boolean)val != false ? "1" : "0");
        }
    }

    public static class IOI_BOOLEAN_ARR
    implements IOXInterpret {
        public Object holObject(String v, String group) {
            v = v.trim();
            boolean[] arr = new boolean[v.length()];
            int i = 0;
            while (i < v.length()) {
                arr[i] = v.charAt(i) == '1';
                ++i;
            }
            return arr;
        }

        public void append(Object val, StringBuilder msb, boolean withMark) {
            boolean[] arr = (boolean[])val;
            if (arr.length != 0) {
                if (withMark) {
                    msb.append(IDObjectXMLHandler.MARK_BOOLEAN_ARR).append(IDObjectXMLHandler.TRENNER1);
                }
                int i = 0;
                while (i < arr.length) {
                    if (arr[i]) {
                        msb.append("1");
                    } else {
                        msb.append("0");
                    }
                    ++i;
                }
            }
        }
    }

    public static class IOI_CHARACTER
    implements IOXInterpret {
        public Object holObject(String v, String group) {
            return new Character(v.charAt(0));
        }

        public void append(Object val, StringBuilder msb, boolean withMark) {
            if (withMark) {
                msb.append(IDObjectXMLHandler.MARK_CHARACTER).append(IDObjectXMLHandler.TRENNER1);
            }
            msb.append(((Character)val).charValue());
        }
    }

    public static class IOI_COLOR
    implements IOXInterpret {
        public Object holObject(String v, String group) {
            Zeile z = new Zeile(v, '|');
            if (z.size() == 3) {
                return new Color(z.getInt(0, 0), z.getInt(1, 0), z.getInt(2, 0));
            }
            if (z.size() == 6) {
                Color mainColor = new Color(z.getInt(0, 0), z.getInt(1, 0), z.getInt(2, 0));
                Color rahmenColor = new Color(z.getInt(3, 0), z.getInt(4, 0), z.getInt(5, 0));
                return new PralineColor(mainColor, rahmenColor);
            }
            if (z.size() == 7) {
                Color c1 = new Color(z.getInt(0, 0), z.getInt(1, 0), z.getInt(2, 0));
                Color c2 = new Color(z.getInt(3, 0), z.getInt(4, 0), z.getInt(5, 0));
                return new MusterColor(c1, c2, z.getInt(6, 0));
            }
            return null;
        }

        public void append(Object val, StringBuilder msb, boolean withMark) {
            if (withMark) {
                msb.append(IDObjectXMLHandler.MARK_COLOR).append(IDObjectXMLHandler.TRENNER1);
            }
            if (val instanceof MusterColor) {
                MusterColor mc = (MusterColor)val;
                Color color = mc;
                msb.append(color.getRed()).append(IDObjectXMLHandler.TRENNER2);
                msb.append(color.getGreen()).append(IDObjectXMLHandler.TRENNER2);
                msb.append(color.getBlue()).append(IDObjectXMLHandler.TRENNER2);
                color = mc.ivSecondColor;
                msb.append(color.getRed()).append(IDObjectXMLHandler.TRENNER2);
                msb.append(color.getGreen()).append(IDObjectXMLHandler.TRENNER2);
                msb.append(color.getBlue()).append(IDObjectXMLHandler.TRENNER2);
                msb.append(mc.ivMuster);
            } else if (val instanceof PralineColor) {
                PralineColor pc = (PralineColor)val;
                msb.append(pc.getRed()).append(IDObjectXMLHandler.TRENNER2);
                msb.append(pc.getGreen()).append(IDObjectXMLHandler.TRENNER2);
                msb.append(pc.getBlue()).append(IDObjectXMLHandler.TRENNER2);
                Color color = pc.ivRahmenColor;
                msb.append(color.getRed()).append(IDObjectXMLHandler.TRENNER2);
                msb.append(color.getGreen()).append(IDObjectXMLHandler.TRENNER2);
                msb.append(color.getBlue());
            } else {
                Color color = (Color)val;
                msb.append(color.getRed()).append(IDObjectXMLHandler.TRENNER2);
                msb.append(color.getGreen()).append(IDObjectXMLHandler.TRENNER2);
                msb.append(color.getBlue());
            }
        }
    }

    public static class IOI_DATE
    implements IOXInterpret {
        public Object holObject(String v, String group) {
            return new Date(Long.parseLong(v) * 1000L);
        }

        public void append(Object val, StringBuilder msb, boolean withMark) {
            if (withMark) {
                msb.append(IDObjectXMLHandler.MARK_DATE).append(IDObjectXMLHandler.TRENNER1);
            }
            msb.append(((Date)val).getTime() / 1000L);
        }
    }

    public static class IOI_DOUBLE
    implements IOXInterpret {
        public Object holObject(String v, String group) {
            return new Double(v);
        }

        public void append(Object val, StringBuilder msb, boolean withMark) {
            if (withMark) {
                msb.append(IDObjectXMLHandler.MARK_DOUBLE).append(IDObjectXMLHandler.TRENNER1);
            }
            msb.append((Double)val);
        }
    }

    public static class IOI_DOUBLE_ARR
    implements IOXInterpret {
        public Object holObject(String v, String group) {
            Zeile z = new Zeile(v, '|');
            double[] arr = new double[z.size()];
            int i = 0;
            while (i < arr.length) {
                arr[i] = z.getDouble(i, 0.0);
                ++i;
            }
            return arr;
        }

        public void append(Object val, StringBuilder msb, boolean withMark) {
            double[] arr = (double[])val;
            if (arr.length != 0) {
                if (withMark) {
                    msb.append(IDObjectXMLHandler.MARK_DOUBLE_ARR).append(IDObjectXMLHandler.TRENNER1);
                }
                int i = 0;
                while (i < arr.length) {
                    if (i != 0) {
                        msb.append(IDObjectXMLHandler.TRENNER2);
                    }
                    msb.append(arr[i]);
                    ++i;
                }
            }
        }
    }

    public static class IOI_FONT
    implements IOXInterpret {
        public Object holObject(String v, String group) {
            Zeile z = new Zeile(v, '|');
            int col = 0;
            String fname = z.getStringB64(col++, "");
            int size = z.getInt(col++, 12);
            boolean bold = z.getString(col++, "0").equals("1");
            boolean italic = z.getString(col++, "0").equals("1");
            int style = 0;
            if (bold & italic) {
                style = 0;
            } else if (bold) {
                style = 1;
            } else if (italic) {
                style = 2;
            }
            return new Font(fname, style, size);
        }

        public void append(Object val, StringBuilder msb, boolean withMark) {
            Font font = (Font)val;
            if (withMark) {
                msb.append(IDObjectXMLHandler.MARK_FONT).append(IDObjectXMLHandler.TRENNER1);
            }
            msb.append(Base64Manager.encodeBase64(font.getName())).append(IDObjectXMLHandler.TRENNER2);
            msb.append(font.getSize()).append(IDObjectXMLHandler.TRENNER2);
            msb.append(font.isBold() ? "1" : "0").append(IDObjectXMLHandler.TRENNER2);
            msb.append(font.isItalic() ? "1" : "0");
        }
    }

    public static class IOI_GPS
    implements IOXInterpret {
        public Object holObject(String v, String group) {
            Zeile z = new Zeile(v, '|');
            return new GPSCoordinates(z.getDouble(0, 0.0), z.getDouble(1, 0.0), z.getString(2, "0").equals("1"), z.getString(3, "0").equals("1"));
        }

        public void append(Object val, StringBuilder msb, boolean withMark) {
            GPSCoordinates gps = (GPSCoordinates)val;
            if (withMark) {
                msb.append(IDObjectXMLHandler.MARK_GPS).append(IDObjectXMLHandler.TRENNER1);
            }
            msb.append(gps.ivBreite).append(IDObjectXMLHandler.TRENNER2);
            msb.append(gps.ivLaenge).append(IDObjectXMLHandler.TRENNER2);
            if (gps.ivIstNorden) {
                msb.append("1");
            } else {
                msb.append("0");
            }
            msb.append(IDObjectXMLHandler.TRENNER2);
            if (gps.ivIstOsten) {
                msb.append("1");
            } else {
                msb.append("0");
            }
        }
    }

    public static class IOI_HASHMAP
    implements IOXInterpret {
        public Object holObject(String v, String group) {
            HashMap<Object, Object> h = new HashMap<Object, Object>();
            Zeile z = new Zeile(v, '|');
            int i = 0;
            while (i < z.size()) {
                int indh;
                String ts = z.getStringNONEmpty(i, null);
                if (ts != null && (indh = ts.indexOf(IDObjectXMLHandler.TRENNER3)) != -1) {
                    Object key = IDObjectXMLHandler.getObject(ts.substring(0, indh), group, true);
                    Object val = IDObjectXMLHandler.getObject(ts.substring(indh + 1, ts.length()), group, true);
                    if (key != null && val != null) {
                        h.put(key, val);
                    }
                }
                ++i;
            }
            return h;
        }

        public void append(Object val, StringBuilder msb, boolean withMark) {
            if (withMark) {
                msb.append(IDObjectXMLHandler.MARK_HASHMAP).append(IDObjectXMLHandler.TRENNER1);
            }
            HashMap h = (HashMap)val;
            boolean first = true;
            Iterator iter = h.keySet().iterator();
            while (iter.hasNext()) {
                if (!first) {
                    msb.append(IDObjectXMLHandler.TRENNER2);
                }
                Object hkey = iter.next();
                Object hval = h.get(hkey);
                msb.append(IDObjectXMLHandler.getTransport(hkey, true, true)).append(IDObjectXMLHandler.TRENNER3).append(IDObjectXMLHandler.getTransport(hval, true, true));
                first = false;
            }
        }
    }

    public static class IOI_HASHSET
    implements IOXInterpret {
        public Object holObject(String v, String group) {
            HashSet<Object> h = new HashSet<Object>();
            Zeile z = new Zeile(v, '|');
            int i = 0;
            while (i < z.size()) {
                String ts = z.getStringNONEmpty(i, null);
                if (ts != null) {
                    h.add(IDObjectXMLHandler.getObject(ts, group, true));
                }
                ++i;
            }
            return h;
        }

        public void append(Object val, StringBuilder msb, boolean withMark) {
            if (withMark) {
                msb.append(IDObjectXMLHandler.MARK_HASHSET).append(IDObjectXMLHandler.TRENNER1);
            }
            HashSet h = (HashSet)val;
            boolean first = true;
            Iterator iter = h.iterator();
            while (iter.hasNext()) {
                if (!first) {
                    msb.append(IDObjectXMLHandler.TRENNER2);
                }
                msb.append(IDObjectXMLHandler.getTransport(iter.next(), true, true));
                first = false;
            }
        }
    }

    public static class IOI_HASHTABLE
    implements IOXInterpret {
        public Object holObject(String v, String group) {
            Hashtable<Object, Object> h = new Hashtable<Object, Object>();
            Zeile z = new Zeile(v, '|');
            int i = 0;
            while (i < z.size()) {
                int indh;
                String ts = z.getStringNONEmpty(i, null);
                if (ts != null && (indh = ts.indexOf(IDObjectXMLHandler.TRENNER3)) != -1) {
                    Object key = IDObjectXMLHandler.getObject(ts.substring(0, indh), group, true);
                    Object val = IDObjectXMLHandler.getObject(ts.substring(indh + 1, ts.length()), group, true);
                    if (key != null && val != null) {
                        h.put(key, val);
                    }
                }
                ++i;
            }
            return h;
        }

        public void append(Object val, StringBuilder msb, boolean withMark) {
            if (withMark) {
                msb.append(IDObjectXMLHandler.MARK_HASHTABLE).append(IDObjectXMLHandler.TRENNER1);
            }
            Hashtable h = (Hashtable)val;
            boolean first = true;
            Iterator iter = h.keySet().iterator();
            while (iter.hasNext()) {
                if (!first) {
                    msb.append(IDObjectXMLHandler.TRENNER2);
                }
                Object hkey = iter.next();
                Object hval = h.get(hkey);
                msb.append(IDObjectXMLHandler.getTransport(hkey, true, true)).append(IDObjectXMLHandler.TRENNER3).append(IDObjectXMLHandler.getTransport(hval, true, true));
                first = false;
            }
        }
    }

    public static class IOI_IMAGE
    implements IOXInterpret {
        public Object holObject(String v, String group) {
            return ImageHelper.getImage(Base64Manager.decodeBase64(v));
        }

        public void append(Object val, StringBuilder msb, boolean withMark) {
            BufferedImage image = (BufferedImage)val;
            if (withMark) {
                msb.append(IDObjectXMLHandler.MARK_IMAGE).append(IDObjectXMLHandler.TRENNER1);
            }
            byte[] tarr = ImageHelper.getJPEG(image, 0.8f, 0);
            msb.append(Base64Manager.encodeBase64(tarr));
        }
    }

    public static class IOI_INDEXOBJECT_ARR
    implements IOXInterpret {
        public Object holObject(String v, String group) {
            Vector v2 = StringHelper.splitStringByAny(v, IDObjectXMLHandler.TRENNER2);
            IndexObject[] arr = new IndexObject[v2.size()];
            int i = 0;
            while (i < v2.size()) {
                Vector v3 = StringHelper.splitStringByAny((String)v2.elementAt(i), IDObjectXMLHandler.TRENNER3);
                arr[i] = new IndexObject(Integer.parseInt((String)v3.elementAt(0)), Long.parseLong((String)v3.elementAt(1)), Double.parseDouble((String)v3.elementAt(2)));
                ++i;
            }
            return arr;
        }

        public void append(Object val, StringBuilder msb, boolean withMark) {
            IndexObject[] indobi = (IndexObject[])val;
            if (indobi.length != 0) {
                if (withMark) {
                    msb.append(IDObjectXMLHandler.MARK_INDEXOBJECT_ARR).append(IDObjectXMLHandler.TRENNER1);
                }
                int i = 0;
                while (i < indobi.length) {
                    if (i != 0) {
                        msb.append(IDObjectXMLHandler.TRENNER2);
                    }
                    msb.append(indobi[i].ivObjectType).append(IDObjectXMLHandler.TRENNER3);
                    msb.append(indobi[i].ivObjectID).append(IDObjectXMLHandler.TRENNER3);
                    msb.append(indobi[i].ivNumber);
                    ++i;
                }
            }
        }
    }

    public static class IOI_INT
    implements IOXInterpret {
        public Object holObject(String v, String group) {
            return new Integer(v);
        }

        public void append(Object val, StringBuilder msb, boolean withMark) {
            if (withMark) {
                msb.append("I").append(IDObjectXMLHandler.TRENNER1);
            }
            msb.append((Integer)val);
        }
    }

    public static class IOI_INT_ARR
    implements IOXInterpret {
        public Object holObject(String v, String group) {
            Vector v2 = StringHelper.splitStringByAny(v, IDObjectXMLHandler.TRENNER2);
            int[] arr = new int[v2.size()];
            int i = 0;
            while (i < v2.size()) {
                arr[i] = Integer.parseInt((String)v2.elementAt(i));
                ++i;
            }
            return arr;
        }

        public void append(Object val, StringBuilder msb, boolean withMark) {
            int[] arr = (int[])val;
            if (arr.length != 0) {
                if (withMark) {
                    msb.append(IDObjectXMLHandler.MARK_INT_ARR).append(IDObjectXMLHandler.TRENNER1);
                }
                int i = 0;
                while (i < arr.length) {
                    if (i != 0) {
                        msb.append(IDObjectXMLHandler.TRENNER2);
                    }
                    msb.append(arr[i]);
                    ++i;
                }
            }
        }
    }

    public static class IOI_LOCANDALL
    implements IOXInterpret {
        public Object holObject(String v, String group) {
            Vector v3 = StringHelper.splitStringByAny(v, IDObjectXMLHandler.TRENNER3);
            long locid = Long.parseLong((String)v3.elementAt(0));
            String[] sarr = null;
            if (v3.size() > 1) {
                sarr = new String[v3.size() - 1];
                int i = 1;
                while (i < v3.size()) {
                    sarr[i - 1] = Base64Manager.getDecodedString((String)v3.elementAt(i));
                    ++i;
                }
            }
            return new LocusAndAlleles(locid, sarr);
        }

        public void append(Object val, StringBuilder msb, boolean withMark) {
            if (withMark) {
                msb.append(IDObjectXMLHandler.MARK_LOCANDALL).append(IDObjectXMLHandler.TRENNER1);
            }
            LocusAndAlleles locgentyp = (LocusAndAlleles)val;
            msb.append(locgentyp.ivLocusID);
            if (locgentyp.ivAllele != null) {
                int ali = 0;
                while (ali < locgentyp.ivAllele.length) {
                    msb.append(IDObjectXMLHandler.TRENNER3).append(Base64Manager.encodeBase64(locgentyp.ivAllele[ali]));
                    ++ali;
                }
            }
        }
    }

    public static class IOI_LOCANDALL_ARR
    implements IOXInterpret {
        public Object holObject(String v, String group) {
            Vector v2 = StringHelper.splitStringByAny(v, IDObjectXMLHandler.TRENNER2);
            LocusAndAlleles[] arr = new LocusAndAlleles[v2.size()];
            int i = 0;
            while (i < v2.size()) {
                Vector v3 = StringHelper.splitStringByAny((String)v2.elementAt(i), IDObjectXMLHandler.TRENNER3);
                long locid = Long.parseLong((String)v3.elementAt(0));
                String[] sarr = null;
                if (v3.size() > 1) {
                    sarr = new String[v3.size() - 1];
                    int iii = 1;
                    while (iii < v3.size()) {
                        sarr[iii - 1] = Base64Manager.getDecodedString((String)v3.elementAt(iii));
                        ++iii;
                    }
                }
                arr[i] = new LocusAndAlleles(locid, sarr);
                ++i;
            }
            return arr;
        }

        public void append(Object val, StringBuilder msb, boolean withMark) {
            LocusAndAlleles[] locgentyps = (LocusAndAlleles[])val;
            if (locgentyps.length != 0) {
                if (withMark) {
                    msb.append(IDObjectXMLHandler.MARK_LOCANDALL_ARR).append(IDObjectXMLHandler.TRENNER1);
                }
                int i = 0;
                while (i < locgentyps.length) {
                    if (i != 0) {
                        msb.append(IDObjectXMLHandler.TRENNER2);
                    }
                    msb.append(locgentyps[i].ivLocusID);
                    if (locgentyps[i].ivAllele != null) {
                        int ali = 0;
                        while (ali < locgentyps[i].ivAllele.length) {
                            msb.append(IDObjectXMLHandler.TRENNER3).append(Base64Manager.encodeBase64(locgentyps[i].ivAllele[ali]));
                            ++ali;
                        }
                    }
                    ++i;
                }
            }
        }
    }

    public static class IOI_LONG
    implements IOXInterpret {
        public Object holObject(String v, String group) {
            return new Long(v);
        }

        public void append(Object val, StringBuilder msb, boolean withMark) {
            if (withMark) {
                msb.append(IDObjectXMLHandler.MARK_LONG).append(IDObjectXMLHandler.TRENNER1);
            }
            msb.append((Long)val);
        }
    }

    public static class IOI_LONG_ARR
    implements IOXInterpret {
        public Object holObject(String v, String group) {
            Zeile z = new Zeile(v, '|');
            long[] arr = new long[z.size()];
            int i = 0;
            while (i < arr.length) {
                arr[i] = z.getLong(i, 0L);
                ++i;
            }
            return arr;
        }

        public void append(Object val, StringBuilder msb, boolean withMark) {
            long[] arr = (long[])val;
            if (arr.length != 0) {
                if (withMark) {
                    msb.append(IDObjectXMLHandler.MARK_LONG_ARR).append(IDObjectXMLHandler.TRENNER1);
                }
                int i = 0;
                while (i < arr.length) {
                    if (i != 0) {
                        msb.append(IDObjectXMLHandler.TRENNER2);
                    }
                    msb.append(arr[i]);
                    ++i;
                }
            }
        }
    }

    public static class IOI_MResult
    implements IOXInterpret {
        public Object holObject(String v, String group) {
            Zeile z = new Zeile(v, '|');
            int col = 0;
            long pseudoID = z.getLong(col++, 0L);
            long expID = z.getLong(col++, 0L);
            MResult mres = new MResult(expID);
            mres.ivPseudoID = pseudoID;
            mres.ivResTyp = z.getInt(col++, 0);
            mres.ivDate = z.getInt(col++, 0);
            mres.ivPerformer = z.getStringB64(col++, "");
            mres.ivResult = IDObjectXMLHandler.getObject(z.getString(col++, ""), group, true);
            return mres;
        }

        public void append(Object val, StringBuilder msb, boolean withMark) {
            if (withMark) {
                msb.append(IDObjectXMLHandler.MARK_MRESULT).append(IDObjectXMLHandler.TRENNER1);
            }
            MResult mres = (MResult)val;
            msb.append(mres.ivPseudoID).append(IDObjectXMLHandler.TRENNER2);
            msb.append(mres.getExperimentID()).append(IDObjectXMLHandler.TRENNER2);
            msb.append(mres.ivResTyp).append(IDObjectXMLHandler.TRENNER2);
            msb.append(mres.ivDate).append(IDObjectXMLHandler.TRENNER2);
            msb.append(mres.ivPerformer != null ? Base64Manager.encodeBase64(mres.ivPerformer) : "").append(IDObjectXMLHandler.TRENNER2);
            msb.append(mres.ivResult != null ? IDObjectXMLHandler.getTransport(mres.ivResult, true, true) : "");
        }
    }

    public static class IOI_MultiDimAnalyzer
    implements IOXInterpret {
        public Object holObject(String v, String group) {
            int typ;
            MultiDimAnalyzer mda;
            Zeile z = new Zeile(v, '|');
            int col = 0;
            if ((mda = MultiDimAnalyzer.getSearcher(typ = z.getInt(col++, 0))) == null) {
                String string = "Wrong analyzer type " + typ;
                Class<?> clazz = class$38;
                if (clazz == null) {
                    try {
                        clazz = class$38 = Class.forName("de.hannse.netobjects.objectstore.IDObjectXMLHandler");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Log.error(string, null, clazz);
                return null;
            }
            mda.ivIsXstart = "1".equals(z.getStringNONEmpty(col++, null));
            mda.ivIsLastOne = "1".equals(z.getStringNONEmpty(col++, null));
            mda.ivMitTotal = "1".equals(z.getStringNONEmpty(col++, null));
            String bagVal = z.getStringNONEmpty(col++, null);
            Zeile z2 = new Zeile(bagVal, '$');
            int i = 0;
            while (i < z2.size()) {
                MultiDimAnalyzer.MDKey mdkey = (MultiDimAnalyzer.MDKey)IDObjectXMLHandler.getObject(z2.getStringNONEmpty(i, null), group, true);
                Object val = IDObjectXMLHandler.getObject(z2.getStringNONEmpty(i + 1, null), group, true);
                mda.ivObjectsByMDKey.put(mdkey, val);
                i += 2;
            }
            return mda;
        }

        public void append(Object val, StringBuilder msb, boolean withMark) {
            if (withMark) {
                msb.append(IDObjectXMLHandler.MARK_MULTIDIMANALYZER).append(IDObjectXMLHandler.TRENNER1);
            }
            MultiDimAnalyzer mda = (MultiDimAnalyzer)val;
            msb.append(mda.getTyp()).append(IDObjectXMLHandler.TRENNER2);
            msb.append(mda.ivIsXstart ? "1" : "0").append(IDObjectXMLHandler.TRENNER2);
            msb.append(mda.ivIsLastOne ? "1" : "0").append(IDObjectXMLHandler.TRENNER2);
            msb.append(mda.ivMitTotal ? "1" : "0").append(IDObjectXMLHandler.TRENNER2);
            Iterator iterator = mda.ivObjectsByMDKey.keySet().iterator();
            while (iterator.hasNext()) {
                MultiDimAnalyzer.MDKey key = (MultiDimAnalyzer.MDKey)iterator.next();
                msb.append(IDObjectXMLHandler.getTransport(key, true, true)).append(IDObjectXMLHandler.TRENNER3);
                Object bval = mda.ivObjectsByMDKey.get(key);
                if (bval instanceof MultiDimAnalyzer) {
                    MultiDimAnalyzer smda = (MultiDimAnalyzer)bval;
                    msb.append(IDObjectXMLHandler.getTransport(smda, true, true));
                } else if (bval instanceof Vector) {
                    Vector v = (Vector)bval;
                    msb.append(IDObjectXMLHandler.getTransport(new Integer(v.size()), true, true));
                }
                if (!iterator.hasNext()) continue;
                msb.append(IDObjectXMLHandler.TRENNER3);
            }
        }
    }

    public static class IOI_MultiDimKey
    implements IOXInterpret {
        public Object holObject(String v, String group) {
            Zeile z = new Zeile(v, '|');
            int col = 0;
            int mdkTyp = z.getInt(col++, 0);
            Object mdkKey = IDObjectXMLHandler.getObject(z.getStringNONEmpty(col++, null), group, true);
            Comparable mdkComp = (Comparable)IDObjectXMLHandler.getObject(z.getStringNONEmpty(col++, null), group, true);
            String mdkRep = (String)IDObjectXMLHandler.getObject(z.getStringNONEmpty(col++, null), group, true);
            return new MultiDimAnalyzer.MDKey(mdkTyp, mdkKey, mdkRep, mdkComp);
        }

        public void append(Object val, StringBuilder msb, boolean withMark) {
            if (withMark) {
                msb.append(IDObjectXMLHandler.MARK_MULTIDIMKEY).append(IDObjectXMLHandler.TRENNER1);
            }
            MultiDimAnalyzer.MDKey mdk = (MultiDimAnalyzer.MDKey)val;
            msb.append(mdk.ivDimTyp).append(IDObjectXMLHandler.TRENNER2);
            msb.append(IDObjectXMLHandler.getTransport(mdk.ivKey, true, true)).append(IDObjectXMLHandler.TRENNER2);
            msb.append(IDObjectXMLHandler.getTransport(mdk.ivCompVal, true, true)).append(IDObjectXMLHandler.TRENNER2);
            msb.append(IDObjectXMLHandler.getTransport(mdk.ivRep, true, true)).append(IDObjectXMLHandler.TRENNER2);
        }
    }

    public static class IOI_NULLOBJECT
    implements IOXInterpret {
        public Object holObject(String v, String group) {
            return NULLObject.INSTANCE;
        }

        public void append(Object val, StringBuilder msb, boolean withMark) {
            if (withMark) {
                msb.append(IDObjectXMLHandler.MARK_NULL_OBJECT);
            }
        }
    }

    public static class IOI_OBJECT_ARR
    implements IOXInterpret {
        public Object holObject(String v, String group) {
            Vector v2 = StringHelper.splitStringByAny(v, IDObjectXMLHandler.TRENNER2);
            Object[] arr = new Object[v2.size()];
            int i = 0;
            while (i < v2.size()) {
                String valString = (String)v2.elementAt(i);
                if (valString.length() != 0) {
                    int ind2 = valString.indexOf(IDObjectXMLHandler.TRENNER3);
                    if (ind2 == -1) {
                        arr[i] = IDObjectXMLHandler.getObject(valString, group, true);
                    } else {
                        String st = valString.substring(0, ind2);
                        String sv = valString.substring(ind2 + 1, valString.length());
                        if (st.equals(IDObjectXMLHandler.MARK_STRING)) {
                            arr[i] = Base64Manager.getDecodedString(sv);
                        } else if (st.equals("I")) {
                            arr[i] = new Integer(sv);
                        } else if (st.equals(IDObjectXMLHandler.MARK_DOUBLE)) {
                            arr[i] = new Double(sv);
                        } else {
                            String string = "Erroneus Object-Array entry " + v + " -> " + valString;
                            Class<?> clazz = class$38;
                            if (clazz == null) {
                                try {
                                    clazz = Class.forName("de.hannse.netobjects.objectstore.IDObjectXMLHandler");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            Log.error(string, null, clazz);
                        }
                    }
                } else {
                    arr[i] = null;
                }
                ++i;
            }
            return arr;
        }

        public void append(Object val, StringBuilder msb, boolean withMark) {
            Object[] obis = (Object[])val;
            if (obis.length != 0) {
                if (withMark) {
                    msb.append(IDObjectXMLHandler.MARK_OBJECT_ARR).append(IDObjectXMLHandler.TRENNER1);
                }
                int i = 0;
                while (i < obis.length) {
                    if (i != 0) {
                        msb.append(IDObjectXMLHandler.TRENNER2);
                    }
                    if (obis[i] != null) {
                        if (obis[i] instanceof String) {
                            msb.append(IDObjectXMLHandler.MARK_STRING).append(IDObjectXMLHandler.TRENNER3).append(Base64Manager.encodeBase64((String)obis[i]));
                        } else if (obis[i] instanceof Integer) {
                            msb.append("I").append(IDObjectXMLHandler.TRENNER3).append((Integer)obis[i]);
                        } else if (obis[i] instanceof Double) {
                            msb.append(IDObjectXMLHandler.MARK_DOUBLE).append(IDObjectXMLHandler.TRENNER3).append((Double)obis[i]);
                        } else {
                            msb.append(IDObjectXMLHandler.getTransport(obis[i], true, true));
                        }
                    }
                    ++i;
                }
            }
        }
    }

    public static class IOI_POINT
    implements IOXInterpret {
        public Object holObject(String v, String group) {
            Zeile z = new Zeile(v, '|');
            return new Point(z.getInt(0, 0), z.getInt(1, 0));
        }

        public void append(Object val, StringBuilder msb, boolean withMark) {
            Point pt = (Point)val;
            if (withMark) {
                msb.append(IDObjectXMLHandler.MARK_POINT).append(IDObjectXMLHandler.TRENNER1);
            }
            msb.append(pt.x).append(IDObjectXMLHandler.TRENNER2).append(pt.y);
        }
    }

    public static class IOI_POLYGON
    implements IOXInterpret {
        public Object holObject(String v, String group) {
            int anz;
            Zeile z = new Zeile(v, '|');
            int col = 0;
            if ((anz = z.getInt(col++, 0)) != 0) {
                int[] x = new int[anz];
                int[] y = new int[anz];
                int i = 0;
                while (i < anz) {
                    x[i] = z.getInt(col++, 0);
                    ++i;
                }
                i = 0;
                while (i < anz) {
                    y[i] = z.getInt(col++, 0);
                    ++i;
                }
                return new Polygon(x, y, anz);
            }
            return null;
        }

        public void append(Object val, StringBuilder msb, boolean withMark) {
            Polygon poly = (Polygon)val;
            if (withMark) {
                msb.append(IDObjectXMLHandler.MARK_POLYGON).append(IDObjectXMLHandler.TRENNER1);
            }
            msb.append(poly.npoints).append(IDObjectXMLHandler.TRENNER2);
            int i = 0;
            while (i < poly.xpoints.length) {
                msb.append(poly.xpoints[i]).append(IDObjectXMLHandler.TRENNER2);
                ++i;
            }
            i = 0;
            while (i < poly.ypoints.length) {
                msb.append(poly.xpoints[i]).append(IDObjectXMLHandler.TRENNER2);
                ++i;
            }
        }
    }

    public static class IOI_RACKPOS
    implements IOXInterpret {
        public Object holObject(String v, String group) {
            Vector v2 = StringHelper.splitStringByAny(v, IDObjectXMLHandler.TRENNER2);
            return new RackPos(Long.parseLong((String)v2.elementAt(0)), Integer.parseInt((String)v2.elementAt(1)), Integer.parseInt((String)v2.elementAt(2)), Integer.parseInt((String)v2.elementAt(3)));
        }

        public void append(Object val, StringBuilder msb, boolean withMark) {
            if (withMark) {
                msb.append(IDObjectXMLHandler.MARK_RACKPOS).append(IDObjectXMLHandler.TRENNER1);
            }
            RackPos rp = (RackPos)val;
            msb.append(rp.ivRackID).append(IDObjectXMLHandler.TRENNER2);
            msb.append(rp.ivSide).append(IDObjectXMLHandler.TRENNER2);
            msb.append(rp.ivRow).append(IDObjectXMLHandler.TRENNER2);
            msb.append(rp.ivColumn);
        }
    }

    public static class IOI_ROI
    implements IOXInterpret {
        public Object holObject(String v, String group) {
            ResultObjectImage roi = new ResultObjectImage();
            roi.evalValueStringNew(v);
            return roi;
        }

        public void append(Object val, StringBuilder msb, boolean withMark) {
            if (withMark) {
                msb.append(IDObjectXMLHandler.MARK_ROI).append(IDObjectXMLHandler.TRENNER1);
            }
            msb.append(((ResultObjectImage)val).getValueStringNew());
        }
    }

    public static class IOI_STRING
    implements IOXInterpret {
        public Object holObject(String v, String group) {
            return Base64Manager.getDecodedString(v);
        }

        public void append(Object val, StringBuilder msb, boolean withMark) {
            if (withMark) {
                msb.append(IDObjectXMLHandler.MARK_STRING).append(IDObjectXMLHandler.TRENNER1);
            }
            msb.append(Base64Manager.encodeBase64((String)val));
        }
    }

    public static class IOI_STRING_ARR
    implements IOXInterpret {
        public Object holObject(String v, String group) {
            Vector v2 = StringHelper.splitStringByAny(v, IDObjectXMLHandler.TRENNER2);
            String[] arr = new String[v2.size()];
            int i = 0;
            while (i < v2.size()) {
                arr[i] = Base64Manager.getDecodedString((String)v2.elementAt(i));
                ++i;
            }
            return arr;
        }

        public void append(Object val, StringBuilder msb, boolean withMark) {
            String[] stringi = (String[])val;
            if (stringi.length != 0) {
                if (withMark) {
                    msb.append(IDObjectXMLHandler.MARK_STRING_ARR).append(IDObjectXMLHandler.TRENNER1);
                }
                int i = 0;
                while (i < stringi.length) {
                    if (i != 0) {
                        msb.append(IDObjectXMLHandler.TRENNER2);
                    }
                    msb.append(Base64Manager.encodeBase64(stringi[i]));
                    ++i;
                }
            }
        }
    }

    public static class IOI_StressRuleArray
    implements IOXInterpret {
        public Object holObject(String v, String group) {
            Vector v2 = StringHelper.splitStringByAny(v, IDObjectXMLHandler.TRENNER2);
            StressRule[] arr = new StressRule[v2.size()];
            int i = 0;
            while (i < v2.size()) {
                arr[i] = new StressRule(Base64Manager.getDecodedString((String)v2.elementAt(i)));
                ++i;
            }
            return arr;
        }

        public void append(Object val, StringBuilder msb, boolean withMark) {
            StressRule[] srArr = (StressRule[])val;
            if (srArr.length != 0) {
                if (withMark) {
                    msb.append(IDObjectXMLHandler.MARK_STRESS_RULE).append(IDObjectXMLHandler.TRENNER1);
                }
                int i = 0;
                while (i < srArr.length) {
                    if (i != 0) {
                        msb.append(IDObjectXMLHandler.TRENNER2);
                    }
                    msb.append(Base64Manager.encodeBase64(srArr[i].getInitString()));
                    ++i;
                }
            }
        }
    }

    public static class IOI_TASK_ARR
    implements IOXInterpret {
        public Object holObject(String v, String group) {
            Vector v2 = StringHelper.splitStringByAny(v, IDObjectXMLHandler.TRENNER2);
            Task[] arr = new Task[v2.size()];
            int i = 0;
            while (i < v2.size()) {
                Vector v3 = StringHelper.splitStringByAny((String)v2.elementAt(i), IDObjectXMLHandler.TRENNER3);
                int datum = Integer.parseInt((String)v3.elementAt(0));
                long pseudoid = Long.parseLong((String)v3.elementAt(1));
                String desc = Base64Manager.getDecodedString((String)v3.elementAt(2));
                arr[i] = new Task(datum, desc, pseudoid);
                ++i;
            }
            return arr;
        }

        public void append(Object val, StringBuilder msb, boolean withMark) {
        }
    }

    public static class IOI_TASK_EXT_ARR
    implements IOXInterpret {
        public Object holObject(String v, String group) {
            Vector v2 = StringHelper.splitStringByAny(v, IDObjectXMLHandler.TRENNER2);
            Vector<TaskExtended> neueTasks = new Vector<TaskExtended>();
            Iterator iter = v2.iterator();
            while (iter.hasNext()) {
                String initString = Base64Manager.getDecodedString((String)iter.next()).trim();
                if (initString.length() == 0) continue;
                neueTasks.add(new TaskExtended(initString));
            }
            TaskExtended[] arr = null;
            if (!neueTasks.isEmpty()) {
                arr = new TaskExtended[neueTasks.size()];
                int i = 0;
                while (i < neueTasks.size()) {
                    arr[i] = (TaskExtended)neueTasks.elementAt(i);
                    if (group != null && arr[i].ivErledigerGroup != null && !arr[i].ivErledigerGroup.equals("service")) {
                        arr[i].ivErledigerGroup = group;
                    }
                    if (group != null && arr[i].ivFavoritGroup != null && !arr[i].ivFavoritGroup.equals("service")) {
                        arr[i].ivFavoritGroup = group;
                    }
                    ++i;
                }
            }
            return arr;
        }

        public void append(Object val, StringBuilder msb, boolean withMark) {
            TaskExtended[] arr = (TaskExtended[])val;
            if (arr.length != 0) {
                StringBuilder ssb = new StringBuilder();
                int i = 0;
                while (i < arr.length) {
                    TaskExtended task = arr[i];
                    if (task != null) {
                        if (ssb.length() != 0) {
                            ssb.append(IDObjectXMLHandler.TRENNER2);
                        }
                        ssb.append(Base64Manager.encodeBase64(task.getInitString()));
                    }
                    ++i;
                }
                if (ssb.length() != 0) {
                    if (withMark) {
                        msb.append(IDObjectXMLHandler.MARK_TASK_EXT_ARR).append(IDObjectXMLHandler.TRENNER1);
                    }
                    msb.append(ssb.toString());
                }
            }
        }
    }

    public static class IOI_TREEMAP
    implements IOXInterpret {
        public Object holObject(String v, String group) {
            TreeMap<Object, Object> h = new TreeMap<Object, Object>();
            Zeile z = new Zeile(v, '|');
            int i = 0;
            while (i < z.size()) {
                int indh;
                String ts = z.getStringNONEmpty(i, null);
                if (ts != null && (indh = ts.indexOf(IDObjectXMLHandler.TRENNER3)) != -1) {
                    Object key = IDObjectXMLHandler.getObject(ts.substring(0, indh), group, true);
                    Object val = IDObjectXMLHandler.getObject(ts.substring(indh + 1, ts.length()), group, true);
                    if (key != null && val != null) {
                        h.put(key, val);
                    }
                }
                ++i;
            }
            return h;
        }

        public void append(Object val, StringBuilder msb, boolean withMark) {
            if (withMark) {
                msb.append(IDObjectXMLHandler.MARK_TREEMAP).append(IDObjectXMLHandler.TRENNER1);
            }
            TreeMap h = (TreeMap)val;
            boolean first = true;
            Iterator iter = h.keySet().iterator();
            while (iter.hasNext()) {
                if (!first) {
                    msb.append(IDObjectXMLHandler.TRENNER2);
                }
                Object hkey = iter.next();
                Object hval = h.get(hkey);
                msb.append(IDObjectXMLHandler.getTransport(hkey, true, true)).append(IDObjectXMLHandler.TRENNER3).append(IDObjectXMLHandler.getTransport(hval, true, true));
                first = false;
            }
        }
    }

    public static class IOI_TREESET
    implements IOXInterpret {
        public Object holObject(String v, String group) {
            TreeSet<Object> erg = new TreeSet<Object>();
            Zeile z = new Zeile(v, '|');
            int i = 0;
            while (i < z.size()) {
                Object ooo;
                String ts = z.getStringNONEmpty(i, null);
                if (ts != null && (ooo = IDObjectXMLHandler.getObject(ts, group, true)) != null) {
                    erg.add(ooo);
                }
                ++i;
            }
            return erg;
        }

        public void append(Object val, StringBuilder msb, boolean withMark) {
            if (withMark) {
                msb.append(IDObjectXMLHandler.MARK_TREESET).append(IDObjectXMLHandler.TRENNER1);
            }
            TreeSet ts = (TreeSet)val;
            boolean first = true;
            Iterator iter = ts.iterator();
            while (iter.hasNext()) {
                if (!first) {
                    msb.append(IDObjectXMLHandler.TRENNER2);
                }
                msb.append(IDObjectXMLHandler.getTransport(iter.next(), true, true));
                first = false;
            }
        }
    }

    public static class IOI_VECTOR
    implements IOXInterpret {
        public Object holObject(String v, String group) {
            Vector<Object> erg = new Vector<Object>();
            Zeile z = new Zeile(v, '|');
            int i = 0;
            while (i < z.size()) {
                Object ooo;
                String ts = z.getStringNONEmpty(i, null);
                if (ts != null && (ooo = IDObjectXMLHandler.getObject(ts, group, true)) != null) {
                    erg.add(ooo);
                }
                ++i;
            }
            return erg;
        }

        public void append(Object val, StringBuilder msb, boolean withMark) {
            Vector v = (Vector)val;
            if (withMark) {
                msb.append(IDObjectXMLHandler.MARK_VECTOR).append(IDObjectXMLHandler.TRENNER1);
            }
            int i = 0;
            while (i < v.size()) {
                if (i != 0) {
                    msb.append(IDObjectXMLHandler.TRENNER2);
                }
                msb.append(IDObjectXMLHandler.getTransport(v.elementAt(i), true, true));
                ++i;
            }
        }
    }

    public static class IOI_VISIT_ARR
    implements IOXInterpret {
        public Object holObject(String v, String group) {
            Vector v2 = StringHelper.splitStringByAny(v, IDObjectXMLHandler.TRENNER2);
            Visit[] arr = new Visit[v2.size()];
            int i = 0;
            while (i < v2.size()) {
                Vector v3 = StringHelper.splitStringByAny((String)v2.elementAt(i), IDObjectXMLHandler.TRENNER3);
                arr[i] = new Visit();
                arr[i].ivCageID = Long.parseLong((String)v3.elementAt(0));
                arr[i].ivMouseID = Long.parseLong((String)v3.elementAt(1));
                String ms = ((String)v3.elementAt(2)).trim();
                if (ms.length() != 0) {
                    arr[i].ivStartDate = new Date(Long.parseLong(ms) * 1000L);
                }
                arr[i].ivStartMode = Integer.parseInt((String)v3.elementAt(3));
                ms = ((String)v3.elementAt(4)).trim();
                if (ms.length() != 0) {
                    arr[i].ivEndDate = new Date(Long.parseLong(ms) * 1000L);
                }
                arr[i].ivEndMode = Integer.parseInt((String)v3.elementAt(5));
                ++i;
            }
            return arr;
        }

        public void append(Object val, StringBuilder msb, boolean withMark) {
            Visit[] arr = (Visit[])val;
            if (arr.length != 0) {
                if (withMark) {
                    msb.append(IDObjectXMLHandler.MARK_VISIT_ARR).append(IDObjectXMLHandler.TRENNER1);
                }
                int i = 0;
                while (i < arr.length) {
                    if (i != 0) {
                        msb.append(IDObjectXMLHandler.TRENNER2);
                    }
                    Visit vis = arr[i];
                    msb.append(vis.ivCageID).append(IDObjectXMLHandler.TRENNER3);
                    msb.append(vis.ivMouseID).append(IDObjectXMLHandler.TRENNER3);
                    if (vis.ivStartDate != null) {
                        msb.append(vis.ivStartDate.getTime() / 1000L);
                    }
                    msb.append(IDObjectXMLHandler.TRENNER3);
                    msb.append(vis.ivStartMode).append(IDObjectXMLHandler.TRENNER3);
                    if (vis.ivEndDate != null) {
                        msb.append(vis.ivEndDate.getTime() / 1000L);
                    }
                    msb.append(IDObjectXMLHandler.TRENNER3);
                    msb.append(vis.ivEndMode);
                    ++i;
                }
            }
        }
    }

    public static interface IOXInterpret {
        public Object holObject(String var1, String var2);

        public void append(Object var1, StringBuilder var2, boolean var3);
    }
}

