/*
 * Decompiled with CFR 0.152.
 */
package de.hannse.netobjects.objectstore;

import de.hannse.netobjects.datalayer.DataLayer;
import de.hannse.netobjects.datalayer.GroupFileManager;
import de.hannse.netobjects.datalayer.dfa.IntermediaerHelfer;
import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.objectstore.IndexObject;
import de.hannse.netobjects.objectstore.ObjectConsumer;
import de.hannse.netobjects.objectstore.ObjectRequest;
import de.hannse.netobjects.objectstore.ObjectStore;
import de.hannse.netobjects.session.Session;
import de.hannse.netobjects.tools.FileManager;
import de.hannse.netobjects.util.Log;
import de.hannse.netobjects.util.MyDate;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.LineNumberReader;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import mausoleum.helper.ZeileAbstr;
import mausoleum.main.ProcessDefinition;
import mausoleum.mouse.Mouse;
import mausoleum.objectstore.IndexChecker;
import mausoleum.result.MResult;

public class ObjectIndex {
    private static final HashMap INDICES_BY_GROUP = new HashMap();
    private static final HashMap INDEXPATHS_BY_GROUP = new HashMap();
    public static final int COL_VERSION = 0;
    public static final int COL_SEX = 1;
    public static final int COL_PARENTS = 2;
    public static final int COL_START = 3;
    public static final int COL_BIRTHDAY = 4;
    public static final int COL_END = 5;
    public static final int COL_LICENSE = 6;
    public static final int COL_LINE = 7;
    public static final int COL_STRAINS = 8;
    public static final int COL_KIDS = 9;
    public static final int COL_RESULTS = 10;
    private static final int MAX_COL = 10;
    private static final String END_MARK = "-|-";
    private static final int[] MULTIPLE_VALUE_COLUMNS = new int[]{2, 8, 9, 10, 6};
    public static final ObjectConsumer HANDLER = new ObjectConsumer(){

        public void objectLeftServiceRoom(int objectTyp, String group, HashSet objectIDs) {
        }

        public void handleNewObjects(Vector idObjects) {
            Iterator iterator = idObjects.iterator();
            while (iterator.hasNext()) {
                this.handleNewObject((IDObject)iterator.next());
            }
        }

        public void handleNewObject(IDObject obj) {
            if (ProcessDefinition.isServer() && obj instanceof Mouse) {
                ObjectIndex.handle((Mouse)obj);
            }
        }
    };
    private static int cvIndexVersion = 2;
    static /* synthetic */ Class class$0;

    public static int getAktVerion() {
        return cvIndexVersion;
    }

    public static void createIndex(String group) {
        if (!DataLayer.USE_DB) {
            HashMap<Long, String> hm = (HashMap<Long, String>)INDICES_BY_GROUP.get(group);
            if (hm == null) {
                hm = new HashMap<Long, String>(10000);
                INDICES_BY_GROUP.put(group, hm);
            }
            hm.clear();
            boolean indexPresent = false;
            File f = new File(ObjectIndex.getPath(group));
            if (f.exists()) {
                try {
                    LineNumberReader lnr;
                    block23: {
                        lnr = new LineNumberReader(new FileReader(f));
                        String line = lnr.readLine();
                        if (line != null) {
                            try {
                                if (Integer.parseInt(line) != cvIndexVersion) break block23;
                                line = lnr.readLine();
                                while (line != null) {
                                    int ind;
                                    if (line.endsWith(END_MARK) && (ind = line.indexOf("#")) != -1) {
                                        try {
                                            Long idKey = new Long(line.substring(0, ind));
                                            String val = line.substring(ind + 1, line.length());
                                            if (val.trim().length() != 0) {
                                                hm.put(idKey, val);
                                            }
                                        }
                                        catch (Exception e) {
                                            String string = "Problem with Index line " + line;
                                            Class<?> clazz = class$0;
                                            if (clazz == null) {
                                                try {
                                                    clazz = Class.forName("de.hannse.netobjects.objectstore.ObjectIndex");
                                                }
                                                catch (ClassNotFoundException classNotFoundException) {
                                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                                }
                                            }
                                            Log.error(string, e, clazz);
                                        }
                                    }
                                    line = lnr.readLine();
                                }
                                indexPresent = true;
                            }
                            catch (Throwable e) {
                                String string = "Could not read index of group " + group;
                                Class<?> clazz = class$0;
                                if (clazz == null) {
                                    try {
                                        clazz = class$0 = Class.forName("de.hannse.netobjects.objectstore.ObjectIndex");
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                    }
                                }
                                Log.error(string, e, clazz);
                            }
                        }
                    }
                    lnr.close();
                }
                catch (Exception e) {
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("de.hannse.netobjects.objectstore.ObjectIndex");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    Log.error("Problem creating index", e, clazz);
                }
            }
            if (!indexPresent) {
                FileManager.saveStringToFile(ObjectIndex.getPath(group), String.valueOf(cvIndexVersion) + "\n");
                DataLayer.cvDataLayer.giveSuccesivelyAllObjectsForCheck(group, 1, HANDLER);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void rewriteIndices() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("de.hannse.netobjects.objectstore.ObjectIndex");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Log.log("Start writing Index information", clazz);
        Iterator iter1 = INDICES_BY_GROUP.keySet().iterator();
        while (iter1.hasNext()) {
            String group = (String)iter1.next();
            try {
                HashMap hm = (HashMap)INDICES_BY_GROUP.get(group);
                if (hm == null) continue;
                HashMap hashMap = hm;
                synchronized (hashMap) {
                    FileWriter fw = new FileWriter(new File(GroupFileManager.getIndexTEMPFilePath(group)));
                    fw.write(String.valueOf(cvIndexVersion) + "\n");
                    Iterator iter2 = hm.keySet().iterator();
                    while (iter2.hasNext()) {
                        Long key = (Long)iter2.next();
                        if (key != null && hm != null) {
                            String val = (String)hm.get(key);
                            if (val != null) {
                                fw.write(String.valueOf(key.toString()) + "#" + val + "\n");
                                continue;
                            }
                            String string = "Strange effect: Index empty for key " + key + " in group " + group;
                            Class<?> clazz2 = class$0;
                            if (clazz2 == null) {
                                try {
                                    clazz2 = Class.forName("de.hannse.netobjects.objectstore.ObjectIndex");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            Log.warn(string, clazz2);
                            continue;
                        }
                        String string = "Very strange effect: key [" + key + "] or Hashmap gone in group " + group;
                        Class<?> clazz3 = class$0;
                        if (clazz3 == null) {
                            try {
                                clazz3 = Class.forName("de.hannse.netobjects.objectstore.ObjectIndex");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        Log.warn(string, clazz3);
                    }
                    fw.flush();
                    fw.close();
                    FileManager.move(GroupFileManager.getIndexFilePath(group), GroupFileManager.getIndexTEMP2FilePath(group));
                    FileManager.move(GroupFileManager.getIndexTEMPFilePath(group), GroupFileManager.getIndexFilePath(group));
                    FileManager.deleteFile(GroupFileManager.getIndexTEMP2FilePath(group));
                }
            }
            catch (Throwable e) {
                Class<?> clazz4 = class$0;
                if (clazz4 == null) {
                    try {
                        clazz4 = Class.forName("de.hannse.netobjects.objectstore.ObjectIndex");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Log.error("Problem while rewriting index information", e, clazz4);
            }
        }
        Class<?> clazz5 = class$0;
        if (clazz5 == null) {
            try {
                clazz5 = class$0 = Class.forName("de.hannse.netobjects.objectstore.ObjectIndex");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Log.log("Finished writing Index information", clazz5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void handle(Mouse mouse) {
        String group = mouse.getGroup();
        HashMap<Long, String> hm = (HashMap<Long, String>)INDICES_BY_GROUP.get(group);
        if (hm == null) {
            hm = new HashMap<Long, String>(10000);
            INDICES_BY_GROUP.put(group, hm);
        }
        Long key = (Long)mouse.get("IDO_ID");
        if (mouse.existed()) {
            String s = ObjectIndex.getIndexInfo(mouse);
            if (!s.equals(hm.get(key))) {
                HashMap<Long, String> hashMap = hm;
                synchronized (hashMap) {
                    hm.put(key, s);
                }
                FileManager.appendStringToServerFile(ObjectIndex.getPath(group), key + "#" + s + "\n");
            }
        } else {
            HashMap<Long, String> hashMap = hm;
            synchronized (hashMap) {
                hm.remove(key);
            }
            FileManager.appendStringToServerFile(ObjectIndex.getPath(group), key + "#\n");
        }
    }

    public static void checkMouseVersion(Mouse mouse) {
        HashMap hm = (HashMap)INDICES_BY_GROUP.get(mouse.getGroup());
        if (hm != null) {
            boolean doHandle = false;
            String index = (String)hm.get(mouse.get("IDO_ID"));
            doHandle = index != null ? ZeileAbstr.getInt(index, IntermediaerHelfer.getIndexSeparator(), 0, -1) != mouse.getInt("IDO_VERSION", -2) : true;
            if (doHandle) {
                ObjectIndex.handle(mouse);
            }
        }
    }

    private static String getPath(String group) {
        String res = (String)INDEXPATHS_BY_GROUP.get(group);
        if (res == null) {
            res = GroupFileManager.getIndexFilePath(group);
            INDEXPATHS_BY_GROUP.put(group, res);
        }
        return res;
    }

    public static String getIndexInfo(Mouse mouse) {
        StringBuilder msb = new StringBuilder(300);
        msb.append(mouse.getInt("IDO_VERSION", 0)).append(" ");
        ObjectIndex.appendIndexInfo(mouse, msb, IntermediaerHelfer.getIndexSeparator());
        msb.append(" ").append(END_MARK);
        return msb.toString();
    }

    public static void appendIndexInfo(Session sess, StringBuilder msb, char sep) {
        msb.append(sess.getLong("SES_USER", 0L));
        msb.append(sep);
        Date date = (Date)sess.get("IDO_START_DATE");
        if (date != null) {
            msb.append(date.getTime());
        }
        msb.append(sep);
        date = (Date)sess.get("IDO_END_DATE");
        if (date != null) {
            msb.append(date.getTime());
        }
        msb.append(sep);
        Vector coms = sess.getVector("SES_COMMAND");
        if (coms != null) {
            msb.append(coms.size());
        }
    }

    public static void appendIndexInfo(Mouse mouse, StringBuilder msb, char sep) {
        int sex = mouse.getSex();
        if (sex != 0) {
            msb.append(sex);
        }
        msb.append(sep);
        Long l = (Long)mouse.get("MOS_FATHER");
        if (l != null) {
            msb.append(l);
        }
        msb.append("|");
        l = (Long)mouse.get("MOS_MOTHER");
        if (l != null) {
            msb.append(l);
        }
        msb.append(sep);
        Date date = (Date)mouse.get("IDO_START_DATE");
        if (date != null) {
            msb.append(MyDate.getTage(date));
        }
        msb.append(sep);
        date = (Date)mouse.get("MOS_BIRTHDAY");
        if (date != null) {
            msb.append(MyDate.getTage(date));
        }
        msb.append(sep);
        date = (Date)mouse.get("IDO_END_DATE");
        if (date != null) {
            msb.append(MyDate.getTage(date));
        }
        msb.append(sep);
        mouse.appendLicenseIndexInfo(msb, "|");
        msb.append(sep);
        l = (Long)mouse.get("MOS_LINEID");
        if (l != null) {
            msb.append(l);
        }
        msb.append(sep);
        IndexObject[] lalArr = (IndexObject[])mouse.get("MOS_STRAIN");
        if (lalArr != null) {
            int j = 0;
            while (j < lalArr.length) {
                if (j != 0) {
                    msb.append("|");
                }
                msb.append(lalArr[j].ivObjectID);
                ++j;
            }
        }
        msb.append(sep);
        long[] arr = (long[])mouse.get("MOS_KID");
        if (arr != null) {
            int j = 0;
            while (j < arr.length) {
                if (j != 0) {
                    msb.append("|");
                }
                msb.append(arr[j]);
                ++j;
            }
        }
        msb.append(sep);
        Vector mrv = (Vector)mouse.get("MOS_MRESULTS");
        if (mrv != null) {
            int j = 0;
            while (j < mrv.size()) {
                if (j != 0) {
                    msb.append("|");
                }
                MResult mres = (MResult)mrv.elementAt(j);
                msb.append(mres.getExperimentID());
                ++j;
            }
        }
    }

    public static String getOIIndex(String group, Long id) {
        HashMap hm = (HashMap)INDICES_BY_GROUP.get(group);
        if (hm != null) {
            return (String)hm.get(id);
        }
        return null;
    }

    public static void getGenealogy(ObjectRequest or, String group, long id, boolean parents, int runden) {
        HashSet target = new HashSet(300);
        HashMap target2 = new HashMap(300);
        HashMap source = (HashMap)INDICES_BY_GROUP.get(group);
        if (source != null) {
            ObjectIndex.collectRelatives(source, target, new Long(id), target2, parents ? 2 : 9, runden, group);
        }
        or.ivObject = target;
        or.ivExtraObject = target2;
    }

    private static void collectRelatives(HashMap source, HashSet behandelteIDs, Long mouseID, HashMap relativesByMouseID, int posInIndex, int runden, String group) {
        behandelteIDs.add(mouseID);
        long[] srcVerwandtenIDs = ObjectIndex.getLongArr(source, mouseID, posInIndex);
        if (srcVerwandtenIDs != null && srcVerwandtenIDs.length != 0) {
            int anz = 0;
            int i = 0;
            while (i < srcVerwandtenIDs.length) {
                if (srcVerwandtenIDs[i] != 0L) {
                    ++anz;
                }
                ++i;
            }
            if (anz != 0) {
                long[] tgtVerwandtenIDs = new long[anz];
                int pos = 0;
                int i2 = 0;
                while (i2 < srcVerwandtenIDs.length) {
                    IDObject ido;
                    if (srcVerwandtenIDs[i2] != 0L && (ido = ObjectStore.getObjectDeadOrAlive(1, srcVerwandtenIDs[i2], group, null, false, true)) != null && !ido.neverExisted()) {
                        Long nid = new Long(srcVerwandtenIDs[i2]);
                        if (!behandelteIDs.contains(nid)) {
                            if (runden > 1) {
                                ObjectIndex.collectRelatives(source, behandelteIDs, nid, relativesByMouseID, posInIndex, runden - 1, group);
                            }
                            tgtVerwandtenIDs[pos++] = srcVerwandtenIDs[i2];
                        } else {
                            tgtVerwandtenIDs[pos++] = -srcVerwandtenIDs[i2];
                        }
                    }
                    ++i2;
                }
                relativesByMouseID.put(mouseID, tgtVerwandtenIDs);
            }
        }
    }

    public static void giveIndicesToChecker(IndexChecker rep, String group) {
        HashMap hm = (HashMap)INDICES_BY_GROUP.get(group);
        if (hm != null) {
            Iterator iterator = hm.keySet().iterator();
            while (iterator.hasNext()) {
                Long id = (Long)iterator.next();
                rep.checkIndex(id, (String)hm.get(id));
            }
        }
    }

    public static HashSet getIndexIds(int indexCol, String group, Object key) {
        HashMap hm;
        if (indexCol > 0 && indexCol <= 10 && key != null && (hm = (HashMap)INDICES_BY_GROUP.get(group)) != null) {
            String vgl = key.toString();
            String vglV = null;
            String vglH = null;
            String vglM = null;
            if (ObjectIndex.isMultipleValueIndex(indexCol)) {
                vglV = String.valueOf(key.toString()) + "|";
                vglH = "|" + key.toString();
                vglM = "|" + key.toString() + "|";
            }
            HashSet<Long> erg = new HashSet<Long>(hm.size() / 10);
            Iterator iterator = hm.keySet().iterator();
            while (iterator.hasNext()) {
                Long id = (Long)iterator.next();
                String s = ZeileAbstr.getPart((String)hm.get(id), IntermediaerHelfer.getIndexSeparator(), indexCol, null);
                if (s == null) continue;
                if (s.equals(vgl)) {
                    erg.add(id);
                    continue;
                }
                if (vglV == null || !s.startsWith(vglV) && !s.endsWith(vglH) && !s.contains(vglM)) continue;
                erg.add(id);
            }
            return erg;
        }
        return null;
    }

    private static boolean isMultipleValueIndex(int indexCol) {
        int i = 0;
        while (i < MULTIPLE_VALUE_COLUMNS.length) {
            if (indexCol == MULTIPLE_VALUE_COLUMNS[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static long[] getLongArr(HashMap source, Long mouseID, int posInIndex) {
        String s = (String)source.get(mouseID);
        if (s != null) {
            return ZeileAbstr.getLongArr(s, IntermediaerHelfer.getIndexSeparator(), posInIndex, '|');
        }
        return null;
    }
}

