/*
 * Decompiled with CFR 0.152.
 */
package de.hannse.netobjects.objectstore;

import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.objectstore.ObjectConsumer;
import de.hannse.netobjects.objectstore.ObjectManagerCache;
import de.hannse.netobjects.objectstore.ObjectRequest;
import de.hannse.netobjects.objectstore.ObjectStoreClient;
import de.hannse.netobjects.tools.FileManager;
import de.hannse.netobjects.tools.StringHelper;
import de.hannse.netobjects.user.UserManager;
import de.hannse.netobjects.user.UserRoomRestriction;
import de.hannse.netobjects.util.Log;
import de.hannse.netobjects.util.RequestManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.ObjectInputStream;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import mausoleum.idobjectgroup.IDObjectGroup;
import mausoleum.main.MausoleumClient;
import mausoleum.main.ProcessDefinition;
import mausoleum.objectstore.AftermathObject;
import mausoleum.tables.MausoleumTableModel;

public class ObjectManager {
    private static final int[] TYPEN_MIT_PSEUDO_OBJEKTEN = new int[]{18, 4};
    public static HashMap cvServiceCareTakerIDsByGroupName = null;
    private static boolean cvAccetptObjectModifications = true;
    private final Hashtable ivHash = new Hashtable();
    private final Hashtable ivNebenHash = new Hashtable();
    private final Hashtable ivOldHash = new Hashtable();
    private final HashSet ivConsumers = ProcessDefinition.isClient() ? new HashSet() : null;
    private final int ivObjectType;
    private final String ivProblemString;
    private boolean isInitialized = false;
    static /* synthetic */ Class class$0;

    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.println("Usage: ObjectManager [Dirname]");
            System.exit(0);
        }
        String dirname = args[0];
        dirname = StringHelper.gSub(dirname, "\\", "/");
        File f = new File(args[0]);
        if (!f.exists()) {
            System.out.println("ObjectManager dir does not exist!");
            System.exit(0);
        }
        if (!f.isDirectory()) {
            System.out.println("ObjectManager dir does not exist!");
            System.exit(0);
        }
        try {
            int ind = dirname.lastIndexOf("/");
            String name = dirname.substring(ind + 1, dirname.length());
            StringBuffer msb = new StringBuffer("<MausoleumBackup>\r\n");
            String[] files = f.list();
            int i = 0;
            while (i < files.length) {
                String path = String.valueOf(dirname) + "/" + files[i];
                System.out.println("Converting " + path);
                ObjectInputStream ois = new ObjectInputStream(new FileInputStream(path));
                Hashtable hash = (Hashtable)ois.readObject();
                ois.close();
                Enumeration en = hash.elements();
                while (en.hasMoreElements()) {
                    IDObject iob = (IDObject)en.nextElement();
                    msb.append(iob.toString());
                }
                ++i;
            }
            msb.append("</MausoleumBackup>\r\n");
            FileManager.saveStringToFile(String.valueOf(name) + ".xml", msb.toString());
        }
        catch (Exception e) {
            System.out.println("ObjectManager Kacke: " + e);
        }
    }

    public static void enterMaturityLimit(IDObject ido, HashMap maturitySammler, String key) {
        String group;
        if (ProcessDefinition.isClient() && (group = ido.getGroup()) != null) {
            Integer mli;
            HashMap<Object, Integer> hm = (HashMap<Object, Integer>)maturitySammler.get(group);
            if (hm == null) {
                hm = new HashMap<Object, Integer>();
                maturitySammler.put(group, hm);
            }
            if ((mli = (Integer)ido.get(key)) != null) {
                hm.put(ido.get("IDO_ID"), mli);
            } else {
                hm.remove(ido.get("IDO_ID"));
            }
        }
    }

    public static Integer getMatlimit(Long id, String group, HashMap maturitySammler) {
        HashMap hm;
        if (id != null && (hm = (HashMap)maturitySammler.get(group)) != null) {
            return (Integer)hm.get(id);
        }
        return null;
    }

    public static Vector getAllMembersOfIDObjectGroups(ObjectManager man, Vector idObjectGroups) {
        Vector<IDObject> erg = new Vector<IDObject>();
        HashSet<Long> collectedIDs = new HashSet<Long>();
        Iterator iter = idObjectGroups.iterator();
        while (iter.hasNext()) {
            IDObjectGroup iog = (IDObjectGroup)iter.next();
            String group = iog.getGroup();
            long[] ids = (long[])iog.get("IOG_IDS");
            if (ids == null) continue;
            int i = 0;
            while (i < ids.length) {
                Long key = new Long(ids[i]);
                if (!collectedIDs.contains(key)) {
                    collectedIDs.add(key);
                    IDObject idObject = man.getObject(ids[i], group);
                    if (idObject != null) {
                        erg.add(idObject);
                    }
                }
                ++i;
            }
        }
        collectedIDs.clear();
        return erg;
    }

    public static void setAcceptObjectModifications(boolean accept) {
        cvAccetptObjectModifications = accept;
    }

    private static boolean isPseudoTyp(int typ) {
        int i = 0;
        while (i < TYPEN_MIT_PSEUDO_OBJEKTEN.length) {
            if (TYPEN_MIT_PSEUDO_OBJEKTEN[i] == typ) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public ObjectManager(int objectType) {
        this.ivObjectType = objectType;
        if (ObjectManager.isPseudoTyp(objectType)) {
            this.ivProblemString = "Serious problem with Manager " + this.getClass().getName();
            ObjectStoreClient.addBroker(this, this.ivObjectType);
        } else {
            this.ivProblemString = "Serious problem with Manager for " + IDObject.getFilenameForTypeClientSide(this.ivObjectType);
            ObjectStoreClient.addBroker(this, this.ivObjectType);
            this.theRealInit();
        }
    }

    public void dispose() {
        if (MausoleumClient.isRegularOrTGService() || MausoleumClient.isHeadOfService()) {
            try {
                Hashtable ghm = (Hashtable)this.ivHash.get(UserManager.getFirstGroup());
                if (ghm != null) {
                    ObjectManagerCache.saveCache(UserManager.getFirstGroup(), this.ivObjectType, ghm);
                }
            }
            catch (Throwable e) {
                Log.error("Error while caching data of type " + IDObject.getFilenameForTypeClientSide(this.ivObjectType), e, this);
            }
        }
        ObjectManager.clearHM(this.ivHash);
        ObjectManager.clearHM(this.ivNebenHash);
        ObjectManager.clearHM(this.ivOldHash);
        this.ivConsumers.clear();
    }

    private static void clearHM(Hashtable ht) {
        if (ht != null) {
            Iterator iterator = ht.keySet().iterator();
            while (iterator.hasNext()) {
                String group = (String)iterator.next();
                Hashtable ghm = (Hashtable)ht.get(group);
                if (ghm == null) continue;
                ghm.clear();
            }
            ht.clear();
        }
    }

    private void theRealInit() {
        if (MausoleumClient.isRegularOrTGService() || MausoleumClient.isHeadOfService()) {
            this.initWithCachedData();
        } else if (MausoleumClient.isServiceCaretaker()) {
            this.initForServiceCareTaker();
        }
    }

    private void initForServiceCareTaker() {
        Iterator iterator = cvServiceCareTakerIDsByGroupName.keySet().iterator();
        while (iterator.hasNext()) {
            Integer type;
            Vector v;
            String group = (String)iterator.next();
            this.ivHash.put(group, new Hashtable());
            HashMap ghm = (HashMap)cvServiceCareTakerIDsByGroupName.get(group);
            if (ghm == null || (v = (Vector)ghm.get(type = new Integer(this.ivObjectType))) == null) continue;
            Iterator iterator2 = v.iterator();
            while (iterator2.hasNext()) {
                String transport = (String)iterator2.next();
                this.insertObject(IDObject.initObjectFromTransport(type, group, transport));
            }
        }
        this.jetztBinIchInitialisiert();
    }

    private void initWithCachedData() {
        String[] groups = null;
        groups = this.ivObjectType == 12 && !"service".equals(UserManager.getFirstGroup()) ? new String[]{UserManager.getFirstGroup(), "service"} : new String[]{UserManager.getFirstGroup()};
        int gi = 0;
        while (gi < groups.length) {
            String group = groups[gi];
            Vector nochZuHolen = ObjectManagerCache.initCache(group, this.ivObjectType, this.ivHash);
            if (nochZuHolen != null && !nochZuHolen.isEmpty()) {
                long[] twids = new long[nochZuHolen.size()];
                int i = 0;
                while (i < nochZuHolen.size()) {
                    Long longi = (Long)nochZuHolen.elementAt(i);
                    twids[i] = longi;
                    ++i;
                }
                nochZuHolen.clear();
                nochZuHolen = null;
                this.getObjectsFromServer(twids, true, group);
            }
            ++gi;
        }
        if (!this.isInitialized) {
            this.jetztBinIchInitialisiert();
        }
    }

    protected void getObjectsFromServer(long[] wantedIDs, boolean isDuringInit, String group) {
        if (wantedIDs != null && wantedIDs.length != 0) {
            Integer type = new Integer(this.ivObjectType);
            int ist = 0;
            int soll = wantedIDs.length;
            Vector<Object> v = new Vector<Object>(2);
            v.addElement(type);
            v.addElement(wantedIDs);
            ObjectRequest mor = RequestManager.createSendAndGetAnswer((byte)2, v, group);
            if (mor == null || !mor.isFinished()) {
                Log.warn(this.ivProblemString, null, this);
            } else {
                String ticket = (String)mor.ivObject;
                boolean cont = true;
                while (cont) {
                    try {
                        if (mor != null) {
                            mor.refresh((byte)43, ticket);
                            mor = RequestManager.sendObjectRequestAndGetAnswer(mor);
                        }
                        if (mor == null || !mor.isFinished()) {
                            cont = false;
                            continue;
                        }
                        String[] erg = (String[])mor.ivObject;
                        ist += erg.length;
                        if (isDuringInit) {
                            MausoleumClient.setSubMessage(ist, soll);
                        }
                        int i = 0;
                        while (i < erg.length) {
                            IDObject obi = IDObject.initObjectFromTransport(type, group, erg[i]);
                            this.insertObject(obi);
                            ++i;
                        }
                        if (mor.ivExtraObject == null || !mor.ivExtraObject.equals("DAS_WARS")) continue;
                        cont = false;
                    }
                    catch (Exception e) {
                        Log.error("Problem getting Object ", e, this);
                    }
                }
            }
        }
    }

    public Vector updateObjectsIfPresent(Hashtable valuesByObjectID, Vector newIDs, String group) {
        Vector<IDObject> erg = new Vector<IDObject>();
        if (!cvAccetptObjectModifications) {
            return erg;
        }
        Enumeration en = valuesByObjectID.keys();
        while (en.hasMoreElements()) {
            Long objectID = (Long)en.nextElement();
            IDObject localIDObject = this.getLocalObject(objectID, group);
            if (localIDObject == null && newIDs != null && newIDs.contains(objectID)) {
                Class cl = IDObject.getClassForType(this.ivObjectType);
                if (cl == null) {
                    Log.warn("No classs defined for type: " + this.ivObjectType, null, this);
                    return null;
                }
                try {
                    localIDObject = (IDObject)cl.newInstance();
                }
                catch (Exception e) {
                    Log.error("Creation of new instance failed", e, this);
                    return null;
                }
            }
            if (localIDObject == null) continue;
            HashMap sentValues = null;
            if (valuesByObjectID.get(objectID) instanceof HashMap) {
                sentValues = (HashMap)valuesByObjectID.get(objectID);
            } else if (valuesByObjectID.get(objectID) instanceof Hashtable) {
                Hashtable sht = (Hashtable)valuesByObjectID.get(objectID);
                sentValues = new HashMap();
                Iterator iterator = sht.keySet().iterator();
                while (iterator.hasNext()) {
                    Object key = iterator.next();
                    sentValues.put(key, sht.get(key));
                }
            }
            if (sentValues != null) {
                boolean useit = true;
                Integer localVersion = (Integer)localIDObject.get("IDO_VERSION");
                Integer sentVersion = (Integer)sentValues.get("IDO_VERSION");
                if (localVersion != null && sentVersion != null && localVersion > sentVersion) {
                    long[] ids = new long[]{objectID};
                    this.getObjectsFromServer(ids, false, group);
                    localIDObject = this.getLocalObject(objectID, group);
                    if (localIDObject != null && (localVersion = (Integer)localIDObject.get("IDO_VERSION")) >= sentVersion) {
                        this.actionBeforeConsumerNotify(localIDObject);
                        erg.add(localIDObject);
                        useit = false;
                    }
                }
                if (!useit) continue;
                localIDObject.setValues(sentValues);
                this.insertObject(localIDObject);
                this.actionBeforeConsumerNotify(localIDObject);
                erg.add(localIDObject);
                continue;
            }
            String string = "No values were sent ID: " + objectID + " Values: " + valuesByObjectID.get(objectID);
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("de.hannse.netobjects.objectstore.ObjectManager");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Log.error(string, null, clazz);
        }
        return erg;
    }

    public void performObjectInsertionAftermath(ObjectRequest or, Vector sentObjects, AftermathObject aftermathObject) {
        int i = 0;
        while (i < sentObjects.size()) {
            IDObject obj = (IDObject)sentObjects.elementAt(i);
            try {
                String group = obj.getGroup(null);
                if (group == null) {
                    Log.error("Group is missing " + obj, new IllegalArgumentException(), this);
                } else if (this.ivHash.containsKey(group)) {
                    this.notifyConsumers(obj);
                }
            }
            catch (Throwable e) {
                Log.error("Problem at Aftermath", e, this);
            }
            ++i;
        }
    }

    public void jetztBinIchInitialisiert() {
        this.isInitialized = true;
    }

    public void handleNewObject(IDObject obj) {
        if (cvAccetptObjectModifications) {
            this.doHandleNewObject(obj, true);
        }
    }

    public boolean doHandleNewObject(IDObject obj, boolean directNotify) {
        if (cvAccetptObjectModifications && obj.getTyp() == this.ivObjectType && this.ivHash.containsKey(obj.getGroup(""))) {
            this.insertObject(obj);
            this.actionBeforeConsumerNotify(obj);
            if (directNotify && this.ivConsumers != null && !this.ivConsumers.isEmpty()) {
                this.notifyConsumers(obj);
            }
            return true;
        }
        return false;
    }

    public void actionBeforeConsumerNotify(IDObject obj) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConsumer(ObjectConsumer oc) {
        if (ProcessDefinition.isClient()) {
            HashSet hashSet = this.ivConsumers;
            synchronized (hashSet) {
                this.ivConsumers.add(oc);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConsumer(ObjectConsumer oc) {
        if (ProcessDefinition.isClient()) {
            HashSet hashSet = this.ivConsumers;
            synchronized (hashSet) {
                this.ivConsumers.remove(oc);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyConsumers(IDObject iob) {
        if (ProcessDefinition.isClient() && iob != null) {
            HashSet hashSet = this.ivConsumers;
            synchronized (hashSet) {
                Iterator iter = this.ivConsumers.iterator();
                while (iter.hasNext()) {
                    ObjectConsumer oc = (ObjectConsumer)iter.next();
                    oc.handleNewObject(iob);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyConsumers(Vector idObjects) {
        if (ProcessDefinition.isClient() && idObjects != null && !idObjects.isEmpty()) {
            HashSet hashSet = this.ivConsumers;
            synchronized (hashSet) {
                Iterator iter = this.ivConsumers.iterator();
                while (iter.hasNext()) {
                    ObjectConsumer oc = (ObjectConsumer)iter.next();
                    oc.handleNewObjects(idObjects);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyConsumersForServiceRoomLeaving(int objectTyp, String group, HashSet objectIDs) {
        if (ProcessDefinition.isClient()) {
            HashSet hashSet = this.ivConsumers;
            synchronized (hashSet) {
                Iterator iter = this.ivConsumers.iterator();
                while (iter.hasNext()) {
                    ObjectConsumer oc = (ObjectConsumer)iter.next();
                    oc.objectLeftServiceRoom(objectTyp, group, objectIDs);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMausoleumTableModelConsumers(HashSet hs) {
        if (ProcessDefinition.isClient()) {
            HashSet hashSet = this.ivConsumers;
            synchronized (hashSet) {
                Iterator iter = this.ivConsumers.iterator();
                while (iter.hasNext()) {
                    ObjectConsumer oc = (ObjectConsumer)iter.next();
                    if (!(oc instanceof MausoleumTableModel)) continue;
                    hs.add(oc);
                }
            }
        }
    }

    public int getActualNumber() {
        int sum = 0;
        Iterator iterator = this.ivHash.values().iterator();
        while (iterator.hasNext()) {
            Hashtable ghm = (Hashtable)iterator.next();
            sum += ghm.size();
        }
        return sum;
    }

    public Vector getObjects(long[] indices, String group) {
        return this.getObjects(indices, null, group);
    }

    public Vector getObjects(long[] indices, Vector indexVector, String group) {
        Vector<IDObject> schonDa = new Vector<IDObject>();
        Vector<Long> nochZuHolen = new Vector<Long>();
        if (indices != null) {
            int i = 0;
            while (i < indices.length) {
                long index = indices[i];
                if (index == 0L) {
                    Log.error("Index 0 angefragt!! Bei Objekttyp: " + this.ivObjectType, new Throwable(), this);
                } else {
                    Long key = new Long(index);
                    IDObject iob = this.getLocalObject(key, group);
                    if (iob != null) {
                        schonDa.addElement(iob);
                    } else {
                        nochZuHolen.addElement(key);
                    }
                }
                ++i;
            }
        } else if (indexVector != null) {
            Iterator iterator = indexVector.iterator();
            while (iterator.hasNext()) {
                Long key = (Long)iterator.next();
                IDObject iob = this.getLocalObject(key, group);
                if (iob != null) {
                    schonDa.addElement(iob);
                    continue;
                }
                nochZuHolen.addElement(key);
            }
        }
        if (nochZuHolen.isEmpty()) {
            return schonDa;
        }
        long[] twids = new long[nochZuHolen.size()];
        int i = 0;
        while (i < nochZuHolen.size()) {
            Long longi = (Long)nochZuHolen.elementAt(i);
            twids[i] = longi;
            ++i;
        }
        this.getObjectsFromServer(twids, false, group);
        i = 0;
        while (i < nochZuHolen.size()) {
            Long key = (Long)nochZuHolen.elementAt(i);
            IDObject iob = this.getLocalObject(key, group);
            if (iob != null) {
                schonDa.addElement(iob);
            }
            ++i;
        }
        return schonDa;
    }

    public IDObject getObject(long id, String group) {
        if (id > 0L) {
            return this.getObject(new Long(id), group);
        }
        return null;
    }

    public IDObject getObject(Long key, String group) {
        IDObject erg = null;
        if (group != null && key != null && (erg = this.getLocalObject(key, group)) == null) {
            this.getObjectsFromServer(new long[]{key}, false, group);
            erg = this.getLocalObject(key, group);
        }
        return erg;
    }

    public IDObject getLocalObject(Long key, String group) {
        if (group != null && this.ivHash != null) {
            IDObject iob;
            Hashtable ghm = (Hashtable)this.ivHash.get(group);
            if (ghm != null && (iob = (IDObject)ghm.get(key)) != null) {
                return iob;
            }
            ghm = (Hashtable)this.ivNebenHash.get(group);
            if (ghm != null && (iob = (IDObject)ghm.get(key)) != null) {
                return iob;
            }
            ghm = (Hashtable)this.ivOldHash.get(group);
            if (ghm != null && (iob = (IDObject)ghm.get(key)) != null) {
                return iob;
            }
        }
        return null;
    }

    public IDObject getObjectWithUniqueLong(long test, String group) {
        Hashtable ghm;
        if (group != null && (ghm = (Hashtable)this.ivHash.get(group)) != null) {
            Iterator iterator = ghm.values().iterator();
            while (iterator.hasNext()) {
                IDObject object = (IDObject)iterator.next();
                if (object.getLong("IDO_UNIQUELONG", 0L) != test) continue;
                return object;
            }
        }
        return null;
    }

    public boolean hasActualObjects(String group) {
        Hashtable ghm;
        return group != null && (ghm = (Hashtable)this.ivHash.get(group)) != null && !ghm.isEmpty();
    }

    public boolean hasActualObjectsForAnyGroup() {
        Iterator iter = this.ivHash.values().iterator();
        while (iter.hasNext()) {
            Hashtable ghm = (Hashtable)iter.next();
            if (ghm == null || ghm.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Vector getActualObjectVector(String group, boolean onlyVisibles, boolean sortThem) {
        Vector v = new Vector();
        this.addActualObjectVector(v, group, onlyVisibles, sortThem);
        return v;
    }

    public void addActualObjectVector(Vector v, String group, boolean onlyVisibles, boolean sortThem) {
        Hashtable ghm;
        if (group != null && (ghm = (Hashtable)this.ivHash.get(group)) != null) {
            Iterator iter = ghm.values().iterator();
            while (iter.hasNext()) {
                IDObject ido = (IDObject)iter.next();
                if (onlyVisibles && !ido.isAliveAndVisible()) continue;
                v.add(ido);
            }
        }
        if (sortThem) {
            Collections.sort(v);
        }
    }

    public Vector getActualObjectVectorAllGroups(boolean onlyVisibles, boolean sortThem) {
        Vector<IDObject> v = new Vector<IDObject>();
        Iterator iterator = this.ivHash.keySet().iterator();
        while (iterator.hasNext()) {
            String group = (String)iterator.next();
            Hashtable ghm = (Hashtable)this.ivHash.get(group);
            if (ghm == null) continue;
            Iterator iter = ghm.values().iterator();
            while (iter.hasNext()) {
                IDObject ido = (IDObject)iter.next();
                if (onlyVisibles && !ido.isAliveAndVisible()) continue;
                v.add(ido);
            }
        }
        if (sortThem) {
            Collections.sort(v);
        }
        return v;
    }

    public Vector getActualObjectVector(String group) {
        Hashtable ghm;
        Vector v = new Vector();
        if (group != null && (ghm = (Hashtable)this.ivHash.get(group)) != null) {
            boolean roomRestricted = UserRoomRestriction.areRoomsRestricted();
            Iterator iterator = ghm.values().iterator();
            while (iterator.hasNext()) {
                Object ooo = iterator.next();
                if (roomRestricted && !UserRoomRestriction.takeObjectWithRoomRestriction(ooo)) continue;
                v.add(ooo);
            }
        }
        return v;
    }

    public Iterator getAllActITER(String group) {
        Hashtable ghm = (Hashtable)this.ivHash.get(group);
        if (ghm != null) {
            return ghm.values().iterator();
        }
        return null;
    }

    public Vector getActualObjectVectorAllGroups() {
        boolean holeAlles = false;
        if (ProcessDefinition.isClient() && MausoleumClient.isServiceCaretaker()) {
            holeAlles = true;
        } else if (ProcessDefinition.isClient() && MausoleumClient.isRegularOrTGService() && this.ivObjectType == 12) {
            holeAlles = true;
        }
        if (holeAlles) {
            Vector v = new Vector();
            Iterator iterator = this.ivHash.values().iterator();
            while (iterator.hasNext()) {
                Hashtable ghm = (Hashtable)iterator.next();
                v.addAll(ghm.values());
            }
            return v;
        }
        return this.getActualObjectVector(UserManager.getFirstGroup());
    }

    public Enumeration getActualObjectEnumerationAllGroups() {
        return this.getActualObjectVectorAllGroups().elements();
    }

    public Enumeration getActualObjectEnumeration(String group) {
        return this.getActualObjectVector(group).elements();
    }

    public void removeObject(String group, Long id) {
        Hashtable ghm;
        if (cvAccetptObjectModifications && group != null && (ghm = (Hashtable)this.ivHash.get(group)) != null) {
            ghm.remove(id);
        }
    }

    private void insertObject(IDObject iob) {
        String group;
        if (cvAccetptObjectModifications && iob != null && (group = iob.getGroup()) != null) {
            Long key = (Long)iob.get("IDO_ID");
            if (iob.isAlive()) {
                Hashtable<Long, IDObject> ghm = (Hashtable<Long, IDObject>)this.ivHash.get(group);
                if (ghm == null) {
                    ghm = new Hashtable<Long, IDObject>();
                    this.ivHash.put(group, ghm);
                }
                boolean drin = true;
                if (this.isInitialized && MausoleumClient.isServiceCaretaker() && iob.canSitInRoom()) {
                    Long sridL = iob.getServiceRoomID();
                    boolean bl = drin = sridL != null && sridL.equals(MausoleumClient.cvServiceCTRoomID);
                }
                if (drin) {
                    ghm.put(key, iob);
                    ghm = (Hashtable)this.ivNebenHash.get(group);
                    if (ghm != null) {
                        ghm.remove(key);
                    }
                } else {
                    ghm.remove(key);
                    ghm = (Hashtable<Long, IDObject>)this.ivNebenHash.get(group);
                    if (ghm == null) {
                        ghm = new Hashtable<Long, IDObject>();
                        this.ivNebenHash.put(group, ghm);
                    }
                    ghm.put(key, iob);
                }
            } else {
                Hashtable<Long, IDObject> ghm = (Hashtable<Long, IDObject>)this.ivHash.get(group);
                if (ghm != null) {
                    ghm.remove(key);
                }
                if ((ghm = (Hashtable)this.ivNebenHash.get(group)) != null) {
                    ghm.remove(key);
                }
                if ((ghm = (Hashtable)this.ivOldHash.get(group)) == null) {
                    ghm = new Hashtable<Long, IDObject>();
                    this.ivOldHash.put(group, ghm);
                }
                ghm.put(key, iob);
            }
        }
    }
}

