/*
 * Decompiled with CFR 0.152.
 */
package de.hannse.netobjects.objectstore;

import de.hannse.netobjects.tools.StringHelper;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;

public class ObjectRequest
implements Externalizable {
    static final long serialVersionUID = -8717671986526504937L;
    public static final byte ACTION_UNKNOWN = 0;
    public static final byte ACTION_GIVE_LIST_OF_ACTUAL = 1;
    public static final byte ACTION_GIVE_OBJECTS = 2;
    public static final byte ACTION_LOGIN = 3;
    public static final byte ACTION_LOGOUT = 4;
    public static final byte ACTION_NEW_GROUP = 5;
    public static final byte ACTION_COMMAND = 6;
    public static final byte ACTION_CHECK_USER = 11;
    public static final byte ACTION_GET_LAST_ID = 12;
    public static final byte ACTION_SEARCH = 13;
    public static final byte ACTION_STOP_SEARCH = 14;
    public static final byte ACTION_READY = 15;
    public static final byte ACTION_GET_SESSION_INFO = 16;
    public static final byte ACTION_GET_SESSIONS = 17;
    public static final byte ACTION_GET_SESSION_PROFILE = 18;
    public static final byte ACTION_COMMIT_SUICIDE = 19;
    public static final byte ACTION_SEND_IMAGE = 20;
    public static final byte ACTION_UNDO = 21;
    public static final byte ACTION_REDO = 22;
    public static final byte ACTION_GET_PREFS = 23;
    public static final byte ACTION_SET_PREFS = 24;
    public static final byte ACTION_GET_UNIQUE_LONG = 25;
    public static final byte ACTION_IS_UNDO_POSSIBLE = 26;
    public static final byte ACTION_IS_REDO_POSSIBLE = 27;
    public static final byte ACTION_GET_GROUPNAMES = 28;
    public static final byte ACTION_RESTORE_GROUP = 29;
    public static final byte ACTION_APPEND_TO_GROUP_REPORT = 30;
    public static final byte ACTION_CHANGE_ADMIN_PW = 31;
    public static final byte ACTION_SEARCH_CAGES = 32;
    public static final byte ACTION_BROWSE = 33;
    public static final byte ACTION_GROUP_STATISTIK = 34;
    public static final byte ACTION_GET_DIR_CONTENT = 35;
    public static final byte ACTION_GET_FILE = 36;
    public static final byte ACTION_SAVE_FILE = 37;
    public static final byte ACTION_APPEND_STRING = 38;
    public static final byte ACTION_CHANGE_USER = 39;
    public static final byte ACTION_GET_USERNAMES = 42;
    public static final byte ACTION_GIVEOBJECTS_FOR_TICKET = 43;
    public static final byte ACTION_READY_TO_DORMANT = 44;
    public static final byte ACTION_DORMANT_TO_READY = 45;
    public static final byte ACTION_GET_SERVICE_ROOMS = 46;
    public static final byte ACTION_GET_SERVICECT_OBJECTS = 47;
    public static final byte ACTION_GENEALOGY_UP = 48;
    public static final byte ACTION_GENEALOGY_DOWN = 49;
    public static final byte ACTION_DEMO_EXPORT = 51;
    public static final byte ACTION_CREATE_HEAD_OF_SERVICE = 52;
    public static final byte ACTION_IMPORT_GROUP_FROM_DEMO = 53;
    public static final byte ACTION_PER_DIEM_REPORT = 54;
    public static final byte ACTION_GET_COMMUNICATOR_INFO = 55;
    public static final byte ACTION_KILL_COMMUNICATOR = 56;
    public static final byte ACTION_GET_SERVER_VERSION = 57;
    public static final byte ACTION_GIVE_OBJECTS_FOR_INDEX = 58;
    public static final byte ACTION_GET_RACK_DISPLAY_INFO = 59;
    public static final byte ACTION_CHANGE_GROUP_COLORS = 60;
    public static final byte ACTION_GET_LINE_INFOS = 61;
    public static final byte ACTION_SET_MIN_LOG_LEVEL = 62;
    public static final byte ACTION_HAS_ARMIS = 63;
    public static final byte ACTION_GET_ARMIS_WEEK_REPORT = 64;
    public static final byte ACTION_GET_OBJECTSELECTPROXIES = 65;
    public static final byte ACTION_SEARCH_GET_RESULTS = 66;
    public static final byte ACTION_FIND_GROUP_BASIC_OBJECTS = 67;
    public static final byte ACTION_PING = 68;
    public static final byte ACTION_GET_GROUP_FOR_SERVICE_RACK_POS = 69;
    public static final byte ACTION_MULTIDIM = 70;
    public static final byte ACTION_GET_CONFIG_VALUE = 71;
    public static final byte ACTION_SET_CONFIG_INT = 72;
    public static final byte ACTION_GET_SERVER_FINGERPRINT = 73;
    public static final byte ACTION_GROUP_QUOTA_REPORT = 74;
    public static final byte ACTION_GET_LAST_EARTAG = 75;
    public static final byte ACTION_GET_KILLED_IN_SERVICE = 76;
    public static final byte ACTION_GET_KILLED_FOR_USER = 77;
    public static final byte ACTION_MOUSE_TRAFFIC_REPORT = 78;
    public static final byte ACTION_IS_GROUP_DISABLEABLE = 79;
    public static final byte ACTION_ENDISABLE_GROUP = 80;
    public static final byte ACTION_SET_GROUP_FOR_OBJECTS = 81;
    public static final byte ACTION_GET_LICENSE_REPORT_1 = 82;
    public static final byte ACTION_GET_LINE_EVAL_REPORT = 83;
    public static final byte ACTION_SONDER_REPORT = 84;
    public static final byte ACTION_GET_LINE_REPORT_1 = 85;
    public static final byte ACTION_COLLECTION_HOLDER = 86;
    public static final byte ACTION_OBJECT_MODIFICATION = 87;
    private static final byte STATUS_UNKNOWN = 0;
    private static final byte STATUS_NEW = 1;
    private static final byte STATUS_FINISHED = 2;
    private static final byte STATUS_DENIED = 3;
    private static final byte STATUS_INPROGRESS = 4;
    private static final byte STATUS_CRASHED = 5;
    private static final HashMap AD = new HashMap();
    private static final HashMap SD = new HashMap();
    public static final String SPECIAL_SPECIAL_COMMANDS = "#soc";
    public static final String SPECIAL_NEW_OBJECTS = "#sno";
    public static final String SPECIAL_WEANED_MICE = "#swm";
    public static final String SPECIAL_SERVICE_ROOM_IDS = "#sri";
    public static final String SPECIAL_LICENSES_EXHAUSTED = "#licex";
    public String ivClientString = StringHelper.getClientString();
    public String ivMagicString = StringHelper.getUniqueString();
    public byte ivAction = 0;
    private byte ivStatus = 1;
    public String ivGroup = null;
    public Object ivObject = null;
    public Object ivExtraObject = null;
    public boolean ivKamVonWoanders = false;

    static {
        AD.put(new Byte(0), "UNKNOWN");
        AD.put(new Byte(1), "GIVELISTOFACTUAL");
        AD.put(new Byte(2), "GIVEOBJECTS");
        AD.put(new Byte(3), "LOGIN");
        AD.put(new Byte(4), "LOGOUT");
        AD.put(new Byte(5), "NEWGROUP");
        AD.put(new Byte(6), "COMMAND");
        AD.put(new Byte(11), "CHECKUSER");
        AD.put(new Byte(12), "GETLASTID");
        AD.put(new Byte(13), "SEARCH");
        AD.put(new Byte(14), "STOP_SEARCH");
        AD.put(new Byte(15), "READY");
        AD.put(new Byte(16), "GET_SESSION_INFO");
        AD.put(new Byte(17), "GET_SESSIONS");
        AD.put(new Byte(18), "GET_SESSION_PROFILE");
        AD.put(new Byte(19), "COMMIT_SUICIDE");
        AD.put(new Byte(20), "SEND_IMAGE");
        AD.put(new Byte(21), "UNDO");
        AD.put(new Byte(22), "REDO");
        AD.put(new Byte(23), "GETPREFS");
        AD.put(new Byte(24), "SETPREFS");
        AD.put(new Byte(25), "GETUNIQUELONG");
        AD.put(new Byte(26), "IS_UNDO_POSSIBLE");
        AD.put(new Byte(27), "IS_REDO_POSSIBLE");
        AD.put(new Byte(28), "GET_GROUPNAMES");
        AD.put(new Byte(29), "RESTOREGROUP");
        AD.put(new Byte(30), "APPENDTOFILE");
        AD.put(new Byte(31), "CHANGE_ADMIN_PW");
        AD.put(new Byte(32), "SEARCH_CAGES");
        AD.put(new Byte(33), "BROWSE");
        AD.put(new Byte(34), "GROUP_STATISTIK");
        AD.put(new Byte(35), "GET_DIR_CONTENT");
        AD.put(new Byte(36), "GET_FILE");
        AD.put(new Byte(37), "SAVE_FILE");
        AD.put(new Byte(38), "APPEND_STRING");
        AD.put(new Byte(39), "CHANGE_USER");
        AD.put(new Byte(42), "GET_USERNAMES");
        AD.put(new Byte(43), "GIVEOBJECTS_FOR_TICKET");
        AD.put(new Byte(44), "READY_TO_DORMANT");
        AD.put(new Byte(45), "DORMANT_TO_READY");
        AD.put(new Byte(46), "GET_SERVICE_ROOMS");
        AD.put(new Byte(47), "GET_SERVICECT_OBJECTS");
        AD.put(new Byte(49), "GET_GENEALOGY_PROGENIES");
        AD.put(new Byte(48), "GET_GENEALOGY_ANCESTORS");
        AD.put(new Byte(51), "ACTION_DEMO_EXPORT");
        AD.put(new Byte(52), "CREATE_HEAD_OF_SERVICE");
        AD.put(new Byte(54), "PER_DIEM_REPORT");
        AD.put(new Byte(55), "GET_COMMUNICATOR_INFO");
        AD.put(new Byte(56), "KILL_COMMUNICATOR");
        AD.put(new Byte(57), "GET_SERVER_VERSION");
        AD.put(new Byte(58), "GIVEOBJECTS_FOR_INDEX");
        AD.put(new Byte(59), "GET_RACK_DISPLAY_INFO");
        AD.put(new Byte(60), "CHANGE_GROUP_COLORS");
        AD.put(new Byte(61), "GET_LINE_INFOS");
        AD.put(new Byte(62), "SET_MIN_LOG_LEVEL");
        AD.put(new Byte(63), "HAS_ARMIS");
        AD.put(new Byte(64), "GET_ARMIS_WEEK_REPORT");
        AD.put(new Byte(65), "GET_OBJECTSELECTPROXIES");
        AD.put(new Byte(66), "SEARCH_GET_RESULTS");
        AD.put(new Byte(67), "FIND_GROUP_BASIC_OBJECTS");
        AD.put(new Byte(68), "PING");
        AD.put(new Byte(70), "MULTIDIM");
        AD.put(new Byte(78), "MOUSE_TRAFFIC_REPORT");
        AD.put(new Byte(79), "IS_GROUP_DISABLEABLE");
        AD.put(new Byte(80), "EN_DIS_ABLE_GROUP");
        AD.put(new Byte(87), "MODIFY OBJECTS");
        SD.put(new Byte(0), "UNKNOWN");
        SD.put(new Byte(1), "NEW");
        SD.put(new Byte(2), "FINISHED");
        SD.put(new Byte(3), "DENIED");
        SD.put(new Byte(4), "INPROGRESS");
        SD.put(new Byte(5), "CRASHED");
    }

    public static String getActionString(byte action) {
        String res = (String)AD.get(new Byte(action));
        return res == null ? "<unknown action: " + action + ">" : res;
    }

    public ObjectRequest() {
    }

    public ObjectRequest(byte action, Object obj, String group, Object extraObject) {
        this.ivAction = action;
        this.ivGroup = group;
        this.ivObject = obj;
        this.ivExtraObject = extraObject;
    }

    public void refresh(byte action, Object obj) {
        this.ivAction = action;
        this.ivStatus = 1;
        this.ivClientString = StringHelper.getClientString();
        this.ivMagicString = StringHelper.getUniqueString();
        this.ivObject = obj;
        this.ivExtraObject = null;
    }

    public String toString() {
        return "\n---> ObjectRequest\n     action       = " + AD.get(new Byte(this.ivAction)) + "\n" + "     status       = " + SD.get(new Byte(this.ivStatus)) + "\n" + "     client       = " + this.ivClientString + "\n" + "     magic        = " + this.ivMagicString + "\n" + "     group        = " + this.ivGroup + "\n";
    }

    public String toShortString() {
        return "\n---> ObjectRequest\n     action       = " + AD.get(new Byte(this.ivAction)) + "\n" + "     magic        = " + this.ivMagicString + "\n" + "     group        = " + this.ivGroup + "\n";
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.ivClientString = (String)in.readObject();
        this.ivMagicString = (String)in.readObject();
        this.ivAction = in.readByte();
        this.ivStatus = in.readByte();
        this.ivGroup = (String)in.readObject();
        this.ivObject = in.readObject();
        this.ivExtraObject = in.readObject();
        this.ivKamVonWoanders = in.readBoolean();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.ivClientString);
        out.writeObject(this.ivMagicString);
        out.writeByte(this.ivAction);
        out.writeByte(this.ivStatus);
        out.writeObject(this.ivGroup);
        out.writeObject(this.ivObject);
        out.writeObject(this.ivExtraObject);
        out.writeBoolean(this.ivKamVonWoanders);
    }

    public boolean isFinished() {
        return this.ivStatus == 2;
    }

    public boolean isCommandRequest() {
        return this.ivAction == 6;
    }

    public boolean isCommandUNDOREDORequest() {
        return this.ivAction == 6 || this.ivAction == 21 || this.ivAction == 22;
    }

    public void finish() {
        this.ivStatus = (byte)2;
    }

    public boolean isDenied() {
        return this.ivStatus == 3;
    }

    public void deny() {
        this.ivStatus = (byte)3;
    }
}

