/*
 * Decompiled with CFR 0.152.
 */
package de.hannse.netobjects.objectstore.requesthandler;

import de.hannse.netobjects.datalayer.DataLayer;
import de.hannse.netobjects.objectstore.CommandParser;
import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.objectstore.ObjectRequest;
import de.hannse.netobjects.objectstore.ObjectStore;
import de.hannse.netobjects.objectstore.requesthandler.OBRHS_Service_Manager;
import de.hannse.netobjects.objectstore.requesthandler.ObjectRequestHandlerServer;
import de.hannse.netobjects.session.Session;
import de.hannse.netobjects.session.ShortSessionInfo;
import de.hannse.netobjects.tools.Base64Manager;
import de.hannse.netobjects.user.User;
import de.hannse.netobjects.util.Log;
import java.util.Date;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import mausoleum.db.DBAssistant;
import mausoleum.helper.Zeile;
import mausoleum.mouse.tierschutz.TierSchutz;
import mausoleum.reports.LineLicenseUsageReport;
import mausoleum.reports.TrafficReport;
import mausoleum.server.export.DemoExporteur;

public class OBRHS_WorkerThread
extends Thread {
    public static final String COM_GET_SHORT_SESSION_INFOS = "COM_GET_SESSIONS";
    public static final String COM_GET_OBJECT_LOG = "COM_GET_SESSION_INFOS";
    public static final String COM_GET_SESSION_PROFILE = "COM_GET_SESSION_PROFILE";
    public static final String COM_LOAD_IMAGE = "COM_LOAD_IMAGE";
    public static final String COM_GET_SERVICE_CARETAKER_PACK = "COM_SERV_CARE_START";
    public static final String COM_DEMO_EXPORT = "COM_DEMO_EXPORT";
    public static final String COM_DEMO_IMPORT = "COM_DEMO_IMPORT";
    public static final String COM_MOUSE_TRAFFIC_REPORT = "COM_MOUSE_TRAFFIC_REPORT";
    public static final String COM_LICENSE_USAGE_REPORT = "COM_LICENSE_USAGE_REPORT";
    public static final String COM_LINE_USAGE_REPORT = "COM_LINE_USAGE_REPORT";
    public static final String COM_LINE_EVALUATTION_REPORT = "COM_LINE_EVALUATTION_REPORT";
    private ObjectRequestHandlerServer ivORHS;
    private ObjectRequest ivRequest;
    private String ivCommand;

    public OBRHS_WorkerThread(ObjectRequestHandlerServer orhs, ObjectRequest request, String command) {
        this.ivORHS = orhs;
        this.ivRequest = request;
        this.ivCommand = command;
    }

    public void run() {
        if (this.ivCommand.equals(COM_GET_SHORT_SESSION_INFOS)) {
            this.getShortSessionInfos();
        } else if (this.ivCommand.equals(COM_GET_OBJECT_LOG)) {
            this.getObjectLog();
        } else if (this.ivCommand.equals(COM_GET_SESSION_PROFILE)) {
            this.handleGetSessionProfile();
        } else if (this.ivCommand.equals(COM_LOAD_IMAGE)) {
            this.handleLoadImage();
        } else if (this.ivCommand.equals(COM_GET_SERVICE_CARETAKER_PACK)) {
            OBRHS_Service_Manager.handleGetServiceCaretakerStartPack(this.ivRequest, this.ivORHS);
        } else if (this.ivCommand.equals(COM_DEMO_EXPORT)) {
            if (DemoExporteur.createDemo(this.ivRequest)) {
                this.ivORHS.finishRequest(this.ivRequest);
            } else {
                this.ivORHS.denyRequest(this.ivRequest);
            }
        } else if (this.ivCommand.equals(COM_DEMO_IMPORT)) {
            if (DemoExporteur.importFromDemo(this.ivRequest)) {
                this.ivORHS.finishRequest(this.ivRequest);
            } else {
                this.ivORHS.denyRequest(this.ivRequest);
            }
        } else if (this.ivCommand.equals(COM_MOUSE_TRAFFIC_REPORT)) {
            if (TrafficReport.getMouseTrafficReport(this.ivRequest)) {
                this.ivORHS.finishRequest(this.ivRequest);
            } else {
                this.ivORHS.denyRequest(this.ivRequest);
            }
        } else if (this.ivCommand.equals(COM_LICENSE_USAGE_REPORT)) {
            try {
                this.ivRequest.ivObject = LineLicenseUsageReport.getLineLicenseUsageReport(this.ivRequest.ivGroup, (long[])this.ivRequest.ivObject, false);
                this.ivORHS.finishRequest(this.ivRequest);
            }
            catch (Exception e) {
                this.ivORHS.denyRequest(this.ivRequest);
            }
        } else if (this.ivCommand.equals(COM_LINE_USAGE_REPORT)) {
            try {
                this.ivRequest.ivObject = LineLicenseUsageReport.getLineLicenseUsageReport(this.ivRequest.ivGroup, (long[])this.ivRequest.ivObject, true);
                this.ivORHS.finishRequest(this.ivRequest);
            }
            catch (Exception e) {
                this.ivORHS.denyRequest(this.ivRequest);
            }
        } else if (COM_LINE_EVALUATTION_REPORT.equals(this.ivCommand)) {
            try {
                this.ivRequest.ivObject = TierSchutz.getLineEvaluationReport(this.ivRequest.ivGroup, (long[])this.ivRequest.ivObject);
                this.ivORHS.finishRequest(this.ivRequest);
            }
            catch (Exception e) {
                this.ivORHS.denyRequest(this.ivRequest);
            }
        }
    }

    private void handleLoadImage() {
        Long longi = (Long)this.ivRequest.ivObject;
        long uid = longi;
        String group = this.ivRequest.ivGroup;
        try {
            Vector erg = DataLayer.cvDataLayer.loadImage(group, Long.toString(uid));
            if (erg != null) {
                this.ivRequest.ivObject = erg;
                this.ivORHS.finishRequest(this.ivRequest);
            } else {
                this.ivRequest.ivObject = null;
                this.ivORHS.denyRequest(this.ivRequest);
            }
        }
        catch (Exception e) {
            Log.warn("Problem beim handleSendImage ", e, this);
            this.ivORHS.denyRequest(this.ivRequest);
        }
    }

    private void getShortSessionInfos() {
        Long longi = (Long)this.ivRequest.ivObject;
        long uid = longi;
        Vector<ShortSessionInfo> erg = new Vector<ShortSessionInfo>();
        try {
            if (DataLayer.USE_DB) {
                DBAssistant.fillShortSessionInfos(this.ivRequest.ivGroup, uid, erg);
            } else {
                int lid = DataLayer.cvDataLayer.getLastID(this.ivRequest.ivGroup, 5);
                int i = 1;
                while (i < lid) {
                    Session sess = (Session)ObjectStore.getObjectDeadOrAlive(5, i, this.ivRequest.ivGroup, null, false);
                    if (sess != null && sess.getLong("SES_USER") == uid) {
                        erg.add(new ShortSessionInfo(sess));
                    }
                    ++i;
                }
            }
            this.ivRequest.ivObject = erg;
            this.ivORHS.finishRequest(this.ivRequest);
        }
        catch (Exception e) {
            Log.warn("Problem beim handleGetSessions ", e, this);
            this.ivORHS.denyRequest(this.ivRequest);
        }
    }

    private void handleGetSessionProfile() {
        String s = (String)this.ivRequest.ivObject;
        long sid = Long.parseLong(s);
        StringBuilder msb = new StringBuilder(3000);
        this.appendFullSessionInfo(sid, null, 0, 0L, msb, true, 0L);
        this.ivRequest.ivObject = msb.toString();
        msb.setLength(0);
        msb = null;
        this.ivORHS.finishRequest(this.ivRequest);
    }

    private void getObjectLog() {
        TreeSet sessionIDs;
        long objID;
        Zeile z = new Zeile((String)this.ivRequest.ivObject, '_');
        if (z.size() != 3) {
            Log.warn("handleGetSessionInfo Error Informations malformed " + this.ivRequest.ivObject, this);
            this.ivORHS.denyRequest(this.ivRequest);
            return;
        }
        int objTyp = z.getInt(1, 0);
        IDObject obi = ObjectStore.getObjectDeadOrAlive(objTyp, objID = z.getLong(2, 0L), this.ivRequest.ivGroup, null, false);
        if (obi == null) {
            Log.warn("handleGetSessionInfo Error no object for group: " + this.ivRequest.ivGroup + " Type: " + objTyp + " ID: " + objID + " from Informations " + this.ivRequest.ivObject, this);
            this.ivORHS.denyRequest(this.ivRequest);
            return;
        }
        boolean isUser = objTyp == 6;
        boolean isService = this.ivRequest.ivGroup.equals("service");
        StringBuilder tsb = new StringBuilder();
        TreeMap<Long, Vector<String>> sessComsByStart = new TreeMap<Long, Vector<String>>();
        TreeSet treeSet = sessionIDs = DataLayer.USE_DB ? DBAssistant.getSessionIDs(this.ivRequest.ivGroup, objTyp, objID) : obi.getSessions();
        if (sessionIDs != null) {
            Iterator iter = sessionIDs.iterator();
            while (iter.hasNext()) {
                Long key;
                Vector<String> v;
                long sessID = (Long)iter.next();
                if (isUser && !isService && sessID <= 0L) continue;
                tsb.setLength(0);
                long sessStart = this.appendFullSessionInfo(sessID, obi, objTyp, objID, tsb, false, Long.MIN_VALUE);
                if (sessStart != Long.MIN_VALUE) {
                    // empty if block
                }
                if ((v = (Vector<String>)sessComsByStart.get(key = new Long(sessStart))) == null) {
                    v = new Vector<String>();
                    sessComsByStart.put(key, v);
                }
                v.add(tsb.toString());
            }
        }
        StringBuilder msb = new StringBuilder(3000);
        Iterator iterator = sessComsByStart.values().iterator();
        while (iterator.hasNext()) {
            Vector v = (Vector)iterator.next();
            Iterator iterator2 = v.iterator();
            while (iterator2.hasNext()) {
                String sc = (String)iterator2.next();
                if (msb.length() != 0) {
                    msb.append("#");
                }
                msb.append(sc);
            }
            v.clear();
        }
        sessComsByStart.clear();
        this.ivRequest.ivObject = msb.toString();
        msb.setLength(0);
        msb = null;
        this.ivORHS.finishRequest(this.ivRequest);
    }

    private long appendFullSessionInfo(long sessionID, IDObject obi, int objTyp, long objID, StringBuilder msb, boolean detailsImmer, long defVal) {
        long res = defVal;
        Session session = null;
        String sessionGroup = this.ivRequest.ivGroup;
        if (sessionID >= 0L) {
            session = (Session)ObjectStore.getObjectDeadOrAlive(5, sessionID, this.ivRequest.ivGroup, null, false);
        } else {
            session = (Session)ObjectStore.getObjectDeadOrAlive(5, -sessionID, "service", null, false);
            sessionGroup = "service";
        }
        if (session != null) {
            String creation = "";
            String parsedCont = String.valueOf(creation) + CommandParser.parseSession(session, this.ivRequest.ivGroup, objTyp, objID);
            if (detailsImmer || parsedCont != null && parsedCont.length() != 0) {
                res = session.getDate("IDO_START_DATE").getTime();
                String sessDet = OBRHS_WorkerThread.getSessionDetails(session, sessionGroup);
                if (msb.length() != 0) {
                    msb.append("#");
                }
                msb.append(Base64Manager.encodeBase64(sessDet)).append("|").append(Base64Manager.encodeBase64(parsedCont));
            }
        }
        return res;
    }

    public static String getSessionDetails(Session sess, String group) {
        String address = "unknown";
        if (sess.getString("SES_ADRESS") != null) {
            address = sess.getString("SES_ADRESS");
        }
        String username = "unknown";
        try {
            User usi = (User)ObjectStore.getObjectDeadOrAlive(6, sess.getLong("SES_USER"), group, null, false);
            if (usi != null) {
                username = String.valueOf((String)usi.get("USR_NAME")) + " (" + group + ")";
            }
        }
        catch (Exception usi) {
            // empty catch block
        }
        String startDate = "";
        Date date = sess.getDate("IDO_START_DATE");
        if (date != null) {
            startDate = Long.toString(date.getTime());
        }
        String endDate = "";
        date = sess.getDate("IDO_END_DATE");
        if (date != null) {
            endDate = Long.toString(date.getTime());
        }
        return String.valueOf(username) + "|" + address + "|" + startDate + "|" + endDate;
    }
}

