/*
 * Decompiled with CFR 0.152.
 */
package de.hannse.netobjects.server.http;

import de.hannse.netobjects.server.http.MultipartData;
import de.hannse.netobjects.tools.StringHelper;
import de.hannse.netobjects.util.Log;
import java.io.DataInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class NetworkRequest
implements Serializable {
    static final long serialVersionUID = -6409637115989776260L;
    private static long cvLastLong = 0L;
    private String ivId;
    private String ivRequestString = null;
    public Hashtable ivCommandAttributes = new Hashtable(10);
    static /* synthetic */ Class class$0;

    public static NetworkRequest generateRequest(InputStream in, String socketID) {
        DataInputStream dis = new DataInputStream(in);
        Vector<String> lines = new Vector<String>();
        boolean cont = true;
        while (cont) {
            try {
                String line = NetworkRequest.readLine(dis, new byte[1024], socketID);
                if (line.trim().length() == 0) {
                    cont = false;
                    continue;
                }
                lines.addElement(line);
            }
            catch (Exception e) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("de.hannse.netobjects.server.http.NetworkRequest");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Log.error("Could not extract Request ", e, clazz);
                return null;
            }
        }
        if (lines.isEmpty()) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("de.hannse.netobjects.server.http.NetworkRequest");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Log.info("No request lines", clazz);
            return null;
        }
        String request = (String)lines.elementAt(0);
        if (request == null) {
            return null;
        }
        NetworkRequest erg = null;
        if (request.trim().toLowerCase().startsWith("get")) {
            erg = NetworkRequest.handleGET(request);
        } else if (request.trim().toLowerCase().startsWith("head")) {
            erg = NetworkRequest.handleGET(request);
        } else if (request.trim().toLowerCase().startsWith("post")) {
            erg = NetworkRequest.handlePost(dis, lines);
        }
        return erg;
    }

    private static String readLine(DataInputStream dis, byte[] buffer, String socketID) throws Exception {
        int b = 32;
        StringBuilder msb = new StringBuilder();
        int pos = 0;
        boolean cont = true;
        boolean lastWasR = true;
        while (cont) {
            try {
                b = dis.readByte();
            }
            catch (Exception e) {
                msb.append(new String(buffer, 0, pos));
                String string = "Problem at readLine >" + msb.toString() + "< from " + socketID;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("de.hannse.netobjects.server.http.NetworkRequest");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Log.warn(string, null, clazz);
                return msb.toString();
            }
            if (b == 13) {
                lastWasR = true;
            } else if (b == 10) {
                if (lastWasR) {
                    msb.append(new String(buffer, 0, pos));
                    return msb.toString();
                }
                lastWasR = false;
                buffer[pos++] = b;
            } else {
                lastWasR = false;
                buffer[pos++] = b;
            }
            if (pos < buffer.length) continue;
            msb.append(new String(buffer, 0, pos));
            pos = 0;
        }
        return null;
    }

    private static NetworkRequest handlePost(DataInputStream dis, Vector lines) {
        NetworkRequest erg = new NetworkRequest();
        Hashtable<String, String> ht = new Hashtable<String, String>(10);
        if (lines.size() > 1) {
            int i = 1;
            while (i < lines.size()) {
                String s = (String)lines.elementAt(i);
                int ind = s.indexOf(":");
                if (ind != -1) {
                    String key = s.substring(0, ind).toLowerCase().trim();
                    String val = s.substring(ind + 1, s.length()).trim();
                    ht.put(key, val);
                }
                ++i;
            }
        }
        String contyp = (String)ht.get("content-type");
        String conlen = (String)ht.get("content-length");
        if (contyp.toLowerCase().startsWith("multipart")) {
            NetworkRequest.extractMultipart(dis, erg, conlen, contyp);
        } else {
            try {
                int len;
                byte[] b;
                if (conlen != null && (b = NetworkRequest.readIt(len = Integer.parseInt(conlen), dis)) != null) {
                    String attrst = new String(b);
                    NetworkRequest.extractAttrs(attrst, erg);
                }
            }
            catch (Exception e) {
                System.out.println("Kacke " + e);
            }
        }
        return erg;
    }

    private static void extractMultipart(DataInputStream in, NetworkRequest erg, String conlen, String contyp) {
        if (conlen == null) {
            System.out.println("Content length not defined!");
            return;
        }
        int len = 0;
        try {
            len = Integer.parseInt(conlen);
        }
        catch (Exception e) {
            System.out.println("Error determinig content length >" + conlen + "< " + e);
            return;
        }
        byte[] b = NetworkRequest.readIt(len, in);
        if (b == null) {
            System.out.println("Could not read content!");
            return;
        }
        String kenn = "boundary=";
        int ind = contyp.indexOf(kenn);
        if (ind == -1) {
            System.out.println("Boundary not defined!");
            return;
        }
        String boundary = "--" + contyp.substring(ind + kenn.length(), contyp.length()).trim();
        Vector bytearrays = StringHelper.splitByteArray(b, boundary.getBytes());
        String twolfsS = "\r\n\r\n";
        byte[] twolfs = twolfsS.getBytes();
        int i = 0;
        while (i < bytearrays.size()) {
            byte[] array = (byte[])bytearrays.elementAt(i);
            String t = new String(array);
            int dnlind = t.indexOf(twolfsS, 1);
            if (dnlind != -1) {
                Vector ouV = StringHelper.splitByteArray(array, twolfs);
                String oben = t.substring(0, dnlind).trim();
                String unten = t.substring(dnlind + 4, t.length());
                Vector obenlines = StringHelper.splitStringByAny(oben, "\n");
                if (obenlines.size() > 1) {
                    MultipartData filedata = new MultipartData();
                    byte[] data = (byte[])ouV.elementAt(1);
                    if (data[data.length - 2] == 13 && data[data.length - 1] == 10) {
                        byte[] ndata = new byte[data.length - 2];
                        int bci = 0;
                        while (bci < ndata.length) {
                            ndata[bci] = data[bci];
                            ++bci;
                        }
                        data = ndata;
                    }
                    filedata.ivData = data;
                    int j = 0;
                    while (j < obenlines.size()) {
                        int dpind;
                        String line = (String)obenlines.elementAt(j);
                        if ((line = line.trim()).length() != 0 && (dpind = line.indexOf(":")) != -1) {
                            String vorn = line.substring(0, dpind).toLowerCase().trim();
                            String hinten = line.substring(dpind + 1, line.length()).trim();
                            if (vorn.equals("content-type")) {
                                filedata.ivContentType = hinten;
                            } else {
                                int fnind;
                                int nind = hinten.indexOf("name=");
                                if (nind != -1) {
                                    String nstr = hinten.substring(nind + 5, hinten.length()).trim();
                                    int vapind = nstr.indexOf("\"");
                                    int hapind = nstr.indexOf("\"", vapind + 1);
                                    if (vapind != -1 && hapind != -1) {
                                        String key = nstr.substring(vapind + 1, hapind);
                                        erg.ivCommandAttributes.put(key, filedata);
                                    }
                                }
                                if ((fnind = hinten.indexOf("filename=")) != -1) {
                                    String nstr = hinten.substring(fnind + 9, hinten.length()).trim();
                                    int vapind = nstr.indexOf("\"");
                                    int hapind = nstr.indexOf("\"", vapind + 1);
                                    if (vapind != -1 && hapind != -1) {
                                        String key;
                                        filedata.ivFilename = key = nstr.substring(vapind + 1, hapind);
                                    }
                                }
                            }
                        }
                        ++j;
                    }
                } else {
                    String hinten;
                    int nind;
                    int dpind = oben.indexOf(":");
                    if (dpind != -1 && (nind = (hinten = oben.substring(dpind + 1, oben.length()).trim()).indexOf("name=")) != -1) {
                        String nstr = hinten.substring(nind + 5, hinten.length()).trim();
                        int vapind = nstr.indexOf("\"");
                        int hapind = nstr.indexOf("\"", vapind + 1);
                        if (vapind != -1 && hapind != -1) {
                            String key = nstr.substring(vapind + 1, hapind);
                            String val = unten.trim();
                            erg.ivCommandAttributes.put(key, val);
                        }
                    }
                }
            }
            ++i;
        }
    }

    private static byte[] readIt(int len, DataInputStream dis) {
        try {
            byte[] b = new byte[len];
            int gelesen = 0;
            while (gelesen != len) {
                int ngel = dis.read(b, gelesen, len - gelesen);
                gelesen += ngel;
            }
            return b;
        }
        catch (Exception e) {
            System.out.println("Kacke beim lesen: " + e);
            return null;
        }
    }

    private static NetworkRequest handleGET(String request) {
        String reqs;
        NetworkRequest erg = new NetworkRequest();
        int start = request.indexOf(47);
        int finish = request.lastIndexOf("HTTP/");
        if (start == -1 || finish == -1) {
            return null;
        }
        erg.ivRequestString = reqs = request.substring(start + 1, finish).trim();
        if (reqs.length() != 0) {
            String realcomm = reqs.substring(1, reqs.length());
            NetworkRequest.extractAttrs(realcomm, erg);
        }
        return erg;
    }

    private static void extractAttrs(String s, NetworkRequest erg) {
        StringTokenizer st = new StringTokenizer(s, "&");
        while (st.hasMoreTokens()) {
            StringTokenizer st2;
            String attr = st.nextToken().trim();
            if (attr.length() == 0 || (st2 = new StringTokenizer(attr, "=")).countTokens() != 2) continue;
            String key = st2.nextToken();
            String val = st2.nextToken();
            erg.ivCommandAttributes.put(key, val);
        }
    }

    public NetworkRequest() {
        long aktmillis = System.currentTimeMillis();
        if (aktmillis <= cvLastLong) {
            aktmillis = cvLastLong + 1L;
        }
        cvLastLong = aktmillis;
        this.ivId = Long.toString(aktmillis);
    }

    public String getId() {
        return this.ivId;
    }

    public String getRequestString() {
        return this.ivRequestString;
    }

    public String getAttribute(String key) {
        return (String)this.ivCommandAttributes.get(key);
    }
}

