/*
 * Decompiled with CFR 0.152.
 */
package de.hannse.netobjects.tools;

import de.hannse.netobjects.objectstore.ObjectRequest;
import de.hannse.netobjects.tools.StringHelper;
import de.hannse.netobjects.util.ArrayHelper;
import de.hannse.netobjects.util.Log;
import de.hannse.netobjects.util.RequestManager;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import mausoleum.main.ProcessDefinition;

public class FileManager {
    public static final String DATA_FILE_TAG = ".txt";
    public static final String DATA_NOT_TAG = ".not";
    public static final String LOCK_FILE_TAG = ".lck";
    private static final String[] IGNORE_FILES = new String[]{".DS_Store", "Thumbs.db"};
    static /* synthetic */ Class class$0;

    public static void prepareDirs(String tree) {
        try {
            File f;
            if (tree.endsWith("/")) {
                tree = tree.substring(0, tree.length() - 1);
            }
            if (!(f = new File(tree)).exists()) {
                f.mkdirs();
            }
        }
        catch (Exception e) {
            String string = "Could not prepare directories >" + tree + "< ";
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("de.hannse.netobjects.tools.FileManager");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Log.warn(string, e, clazz);
        }
    }

    public static void deleteFile(String filename) {
        File f = new File(filename);
        if (f.exists() && !f.isDirectory()) {
            try {
                f.delete();
            }
            catch (Exception e) {
                String string = "Could not delete file >" + filename + "< ";
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("de.hannse.netobjects.tools.FileManager");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Log.warn(string, e, clazz);
            }
        }
    }

    public static boolean saveStringToFile(String filename, String content) {
        try {
            FileWriter fw = new FileWriter(filename);
            fw.write(content);
            fw.flush();
            fw.close();
            return true;
        }
        catch (Exception e) {
            String string = "Could not save String to file >" + filename + "< ";
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("de.hannse.netobjects.tools.FileManager");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Log.warn(string, e, clazz);
            return false;
        }
    }

    public static boolean saveUTF8StringToFile(String filename, String content) {
        try {
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filename), "UTF-8"));
            out.write(content);
            ((Writer)out).flush();
            ((Writer)out).close();
            return true;
        }
        catch (Exception e) {
            String string = "Could not save String to file >" + filename + "< ";
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("de.hannse.netobjects.tools.FileManager");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Log.warn(string, e, clazz);
            return false;
        }
    }

    public static boolean appendStringToServerFile(String filename, String content) {
        if (!ProcessDefinition.isClient()) {
            FileManager.prepareDirsForFile(filename);
            return FileManager.pureAppend(filename, content);
        }
        FileManager.appendStringContentToServer(filename, content);
        return true;
    }

    public static boolean pureAppend(String filename, String content) {
        try {
            FileWriter fw = new FileWriter(filename, true);
            fw.write(content);
            fw.flush();
            fw.close();
        }
        catch (Throwable e) {
            String string = "Could not save String to file >" + filename + "< ";
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("de.hannse.netobjects.tools.FileManager");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Log.warn(string, e, clazz);
            return false;
        }
        return true;
    }

    public static boolean saveBytesToFile(String filename, byte[] content) {
        try {
            FileManager.prepareDirsForFile(filename);
            FileOutputStream fos = new FileOutputStream(filename);
            fos.write(content);
            fos.flush();
            fos.close();
            return true;
        }
        catch (Exception e) {
            String string = "Could not save Bytes to file >" + filename + "< ";
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("de.hannse.netobjects.tools.FileManager");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Log.warn(string, e, clazz);
            return false;
        }
    }

    public static String[] getDirContentFromServer(String dir) {
        try {
            ObjectRequest mor = RequestManager.createSendAndGetAnswer((byte)35, dir, null);
            if (mor.isFinished()) {
                return (String[])mor.ivObject;
            }
        }
        catch (Exception e) {
            String string = "Could not get dir content >" + dir + "< ";
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("de.hannse.netobjects.tools.FileManager");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Log.warn(string, e, clazz);
        }
        return null;
    }

    public static String getStringContentFromServer(String filepath) {
        if (ProcessDefinition.isServer()) {
            return FileManager.getStringFromFile(filepath);
        }
        try {
            ObjectRequest mor = RequestManager.createSendAndGetAnswer((byte)36, filepath, null);
            if (mor.isFinished()) {
                byte[] buff = (byte[])mor.ivObject;
                return new String(buff);
            }
        }
        catch (Exception e) {
            String string = "Could not get file content >" + filepath + "< ";
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("de.hannse.netobjects.tools.FileManager");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Log.warn(string, e, clazz);
        }
        return null;
    }

    public static void appendStringContentToServer(String filepath, String content) {
        if (RequestManager.isUpAndRunning()) {
            String[] arg = new String[]{filepath, content};
            ObjectRequest mor = new ObjectRequest(38, arg, null, null);
            try {
                RequestManager.sendObjectRequestAndForget(mor);
            }
            catch (Exception e) {
                String string = "Could not send string content >" + filepath + "< " + e;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("de.hannse.netobjects.tools.FileManager");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Log.info(string, clazz);
            }
        }
    }

    public static void saveStringContentToServer(String filepath, String content, String command, String group) {
        HashMap<String, Object> hm = new HashMap<String, Object>(5);
        hm.put("path", filepath);
        hm.put("content", content.getBytes());
        if (command != null) {
            hm.put("command", command);
        }
        ObjectRequest mor = new ObjectRequest(37, hm, group, null);
        try {
            RequestManager.sendObjectRequestAndForget(mor);
        }
        catch (Exception e) {
            String string = "Could not send string content >" + filepath + "< " + e;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("de.hannse.netobjects.tools.FileManager");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Log.info(string, clazz);
        }
    }

    public static Object getObjectFromFile(String filename) {
        File f = new File(filename);
        if (f.exists()) {
            if (!f.isDirectory()) {
                try {
                    ObjectInputStream ois = new ObjectInputStream(new FileInputStream(f));
                    Object erg = ois.readObject();
                    ois.close();
                    return erg;
                }
                catch (Exception e) {
                    String string = "Could not get Bytes from file >" + filename + "< ";
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("de.hannse.netobjects.tools.FileManager");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    Log.warn(string, e, clazz);
                }
            }
        } else {
            try {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                InputStream is = cl.getResourceAsStream(filename);
                if (is != null) {
                    ObjectInputStream ois = new ObjectInputStream(is);
                    Object erg = ois.readObject();
                    ois.close();
                    return erg;
                }
            }
            catch (Exception e) {
                String string = "Could not get Object from Classpath file >" + filename + "< ";
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("de.hannse.netobjects.tools.FileManager");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Log.warn(string, e, clazz);
            }
        }
        return null;
    }

    public static void prepareDirsForFile(String path) {
        int ind = path.lastIndexOf("/");
        if (ind != -1) {
            FileManager.prepareDirs(path.substring(0, ind));
        }
    }

    public static InputStream getInputstream(String filename) {
        File f = new File(filename);
        if (!f.exists()) {
            try {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                return cl.getResourceAsStream(filename);
            }
            catch (Exception e) {
                String string = "Could not get InputStream from Classpath file >" + filename + "< ";
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("de.hannse.netobjects.tools.FileManager");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Log.info(string, clazz);
            }
        }
        try {
            return new FileInputStream(filename);
        }
        catch (Exception e) {
            String string = "Could not get InputStream from file >" + filename + "<";
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("de.hannse.netobjects.tools.FileManager");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Log.warn(string, e, clazz);
            return null;
        }
    }

    public static String getStringFromFile(String pfad) {
        return FileManager.getStringFromFile(pfad, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getStringFromFile(String pfad, boolean showWarning) {
        File f = new File(pfad);
        if (f.exists()) {
            if (f.isDirectory()) return "";
            try {
                long l = f.length();
                byte[] buff = new byte[(int)l];
                DataInputStream dis = new DataInputStream(new FileInputStream(f));
                dis.readFully(buff);
                dis.close();
                return new String(buff);
            }
            catch (Exception e) {
                if (!showWarning) return "";
                String string = "Could not get String from file >" + pfad + "< ";
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("de.hannse.netobjects.tools.FileManager");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Log.warn(string, e, clazz);
                return "";
            }
        }
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            InputStream is = cl.getResourceAsStream(pfad);
            if (is != null) {
                int av = is.available();
                byte[] b = new byte[av];
                DataInputStream dis = new DataInputStream(is);
                dis.readFully(b);
                dis.close();
                return new String(b);
            }
            if (!showWarning) return "";
            String string = "Datei >" + pfad + "< nicht im Classpath";
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("de.hannse.netobjects.tools.FileManager");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Log.debug(string, clazz);
            return "";
        }
        catch (Exception e) {
            if (!showWarning) return "";
            String string = "Could not get String from Classpath file >" + pfad + "< ";
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("de.hannse.netobjects.tools.FileManager");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Log.warn(string, e, clazz);
        }
        return "";
    }

    public static byte[] getBytesFromFile(String pfad) {
        File f = new File(pfad);
        if (f.exists()) {
            if (!f.isDirectory()) {
                try {
                    long l = f.length();
                    byte[] buff = new byte[(int)l];
                    DataInputStream dis = new DataInputStream(new FileInputStream(f));
                    dis.readFully(buff);
                    dis.close();
                    return buff;
                }
                catch (Exception e) {
                    String string = "Could not get Bytes from file >" + pfad + "< ";
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("de.hannse.netobjects.tools.FileManager");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    Log.warn(string, e, clazz);
                }
            }
        } else {
            try {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                InputStream is = cl.getResourceAsStream(pfad);
                if (is != null) {
                    int av = is.available();
                    byte[] b = new byte[av];
                    DataInputStream dis = new DataInputStream(is);
                    dis.readFully(b);
                    dis.close();
                    return b;
                }
            }
            catch (Exception e) {
                String string = "Could not get Bytes from Classpath file >" + pfad + "< ";
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("de.hannse.netobjects.tools.FileManager");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Log.warn(string, e, clazz);
                return null;
            }
        }
        return null;
    }

    public static Vector getSplittedLinesFromFile(String filename, String elementSplitter, String commentStart) {
        Vector erg = new Vector();
        InputStream is = FileManager.getInputstream(filename);
        if (is != null) {
            LineNumberReader lnr = new LineNumberReader(new InputStreamReader(is));
            try {
                String line = lnr.readLine();
                while (line != null) {
                    if (!((line = line.trim()).length() == 0 || commentStart != null && line.startsWith(commentStart))) {
                        Vector v = StringHelper.splitStringByAny(line, elementSplitter);
                        Vector<String> rein = new Vector<String>();
                        int zi = 0;
                        while (zi < v.size()) {
                            rein.addElement(((String)v.elementAt(zi)).trim());
                            ++zi;
                        }
                        erg.addElement(rein);
                    }
                    line = lnr.readLine();
                }
                lnr.close();
                lnr = null;
                is.close();
            }
            catch (Exception e) {
                String string = "Error while loading " + filename;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("de.hannse.netobjects.tools.FileManager");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Log.warn(string, e, clazz);
            }
        } else {
            String string = "No inputstream for " + filename;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("de.hannse.netobjects.tools.FileManager");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Log.info(string, clazz);
        }
        return erg;
    }

    public static boolean copyAlsoFromJar(String from, String to) {
        try {
            byte[] buf = FileManager.getBytesFromFile(from);
            if (buf != null) {
                return FileManager.saveBytesToFile(to, buf);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static boolean move(String from_name, String to_name) {
        File from_file = new File(from_name);
        if (!from_file.exists()) {
            return false;
        }
        File to_file = new File(to_name);
        if (to_file.exists()) {
            FileManager.deleteFile(to_name);
        }
        long length = from_file.length();
        boolean res = from_file.renameTo(to_file);
        if (res) {
            while (!to_file.exists() && to_file.length() != length) {
                try {
                    Thread.sleep(400L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return res;
    }

    public static void copyDir(String fromDir, String toDir, boolean rekursiv) {
        if (new File(fromDir).exists()) {
            FileManager.prepareDirs(toDir);
            String[] files = new File(fromDir).list();
            int i = 0;
            while (i < files.length) {
                String fromPath = String.valueOf(fromDir) + "/" + files[i];
                File f = new File(fromPath);
                if (f.isDirectory()) {
                    if (rekursiv) {
                        FileManager.copyDir(String.valueOf(fromDir) + "/" + files[i], String.valueOf(toDir) + "/" + files[i], rekursiv);
                    }
                } else {
                    FileManager.copy(String.valueOf(fromDir) + "/" + files[i], String.valueOf(toDir) + "/" + files[i]);
                }
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean copy(String from_name, String to_name) {
        block31: {
            from_file = new File(from_name);
            to_file = new File(to_name);
            from = null;
            to = null;
            try {
                try {
                    from = new FileInputStream(from_file);
                    to = new FileOutputStream(to_file);
                    buffer = new byte[4096];
                    while (true) {
                        block32: {
                            if ((bytes_read = from.read(buffer)) != -1) break block32;
                            to.flush();
                            break;
                        }
                        to.write(buffer, 0, bytes_read);
                    }
                }
                catch (Exception e) {
                    v0 = "Konnte Datei " + from_name + " nicht nach " + to_name + " kopieren!";
                    v1 = FileManager.class$0;
                    if (v1 == null) {
                        try {
                            v2 = Class.forName("de.hannse.netobjects.tools.FileManager");
                        }
                        catch (ClassNotFoundException v3) {
                            throw new NoClassDefFoundError(v3.getMessage());
                        }
                        v1 = FileManager.class$0 = v2;
                    }
                    Log.error(v0, e, v1);
                    var8_9 = null;
                    if (from != null) {
                        try {
                            from.close();
                        }
                        catch (IOException e) {
                            v4 = "Could not close File " + from_name;
                            v5 = FileManager.class$0;
                            if (v5 == null) {
                                try {
                                    v6 = Class.forName("de.hannse.netobjects.tools.FileManager");
                                }
                                catch (ClassNotFoundException v7) {
                                    throw new NoClassDefFoundError(v7.getMessage());
                                }
                                v5 = FileManager.class$0 = v6;
                            }
                            Log.error(v4, e, v5);
                        }
                    }
                    if (to == null) return false;
                    try {
                        to.close();
                        return false;
                    }
                    catch (IOException e) {
                        v8 = "Could not close File " + to_name;
                        v9 = FileManager.class$0;
                        if (v9 == null) {
                            try {
                                v10 = Class.forName("de.hannse.netobjects.tools.FileManager");
                            }
                            catch (ClassNotFoundException v11) {
                                throw new NoClassDefFoundError(v11.getMessage());
                            }
                            v9 = FileManager.class$0 = v10;
                        }
                        Log.error(v8, e, v9);
                    }
                    return false;
                }
            }
            catch (Throwable var9_15) {
                block33: {
                    var8_10 = null;
                    if (from == null) break block33;
                    ** try [egrp 3[TRYBLOCK] [4 : 178->186)] { 
lbl69:
                    // 1 sources

                    from.close();
                    break block33;
lbl71:
                    // 1 sources

                    catch (IOException e) {
                        block34: {
                            v12 = "Could not close File " + from_name;
                            v13 = FileManager.class$0;
                            if (v13 != null) break block34;
                            try {}
                            catch (ClassNotFoundException v14) {
                                throw new NoClassDefFoundError(v14.getMessage());
                            }
                            v13 = FileManager.class$0 = Class.forName("de.hannse.netobjects.tools.FileManager");
                        }
                        Log.error(v12, e, v13);
                    }
                }
                if (to == null) throw var9_15;
                ** try [egrp 5[TRYBLOCK] [6 : 247->255)] { 
lbl85:
                // 1 sources

                to.close();
                throw var9_15;
lbl87:
                // 1 sources

                catch (IOException e) {
                    block35: {
                        v15 = "Could not close File " + to_name;
                        v16 = FileManager.class$0;
                        if (v16 != null) break block35;
                        try {}
                        catch (ClassNotFoundException v17) {
                            throw new NoClassDefFoundError(v17.getMessage());
                        }
                        v16 = FileManager.class$0 = Class.forName("de.hannse.netobjects.tools.FileManager");
                    }
                    Log.error(v15, e, v16);
                }
                throw var9_15;
            }
            {
                var8_11 = null;
                if (from == null) break block31;
            }
            ** try [egrp 3[TRYBLOCK] [4 : 178->186)] { 
lbl102:
            // 1 sources

            from.close();
            break block31;
lbl104:
            // 1 sources

            catch (IOException e) {
                block36: {
                    v18 = "Could not close File " + from_name;
                    v19 = FileManager.class$0;
                    if (v19 != null) break block36;
                    try {}
                    catch (ClassNotFoundException v20) {
                        throw new NoClassDefFoundError(v20.getMessage());
                    }
                    v19 = FileManager.class$0 = Class.forName("de.hannse.netobjects.tools.FileManager");
                }
                Log.error(v18, e, v19);
            }
        }
        if (to == null) return true;
        try {}
        catch (IOException e) {
            block37: {
                v21 = "Could not close File " + to_name;
                v22 = FileManager.class$0;
                if (v22 != null) break block37;
                try {}
                catch (ClassNotFoundException v23) {
                    throw new NoClassDefFoundError(v23.getMessage());
                }
                v22 = FileManager.class$0 = Class.forName("de.hannse.netobjects.tools.FileManager");
            }
            Log.error(v21, e, v22);
            return true;
        }
        to.close();
        return true;
    }

    public static void deleteDir(String dir, boolean rekursiv) {
        if (new File(dir).exists()) {
            String[] files = new File(dir).list();
            int i = 0;
            while (i < files.length) {
                String fromPath = String.valueOf(dir) + "/" + files[i];
                File f = new File(fromPath);
                if (f.isDirectory()) {
                    if (rekursiv) {
                        FileManager.deleteDir(fromPath, rekursiv);
                    }
                } else {
                    FileManager.deleteFile(fromPath);
                }
                ++i;
            }
        }
        new File(dir).delete();
    }

    public static void zip(String generalDir, String zipName, HashSet exludeDirNames, Vector excludeFileSuffices) {
        if (new File(zipName).exists()) {
            FileManager.deleteFile(zipName);
        }
        Vector paths = new Vector(200000);
        Vector names = new Vector(200000);
        FileManager.preparePathsForZipping(generalDir, null, paths, names, exludeDirNames, excludeFileSuffices);
        FileManager.zipFiles(zipName, paths, names);
    }

    private static void preparePathsForZipping(String dirPath, String relPath, Vector paths, Vector names, HashSet exludeDirNames, Vector excludeFileSuffices) {
        File dir = new File(dirPath);
        String[] files = dir.list();
        int i = 0;
        while (i < files.length) {
            String filepath = String.valueOf(dirPath) + "/" + files[i];
            File sf = new File(filepath);
            if (sf.isDirectory()) {
                if (exludeDirNames == null || !exludeDirNames.contains(files[i])) {
                    if (relPath == null) {
                        FileManager.preparePathsForZipping(filepath, files[i], paths, names, exludeDirNames, excludeFileSuffices);
                    } else {
                        FileManager.preparePathsForZipping(filepath, String.valueOf(relPath) + "/" + files[i], paths, names, exludeDirNames, excludeFileSuffices);
                    }
                }
            } else {
                boolean takeit = true;
                if (excludeFileSuffices != null) {
                    Iterator iterator = excludeFileSuffices.iterator();
                    while (takeit && iterator.hasNext()) {
                        if (!files[i].endsWith((String)iterator.next())) continue;
                        takeit = false;
                    }
                }
                if (takeit) {
                    if (relPath == null) {
                        names.addElement(files[i]);
                    } else {
                        names.addElement(String.valueOf(relPath) + "/" + files[i]);
                    }
                    paths.addElement(filepath);
                }
            }
            ++i;
        }
    }

    public static boolean zipFiles(String outpath, Vector inpaths, Vector namesInZip) {
        String outPathTemp = String.valueOf(outpath) + "_tmp";
        byte[] buf = new byte[1024];
        try {
            ZipOutputStream out = new ZipOutputStream(new FileOutputStream(outpath));
            CRC32 crc = new CRC32();
            int i = 0;
            while (i < inpaths.size()) {
                String inPath = (String)inpaths.elementAt(i);
                if (new File(inPath).exists()) {
                    int len;
                    String outPath = (String)namesInZip.elementAt(i);
                    FileInputStream in = new FileInputStream(inPath);
                    ZipEntry entry = new ZipEntry(outPath);
                    crc.reset();
                    crc.update(buf);
                    entry.setCrc(crc.getValue());
                    out.putNextEntry(entry);
                    while ((len = in.read(buf)) > 0) {
                        out.write(buf, 0, len);
                    }
                    out.closeEntry();
                    in.close();
                }
                ++i;
            }
            out.close();
            FileManager.move(outPathTemp, outpath);
            return true;
        }
        catch (IOException e) {
            String string = "FileManager Problem creating ZIP: " + outpath;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("de.hannse.netobjects.tools.FileManager");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Log.error(string, e, clazz);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static HashMap digestZIPBytes(byte[] zipData) {
        HashMap<String, byte[]> erg = new HashMap<String, byte[]>();
        ByteArrayInputStream bis = new ByteArrayInputStream(zipData);
        ZipInputStream zis = new ZipInputStream(bis);
        ZipEntry ze = null;
        try {
            block8: while (true) {
                if ((ze = zis.getNextEntry()) == null) {
                    return erg;
                }
                if (ze.isDirectory()) continue;
                String zeName = ze.getName();
                int size = (int)ze.getSize();
                try {
                    if (size == -1) {
                        ByteArrayOutputStream bos = new ByteArrayOutputStream();
                        byte[] buff = new byte[1024];
                        int gelesen = zis.read(buff, 0, 1024);
                        while (true) {
                            if (gelesen == -1) {
                                bos.flush();
                                byte[] b = bos.toByteArray();
                                bos.close();
                                erg.put(zeName, b);
                                continue block8;
                            }
                            bos.write(buff, 0, gelesen);
                            gelesen = zis.read(buff, 0, 1024);
                        }
                    }
                    byte[] b = new byte[size];
                    int rb = 0;
                    int chunk = 0;
                    while (size - rb > 0 && (chunk = zis.read(b, rb, size - rb)) != -1) {
                        rb += chunk;
                    }
                    erg.put(zeName, b);
                }
                catch (Exception e) {
                    String string = "Problem bei entzippen von Entry " + zeName;
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("de.hannse.netobjects.tools.FileManager");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    Log.error(string, e, clazz);
                }
            }
        }
        catch (Exception e) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                Class<?> clazz2;
                try {
                    clazz2 = Class.forName("de.hannse.netobjects.tools.FileManager");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                clazz = class$0 = clazz2;
            }
            Log.error("Problem bei entzippen", e, clazz);
        }
        return erg;
    }

    public static void addRealFiles(List files, Vector target) {
        if (files != null && !files.isEmpty()) {
            Iterator iterator = files.iterator();
            while (iterator.hasNext()) {
                File f = (File)iterator.next();
                if (f.isFile() && ArrayHelper.findStringInArray(f.getName(), IGNORE_FILES) == -1) {
                    target.add(f);
                    continue;
                }
                if (!f.isDirectory()) continue;
                File[] kids = f.listFiles();
                Vector<File> klist = new Vector<File>(kids.length);
                int i = 0;
                while (i < kids.length) {
                    klist.add(kids[i]);
                    ++i;
                }
                FileManager.addRealFiles(klist, target);
            }
        }
    }
}

