/*
 * Decompiled with CFR 0.152.
 */
package de.hannse.netobjects.util;

import de.hannse.netobjects.tools.StringHelper;
import de.hannse.netobjects.util.ConfigReader;
import de.hannse.netobjects.util.Log;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import mausoleum.main.ProcessDefinition;
import mausoleum.util.InstallationType;

public class Babel {
    public static final String DEFAULT_LANGUAGE = "en";
    public static final Vector AVAILABLE_LANGUAGES = new Vector();
    public static final Vector AVAILABLE_LANGUAGES_SHORT = new Vector();
    private static final String DEFAULT_LANGUAGE_S = "en";
    private static final String DEFAULT_LANGUAGE_L = "English";
    private static final HashMap FULL_BY_SHORT = new HashMap();
    private static final HashMap SHORT_BY_FULL = new HashMap();
    private static final HashMap ROSETTA = new HashMap();
    public static String cvUserLangue = "en";
    static /* synthetic */ Class class$0;

    static {
        Babel.readOneFile("data/babel64.txt", false);
        if (InstallationType.isFish()) {
            Babel.readOneFile("data/babelfish64.txt", true);
        }
        int i = 0;
        while (i < AVAILABLE_LANGUAGES_SHORT.size()) {
            String shortName = (String)AVAILABLE_LANGUAGES_SHORT.elementAt(i);
            String longName = Babel.get("LANGUAGENAME", shortName);
            FULL_BY_SHORT.put(shortName, longName);
            SHORT_BY_FULL.put(longName, shortName);
            AVAILABLE_LANGUAGES.add(longName);
            ++i;
        }
    }

    private static void readOneFile(String filename, boolean isOverride) {
        boolean languagesDefined = false;
        Vector lines = ConfigReader.getLines(filename, "|", true);
        if (lines != null) {
            Hashtable<Integer, String> langPosKeys = new Hashtable<Integer, String>(10);
            int i = 0;
            while (i < lines.size()) {
                Vector lv = (Vector)lines.elementAt(i);
                if (lv.size() != 0) {
                    int li;
                    String key = ((String)lv.elementAt(0)).trim();
                    if (!languagesDefined) {
                        if (!key.equals("THELANGUAGE")) {
                            String string = "Malformed babel file 1 in line " + (i + 1);
                            Class<?> clazz = class$0;
                            if (clazz == null) {
                                try {
                                    clazz = Class.forName("de.hannse.netobjects.util.Babel");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            Log.error(string, null, clazz);
                        } else {
                            li = 1;
                            while (li < lv.size() - 1) {
                                String lkey = ((String)lv.elementAt(li)).trim().toLowerCase();
                                langPosKeys.put(new Integer(li), lkey);
                                if (!isOverride) {
                                    AVAILABLE_LANGUAGES_SHORT.add(lkey);
                                    ROSETTA.put(lkey, new HashMap(2000));
                                }
                                languagesDefined = true;
                                ++li;
                            }
                        }
                    } else {
                        li = 1;
                        while (li < lv.size() - 1) {
                            String language = (String)langPosKeys.get(new Integer(li));
                            if (language == null) {
                                String string = "Malformed babel file no language defined in line " + (i + 1) + ": " + lv;
                                Class<?> clazz = class$0;
                                if (clazz == null) {
                                    try {
                                        clazz = Class.forName("de.hannse.netobjects.util.Babel");
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                    }
                                }
                                Log.error(string, null, clazz);
                            } else {
                                HashMap ht = (HashMap)ROSETTA.get(language);
                                if (ht == null) {
                                    String string = "Malformed babel file missing dictionary in line " + (i + 1) + ": " + lv;
                                    Class<?> clazz = class$0;
                                    if (clazz == null) {
                                        try {
                                            clazz = Class.forName("de.hannse.netobjects.util.Babel");
                                        }
                                        catch (ClassNotFoundException classNotFoundException) {
                                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                        }
                                    }
                                    Log.error(string, null, clazz);
                                } else {
                                    String val = ((String)lv.elementAt(li)).trim();
                                    if (val.length() != 0) {
                                        if (val.startsWith("\"") || val.startsWith("'")) {
                                            val = val.substring(1, val.length() - 1);
                                        }
                                        if (!isOverride && ht.get(key.toUpperCase()) != null) {
                                            String string = "Duplicate definition of " + key + " in babel file line " + (i + 1) + ": " + lv;
                                            Class<?> clazz = class$0;
                                            if (clazz == null) {
                                                try {
                                                    clazz = Class.forName("de.hannse.netobjects.util.Babel");
                                                }
                                                catch (ClassNotFoundException classNotFoundException) {
                                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                                }
                                            }
                                            Log.error(string, null, clazz);
                                        } else {
                                            ht.put(key.toUpperCase(), StringHelper.gSub(val, "\\n", "\n"));
                                        }
                                    } else if (isOverride) {
                                        ht.remove(key.toUpperCase());
                                    }
                                }
                            }
                            ++li;
                        }
                    }
                }
                ++i;
            }
        }
    }

    public static Vector getAvailableLanguagesShort() {
        return AVAILABLE_LANGUAGES_SHORT;
    }

    public static void enterBabelValue(String lang, String key, String val) {
        HashMap hm = (HashMap)ROSETTA.get(lang);
        if (hm != null) {
            hm.put(key.toUpperCase().trim(), val);
        }
    }

    public static String get(String s) {
        if (s == null || s.trim().length() == 0) {
            return "";
        }
        return Babel.get(s, ProcessDefinition.isClient() ? cvUserLangue : "en");
    }

    public static String[] get(String[] arr) {
        return Babel.get(arr, false);
    }

    public static String getLangForString(String s) {
        String erg;
        if (s != null && (erg = (String)SHORT_BY_FULL.get(s)) != null) {
            return erg;
        }
        return "en";
    }

    public static String getStringForLang(String s) {
        String erg;
        if (s != null && (erg = (String)FULL_BY_SHORT.get(s)) != null) {
            return erg;
        }
        return DEFAULT_LANGUAGE_L;
    }

    public static String[] get(String[] babels, boolean withSpaces) {
        String[] res = null;
        if (babels != null) {
            res = new String[babels.length];
            int i = 0;
            while (i < res.length) {
                res[i] = babels[i].trim().length() == 0 ? "" : (withSpaces ? " " + Babel.get(babels[i]) + " " : Babel.get(babels[i]));
                ++i;
            }
        }
        return res;
    }

    public static void fillAllTranslations(String search, HashMap target) {
        target.clear();
        String ks = search.toUpperCase().trim();
        Iterator iterator = ROSETTA.keySet().iterator();
        while (iterator.hasNext()) {
            String val;
            String lang = (String)iterator.next();
            HashMap hm = (HashMap)ROSETTA.get(lang);
            if (hm == null || (val = (String)hm.get(ks)) == null) continue;
            target.put(lang, val);
        }
    }

    public static String get(String s, String language) {
        HashMap ht;
        if (s == null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("de.hannse.netobjects.util.Babel");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Log.error("Leere Babelabfrage", null, clazz);
            return "";
        }
        if (language == null) {
            language = "en";
        }
        if ((ht = (HashMap)ROSETTA.get(language)) == null) {
            return s;
        }
        String ks = s.toUpperCase().trim();
        String erg = (String)ht.get(ks);
        if (erg != null) {
            return erg;
        }
        ht = (HashMap)ROSETTA.get("en");
        if (ht == null) {
            return s;
        }
        erg = (String)ht.get(ks);
        if (erg != null) {
            return erg;
        }
        return s;
    }
}

