/*
 * Decompiled with CFR 0.152.
 */
package de.hannse.netobjects.util;

import de.hannse.netobjects.tools.Base64Manager;
import de.hannse.netobjects.tools.FileManager;
import de.hannse.netobjects.util.Log;
import java.io.File;
import java.util.HashMap;
import java.util.Vector;
import jxl.Cell;
import jxl.Sheet;
import jxl.Workbook;
import mausoleum.main.ProcessDefinition;

public abstract class ConfigManager {
    private static final String FILENAME_BIG_CONFIG_EXCEL = "data/BigConfig.xls";
    public static final String FILENAME_BABEL_64 = "data/babel64.txt";
    public static final String FILENAME_BABELFISH_64 = "data/babelfish64.txt";
    public static final String FILENAME_PRIVILEGES_64 = "data/privileges64.txt";
    public static final String FILENAME_PRIVILEGES_64_OVR = "data/privileges64_OVR.txt";
    public static final String FILENAME_HOLIDAYS = "data/holidays64.txt";
    public static final String FILENAME_HOLIDAY_SETS = "data/holidaysSets64.txt";
    private static final String BABEL_SHEET = "babel";
    private static final String BABELFISH_SHEET = "babelfish";
    private static final String PRIVILEGES_SHEET = "privileges";
    private static final String HOLIDAYS_SHEET = "holidays";
    private static final String HOLIDAYSETS_SHEET = "holidaysets";
    static /* synthetic */ Class class$0;

    public static void main(String[] args) {
        ProcessDefinition.setProcessType(1);
        Log.init();
        try {
            HashMap<String, Sheet> sheetsByLabel = new HashMap<String, Sheet>(20);
            Vector<String> sheetNames = new Vector<String>();
            Workbook wb = Workbook.getWorkbook(new File(FILENAME_BIG_CONFIG_EXCEL));
            if (wb != null) {
                Sheet[] sheets = wb.getSheets();
                int i = 0;
                while (i < sheets.length) {
                    String sname = sheets[i].getName().toLowerCase().trim();
                    String string = "Found sheet: " + sname;
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("de.hannse.netobjects.util.ConfigManager");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    Log.log(string, clazz);
                    sheetsByLabel.put(sname, sheets[i]);
                    sheetNames.add(sname);
                    ++i;
                }
            }
            ConfigManager.handleSheet((Sheet)sheetsByLabel.get(BABEL_SHEET), FILENAME_BABEL_64, "|");
            ConfigManager.handleSheet((Sheet)sheetsByLabel.get(BABELFISH_SHEET), FILENAME_BABELFISH_64, "|");
            ConfigManager.handleSheet((Sheet)sheetsByLabel.get(PRIVILEGES_SHEET), FILENAME_PRIVILEGES_64, "\t");
            ConfigManager.handleSheet((Sheet)sheetsByLabel.get(HOLIDAYS_SHEET), FILENAME_HOLIDAYS, "|");
            ConfigManager.handleSheet((Sheet)sheetsByLabel.get(HOLIDAYSETS_SHEET), FILENAME_HOLIDAY_SETS, "|");
        }
        catch (Throwable e) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("de.hannse.netobjects.util.ConfigManager");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Log.error("Kann nicht wandeln: ", e, clazz);
        }
        System.exit(0);
    }

    private static void handleSheet(Sheet sheet, String outPath, String trenner) throws Exception {
        String string = "Handle sheet: " + sheet.getName();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("de.hannse.netobjects.util.ConfigManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Log.log(string, clazz);
        StringBuilder msb = new StringBuilder(10000);
        if (sheet != null) {
            Vector headers = ConfigManager.getContent(sheet, -1, false, 0);
            int anzCols = headers.size();
            int i = 0;
            while (i < anzCols) {
                if (i != 0) {
                    msb.append(trenner);
                }
                msb.append(Base64Manager.encodeBase64((String)headers.elementAt(i)));
                ++i;
            }
            msb.append("\n");
            int row = 1;
            while (row < sheet.getRows()) {
                Vector zeile = ConfigManager.getContent(sheet, anzCols, true, row);
                String vorne = (String)zeile.elementAt(0);
                if (vorne.trim().length() != 0) {
                    int i2 = 0;
                    while (i2 < zeile.size()) {
                        if (i2 != 0) {
                            msb.append(trenner);
                        }
                        msb.append(Base64Manager.encodeBase64((String)zeile.elementAt(i2)));
                        ++i2;
                    }
                    msb.append("\n");
                }
                ++row;
            }
        }
        FileManager.saveStringToFile(outPath, msb.toString());
    }

    private static Vector getContent(Sheet sheet, int maxCol, boolean acceptEmpties, int row) throws Exception {
        if (maxCol == -1) {
            maxCol = sheet.getColumns();
        }
        Vector<String> res = new Vector<String>();
        int col = 0;
        while (col < maxCol) {
            Cell cell = sheet.getCell(col, row);
            if (cell != null) {
                String cont = cell.getContents();
                if (acceptEmpties) {
                    if (cont == null) {
                        cont = "";
                    }
                    res.add(cont.trim());
                } else {
                    if (cont == null || cont.trim().length() == 0) {
                        return res;
                    }
                    res.add(cont.trim());
                }
            }
            ++col;
        }
        return res;
    }
}

