/*
 * Decompiled with CFR 0.152.
 */
package de.hannse.netobjects.util;

import de.hannse.netobjects.tools.FileManager;
import de.hannse.netobjects.tools.StringHelper;
import de.hannse.netobjects.util.DirPutzer;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.GregorianCalendar;
import java.util.Vector;
import mausoleum.helper.DatumFormat;
import mausoleum.main.ProcessDefinition;

public abstract class Log {
    private static final long FRIST = 1814400000L;
    public static final String LOG_DIR = "files/log/";
    private static final String SUFFIX = ".log";
    public static final int LOG_TYP_SUBDEBUG = 0;
    public static final int LOG_TYP_DEBUG = 1;
    public static final int LOG_TYP_LOG = 2;
    public static final int LOG_TYP_INFO = 3;
    public static final int LOG_TYP_WARN = 4;
    public static final int LOG_TYP_ERROR = 5;
    public static final String[] MIN_LOG_CHOICES = new String[]{" INFO ", " LOG ", " DEBUG ", " SUBDEBUG "};
    public static final int[] MIN_LOG_VALUES;
    private static final String TRENNER_NEU = "|============|";
    private static final String NEW_LINE = "\r\n";
    private static final String SPLITTER = "+------------+----------+--------------------------------------------------\r\n";
    private static final String SPLITTERH = "+------------+-------------------------------------------------------------\r\n";
    private static final String NORM_LINE_HEADER = "|            |          | ";
    private static final int MAX_LINE_WIDTH = 75;
    private static final int BODY_LINE_WIDTH;
    private static final CharArrayWriter CAW;
    private static final PrintWriter PW;
    private static String cvCurrentSpeaker;
    private static int cvMinLogMode;
    private static final GregorianCalendar GREG;
    static /* synthetic */ Class class$0;

    static {
        int[] nArray = new int[4];
        nArray[0] = 3;
        nArray[1] = 2;
        nArray[2] = 1;
        MIN_LOG_VALUES = nArray;
        BODY_LINE_WIDTH = 75 - NORM_LINE_HEADER.length();
        CAW = new CharArrayWriter();
        PW = new PrintWriter(CAW);
        cvCurrentSpeaker = null;
        cvMinLogMode = 2;
        GREG = new GregorianCalendar();
        FileManager.prepareDirs("files/log");
    }

    public static synchronized String getStacktrace(Throwable e) {
        if (e != null) {
            PW.flush();
            CAW.flush();
            CAW.reset();
            e.printStackTrace(PW);
            PW.flush();
            CAW.flush();
            return CAW.toString();
        }
        return "";
    }

    public static void init() {
        String s;
        FileManager.prepareDirs("files/log");
        DirPutzer.addDirPutzer("files/log", 1814400000L, 10000L);
        File f = new File("data/minloglevel.txt");
        if (f.exists() && (s = FileManager.getStringFromFile("data/minloglevel.txt")) != null) {
            try {
                Log.setDebugLevel(Integer.parseInt(s));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static boolean setDebugLevel(int logLevel) {
        if (logLevel >= 0 && logLevel < 4) {
            cvMinLogMode = logLevel;
            if (ProcessDefinition.isServer()) {
                String string = "Changed Min log mode to " + StringHelper.getStringForInt(logLevel, MIN_LOG_VALUES, MIN_LOG_CHOICES, false, "?");
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("de.hannse.netobjects.util.Log");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Log.log(string, clazz);
            }
            return true;
        }
        return false;
    }

    public static boolean shouldLog(int logLevel) {
        return logLevel >= cvMinLogMode;
    }

    public static void log(String s, Object speaker) {
        Log.createOutput(s, 2, null, speaker);
    }

    public static void info(String s, Object speaker) {
        Log.createOutput(s, 3, null, speaker);
    }

    public static void debug(String s, Object speaker) {
        Log.createOutput(s, 1, null, speaker);
    }

    public static void subdebug(String s, Object speaker) {
        Log.createOutput(s, 0, null, speaker);
    }

    public static void warn(String s, Object speaker) {
        Log.createOutput(s, 4, null, speaker);
    }

    public static void warn(String s, Throwable e, Object speaker) {
        Log.createOutput(s, 4, e, speaker);
    }

    public static void error(String s, Throwable e, Object speaker) {
        Log.createOutput(s, 5, e, speaker);
    }

    private static void createOutput(String msg, int logtyp, Throwable e, Object speaker) {
        if (msg != null && logtyp >= cvMinLogMode) {
            try {
                String speakerLine = SPLITTER;
                String speakerName = Log.getSpeakerName(speaker);
                if (!speakerName.equalsIgnoreCase(cvCurrentSpeaker)) {
                    cvCurrentSpeaker = speakerName;
                    speakerLine = Log.getSpeakerLine(speakerName);
                }
                StringBuilder msb = new StringBuilder(speakerLine);
                switch (logtyp) {
                    case 4: 
                    case 5: {
                        msb.append(Log.formatString(msg, logtyp));
                        if (e == null) break;
                        msb.append(NEW_LINE).append(Log.formatString(Log.getStacktrace(e), 0, true));
                        break;
                    }
                    default: {
                        if (e != null) {
                            msb.append(Log.formatString(String.valueOf(msg) + " ERROR -> " + e, logtyp));
                            break;
                        }
                        msb.append(Log.formatString(msg, logtyp));
                    }
                }
                String bigMessage = msb.toString();
                if (ProcessDefinition.isClient()) {
                    switch (logtyp) {
                        case 4: 
                        case 5: {
                            try {
                                msb = new StringBuilder(LOG_DIR);
                                msb.append(ProcessDefinition.isServer() ? "S-" : "C-");
                                msb.append(DatumFormat.getISOStringDate(GREG)).append(SUFFIX);
                                FileManager.appendStringToServerFile(msb.toString(), bigMessage);
                            }
                            catch (Exception exxx) {
                                System.out.println("Problem while sending ClientLog " + Log.getStacktrace(exxx));
                            }
                            break;
                        }
                    }
                    System.out.println(bigMessage);
                    return;
                }
                try {
                    msb = new StringBuilder(LOG_DIR);
                    msb.append(ProcessDefinition.isServer() ? "S-" : "C-");
                    msb.append(DatumFormat.getISOStringDate(GREG)).append(SUFFIX);
                    FileWriter fw = new FileWriter(msb.toString(), true);
                    fw.write(bigMessage);
                    fw.write("\n");
                    fw.flush();
                    fw.close();
                    System.out.println(bigMessage);
                }
                catch (IOException exc) {
                    System.out.println("IOException beim Loggen " + msg + " " + exc);
                }
            }
            catch (Exception exc2) {
                System.out.println("Problem beim Loggen " + msg + " " + exc2);
            }
        }
    }

    private static String getSpeakerName(Object speaker) {
        int pos;
        String speakerName = "???";
        if (speaker != null) {
            if (speaker instanceof Class) {
                Class sp = (Class)speaker;
                speakerName = sp.getName();
            } else {
                speakerName = speaker.getClass().getName();
            }
        }
        if ((pos = speakerName.lastIndexOf(".")) != -1) {
            return speakerName.substring(pos + 1, speakerName.length());
        }
        return speakerName;
    }

    public static String getSpeakerLine(String speakerName) {
        StringBuilder asb = new StringBuilder();
        asb.append(TRENNER_NEU);
        asb.append(" ");
        asb.append(DatumFormat.getDateTimeString(GREG, true));
        asb.append(" ");
        asb.append(speakerName);
        asb.append(" ");
        while (asb.length() < 75) {
            asb.append("=");
        }
        String a = asb.toString();
        if (a.length() > 75) {
            a = String.valueOf(a.substring(0, 70)) + "...";
        }
        StringBuilder msb = new StringBuilder();
        msb.append(SPLITTERH).append(a).append(NEW_LINE).append(SPLITTERH);
        return msb.toString();
    }

    public static String formatString(String msg, int typ) {
        return Log.formatString(msg, typ, false);
    }

    public static String formatString(String msg, int typ, boolean withoutPrefix) {
        if (msg == null) {
            msg = "";
        }
        msg = msg.replaceAll(NEW_LINE, "\n");
        msg = msg.replaceAll("\r", "\n");
        msg = msg.replaceAll("\t", " ");
        msg = msg.trim();
        Vector v = StringHelper.splitStringByAny(msg, "\n");
        Vector<String> broken = new Vector<String>();
        int i = 0;
        while (i < v.size()) {
            String line = (String)v.elementAt(i);
            while (line.length() > BODY_LINE_WIDTH) {
                broken.add(line.substring(0, BODY_LINE_WIDTH));
                line = line.substring(BODY_LINE_WIDTH, line.length());
            }
            if (line.length() != 0) {
                broken.add(line);
            }
            ++i;
        }
        StringBuilder msb = new StringBuilder();
        int i2 = 0;
        while (i2 < broken.size()) {
            if (i2 == 0) {
                if (withoutPrefix) {
                    msb.append(NORM_LINE_HEADER);
                } else {
                    switch (typ) {
                        case 0: {
                            msb.append("| Subdebug   | ");
                            break;
                        }
                        case 1: {
                            msb.append("| Debug      | ");
                            break;
                        }
                        case 2: {
                            msb.append("| Log        | ");
                            break;
                        }
                        case 5: {
                            msb.append("|** ERROR ** | ");
                            break;
                        }
                        case 4: {
                            msb.append("|* WARNING * | ");
                            break;
                        }
                        case 3: {
                            msb.append("| Info       | ");
                            break;
                        }
                        default: {
                            msb.append("| Unknown    | ");
                        }
                    }
                    msb.append(DatumFormat.getTimeString(GREG, System.currentTimeMillis()));
                    msb.append(" | ");
                }
            } else {
                msb.append(NEW_LINE);
                msb.append(NORM_LINE_HEADER);
            }
            msb.append(broken.elementAt(i2));
            ++i2;
        }
        return msb.toString();
    }
}

