/*
 * Decompiled with CFR 0.152.
 */
package de.hannse.netobjects.util;

import de.hannse.netobjects.util.TabManager;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

public class XMLNode {
    private String ivTag;
    private String ivContent;
    private XMLNode parent;
    private Object userObject;
    private Vector ivKids = new Vector();
    private Hashtable ivAttributes = new Hashtable();

    public XMLNode(String tag) {
        this.ivTag = tag;
    }

    public XMLNode findFirstNodeWithTag(String search) {
        if (this.ivTag.equalsIgnoreCase(search)) {
            return this;
        }
        if (this.ivKids == null) {
            return null;
        }
        int i = 0;
        while (i < this.ivKids.size()) {
            XMLNode tk = (XMLNode)this.ivKids.elementAt(i);
            XMLNode fn = tk.findFirstNodeWithTag(search);
            if (fn != null) {
                return fn;
            }
            ++i;
        }
        return null;
    }

    public String getFirstContentWithTag(String search) {
        if (this.ivTag.equalsIgnoreCase(search)) {
            return this.ivContent;
        }
        if (this.ivKids == null) {
            return null;
        }
        int i = 0;
        while (i < this.ivKids.size()) {
            XMLNode tk = (XMLNode)this.ivKids.elementAt(i);
            XMLNode fn = tk.findFirstNodeWithTag(search);
            if (fn != null) {
                return fn.ivContent;
            }
            ++i;
        }
        return null;
    }

    public Vector getKidVector() {
        return this.ivKids;
    }

    public void findAllNodesWithTag(String search, Vector in) {
        if (in == null) {
            return;
        }
        if (this.ivTag.equalsIgnoreCase(search)) {
            in.addElement(this);
        }
        if (this.ivKids != null) {
            int i = 0;
            while (i < this.ivKids.size()) {
                XMLNode tk = (XMLNode)this.ivKids.elementAt(i);
                tk.findAllNodesWithTag(search, in);
                ++i;
            }
        }
    }

    public String getTag() {
        return this.ivTag;
    }

    public void setContent(String content) {
        this.ivContent = content;
    }

    public String getContent() {
        return this.ivContent;
    }

    public void setParent(XMLNode parent) {
        this.parent = parent;
    }

    public XMLNode getParent() {
        return this.parent;
    }

    public void addKid(XMLNode kid) {
        this.ivKids.addElement(kid);
    }

    public Enumeration kids() {
        return this.ivKids.elements();
    }

    public void addAttribute(String name, String value) {
        this.ivAttributes.put(name, value);
    }

    public String getAttributeValue(String name, String def) {
        if (this.ivAttributes.containsKey(name)) {
            return (String)this.ivAttributes.get(name);
        }
        return def;
    }

    public Enumeration attributes() {
        return this.ivAttributes.keys();
    }

    public void setUserObject(Object obj) {
        this.userObject = obj;
    }

    public Object getUserObject() {
        return this.userObject;
    }

    public String toString() {
        String sOut = this.ivTag;
        Enumeration enum1 = this.attributes();
        while (enum1.hasMoreElements()) {
            String name = (String)enum1.nextElement();
            sOut = String.valueOf(sOut) + " " + name + "=\"" + this.getAttributeValue(name, "") + "\"";
        }
        if (this.ivContent != null) {
            return "<" + sOut + "> " + this.ivContent.trim();
        }
        return "<" + sOut + "> ";
    }

    public String toString(int tabs) {
        boolean contentDa;
        StringBuffer msb = new StringBuffer();
        msb.append(TabManager.getTab(tabs)).append("<").append(this.ivTag);
        boolean attributesDa = this.ivAttributes != null && !this.ivAttributes.isEmpty();
        boolean kidsDa = this.ivKids != null && !this.ivKids.isEmpty();
        boolean bl = contentDa = this.ivContent != null && this.ivContent.trim().length() != 0;
        if (!(attributesDa || contentDa || kidsDa)) {
            msb.append(" />\n");
        } else {
            XMLNode kid;
            Iterator<Object> iter;
            if (attributesDa) {
                iter = this.ivAttributes.keySet().iterator();
                while (iter.hasNext()) {
                    String name = (String)iter.next();
                    msb.append(" ").append(name).append("=\"").append(this.getAttributeValue(name, "")).append("\"");
                }
            }
            if (!contentDa && !kidsDa) {
                msb.append(" />\n");
            } else if (contentDa && !kidsDa) {
                msb.append(">").append(this.ivContent.trim()).append("</").append(this.ivTag).append(">\n");
            } else if (!contentDa && kidsDa) {
                msb.append(">\n");
                iter = this.ivKids.iterator();
                while (iter.hasNext()) {
                    kid = (XMLNode)iter.next();
                    msb.append(kid.toString(tabs + 1));
                }
                msb.append(TabManager.getTab(tabs)).append("</").append(this.ivTag).append(">\n");
            } else if (contentDa && kidsDa) {
                msb.append(">\n");
                msb.append(TabManager.getTab(tabs + 1)).append(this.ivContent.trim()).append("\n");
                iter = this.ivKids.iterator();
                while (iter.hasNext()) {
                    kid = (XMLNode)iter.next();
                    msb.append(kid.toString(tabs + 1));
                }
                msb.append(TabManager.getTab(tabs)).append("</").append(this.ivTag).append(">\n");
            }
        }
        return msb.toString();
    }
}

