/*
 * Decompiled with CFR 0.152.
 */
package de.hannse.webstart;

import de.hannse.webstart.FileResource;
import de.hannse.webstart.TimedInputStreamReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JOptionPane;

public abstract class ClientPart {
    public static boolean checkSetting(String host, int port) {
        System.out.println("+----------------------------------------------------");
        System.out.println("| First test of connection");
        System.out.println("+----------------------------------------------------");
        try {
            Socket client = new Socket();
            client.connect(new InetSocketAddress(host, port), 500);
            client.close();
        }
        catch (IOException e) {
            System.out.println("| " + e);
            return false;
        }
        try {
            String s = ClientPart.holeString("PNG", host, port);
            if (s != null && s.equals("pong")) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static void startClientPart(String host, int port) {
        System.out.println("+----------------------------------------------------");
        System.out.println("| Start ClientPart " + host + " port " + port);
        System.out.println("+----------------------------------------------------");
        try {
            int possRounds = 10;
            String command = null;
            while (possRounds > 0 && command == null) {
                command = ClientPart.createCommand(host, port);
                --possRounds;
            }
            if (command == null) {
                JOptionPane.showMessageDialog(null, "Contact to server not functional!", "ALERT", 0);
                System.exit(0);
            }
            System.out.println("| Command: >>" + command + "<<");
            System.out.println("+----------------------------------------------------");
            try {
                Runtime rt = Runtime.getRuntime();
                System.out.println("+----------------------------------------------------");
                System.out.println("| Runtime: " + rt);
                Process process = rt.exec(command);
                System.out.println("| Process: " + process);
                System.out.println("+----------------------------------------------------");
                TimedInputStreamReader tis1 = new TimedInputStreamReader(process.getInputStream(), "1:", null, true, false);
                TimedInputStreamReader tis2 = new TimedInputStreamReader(process.getErrorStream(), "2:", null, true, false);
                tis1.start();
                tis2.start();
                System.out.println("| InputStream: " + tis1);
                System.out.println("| ErrorStream: " + tis2);
                System.out.println("+----------------------------------------------------");
                process.waitFor();
                System.exit(0);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Problem beim Starten " + command + " -> " + e);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Problem bei Webstart ClientPart" + e);
        }
    }

    private static String createCommand(String host, int port) throws Exception {
        Vector<FileResource> jars = new Vector<FileResource>();
        String jl = ClientPart.holeString("GJL", host, port);
        if (jl != null) {
            StringTokenizer st = new StringTokenizer(jl, "\n");
            while (st.hasMoreTokens()) {
                jars.addElement(new FileResource(st.nextToken()));
            }
        }
        String memory = ClientPart.holeString("GMM", host, port);
        String startClass = ClientPart.holeString("GSC", host, port);
        System.out.println("+----------------------------------------------------");
        System.out.println("| JL:         " + jl);
        System.out.println("| JARS:       " + jars);
        System.out.println("| MEMORY:     " + memory);
        System.out.println("| STARTCLASS: " + startClass);
        System.out.println("+----------------------------------------------------");
        if (jl == null || memory == null || startClass == null) {
            System.out.println("| -------> Unable to retrieve information");
            System.out.println("+----------------------------------------------------");
            return null;
        }
        String classpath = "";
        if (!jars.isEmpty()) {
            Iterator iter = jars.iterator();
            while (iter.hasNext()) {
                FileResource jd = (FileResource)iter.next();
                if (jd.ivPresent) continue;
                byte[] data = ClientPart.holeBytes("GJF" + jd.ivID + "#", host, port);
                if (data != null) {
                    FileOutputStream fos = new FileOutputStream(jd.ivFilename);
                    fos.write(data);
                    fos.flush();
                    fos.close();
                    jd.ivPresent = true;
                    continue;
                }
                throw new Exception("Filedata " + jd.ivFilename + " not retrievable!");
            }
            String trenner = ";";
            String cpParameter = "cp";
            String osName = System.getProperty("os.name");
            if (osName.startsWith("Mac OS")) {
                cpParameter = "classpath";
                trenner = ":";
            } else if (!osName.startsWith("Windows")) {
                cpParameter = "classpath";
                trenner = ":";
            }
            StringBuffer msb = new StringBuffer();
            Iterator iter2 = jars.iterator();
            while (iter2.hasNext()) {
                FileResource jd = (FileResource)iter2.next();
                if (jd.ivType != 1) continue;
                if (msb.length() != 0) {
                    msb.append(trenner);
                }
                msb.append(jd.ivFilename);
            }
            classpath = "-" + cpParameter + " " + msb.toString() + " ";
        }
        return "java " + memory + " " + classpath + " " + startClass;
    }

    private static String holeString(String command, String host, int port) throws Exception {
        byte[] arr = ClientPart.holeBytes(command, host, port);
        if (arr == null) {
            return null;
        }
        return new String(arr);
    }

    private static byte[] holeBytes(String command, String host, int port) throws Exception {
        byte[] res = null;
        Socket sock = new Socket(host, port);
        try {
            DataInputStream dis = new DataInputStream(sock.getInputStream());
            DataOutputStream dos = new DataOutputStream(sock.getOutputStream());
            dos.writeBytes(command);
            dos.flush();
            res = ClientPart.getBytes(dis);
        }
        catch (Exception e) {
            System.out.println("Problem while getting bytes -> " + e);
        }
        sock.close();
        return res;
    }

    private static byte[] getBytes(DataInputStream dis) throws Exception {
        System.out.print("| ");
        boolean cont = true;
        char c1 = ' ';
        char c2 = ' ';
        char c3 = ' ';
        while (cont) {
            try {
                c1 = c2;
                c2 = c3;
                byte b = dis.readByte();
                c3 = (char)b;
                System.out.print(c3);
                if (c1 != 35 || c2 != 64 || c3 != 35) continue;
                cont = false;
            }
            catch (Exception e) {
                System.out.println("Error in getBytes " + e);
                return null;
            }
        }
        StringBuffer msb = new StringBuffer();
        cont = true;
        while (cont) {
            byte b = dis.readByte();
            char c = (char)b;
            System.out.print(c);
            if (c == '#') {
                cont = false;
                continue;
            }
            msb.append(c);
        }
        System.out.println();
        int len = Integer.parseInt(msb.toString());
        if (len == 0) {
            System.out.println("Wrong length information " + len);
            return null;
        }
        byte[] buf = new byte[len];
        dis.readFully(buf);
        return buf;
    }
}

