/*
 * Decompiled with CFR 0.152.
 */
package de.hannse.webstart;

import de.hannse.netobjects.util.Log;
import de.hannse.webstart.FileResource;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.Vector;
import mausoleum.helper.DatumFormat;

public class ServerPart
implements Runnable {
    public static final String COM_PING = "PNG";
    public static final String COM_GET_JARLIST = "GJL";
    public static final String COM_GET_JARFILE = "GJF";
    public static final String COM_GET_STARTCLASS = "GSC";
    public static final String COM_GET_MEMORY = "GMM";
    public static final String RES_PONG = "pong";
    private static final int MEM_START = 20;
    private static final int MEM_MAX = 300;
    private static final long DISPOSAL = 20000L;
    private static final Vector OLD_SOCKS = new Vector();
    private static final Vector OLD_SOCKS_SAMMLER1 = new Vector();
    private static final Vector OLD_SOCKS_SAMMLER2 = new Vector();
    private static String cvStartClass = null;
    private static Vector cvJars = new Vector(10);
    private static int cvStartMegaBytes = 0;
    private static int cvMaxMegaBytes = 0;
    private static String cvMemoryString = "-Xms20m -Xmx300m";
    private static boolean cvInitialized = false;
    private ServerSocket ivServerSocket = null;
    static /* synthetic */ Class class$0;

    public static void init(int port, String[] jarFilenames, String[] resourceFilenames, String startClass, int startMegas, int maxMegas) {
        if (!cvInitialized) {
            int i;
            cvInitialized = true;
            cvStartMegaBytes = startMegas;
            cvMaxMegaBytes = maxMegas;
            if (startMegas > 0 && maxMegas > 0) {
                cvMemoryString = "-Xms" + cvStartMegaBytes + "m -Xmx" + cvMaxMegaBytes + "m";
            }
            if (startClass == null) {
                throw new IllegalArgumentException("WebStartServerPart startClass not defined");
            }
            cvStartClass = startClass.trim();
            if (cvStartClass.length() == 0) {
                throw new IllegalArgumentException("WebStartServerPart startClass not defined");
            }
            if (jarFilenames != null) {
                i = 0;
                while (i < jarFilenames.length) {
                    try {
                        cvJars.addElement(new FileResource(i + 1, jarFilenames[i], 1));
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("Illegal JAR-Definition " + jarFilenames[i]);
                    }
                    ++i;
                }
            }
            if (resourceFilenames != null) {
                i = 0;
                while (i < resourceFilenames.length) {
                    try {
                        cvJars.addElement(new FileResource(i + 1, resourceFilenames[i], 2));
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("Illegal Resource-Definition " + resourceFilenames[i]);
                    }
                    ++i;
                }
            }
            new ServerPart(port);
        }
    }

    private ServerPart(int port) {
        try {
            String string = ">>> Start ServerSocket for WebStart on Port " + port;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("de.hannse.webstart.ServerPart");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Log.info(string, clazz);
            this.ivServerSocket = new ServerSocket(port);
            if (this.ivServerSocket == null) {
                throw new IllegalArgumentException("Couldn't listen to WebStartServerPart port " + port);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Couldn't listen to WebStartServerPart port " + port);
        }
        new Thread(this).start();
        new Thread(new Runnable(){

            public void run() {
                while (true) {
                    try {
                        while (true) {
                            ConnectInfo ci;
                            OLD_SOCKS_SAMMLER1.clear();
                            OLD_SOCKS_SAMMLER2.clear();
                            ServerPart.addAllCi(OLD_SOCKS_SAMMLER1);
                            long now = System.currentTimeMillis();
                            Iterator iterator = OLD_SOCKS_SAMMLER1.iterator();
                            while (iterator.hasNext()) {
                                ci = (ConnectInfo)iterator.next();
                                if (ci.ivFinishMillis != -1L) {
                                    if (now - ci.ivFinishMillis <= 20000L) continue;
                                    OLD_SOCKS_SAMMLER2.add(ci);
                                    continue;
                                }
                                if (now - ci.ivStartMillis <= 400000L) continue;
                                OLD_SOCKS_SAMMLER2.add(ci);
                            }
                            if (!OLD_SOCKS_SAMMLER2.isEmpty()) {
                                iterator = OLD_SOCKS_SAMMLER2.iterator();
                                while (iterator.hasNext()) {
                                    ci = (ConnectInfo)iterator.next();
                                    ServerPart.removeCI(ci);
                                    if (ci.stillConnected()) {
                                        String string = "SP: Remove Connection " + ci;
                                        Class<?> clazz = class$0;
                                        if (clazz == null) {
                                            try {
                                                clazz = Class.forName("de.hannse.webstart.ServerPart");
                                            }
                                            catch (ClassNotFoundException classNotFoundException) {
                                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                            }
                                        }
                                        Log.debug(string, clazz);
                                        ci.disconnect();
                                    }
                                    ci.dispose();
                                }
                            }
                            OLD_SOCKS_SAMMLER1.clear();
                            OLD_SOCKS_SAMMLER2.clear();
                            Thread.sleep(40000L);
                        }
                    }
                    catch (Exception e) {
                        Class<?> clazz = class$0;
                        if (clazz == null) {
                            try {
                                clazz = Class.forName("de.hannse.webstart.ServerPart");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        Log.error("SP: Error while cleaning", e, clazz);
                        continue;
                    }
                    break;
                }
            }
        }).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addAllCi(Vector target) {
        Vector vector = OLD_SOCKS;
        synchronized (vector) {
            target.addAll(OLD_SOCKS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addCI(ConnectInfo ci) {
        Vector vector = OLD_SOCKS;
        synchronized (vector) {
            OLD_SOCKS.add(ci);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeCI(ConnectInfo ci) {
        Vector vector = OLD_SOCKS;
        synchronized (vector) {
            OLD_SOCKS.remove(ci);
        }
    }

    public void run() {
        while (true) {
            try {
                while (true) {
                    Socket socket = this.ivServerSocket.accept();
                    new Thread(new ConnectInfo(socket)).start();
                }
            }
            catch (IOException e) {
                Log.error("SP: General IO Error", e, this);
                continue;
            }
            catch (Exception e) {
                Log.error("SP: General Error", e, this);
                continue;
            }
            break;
        }
    }

    private static void handleRequest(DataOutputStream os, DataInputStream is) throws IOException {
        StringBuffer msb = new StringBuffer();
        msb.append((char)is.readByte());
        msb.append((char)is.readByte());
        msb.append((char)is.readByte());
        String command = msb.toString();
        if (command.equals(COM_GET_JARLIST)) {
            msb = new StringBuffer();
            Iterator iter = cvJars.iterator();
            while (iter.hasNext()) {
                FileResource jd = (FileResource)iter.next();
                String ran = jd.getInfoLine();
                if (ran == null) continue;
                msb.append(ran).append("\n");
            }
            ServerPart.send(msb.toString().trim(), os);
        } else if (command.equals(COM_GET_JARFILE)) {
            msb = new StringBuffer();
            boolean cont = true;
            while (cont) {
                byte b = is.readByte();
                char c = (char)b;
                if (c == '#') {
                    cont = false;
                    continue;
                }
                msb.append(c);
            }
            int id = Integer.parseInt(msb.toString());
            Iterator iter = cvJars.iterator();
            while (iter.hasNext()) {
                FileResource jd = (FileResource)iter.next();
                if (jd.ivID != id) continue;
                ServerPart.send(jd.getFileData(), os);
            }
        } else if (command.equals(COM_GET_STARTCLASS)) {
            ServerPart.send(cvStartClass, os);
        } else if (command.equals(COM_GET_MEMORY)) {
            ServerPart.send(cvMemoryString, os);
        } else if (command.equals(COM_PING)) {
            ServerPart.send(RES_PONG, os);
        }
    }

    private static void send(String s, DataOutputStream os) throws IOException {
        os.writeBytes("#@#" + Integer.toString(s.length()) + "#" + s);
    }

    private static void send(byte[] arr, DataOutputStream os) throws IOException {
        os.writeBytes("#@#" + arr.length + "#");
        os.write(arr);
    }

    public static class ConnectInfo
    implements Runnable {
        public Socket ivSocket;
        public String ivAddress;
        public long ivStartMillis;
        public long ivFinishMillis = -1L;

        public ConnectInfo(Socket socket) {
            this.ivSocket = socket;
            this.ivStartMillis = System.currentTimeMillis();
            this.ivAddress = socket.getInetAddress() != null ? socket.getInetAddress().toString() : "unknown";
        }

        public void dispose() {
            this.ivSocket = null;
            this.ivAddress = null;
        }

        public void finish() {
            this.ivFinishMillis = System.currentTimeMillis();
        }

        public boolean stillConnected() {
            return this.ivSocket != null && !this.ivSocket.isClosed();
        }

        public void disconnect() {
            try {
                if (this.ivSocket != null && !this.ivSocket.isClosed()) {
                    this.ivSocket.close();
                    this.ivSocket = null;
                }
            }
            catch (Exception e) {
                Log.error("SP: Problem closing socket " + this, e, this);
            }
        }

        public String toString() {
            StringBuilder msb = new StringBuilder();
            msb.append("Webstart Connection [").append(this.ivAddress).append("] Status: ");
            if (this.ivSocket != null) {
                msb.append(this.ivSocket.isConnected() ? "connected" : "not connected");
            } else {
                msb.append("no socket");
            }
            msb.append(" Start:").append(DatumFormat.getTimeString(new GregorianCalendar(), System.currentTimeMillis()));
            if (this.ivFinishMillis != -1L) {
                msb.append(" End:").append(DatumFormat.getTimeString(new GregorianCalendar(), System.currentTimeMillis()));
            }
            return msb.toString();
        }

        public void run() {
            Log.debug("SP: New connection " + this, this);
            DataOutputStream out_stream = null;
            try {
                out_stream = new DataOutputStream(this.ivSocket.getOutputStream());
                try {
                    Thread.sleep(100L);
                    ServerPart.addCI(this);
                    ServerPart.handleRequest(out_stream, new DataInputStream(this.ivSocket.getInputStream()));
                    out_stream.flush();
                    out_stream.close();
                    this.finish();
                }
                catch (EOFException e) {
                    Log.log("SP: EOF :" + this, this);
                }
                catch (Exception e) {
                    Log.error("SP: Error in handleRequest :" + this, e, this);
                }
            }
            catch (IOException e) {
                Log.error("SP: IOException in main loop:" + this, e, this);
                this.disconnect();
            }
            catch (Exception e) {
                Log.error("SP: Error in main loop:" + this, e, this);
                this.disconnect();
            }
            Log.debug("SP: Done with connection " + this, this);
        }
    }
}

