/*
 * Decompiled with CFR 0.152.
 */
package jxl.biff;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jxl.Cell;
import jxl.CellType;
import jxl.LabelCell;
import jxl.Sheet;

public class CellFinder {
    private Sheet sheet;

    public CellFinder(Sheet s) {
        this.sheet = s;
    }

    public Cell findCell(String contents, int firstCol, int firstRow, int lastCol, int lastRow, boolean reverse) {
        Cell cell = null;
        boolean found = false;
        int numCols = lastCol - firstCol;
        int numRows = lastRow - firstRow;
        int row1 = reverse ? lastRow : firstRow;
        int col1 = reverse ? lastCol : firstCol;
        int inc = reverse ? -1 : 1;
        int i = 0;
        while (i <= numCols && !found) {
            int j = 0;
            while (j <= numRows && !found) {
                Cell c;
                int curCol = col1 + i * inc;
                int curRow = row1 + j * inc;
                if (curCol < this.sheet.getColumns() && curRow < this.sheet.getRows() && (c = this.sheet.getCell(curCol, curRow)).getType() != CellType.EMPTY && c.getContents().equals(contents)) {
                    cell = c;
                    found = true;
                }
                ++j;
            }
            ++i;
        }
        return cell;
    }

    public Cell findCell(String contents) {
        Cell cell = null;
        boolean found = false;
        int i = 0;
        while (i < this.sheet.getRows() && !found) {
            Cell[] row = this.sheet.getRow(i);
            int j = 0;
            while (j < row.length && !found) {
                if (row[j].getContents().equals(contents)) {
                    cell = row[j];
                    found = true;
                }
                ++j;
            }
            ++i;
        }
        return cell;
    }

    public Cell findCell(Pattern pattern, int firstCol, int firstRow, int lastCol, int lastRow, boolean reverse) {
        Cell cell = null;
        boolean found = false;
        int numCols = lastCol - firstCol;
        int numRows = lastRow - firstRow;
        int row1 = reverse ? lastRow : firstRow;
        int col1 = reverse ? lastCol : firstCol;
        int inc = reverse ? -1 : 1;
        int i = 0;
        while (i <= numCols && !found) {
            int j = 0;
            while (j <= numRows && !found) {
                Matcher m;
                Cell c;
                int curCol = col1 + i * inc;
                int curRow = row1 + j * inc;
                if (curCol < this.sheet.getColumns() && curRow < this.sheet.getRows() && (c = this.sheet.getCell(curCol, curRow)).getType() != CellType.EMPTY && (m = pattern.matcher(c.getContents())).matches()) {
                    cell = c;
                    found = true;
                }
                ++j;
            }
            ++i;
        }
        return cell;
    }

    public LabelCell findLabelCell(String contents) {
        LabelCell cell = null;
        boolean found = false;
        int i = 0;
        while (i < this.sheet.getRows() && !found) {
            Cell[] row = this.sheet.getRow(i);
            int j = 0;
            while (j < row.length && !found) {
                if ((row[j].getType() == CellType.LABEL || row[j].getType() == CellType.STRING_FORMULA) && row[j].getContents().equals(contents)) {
                    cell = (LabelCell)row[j];
                    found = true;
                }
                ++j;
            }
            ++i;
        }
        return cell;
    }
}

