/*
 * Decompiled with CFR 0.152.
 */
package jxl.biff;

import de.hannse.netobjects.util.Log;
import java.io.UnsupportedEncodingException;
import jxl.WorkbookSettings;

public final class JXLStringHelper {
    public static String UNICODE_ENCODING = "UnicodeLittle";
    static /* synthetic */ Class class$0;

    private JXLStringHelper() {
    }

    public static byte[] getBytes(String s) {
        return s.getBytes();
    }

    public static byte[] getBytes(String s, WorkbookSettings ws) {
        try {
            return s.getBytes(ws.getEncoding());
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public static byte[] getUnicodeBytes(String s) {
        try {
            byte[] b = s.getBytes(UNICODE_ENCODING);
            if (b.length == s.length() * 2 + 2) {
                byte[] b2 = new byte[b.length - 2];
                System.arraycopy(b, 2, b2, 0, b2.length);
                b = b2;
            }
            return b;
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public static void getBytes(String s, byte[] d, int pos) {
        byte[] b = JXLStringHelper.getBytes(s);
        System.arraycopy(b, 0, d, pos, b.length);
    }

    public static void getUnicodeBytes(String s, byte[] d, int pos) {
        byte[] b = JXLStringHelper.getUnicodeBytes(s);
        System.arraycopy(b, 0, d, pos, b.length);
    }

    public static String getString(byte[] d, int length, int pos, WorkbookSettings ws) {
        if (length == 0) {
            return "";
        }
        try {
            return new String(d, pos, length, ws.getEncoding());
        }
        catch (UnsupportedEncodingException e) {
            String string = e.toString();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("jxl.biff.JXLStringHelper");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Log.warn(string, clazz);
            return "";
        }
    }

    public static String getUnicodeString(byte[] d, int length, int pos) {
        try {
            byte[] b = new byte[length * 2];
            System.arraycopy(d, pos, b, 0, length * 2);
            return new String(b, UNICODE_ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }

    public static final String replace(String input, String search, String replace) {
        String fmtstr = input;
        int pos = fmtstr.indexOf(search);
        while (pos != -1) {
            StringBuffer tmp = new StringBuffer(fmtstr.substring(0, pos));
            tmp.append(replace);
            tmp.append(fmtstr.substring(pos + search.length()));
            fmtstr = tmp.toString();
            pos = fmtstr.indexOf(search, pos + replace.length());
        }
        return fmtstr;
    }
}

