/*
 * Decompiled with CFR 0.152.
 */
package jxl.read.biff;

import jxl.WorkbookSettings;
import jxl.biff.JXLStringHelper;
import jxl.biff.RecordData;
import jxl.read.biff.Record;

class BoundsheetRecord
extends RecordData {
    private byte typeFlag;
    private byte visibilityFlag;
    private int length;
    private String name;

    public BoundsheetRecord(Record t, WorkbookSettings s) {
        super(t);
        byte[] data = this.getRecord().getData();
        this.typeFlag = data[5];
        this.visibilityFlag = data[4];
        this.length = data[6];
        if (data[7] == 0) {
            byte[] bytes = new byte[this.length];
            System.arraycopy(data, 8, bytes, 0, this.length);
            this.name = JXLStringHelper.getString(bytes, this.length, 0, s);
        } else {
            byte[] bytes = new byte[this.length * 2];
            System.arraycopy(data, 8, bytes, 0, this.length * 2);
            this.name = JXLStringHelper.getUnicodeString(bytes, this.length, 0);
        }
    }

    public BoundsheetRecord(Record t) {
        super(t);
        byte[] data = this.getRecord().getData();
        this.typeFlag = data[5];
        this.visibilityFlag = data[4];
        this.length = data[6];
        byte[] bytes = new byte[this.length];
        System.arraycopy(data, 7, bytes, 0, this.length);
        this.name = new String(bytes);
    }

    public String getName() {
        return this.name;
    }

    public boolean isHidden() {
        return this.visibilityFlag != 0;
    }

    public boolean isSheet() {
        return this.typeFlag == 0;
    }

    public boolean isChart() {
        return this.typeFlag == 2;
    }
}

