/*
 * Decompiled with CFR 0.152.
 */
package jxl.write.biff;

import de.hannse.netobjects.util.Log;
import java.io.IOException;
import java.io.OutputStream;
import jxl.WorkbookSettings;
import jxl.biff.ByteData;
import jxl.write.biff.CompoundFile;
import jxl.write.biff.ExcelDataOutput;
import jxl.write.biff.FileDataOutput;
import jxl.write.biff.JxlWriteException;
import jxl.write.biff.MemoryDataOutput;

public final class File {
    private ExcelDataOutput data;
    private OutputStream outputStream;
    private int initialFileSize;
    private int arrayGrowSize;
    private WorkbookSettings workbookSettings;
    jxl.read.biff.CompoundFile readCompoundFile;

    File(OutputStream os, WorkbookSettings ws, jxl.read.biff.CompoundFile rcf) throws IOException {
        this.outputStream = os;
        this.workbookSettings = ws;
        this.readCompoundFile = rcf;
        this.createDataOutput();
    }

    private void createDataOutput() throws IOException {
        if (this.workbookSettings.getUseTemporaryFileDuringWrite()) {
            this.data = new FileDataOutput(this.workbookSettings.getTemporaryFileDuringWriteDirectory());
        } else {
            this.initialFileSize = this.workbookSettings.getInitialFileSize();
            this.arrayGrowSize = this.workbookSettings.getArrayGrowSize();
            this.data = new MemoryDataOutput(this.initialFileSize, this.arrayGrowSize);
        }
    }

    void close(boolean cs) throws IOException, JxlWriteException {
        CompoundFile cf = new CompoundFile(this.data, this.data.getPosition(), this.outputStream, this.readCompoundFile);
        cf.write();
        this.outputStream.flush();
        this.data.close();
        if (cs) {
            this.outputStream.close();
        }
        this.data = null;
        if (!this.workbookSettings.getGCDisabled()) {
            System.gc();
        }
    }

    public void write(ByteData record) throws IOException {
        byte[] bytes = record.getBytes();
        this.data.write(bytes);
    }

    int getPos() throws IOException {
        return this.data.getPosition();
    }

    void setData(byte[] newdata, int pos) throws IOException {
        this.data.setData(newdata, pos);
    }

    public void setOutputFile(OutputStream os) throws IOException {
        if (this.data != null) {
            Log.warn("Rewriting a workbook with non-empty data", this);
        }
        this.outputStream = os;
        this.createDataOutput();
    }
}

