/*
 * Decompiled with CFR 0.152.
 */
package jxl.write.biff;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import jxl.write.biff.ExcelDataOutput;

class FileDataOutput
implements ExcelDataOutput {
    private File temporaryFile;
    private RandomAccessFile data;

    public FileDataOutput(File tmpdir) throws IOException {
        this.temporaryFile = File.createTempFile("jxl", ".tmp", tmpdir);
        this.temporaryFile.deleteOnExit();
        this.data = new RandomAccessFile(this.temporaryFile, "rw");
    }

    public void write(byte[] bytes) throws IOException {
        this.data.write(bytes);
    }

    public int getPosition() throws IOException {
        return (int)this.data.getFilePointer();
    }

    public void setData(byte[] newdata, int pos) throws IOException {
        long curpos = this.data.getFilePointer();
        this.data.seek(pos);
        this.data.write(newdata);
        this.data.seek(curpos);
    }

    public void writeData(OutputStream out) throws IOException {
        byte[] buffer = new byte[1024];
        int length = 0;
        this.data.seek(0L);
        while ((length = this.data.read(buffer)) != -1) {
            out.write(buffer, 0, length);
        }
    }

    public void close() throws IOException {
        this.data.close();
        this.temporaryFile.delete();
    }
}

