/*
 * Decompiled with CFR 0.152.
 */
package jxl.write.biff;

import de.hannse.netobjects.util.Log;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.regex.Pattern;
import jxl.Cell;
import jxl.CellFeatures;
import jxl.CellReferenceHelper;
import jxl.CellType;
import jxl.CellView;
import jxl.HeaderFooter;
import jxl.Hyperlink;
import jxl.Image;
import jxl.LabelCell;
import jxl.Range;
import jxl.Sheet;
import jxl.SheetSettings;
import jxl.WorkbookSettings;
import jxl.biff.AutoFilter;
import jxl.biff.CellFinder;
import jxl.biff.ConditionalFormat;
import jxl.biff.DVParser;
import jxl.biff.DataValidation;
import jxl.biff.EmptyCell;
import jxl.biff.FormattingRecords;
import jxl.biff.IndexMapping;
import jxl.biff.NumFormatRecordsException;
import jxl.biff.SheetRangeImpl;
import jxl.biff.WorkspaceInformationRecord;
import jxl.biff.XFRecord;
import jxl.biff.drawing.Chart;
import jxl.biff.drawing.ComboBox;
import jxl.biff.drawing.Drawing;
import jxl.biff.drawing.DrawingGroupObject;
import jxl.common.Assert;
import jxl.format.CellFormat;
import jxl.format.Font;
import jxl.format.PageOrientation;
import jxl.format.PaperSize;
import jxl.write.Blank;
import jxl.write.Label;
import jxl.write.WritableCell;
import jxl.write.WritableCellFeatures;
import jxl.write.WritableCellFormat;
import jxl.write.WritableHyperlink;
import jxl.write.WritableImage;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;
import jxl.write.biff.ButtonPropertySetRecord;
import jxl.write.biff.CellValue;
import jxl.write.biff.ColumnInfoRecord;
import jxl.write.biff.File;
import jxl.write.biff.FooterRecord;
import jxl.write.biff.HeaderRecord;
import jxl.write.biff.HyperlinkRecord;
import jxl.write.biff.JxlWriteException;
import jxl.write.biff.MergedCells;
import jxl.write.biff.PLSRecord;
import jxl.write.biff.RowRecord;
import jxl.write.biff.RowsExceededException;
import jxl.write.biff.SharedStrings;
import jxl.write.biff.SheetCopier;
import jxl.write.biff.SheetWriter;
import jxl.write.biff.Styles;
import jxl.write.biff.WritableSheetCopier;
import jxl.write.biff.WritableWorkbookImpl;

class WritableSheetImpl
implements WritableSheet {
    private String name;
    private File outputFile;
    private RowRecord[] rows;
    private FormattingRecords formatRecords;
    private SharedStrings sharedStrings;
    private TreeSet columnFormats;
    private TreeSet autosizedColumns;
    private ArrayList hyperlinks;
    private MergedCells mergedCells;
    private int numRows;
    private int numColumns;
    private PLSRecord plsRecord;
    private ButtonPropertySetRecord buttonPropertySet;
    private boolean chartOnly;
    private DataValidation dataValidation;
    private ArrayList rowBreaks;
    private ArrayList columnBreaks;
    private ArrayList drawings;
    private ArrayList images;
    private ArrayList conditionalFormats;
    private AutoFilter autoFilter;
    private ArrayList validatedCells;
    private ComboBox comboBox;
    private boolean drawingsModified;
    private int maxRowOutlineLevel;
    private int maxColumnOutlineLevel;
    private SheetSettings settings;
    private SheetWriter sheetWriter;
    private WorkbookSettings workbookSettings;
    private WritableWorkbookImpl workbook;
    private static final int rowGrowSize = 10;
    private static final int numRowsPerSheet = 65536;
    private static final int maxSheetNameLength = 31;
    private static final char[] illegalSheetNameCharacters = new char[]{'*', ':', '?', '\\'};
    private static final String[] imageTypes = new String[]{"png"};

    public WritableSheetImpl(String n, File of, FormattingRecords fr, SharedStrings ss, WorkbookSettings ws, WritableWorkbookImpl ww) {
        this.name = this.validateName(n);
        this.outputFile = of;
        this.rows = new RowRecord[0];
        this.numRows = 0;
        this.numColumns = 0;
        this.chartOnly = false;
        this.workbook = ww;
        this.formatRecords = fr;
        this.sharedStrings = ss;
        this.workbookSettings = ws;
        this.drawingsModified = false;
        this.columnFormats = new TreeSet(new ColumnInfoComparator());
        this.autosizedColumns = new TreeSet();
        this.hyperlinks = new ArrayList();
        this.mergedCells = new MergedCells(this);
        this.rowBreaks = new ArrayList();
        this.columnBreaks = new ArrayList();
        this.drawings = new ArrayList();
        this.images = new ArrayList();
        this.conditionalFormats = new ArrayList();
        this.validatedCells = new ArrayList();
        this.settings = new SheetSettings(this);
        this.sheetWriter = new SheetWriter(this.outputFile, this, this.workbookSettings);
    }

    public Cell getCell(String loc) {
        return this.getCell(CellReferenceHelper.getColumn(loc), CellReferenceHelper.getRow(loc));
    }

    public Cell getCell(int column, int row) {
        return this.getWritableCell(column, row);
    }

    public WritableCell getWritableCell(String loc) {
        return this.getWritableCell(CellReferenceHelper.getColumn(loc), CellReferenceHelper.getRow(loc));
    }

    public WritableCell getWritableCell(int column, int row) {
        WritableCell c = null;
        if (row < this.rows.length && this.rows[row] != null) {
            c = this.rows[row].getCell(column);
        }
        if (c == null) {
            c = new EmptyCell(column, row);
        }
        return c;
    }

    public int getRows() {
        return this.numRows;
    }

    public int getColumns() {
        return this.numColumns;
    }

    public Cell findCell(String contents) {
        CellFinder cellFinder = new CellFinder(this);
        return cellFinder.findCell(contents);
    }

    public Cell findCell(String contents, int firstCol, int firstRow, int lastCol, int lastRow, boolean reverse) {
        CellFinder cellFinder = new CellFinder(this);
        return cellFinder.findCell(contents, firstCol, firstRow, lastCol, lastRow, reverse);
    }

    public Cell findCell(Pattern pattern, int firstCol, int firstRow, int lastCol, int lastRow, boolean reverse) {
        CellFinder cellFinder = new CellFinder(this);
        return cellFinder.findCell(pattern, firstCol, firstRow, lastCol, lastRow, reverse);
    }

    public LabelCell findLabelCell(String contents) {
        CellFinder cellFinder = new CellFinder(this);
        return cellFinder.findLabelCell(contents);
    }

    public Cell[] getRow(int row) {
        boolean found = false;
        int col = this.numColumns - 1;
        while (col >= 0 && !found) {
            if (this.getCell(col, row).getType() != CellType.EMPTY) {
                found = true;
                continue;
            }
            --col;
        }
        Cell[] cells = new Cell[col + 1];
        int i = 0;
        while (i <= col) {
            cells[i] = this.getCell(i, row);
            ++i;
        }
        return cells;
    }

    public Cell[] getColumn(int col) {
        boolean found = false;
        int row = this.numRows - 1;
        while (row >= 0 && !found) {
            if (this.getCell(col, row).getType() != CellType.EMPTY) {
                found = true;
                continue;
            }
            --row;
        }
        Cell[] cells = new Cell[row + 1];
        int i = 0;
        while (i <= row) {
            cells[i] = this.getCell(col, i);
            ++i;
        }
        return cells;
    }

    public String getName() {
        return this.name;
    }

    public void insertRow(int row) {
        if (row < 0 || row >= this.numRows) {
            return;
        }
        RowRecord[] oldRows = this.rows;
        this.rows = this.numRows == this.rows.length ? new RowRecord[oldRows.length + 10] : new RowRecord[oldRows.length];
        System.arraycopy(oldRows, 0, this.rows, 0, row);
        System.arraycopy(oldRows, row, this.rows, row + 1, this.numRows - row);
        int i = row + 1;
        while (i <= this.numRows) {
            if (this.rows[i] != null) {
                this.rows[i].incrementRow();
            }
            ++i;
        }
        HyperlinkRecord hr = null;
        Iterator i2 = this.hyperlinks.iterator();
        while (i2.hasNext()) {
            hr = (HyperlinkRecord)i2.next();
            hr.insertRow(row);
        }
        if (this.dataValidation != null) {
            this.dataValidation.insertRow(row);
        }
        if (this.validatedCells != null && this.validatedCells.size() > 0) {
            Iterator vci = this.validatedCells.iterator();
            while (vci.hasNext()) {
                CellValue cv = (CellValue)vci.next();
                CellFeatures cf = cv.getCellFeatures();
                if (cf.getDVParser() == null) continue;
                cf.getDVParser().insertRow(row);
            }
        }
        this.mergedCells.insertRow(row);
        ArrayList<Integer> newRowBreaks = new ArrayList<Integer>();
        Iterator ri = this.rowBreaks.iterator();
        while (ri.hasNext()) {
            int val = (Integer)ri.next();
            if (val >= row) {
                ++val;
            }
            newRowBreaks.add(new Integer(val));
        }
        this.rowBreaks = newRowBreaks;
        Iterator cfit = this.conditionalFormats.iterator();
        while (cfit.hasNext()) {
            ConditionalFormat cf = (ConditionalFormat)cfit.next();
            cf.insertRow(row);
        }
        if (this.workbookSettings.getFormulaAdjust()) {
            this.workbook.rowInserted(this, row);
        }
        ++this.numRows;
    }

    public void insertColumn(int col) {
        if (col < 0 || col >= this.numColumns) {
            return;
        }
        int i = 0;
        while (i < this.numRows) {
            if (this.rows[i] != null) {
                this.rows[i].insertColumn(col);
            }
            ++i;
        }
        HyperlinkRecord hr = null;
        Iterator i2 = this.hyperlinks.iterator();
        while (i2.hasNext()) {
            hr = (HyperlinkRecord)i2.next();
            hr.insertColumn(col);
        }
        i2 = this.columnFormats.iterator();
        while (i2.hasNext()) {
            ColumnInfoRecord cir = (ColumnInfoRecord)i2.next();
            if (cir.getColumn() < col) continue;
            cir.incrementColumn();
        }
        if (this.autosizedColumns.size() > 0) {
            TreeSet<Integer> newAutosized = new TreeSet<Integer>();
            i2 = this.autosizedColumns.iterator();
            while (i2.hasNext()) {
                Integer colnumber = (Integer)i2.next();
                if (colnumber >= col) {
                    newAutosized.add(new Integer(colnumber + 1));
                    continue;
                }
                newAutosized.add(colnumber);
            }
            this.autosizedColumns = newAutosized;
        }
        if (this.dataValidation != null) {
            this.dataValidation.insertColumn(col);
        }
        if (this.validatedCells != null && this.validatedCells.size() > 0) {
            Iterator vci = this.validatedCells.iterator();
            while (vci.hasNext()) {
                CellValue cv = (CellValue)vci.next();
                CellFeatures cf = cv.getCellFeatures();
                if (cf.getDVParser() == null) continue;
                cf.getDVParser().insertColumn(col);
            }
        }
        this.mergedCells.insertColumn(col);
        ArrayList<Integer> newColumnBreaks = new ArrayList<Integer>();
        Iterator ri = this.columnBreaks.iterator();
        while (ri.hasNext()) {
            int val = (Integer)ri.next();
            if (val >= col) {
                ++val;
            }
            newColumnBreaks.add(new Integer(val));
        }
        this.columnBreaks = newColumnBreaks;
        Iterator cfit = this.conditionalFormats.iterator();
        while (cfit.hasNext()) {
            ConditionalFormat cf = (ConditionalFormat)cfit.next();
            cf.insertColumn(col);
        }
        if (this.workbookSettings.getFormulaAdjust()) {
            this.workbook.columnInserted(this, col);
        }
        ++this.numColumns;
    }

    public void removeColumn(int col) {
        if (col < 0 || col >= this.numColumns) {
            return;
        }
        int i = 0;
        while (i < this.numRows) {
            if (this.rows[i] != null) {
                this.rows[i].removeColumn(col);
            }
            ++i;
        }
        HyperlinkRecord hr = null;
        Iterator i2 = this.hyperlinks.iterator();
        while (i2.hasNext()) {
            hr = (HyperlinkRecord)i2.next();
            if (hr.getColumn() == col && hr.getLastColumn() == col) {
                i2.remove();
                continue;
            }
            hr.removeColumn(col);
        }
        if (this.dataValidation != null) {
            this.dataValidation.removeColumn(col);
        }
        if (this.validatedCells != null && this.validatedCells.size() > 0) {
            Iterator vci = this.validatedCells.iterator();
            while (vci.hasNext()) {
                CellValue cv = (CellValue)vci.next();
                CellFeatures cf = cv.getCellFeatures();
                if (cf.getDVParser() == null) continue;
                cf.getDVParser().removeColumn(col);
            }
        }
        this.mergedCells.removeColumn(col);
        ArrayList<Integer> newColumnBreaks = new ArrayList<Integer>();
        Iterator ri = this.columnBreaks.iterator();
        while (ri.hasNext()) {
            int val = (Integer)ri.next();
            if (val == col) continue;
            if (val > col) {
                --val;
            }
            newColumnBreaks.add(new Integer(val));
        }
        this.columnBreaks = newColumnBreaks;
        i2 = this.columnFormats.iterator();
        ColumnInfoRecord removeColumn = null;
        while (i2.hasNext()) {
            ColumnInfoRecord cir = (ColumnInfoRecord)i2.next();
            if (cir.getColumn() == col) {
                removeColumn = cir;
                continue;
            }
            if (cir.getColumn() <= col) continue;
            cir.decrementColumn();
        }
        if (removeColumn != null) {
            this.columnFormats.remove(removeColumn);
        }
        if (this.autosizedColumns.size() > 0) {
            TreeSet<Integer> newAutosized = new TreeSet<Integer>();
            i2 = this.autosizedColumns.iterator();
            while (i2.hasNext()) {
                Integer colnumber = (Integer)i2.next();
                if (colnumber == col) continue;
                if (colnumber > col) {
                    newAutosized.add(new Integer(colnumber - 1));
                    continue;
                }
                newAutosized.add(colnumber);
            }
            this.autosizedColumns = newAutosized;
        }
        Iterator cfit = this.conditionalFormats.iterator();
        while (cfit.hasNext()) {
            ConditionalFormat cf = (ConditionalFormat)cfit.next();
            cf.removeColumn(col);
        }
        if (this.workbookSettings.getFormulaAdjust()) {
            this.workbook.columnRemoved(this, col);
        }
        --this.numColumns;
    }

    public void removeRow(int row) {
        if (row < 0 || row >= this.numRows) {
            if (this.workbookSettings.getFormulaAdjust()) {
                this.workbook.rowRemoved(this, row);
            }
            return;
        }
        RowRecord[] oldRows = this.rows;
        this.rows = new RowRecord[oldRows.length];
        System.arraycopy(oldRows, 0, this.rows, 0, row);
        System.arraycopy(oldRows, row + 1, this.rows, row, this.numRows - (row + 1));
        int i = row;
        while (i < this.numRows) {
            if (this.rows[i] != null) {
                this.rows[i].decrementRow();
            }
            ++i;
        }
        HyperlinkRecord hr = null;
        Iterator i2 = this.hyperlinks.iterator();
        while (i2.hasNext()) {
            hr = (HyperlinkRecord)i2.next();
            if (hr.getRow() == row && hr.getLastRow() == row) {
                i2.remove();
                continue;
            }
            hr.removeRow(row);
        }
        if (this.dataValidation != null) {
            this.dataValidation.removeRow(row);
        }
        if (this.validatedCells != null && this.validatedCells.size() > 0) {
            Iterator vci = this.validatedCells.iterator();
            while (vci.hasNext()) {
                CellValue cv = (CellValue)vci.next();
                CellFeatures cf = cv.getCellFeatures();
                if (cf.getDVParser() == null) continue;
                cf.getDVParser().removeRow(row);
            }
        }
        this.mergedCells.removeRow(row);
        ArrayList<Integer> newRowBreaks = new ArrayList<Integer>();
        Iterator ri = this.rowBreaks.iterator();
        while (ri.hasNext()) {
            int val = (Integer)ri.next();
            if (val == row) continue;
            if (val > row) {
                --val;
            }
            newRowBreaks.add(new Integer(val));
        }
        this.rowBreaks = newRowBreaks;
        Iterator cfit = this.conditionalFormats.iterator();
        while (cfit.hasNext()) {
            ConditionalFormat cf = (ConditionalFormat)cfit.next();
            cf.removeRow(row);
        }
        if (this.workbookSettings.getFormulaAdjust()) {
            this.workbook.rowRemoved(this, row);
        }
        --this.numRows;
    }

    public void addCell(WritableCell cell) throws WriteException, RowsExceededException {
        boolean curSharedValidation;
        if (cell.getType() == CellType.EMPTY && cell != null && cell.getCellFormat() == null) {
            return;
        }
        CellValue cv = (CellValue)cell;
        if (cv.isReferenced()) {
            throw new JxlWriteException(JxlWriteException.cellReferenced);
        }
        int row = cell.getRow();
        RowRecord rowrec = this.getRowRecord(row);
        CellValue curcell = rowrec.getCell(cv.getColumn());
        boolean bl = curSharedValidation = curcell != null && curcell.getCellFeatures() != null && curcell.getCellFeatures().getDVParser() != null && curcell.getCellFeatures().getDVParser().extendedCellsValidation();
        if (cell.getCellFeatures() != null && cell.getCellFeatures().hasDataValidation() && curSharedValidation) {
            DVParser dvp = curcell.getCellFeatures().getDVParser();
            Log.warn("Cannot add cell at " + CellReferenceHelper.getCellReference(cv) + " because it is part of the shared cell validation group " + CellReferenceHelper.getCellReference(dvp.getFirstColumn(), dvp.getFirstRow()) + "-" + CellReferenceHelper.getCellReference(dvp.getLastColumn(), dvp.getLastRow()), this);
            return;
        }
        if (curSharedValidation) {
            WritableCellFeatures wcf = cell.getWritableCellFeatures();
            if (wcf == null) {
                wcf = new WritableCellFeatures();
                cell.setCellFeatures(wcf);
            }
            wcf.shareDataValidation(curcell.getCellFeatures());
        }
        rowrec.addCell(cv);
        this.numRows = Math.max(row + 1, this.numRows);
        this.numColumns = Math.max(this.numColumns, rowrec.getMaxColumn());
        cv.setCellDetails(this.formatRecords, this.sharedStrings, this);
    }

    RowRecord getRowRecord(int row) throws RowsExceededException {
        RowRecord rowrec;
        if (row >= 65536) {
            throw new RowsExceededException();
        }
        if (row >= this.rows.length) {
            RowRecord[] oldRows = this.rows;
            this.rows = new RowRecord[Math.max(oldRows.length + 10, row + 1)];
            System.arraycopy(oldRows, 0, this.rows, 0, oldRows.length);
            oldRows = null;
        }
        if ((rowrec = this.rows[row]) == null) {
            this.rows[row] = rowrec = new RowRecord(row, this);
        }
        return rowrec;
    }

    RowRecord getRowInfo(int r) {
        if (r < 0 || r > this.rows.length) {
            return null;
        }
        return this.rows[r];
    }

    ColumnInfoRecord getColumnInfo(int c) {
        Iterator i = this.columnFormats.iterator();
        ColumnInfoRecord cir = null;
        boolean stop = false;
        while (i.hasNext() && !stop) {
            cir = (ColumnInfoRecord)i.next();
            if (cir.getColumn() < c) continue;
            stop = true;
        }
        if (!stop) {
            return null;
        }
        return cir.getColumn() == c ? cir : null;
    }

    public void setName(String n) {
        this.name = n;
    }

    public void setHidden(boolean h) {
        this.settings.setHidden(h);
    }

    public void setProtected(boolean prot) {
        this.settings.setProtected(prot);
    }

    public void setSelected() {
        this.settings.setSelected();
    }

    public boolean isHidden() {
        return this.settings.isHidden();
    }

    public void setColumnView(int col, int width) {
        CellView cv = new CellView();
        cv.setSize(width * 256);
        this.setColumnView(col, cv);
    }

    public void setColumnView(int col, int width, CellFormat format) {
        CellView cv = new CellView();
        cv.setSize(width * 256);
        cv.setFormat(format);
        this.setColumnView(col, cv);
    }

    public void setColumnView(int col, CellView view) {
        block8: {
            XFRecord xfr = (XFRecord)view.getFormat();
            if (xfr == null) {
                Styles styles = this.getWorkbook().getStyles();
                xfr = styles.getNormalStyle();
            }
            try {
                int width;
                if (!xfr.isInitialized()) {
                    this.formatRecords.addStyle(xfr);
                }
                int n = width = view.depUsed() ? view.getDimension() * 256 : view.getSize();
                if (view.isAutosize()) {
                    this.autosizedColumns.add(new Integer(col));
                }
                ColumnInfoRecord cir = new ColumnInfoRecord(col, width, xfr);
                if (view.isHidden()) {
                    cir.setHidden(true);
                }
                if (!this.columnFormats.contains(cir)) {
                    this.columnFormats.add(cir);
                } else {
                    this.columnFormats.remove(cir);
                    this.columnFormats.add(cir);
                }
            }
            catch (NumFormatRecordsException e) {
                Log.warn("Maximum number of format records exceeded.  Using default format.", this);
                ColumnInfoRecord cir = new ColumnInfoRecord(col, view.getDimension() * 256, WritableWorkbook.NORMAL_STYLE);
                if (this.columnFormats.contains(cir)) break block8;
                this.columnFormats.add(cir);
            }
        }
    }

    public void setRowView(int row, int height) throws RowsExceededException {
        CellView cv = new CellView();
        cv.setSize(height);
        cv.setHidden(false);
        this.setRowView(row, cv);
    }

    public void setRowView(int row, boolean collapsed) throws RowsExceededException {
        CellView cv = new CellView();
        cv.setHidden(collapsed);
        this.setRowView(row, cv);
    }

    public void setRowView(int row, int height, boolean collapsed) throws RowsExceededException {
        CellView cv = new CellView();
        cv.setSize(height);
        cv.setHidden(collapsed);
        this.setRowView(row, cv);
    }

    public void setRowView(int row, CellView view) throws RowsExceededException {
        RowRecord rowrec = this.getRowRecord(row);
        XFRecord xfr = (XFRecord)view.getFormat();
        try {
            if (xfr != null && !xfr.isInitialized()) {
                this.formatRecords.addStyle(xfr);
            }
        }
        catch (NumFormatRecordsException e) {
            Log.warn("Maximum number of format records exceeded.  Using default format.", this);
            xfr = null;
        }
        rowrec.setRowDetails(view.getSize(), false, view.isHidden(), 0, false, xfr);
        this.numRows = Math.max(this.numRows, row + 1);
    }

    public void write() throws IOException {
        boolean dmod = this.drawingsModified;
        if (this.workbook.getDrawingGroup() != null) {
            dmod |= this.workbook.getDrawingGroup().hasDrawingsOmitted();
        }
        if (this.autosizedColumns.size() > 0) {
            this.autosizeColumns();
        }
        this.sheetWriter.setWriteData(this.rows, this.rowBreaks, this.columnBreaks, this.hyperlinks, this.mergedCells, this.columnFormats, this.maxRowOutlineLevel, this.maxColumnOutlineLevel);
        this.sheetWriter.setDimensions(this.getRows(), this.getColumns());
        this.sheetWriter.setSettings(this.settings);
        this.sheetWriter.setPLS(this.plsRecord);
        this.sheetWriter.setDrawings(this.drawings, dmod);
        this.sheetWriter.setButtonPropertySet(this.buttonPropertySet);
        this.sheetWriter.setDataValidation(this.dataValidation, this.validatedCells);
        this.sheetWriter.setConditionalFormats(this.conditionalFormats);
        this.sheetWriter.setAutoFilter(this.autoFilter);
        this.sheetWriter.write();
    }

    void copy(Sheet s) {
        this.settings = new SheetSettings(s.getSettings(), this);
        SheetCopier si = new SheetCopier(s, this);
        si.setColumnFormats(this.columnFormats);
        si.setFormatRecords(this.formatRecords);
        si.setHyperlinks(this.hyperlinks);
        si.setMergedCells(this.mergedCells);
        si.setRowBreaks(this.rowBreaks);
        si.setColumnBreaks(this.columnBreaks);
        si.setSheetWriter(this.sheetWriter);
        si.setDrawings(this.drawings);
        si.setImages(this.images);
        si.setConditionalFormats(this.conditionalFormats);
        si.setValidatedCells(this.validatedCells);
        si.copySheet();
        this.dataValidation = si.getDataValidation();
        this.comboBox = si.getComboBox();
        this.plsRecord = si.getPLSRecord();
        this.chartOnly = si.isChartOnly();
        this.buttonPropertySet = si.getButtonPropertySet();
        this.numRows = si.getRows();
        this.autoFilter = si.getAutoFilter();
        this.maxRowOutlineLevel = si.getMaxRowOutlineLevel();
        this.maxColumnOutlineLevel = si.getMaxColumnOutlineLevel();
    }

    void copy(WritableSheet s) {
        this.settings = new SheetSettings(s.getSettings(), this);
        WritableSheetImpl si = (WritableSheetImpl)s;
        WritableSheetCopier sc = new WritableSheetCopier(s, this);
        sc.setColumnFormats(si.columnFormats, this.columnFormats);
        sc.setMergedCells(si.mergedCells, this.mergedCells);
        sc.setRows(si.rows);
        sc.setRowBreaks(si.rowBreaks, this.rowBreaks);
        sc.setColumnBreaks(si.columnBreaks, this.columnBreaks);
        sc.setDataValidation(si.dataValidation);
        sc.setSheetWriter(this.sheetWriter);
        sc.setDrawings(si.drawings, this.drawings, this.images);
        sc.setWorkspaceOptions(si.getWorkspaceOptions());
        sc.setPLSRecord(si.plsRecord);
        sc.setButtonPropertySetRecord(si.buttonPropertySet);
        sc.setHyperlinks(si.hyperlinks, this.hyperlinks);
        sc.setValidatedCells(this.validatedCells);
        sc.copySheet();
        this.dataValidation = sc.getDataValidation();
        this.plsRecord = sc.getPLSRecord();
        this.buttonPropertySet = sc.getButtonPropertySet();
    }

    final HeaderRecord getHeader() {
        return this.sheetWriter.getHeader();
    }

    final FooterRecord getFooter() {
        return this.sheetWriter.getFooter();
    }

    public boolean isProtected() {
        return this.settings.isProtected();
    }

    public Hyperlink[] getHyperlinks() {
        Hyperlink[] hl = new Hyperlink[this.hyperlinks.size()];
        int i = 0;
        while (i < this.hyperlinks.size()) {
            hl[i] = (Hyperlink)this.hyperlinks.get(i);
            ++i;
        }
        return hl;
    }

    public Range[] getMergedCells() {
        return this.mergedCells.getMergedCells();
    }

    public WritableHyperlink[] getWritableHyperlinks() {
        WritableHyperlink[] hl = new WritableHyperlink[this.hyperlinks.size()];
        int i = 0;
        while (i < this.hyperlinks.size()) {
            hl[i] = (WritableHyperlink)this.hyperlinks.get(i);
            ++i;
        }
        return hl;
    }

    public void removeHyperlink(WritableHyperlink h) {
        this.removeHyperlink(h, false);
    }

    public void removeHyperlink(WritableHyperlink h, boolean preserveLabel) {
        this.hyperlinks.remove(this.hyperlinks.indexOf(h));
        if (!preserveLabel) {
            Assert.verify(this.rows.length > h.getRow() && this.rows[h.getRow()] != null);
            this.rows[h.getRow()].removeCell(h.getColumn());
        }
    }

    public void addHyperlink(WritableHyperlink h) throws WriteException, RowsExceededException {
        Label l;
        String cnts;
        Cell c = this.getCell(h.getColumn(), h.getRow());
        String contents = null;
        if (h.isFile() || h.isUNC()) {
            cnts = h.getContents();
            contents = cnts == null ? h.getFile().getPath() : cnts;
        } else if (h.isURL()) {
            cnts = h.getContents();
            contents = cnts == null ? h.getURL().toString() : cnts;
        } else if (h.isLocation()) {
            contents = h.getContents();
        }
        if (c.getType() == CellType.LABEL) {
            l = (Label)c;
            l.setString(contents);
            WritableCellFormat wcf = new WritableCellFormat(l.getCellFormat());
            wcf.setFont(WritableWorkbook.HYPERLINK_FONT);
            l.setCellFormat(wcf);
        } else {
            l = new Label(h.getColumn(), h.getRow(), contents, (CellFormat)WritableWorkbook.HYPERLINK_STYLE);
            this.addCell(l);
        }
        int i = h.getRow();
        while (i <= h.getLastRow()) {
            int j = h.getColumn();
            while (j <= h.getLastColumn()) {
                if (i != h.getRow() && j != h.getColumn() && this.rows.length < h.getLastColumn() && this.rows[i] != null) {
                    this.rows[i].removeCell(j);
                }
                ++j;
            }
            ++i;
        }
        h.initialize(this);
        this.hyperlinks.add(h);
    }

    public Range mergeCells(int col1, int row1, int col2, int row2) throws WriteException, RowsExceededException {
        if (col2 < col1 || row2 < row1) {
            Log.warn("Cannot merge cells - top left and bottom right incorrectly specified", this);
        }
        if (col2 >= this.numColumns || row2 >= this.numRows) {
            this.addCell(new Blank(col2, row2));
        }
        SheetRangeImpl range = new SheetRangeImpl(this, col1, row1, col2, row2);
        this.mergedCells.add(range);
        return range;
    }

    public void setRowGroup(int row1, int row2, boolean collapsed) throws WriteException, RowsExceededException {
        if (row2 < row1) {
            Log.warn("Cannot merge cells - top and bottom rows incorrectly specified", this);
        }
        int i = row1;
        while (i <= row2) {
            RowRecord row = this.getRowRecord(i);
            this.numRows = Math.max(i + 1, this.numRows);
            row.incrementOutlineLevel();
            row.setCollapsed(collapsed);
            this.maxRowOutlineLevel = Math.max(this.maxRowOutlineLevel, row.getOutlineLevel());
            ++i;
        }
    }

    public void unsetRowGroup(int row1, int row2) throws WriteException, RowsExceededException {
        if (row2 < row1) {
            Log.warn("Cannot merge cells - top and bottom rows incorrectly specified", this);
        }
        if (row2 >= this.numRows) {
            Log.warn(row2 + " is greater than the sheet bounds", this);
            row2 = this.numRows - 1;
        }
        int i = row1;
        while (i <= row2) {
            this.rows[i].decrementOutlineLevel();
            ++i;
        }
        this.maxRowOutlineLevel = 0;
        i = this.rows.length;
        while (i-- > 0) {
            this.maxRowOutlineLevel = Math.max(this.maxRowOutlineLevel, this.rows[i].getOutlineLevel());
        }
    }

    public void setColumnGroup(int col1, int col2, boolean collapsed) throws WriteException, RowsExceededException {
        if (col2 < col1) {
            Log.warn("Cannot merge cells - top and bottom rows incorrectly specified", this);
        }
        int i = col1;
        while (i <= col2) {
            ColumnInfoRecord cir = this.getColumnInfo(i);
            if (cir == null) {
                this.setColumnView(i, new CellView());
                cir = this.getColumnInfo(i);
            }
            cir.incrementOutlineLevel();
            cir.setCollapsed(collapsed);
            this.maxColumnOutlineLevel = Math.max(this.maxColumnOutlineLevel, cir.getOutlineLevel());
            ++i;
        }
    }

    public void unsetColumnGroup(int col1, int col2) throws WriteException, RowsExceededException {
        ColumnInfoRecord cir;
        if (col2 < col1) {
            Log.warn("Cannot merge cells - top and bottom rows incorrectly specified", this);
        }
        int i = col1;
        while (i <= col2) {
            cir = this.getColumnInfo(i);
            cir.decrementOutlineLevel();
            ++i;
        }
        this.maxColumnOutlineLevel = 0;
        Iterator it = this.columnFormats.iterator();
        while (it.hasNext()) {
            cir = (ColumnInfoRecord)it.next();
            this.maxColumnOutlineLevel = Math.max(this.maxColumnOutlineLevel, cir.getOutlineLevel());
        }
    }

    public void unmergeCells(Range r) {
        this.mergedCells.unmergeCells(r);
    }

    public void setHeader(String l, String c, String r) {
        HeaderFooter header = new HeaderFooter();
        header.getLeft().append(l);
        header.getCentre().append(c);
        header.getRight().append(r);
        this.settings.setHeader(header);
    }

    public void setFooter(String l, String c, String r) {
        HeaderFooter footer = new HeaderFooter();
        footer.getLeft().append(l);
        footer.getCentre().append(c);
        footer.getRight().append(r);
        this.settings.setFooter(footer);
    }

    public void setPageSetup(PageOrientation p) {
        this.settings.setOrientation(p);
    }

    public void setPageSetup(PageOrientation p, double hm, double fm) {
        this.settings.setOrientation(p);
        this.settings.setHeaderMargin(hm);
        this.settings.setFooterMargin(fm);
    }

    public void setPageSetup(PageOrientation p, PaperSize ps, double hm, double fm) {
        this.settings.setPaperSize(ps);
        this.settings.setOrientation(p);
        this.settings.setHeaderMargin(hm);
        this.settings.setFooterMargin(fm);
    }

    public SheetSettings getSettings() {
        return this.settings;
    }

    WorkbookSettings getWorkbookSettings() {
        return this.workbookSettings;
    }

    public void addRowPageBreak(int row) {
        Iterator i = this.rowBreaks.iterator();
        boolean found = false;
        while (i.hasNext() && !found) {
            if ((Integer)i.next() != row) continue;
            found = true;
        }
        if (!found) {
            this.rowBreaks.add(new Integer(row));
        }
    }

    public void addColumnPageBreak(int col) {
        Iterator i = this.columnBreaks.iterator();
        boolean found = false;
        while (i.hasNext() && !found) {
            if ((Integer)i.next() != col) continue;
            found = true;
        }
        if (!found) {
            this.columnBreaks.add(new Integer(col));
        }
    }

    Chart[] getCharts() {
        return this.sheetWriter.getCharts();
    }

    void checkMergedBorders() {
        this.sheetWriter.setWriteData(this.rows, this.rowBreaks, this.columnBreaks, this.hyperlinks, this.mergedCells, this.columnFormats, this.maxRowOutlineLevel, this.maxColumnOutlineLevel);
        this.sheetWriter.setDimensions(this.getRows(), this.getColumns());
        this.sheetWriter.checkMergedBorders();
    }

    private WorkspaceInformationRecord getWorkspaceOptions() {
        return this.sheetWriter.getWorkspaceOptions();
    }

    void rationalize(IndexMapping xfMapping, IndexMapping fontMapping, IndexMapping formatMapping) {
        Iterator i = this.columnFormats.iterator();
        while (i.hasNext()) {
            ColumnInfoRecord cir = (ColumnInfoRecord)i.next();
            cir.rationalize(xfMapping);
        }
        int i2 = 0;
        while (i2 < this.rows.length) {
            if (this.rows[i2] != null) {
                this.rows[i2].rationalize(xfMapping);
            }
            ++i2;
        }
        Chart[] charts = this.getCharts();
        int c = 0;
        while (c < charts.length) {
            charts[c].rationalize(fontMapping, formatMapping);
            ++c;
        }
    }

    WritableWorkbookImpl getWorkbook() {
        return this.workbook;
    }

    boolean isChartOnly() {
        return this.chartOnly;
    }

    public CellView getRowView(int row) {
        CellView cv = new CellView();
        try {
            RowRecord rr = this.getRowRecord(row);
            if (rr == null || rr.isDefaultHeight()) {
                cv.setDimension(this.settings.getDefaultRowHeight());
                cv.setSize(this.settings.getDefaultRowHeight());
            } else if (rr.isCollapsed()) {
                cv.setHidden(true);
            } else {
                cv.setDimension(rr.getRowHeight());
                cv.setSize(rr.getRowHeight());
            }
            return cv;
        }
        catch (RowsExceededException e) {
            cv.setDimension(this.settings.getDefaultRowHeight());
            cv.setSize(this.settings.getDefaultRowHeight());
            return cv;
        }
    }

    public CellView getColumnView(int col) {
        ColumnInfoRecord cir = this.getColumnInfo(col);
        CellView cv = new CellView();
        if (cir != null) {
            cv.setDimension(cir.getWidth() / 256);
            cv.setSize(cir.getWidth());
            cv.setHidden(cir.getHidden());
            cv.setFormat(cir.getCellFormat());
        } else {
            cv.setDimension(this.settings.getDefaultColumnWidth() / 256);
            cv.setSize(this.settings.getDefaultColumnWidth() * 256);
        }
        return cv;
    }

    public void addImage(WritableImage image) {
        boolean supported = false;
        java.io.File imageFile = image.getImageFile();
        String fileType = "?";
        if (imageFile != null) {
            String fileName = imageFile.getName();
            int fileTypeIndex = fileName.lastIndexOf(46);
            fileType = fileTypeIndex != -1 ? fileName.substring(fileTypeIndex + 1) : "";
            int i = 0;
            while (i < imageTypes.length && !supported) {
                if (fileType.equalsIgnoreCase(imageTypes[i])) {
                    supported = true;
                }
                ++i;
            }
        } else {
            supported = true;
        }
        if (supported) {
            this.workbook.addDrawing(image);
            this.drawings.add(image);
            this.images.add(image);
        } else {
            StringBuffer message = new StringBuffer("Image type ");
            message.append(fileType);
            message.append(" not supported.  Supported types are ");
            message.append(imageTypes[0]);
            int i = 1;
            while (i < imageTypes.length) {
                message.append(", ");
                message.append(imageTypes[i]);
                ++i;
            }
            Log.warn(message.toString(), this);
        }
    }

    public int getNumberOfImages() {
        return this.images.size();
    }

    public WritableImage getImage(int i) {
        return (WritableImage)this.images.get(i);
    }

    public Image getDrawing(int i) {
        return (Image)this.images.get(i);
    }

    public void removeImage(WritableImage wi) {
        this.drawings.remove(wi);
        this.images.remove(wi);
        this.drawingsModified = true;
        this.workbook.removeDrawing(wi);
    }

    private String validateName(String n) {
        if (n.length() > 31) {
            Log.warn("Sheet name " + n + " too long - truncating", this);
            n = n.substring(0, 31);
        }
        if (n.charAt(0) == '\'') {
            Log.warn("Sheet naming cannot start with ' - removing", this);
            n = n.substring(1);
        }
        int i = 0;
        while (i < illegalSheetNameCharacters.length) {
            String newname = n.replace(illegalSheetNameCharacters[i], '@');
            if (n != newname) {
                Log.warn(String.valueOf(illegalSheetNameCharacters[i]) + " is not a valid character within a sheet name - replacing", this);
            }
            n = newname;
            ++i;
        }
        return n;
    }

    void addDrawing(DrawingGroupObject o) {
        this.drawings.add(o);
        Assert.verify(!(o instanceof Drawing));
    }

    void removeDrawing(DrawingGroupObject o) {
        int origSize = this.drawings.size();
        this.drawings.remove(o);
        int newSize = this.drawings.size();
        this.drawingsModified = true;
        Assert.verify(newSize == origSize - 1);
    }

    void removeDataValidation(CellValue cv) {
        boolean result;
        if (this.dataValidation != null) {
            this.dataValidation.removeDataValidation(cv.getColumn(), cv.getRow());
        }
        if (this.validatedCells != null && !(result = this.validatedCells.remove(cv))) {
            Log.warn("Could not remove validated cell " + CellReferenceHelper.getCellReference(cv), this);
        }
    }

    public int[] getRowPageBreaks() {
        int[] rb = new int[this.rowBreaks.size()];
        int pos = 0;
        Iterator i = this.rowBreaks.iterator();
        while (i.hasNext()) {
            rb[pos] = (Integer)i.next();
            ++pos;
        }
        return rb;
    }

    public int[] getColumnPageBreaks() {
        int[] rb = new int[this.columnBreaks.size()];
        int pos = 0;
        Iterator i = this.columnBreaks.iterator();
        while (i.hasNext()) {
            rb[pos] = (Integer)i.next();
            ++pos;
        }
        return rb;
    }

    void addValidationCell(CellValue cv) {
        this.validatedCells.add(cv);
    }

    ComboBox getComboBox() {
        return this.comboBox;
    }

    void setComboBox(ComboBox cb) {
        this.comboBox = cb;
    }

    public DataValidation getDataValidation() {
        return this.dataValidation;
    }

    private void autosizeColumns() {
        Iterator i = this.autosizedColumns.iterator();
        while (i.hasNext()) {
            Integer col = (Integer)i.next();
            this.autosizeColumn(col);
        }
    }

    private void autosizeColumn(int col) {
        int maxWidth = 0;
        ColumnInfoRecord cir = this.getColumnInfo(col);
        Font columnFont = cir.getCellFormat().getFont();
        Font defaultFont = WritableWorkbook.NORMAL_STYLE.getFont();
        int i = 0;
        while (i < this.numRows) {
            Cell cell = null;
            if (this.rows[i] != null) {
                cell = this.rows[i].getCell(col);
            }
            if (cell != null) {
                String contents = cell.getContents();
                Font font = cell.getCellFormat().getFont();
                Font activeFont = font.equals(defaultFont) ? columnFont : font;
                int pointSize = activeFont.getPointSize();
                int numChars = contents.length();
                if (activeFont.isItalic() || activeFont.getBoldWeight() > 400) {
                    numChars += 2;
                }
                int points = numChars * pointSize;
                maxWidth = Math.max(maxWidth, points * 256);
            }
            ++i;
        }
        cir.setWidth(maxWidth / defaultFont.getPointSize());
    }

    void importSheet(Sheet s) {
        this.settings = new SheetSettings(s.getSettings(), this);
        SheetCopier si = new SheetCopier(s, this);
        si.setColumnFormats(this.columnFormats);
        si.setFormatRecords(this.formatRecords);
        si.setHyperlinks(this.hyperlinks);
        si.setMergedCells(this.mergedCells);
        si.setRowBreaks(this.rowBreaks);
        si.setColumnBreaks(this.columnBreaks);
        si.setSheetWriter(this.sheetWriter);
        si.setDrawings(this.drawings);
        si.setImages(this.images);
        si.setValidatedCells(this.validatedCells);
        si.importSheet();
        this.dataValidation = si.getDataValidation();
        this.comboBox = si.getComboBox();
        this.plsRecord = si.getPLSRecord();
        this.chartOnly = si.isChartOnly();
        this.buttonPropertySet = si.getButtonPropertySet();
        this.numRows = si.getRows();
        this.maxRowOutlineLevel = si.getMaxRowOutlineLevel();
        this.maxColumnOutlineLevel = si.getMaxColumnOutlineLevel();
    }

    public void applySharedDataValidation(WritableCell c, int extraCols, int extraRows) throws WriteException {
        int startRow;
        if (c.getWritableCellFeatures() == null || !c.getWritableCellFeatures().hasDataValidation()) {
            Log.warn("Cannot extend data validation for " + CellReferenceHelper.getCellReference(c.getColumn(), c.getRow()) + " as it has no data validation", this);
            return;
        }
        int startColumn = c.getColumn();
        int y = startRow = c.getRow();
        while (y <= startRow + extraRows) {
            if (this.rows[y] != null) {
                int x = startColumn;
                while (x <= startColumn + extraCols) {
                    CellValue c2;
                    if ((x != startColumn || y != startRow) && (c2 = this.rows[y].getCell(x)) != null && c2.getWritableCellFeatures() != null && c2.getWritableCellFeatures().hasDataValidation()) {
                        Log.warn("Cannot apply data validation from " + CellReferenceHelper.getCellReference(startColumn, startRow) + " to " + CellReferenceHelper.getCellReference(startColumn + extraCols, startRow + extraRows) + " as cell " + CellReferenceHelper.getCellReference(x, y) + " already has a data validation", this);
                        return;
                    }
                    ++x;
                }
            }
            ++y;
        }
        WritableCellFeatures sourceDataValidation = c.getWritableCellFeatures();
        sourceDataValidation.getDVParser().extendCellValidation(extraCols, extraRows);
        int y2 = startRow;
        while (y2 <= startRow + extraRows) {
            RowRecord rowrec = this.getRowRecord(y2);
            int x = startColumn;
            while (x <= startColumn + extraCols) {
                if (x != startColumn || y2 != startRow) {
                    CellValue c2 = rowrec.getCell(x);
                    if (c2 == null) {
                        Blank b = new Blank(x, y2);
                        WritableCellFeatures validation = new WritableCellFeatures();
                        validation.shareDataValidation(sourceDataValidation);
                        b.setCellFeatures(validation);
                        this.addCell(b);
                    } else {
                        WritableCellFeatures validation = c2.getWritableCellFeatures();
                        if (validation != null) {
                            validation.shareDataValidation(sourceDataValidation);
                        } else {
                            validation = new WritableCellFeatures();
                            validation.shareDataValidation(sourceDataValidation);
                            c2.setCellFeatures(validation);
                        }
                    }
                }
                ++x;
            }
            ++y2;
        }
    }

    public void removeSharedDataValidation(WritableCell cell) throws WriteException {
        WritableCellFeatures wcf = cell.getWritableCellFeatures();
        if (wcf == null || !wcf.hasDataValidation()) {
            return;
        }
        DVParser dvp = wcf.getDVParser();
        if (!dvp.extendedCellsValidation()) {
            wcf.removeDataValidation();
            return;
        }
        if (dvp.extendedCellsValidation() && (cell.getColumn() != dvp.getFirstColumn() || cell.getRow() != dvp.getFirstRow())) {
            Log.warn("Cannot remove data validation from " + CellReferenceHelper.getCellReference(dvp.getFirstColumn(), dvp.getFirstRow()) + "-" + CellReferenceHelper.getCellReference(dvp.getLastColumn(), dvp.getLastRow()) + " because the selected cell " + CellReferenceHelper.getCellReference(cell) + " is not the top left cell in the range", this);
            return;
        }
        int y = dvp.getFirstRow();
        while (y <= dvp.getLastRow()) {
            int x = dvp.getFirstColumn();
            while (x <= dvp.getLastColumn()) {
                CellValue c2 = this.rows[y].getCell(x);
                if (c2 != null) {
                    c2.getWritableCellFeatures().removeSharedDataValidation();
                    c2.removeCellFeatures();
                }
                ++x;
            }
            ++y;
        }
        if (this.dataValidation != null) {
            this.dataValidation.removeSharedDataValidation(dvp.getFirstColumn(), dvp.getFirstRow(), dvp.getLastColumn(), dvp.getLastRow());
        }
    }

    private static class ColumnInfoComparator
    implements Comparator {
        private ColumnInfoComparator() {
        }

        public boolean equals(Object o) {
            return o == this;
        }

        public int compare(Object o1, Object o2) {
            if (o1 == o2) {
                return 0;
            }
            Assert.verify(o1 instanceof ColumnInfoRecord);
            Assert.verify(o2 instanceof ColumnInfoRecord);
            ColumnInfoRecord ci1 = (ColumnInfoRecord)o1;
            ColumnInfoRecord ci2 = (ColumnInfoRecord)o2;
            return ci1.getColumn() - ci2.getColumn();
        }
    }
}

