/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.alert;

import de.hannse.netobjects.util.Babel;
import de.hannse.netobjects.util.Log;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JDialog;
import mausoleum.gui.MGButton;
import mausoleum.gui.NULLLayoutManager;
import mausoleum.gui.RequesterPane;
import mausoleum.gui.TextWrapComponent;
import mausoleum.helper.FontManager;
import mausoleum.helper.WindowUtils;
import mausoleum.ui.UIDef;

public class Alert
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 7107695456517090519L;
    private static final String STR_OK = "OK";
    private static final String STR_NO = "NO";
    private static final String STR_CANCEL = "CANCEL";
    private static final int BREITE = UIDef.getScaled(330);
    private static final int BIG_BREITE = UIDef.getScaled(450);
    public static final int MODE_YES = 1;
    public static final int MODE_YES_NO = 2;
    public static final int MODE_YES_NO_CANCEL = 3;
    public static final int RES_YES = 1;
    public static final int RES_NO = 2;
    public static final int RES_CANCEL = 3;
    private int ivRES = 3;
    static /* synthetic */ Class class$0;

    public static boolean showAlert(String meldung, boolean nurok) {
        return Alert.showAlert(meldung, null, null, nurok, false);
    }

    public static boolean showAlert(String meldung, String ok, String cancel, boolean nurok) {
        return Alert.showAlert(meldung, ok, cancel, nurok, false);
    }

    public static boolean showAlert(String meldung, boolean nurok, boolean smallFont) {
        return Alert.showAlert(meldung, null, null, nurok, smallFont);
    }

    private static synchronized boolean showAlert(String meldung, String yes, String no, boolean nurok, boolean smallFont) {
        return Alert.showAlert(meldung, yes, no, null, nurok ? 1 : 2, smallFont) == 1;
    }

    public static synchronized int showAlert(String meldung, String yes, String no, String cancel, int mode, boolean smallFont) {
        String string = "Bringing up Alert:\n------------------\n" + meldung;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("mausoleum.alert.Alert");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Log.log(string, clazz);
        if (yes == null) {
            yes = Babel.get(STR_OK);
        }
        if (no == null) {
            no = Babel.get(STR_CANCEL);
        }
        Alert ap = new Alert(meldung, yes, no, cancel, mode, smallFont);
        return ap.ivRES;
    }

    private Alert(String meldung, String yes, String no, String cancel, int mode, boolean smallFont) {
        super((Frame)null, Babel.get("ALERT"), true);
        this.setResizable(false);
        int breite = mode == 3 ? BIG_BREITE : BREITE;
        int iBreite = breite - 2 * UIDef.RAND;
        TextWrapComponent twc = new TextWrapComponent(meldung, smallFont);
        twc.ivHardWrapPossible = true;
        twc.setBounds(UIDef.RAND, UIDef.RAND, breite - 2 * UIDef.RAND, UIDef.getScaled(200));
        twc.generateElements();
        twc.setOpaque(false);
        if (twc.ivNeededWidth + 2 * UIDef.RAND > breite) {
            breite = twc.ivNeededWidth + 2 * UIDef.RAND;
            twc.setBounds(UIDef.RAND, UIDef.RAND, breite - 2 * UIDef.RAND, UIDef.getScaled(200));
            twc.generateElements();
        }
        int restStart = UIDef.RAND + twc.getNecessaryHeight() + 2 * UIDef.RAND;
        twc.setBounds(UIDef.RAND, UIDef.RAND, breite - 2 * UIDef.RAND, twc.getNecessaryHeight());
        this.setContentPane(new RequesterPane(new NULLLayoutManager(breite, restStart + UIDef.BUT_HEIGHT + UIDef.RAND)));
        this.getContentPane().add(twc);
        int x = UIDef.RAND;
        if (mode == 1) {
            this.addButton(yes, STR_OK, x, restStart, iBreite, UIDef.BUT_HEIGHT, true);
        } else if (mode == 2) {
            int lbr = (iBreite - UIDef.INNER_RAND) / 2;
            int rbr = iBreite - UIDef.INNER_RAND - lbr;
            x = this.addButton(yes, STR_OK, x, restStart, lbr, UIDef.BUT_HEIGHT, false);
            x = this.addButton(no, STR_NO, x, restStart, rbr, UIDef.BUT_HEIGHT, false);
        } else if (mode == 3) {
            int lbr = (iBreite - 2 * UIDef.INNER_RAND) / 3;
            int rbr = iBreite - 2 * UIDef.INNER_RAND - 2 * lbr;
            x = this.addButton(yes, STR_OK, x, restStart, lbr, UIDef.BUT_HEIGHT, false);
            x = this.addButton(no, STR_NO, x, restStart, lbr, UIDef.BUT_HEIGHT, false);
            x = this.addButton(cancel, STR_CANCEL, x, restStart, rbr, UIDef.BUT_HEIGHT, false);
        }
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                Alert.this.ivRES = 3;
                Alert.this.dispose();
            }
        });
        WindowUtils.bringUpCenteredDialog(this, breite, restStart + UIDef.BUT_HEIGHT + UIDef.RAND, true);
    }

    private int addButton(String text, String ac, int x, int y, int w, int h, boolean retOk) {
        MGButton cButton = new MGButton(text);
        cButton.setFont(FontManager.getFont("SSB24"));
        cButton.setActionCommand(ac);
        cButton.addActionListener(this);
        cButton.setBounds(x, y, w, h);
        this.getContentPane().add(cButton);
        if (retOk) {
            cButton.addKeyListener(new KeyAdapter(){

                public void keyPressed(KeyEvent e) {
                    if (e.getKeyChar() == '\n') {
                        e.consume();
                        Alert.this.ivRES = 1;
                        Alert.this.dispose();
                    }
                }
            });
        }
        return x + w + UIDef.INNER_RAND;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals(STR_OK)) {
            this.ivRES = 1;
            this.dispose();
        } else if (e.getActionCommand().equals(STR_NO)) {
            this.ivRES = 2;
            this.dispose();
        } else if (e.getActionCommand().equals(STR_CANCEL)) {
            this.ivRES = 3;
            this.dispose();
        }
    }
}

