/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.cage;

import de.hannse.netobjects.network.client.TimeMachine;
import de.hannse.netobjects.objectstore.CommandManagerExecutive;
import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.objectstore.ObjectManager;
import de.hannse.netobjects.objectstore.ObjectRequest;
import de.hannse.netobjects.objectstore.ObjectStore;
import de.hannse.netobjects.tools.StringHelper;
import de.hannse.netobjects.user.Privileges;
import de.hannse.netobjects.util.Babel;
import de.hannse.netobjects.util.RequestManager;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import mausoleum.cage.Cage;
import mausoleum.main.MausoleumClient;
import mausoleum.main.ProcessDefinition;
import mausoleum.mouse.Mouse;
import mausoleum.mouse.WeaningControl;
import mausoleum.objectstore.AftermathObject;
import mausoleum.tables.TableFrameCage;
import mausoleum.tables.TableFrameTasks;
import mausoleum.tables.models.MTCage;
import mausoleum.util.InstallationType;
import mausoleum.visit.Visit;

public class CageManager
extends ObjectManager {
    private static final int MAT_RES_MATING = 1;
    private static final int MAT_RES_MISSING_GENOTYPE = 2;
    private static final int MAT_RES_STERILE = 4;
    private static final HashMap MATINGS = new HashMap();
    public static CageManager cvInstance = null;

    public static void init() {
        if (cvInstance == null) {
            cvInstance = new CageManager();
        }
    }

    public static void exit() {
        if (ProcessDefinition.isClient() && cvInstance != null) {
            cvInstance.dispose();
            cvInstance = null;
        }
    }

    public static Cage getCage(Long id, String group) {
        return (Cage)cvInstance.getObject(id, group);
    }

    public static void performWeanControl(boolean forceShowFrame) {
        Vector v;
        if (ProcessDefinition.isClient() && (MausoleumClient.isRegularOrTGService() || MausoleumClient.isServiceCaretaker()) && Privileges.hasPrivilege("WEAN_CONTROL") && (v = cvInstance.getActualObjectVectorAllGroups()) != null && !v.isEmpty()) {
            Vector<Cage> erg = new Vector<Cage>();
            Vector<Cage> toClean = new Vector<Cage>();
            long jetztMillis = TimeMachine.getCurrentMillis();
            Vector tempTarget = new Vector();
            int i = 0;
            while (i < v.size()) {
                Cage c = (Cage)v.elementAt(i);
                c.determineActualMice();
                if (CageManager.containsDeadMice(c)) {
                    toClean.addElement(c);
                }
                tempTarget.clear();
                if (WeaningControl.isWeaningNecessary(c, jetztMillis, null, tempTarget)) {
                    erg.add(c);
                }
                ++i;
            }
            tempTarget.clear();
            tempTarget = null;
            if (!erg.isEmpty() || forceShowFrame) {
                TableFrameTasks.showWeanAlert(erg, forceShowFrame);
                if (!erg.isEmpty()) {
                    TableFrameTasks.windowIsNecessary();
                }
            }
            if (!toClean.isEmpty()) {
                StringBuilder msb = new StringBuilder();
                HashMap objectsByGroup = IDObject.sortByGroup(toClean);
                if (objectsByGroup != null) {
                    Iterator iter = objectsByGroup.keySet().iterator();
                    while (iter.hasNext()) {
                        String group = (String)iter.next();
                        Vector cagesToCleanInGoup = (Vector)objectsByGroup.get(group);
                        msb.setLength(0);
                        int i2 = 0;
                        while (i2 < cagesToCleanInGoup.size()) {
                            if (msb.length() != 0) {
                                msb.append("\n");
                            }
                            Cage tcc = (Cage)cagesToCleanInGoup.elementAt(i2);
                            msb.append(CommandManagerExecutive.getServiceRoomTag(tcc, ""));
                            msb.append("CCLEAN");
                            msb.append(" ");
                            msb.append(Long.toString(tcc.getID()));
                            ++i2;
                        }
                        RequestManager.sendCommandRequestAndGetAnswer(msb.toString(), group);
                        msb.setLength(0);
                    }
                }
            }
        }
    }

    public static void checkWeddingStatusOfAllCages() {
        MATINGS.clear();
        if (InstallationType.useMatings() && (MausoleumClient.isRegularOrTGService() || MausoleumClient.isServiceCaretaker())) {
            Enumeration en = cvInstance.getActualObjectEnumerationAllGroups();
            while (en.hasMoreElements()) {
                Cage c = (Cage)en.nextElement();
                c.determineActualMice();
                CageManager.checkWeddingStatus(c, false, false);
            }
            TableFrameCage.MATING_CAGES.ivModel.fillMainTable();
        }
    }

    public static void prepareSingleColorsOfAllCages(int modus, String groupIfNotAll) {
        if (MausoleumClient.isServiceCaretaker() || MausoleumClient.isRegularOrTGService()) {
            HashMap merker = new HashMap();
            Enumeration en = groupIfNotAll != null ? cvInstance.getActualObjectEnumeration(groupIfNotAll) : cvInstance.getActualObjectEnumerationAllGroups();
            while (en.hasMoreElements()) {
                Cage c = (Cage)en.nextElement();
                c.prepareColorsForMode(modus, c.itsMine(null), c.getActualMice(), merker);
            }
            merker.clear();
            Object var2_2 = null;
        }
    }

    public static void checkWeddingStatus(Cage c, boolean withFillMainTable, boolean withRemove) {
        if (InstallationType.useMatings() && (MausoleumClient.isRegularOrTGService() || MausoleumClient.isServiceCaretaker())) {
            int matRes = CageManager.isAMating(c.getActualMice(), true, null);
            if (matRes != 0) {
                c.ivIsWeddingCage = true;
                c.ivIsWeddingCageWithMissingGenotypes = (matRes & 2) != 0;
                c.ivIsSterileWeddingCage = (matRes & 4) != 0;
                CageManager.addMatingCage(c, withFillMainTable);
            } else {
                c.ivIsWeddingCage = false;
                c.ivIsWeddingCageWithMissingGenotypes = false;
                c.ivIsSterileWeddingCage = false;
                if (withRemove) {
                    CageManager.removeMatingCage(c, withFillMainTable);
                }
            }
        }
    }

    private static void addMatingCage(Cage c, boolean withFillMainTable) {
        if (InstallationType.useMatings()) {
            MATINGS.put(c.getIdentifierString(), c);
            if (withFillMainTable) {
                TableFrameCage.MATING_CAGES.ivModel.fillMainTable();
            }
        }
    }

    private static void removeMatingCage(Cage c, boolean withFillMainTable) {
        Object old;
        if (InstallationType.useMatings() && (old = MATINGS.remove(c.getIdentifierString())) != null && withFillMainTable) {
            TableFrameCage.MATING_CAGES.ivModel.fillMainTable();
        }
    }

    private CageManager() {
        super(2);
    }

    public void removeObject(String group, Long id) {
        Cage cage = (Cage)this.getLocalObject(id, group);
        if (cage != null) {
            CageManager.removeMatingCage(cage, true);
        }
        super.removeObject(group, id);
    }

    public void notifyConsumers(IDObject iob) {
        if (iob instanceof Cage) {
            Cage c = (Cage)iob;
            c = c.getSuperCageIfThere();
            super.notifyConsumers(c);
            super.notifyConsumers(c.getLeftSubCage());
            super.notifyConsumers(c.getRightSubCage());
        } else {
            super.notifyConsumers(iob);
        }
    }

    public void performObjectInsertionAftermath(ObjectRequest or, Vector sentObjects, AftermathObject aftermathObject) {
        super.performObjectInsertionAftermath(or, sentObjects, aftermathObject);
        if (ProcessDefinition.isClient() && (MausoleumClient.isRegularOrTGService() || MausoleumClient.isServiceCaretaker()) && MausoleumClient.cvManagerInitialized && sentObjects != null) {
            int i = 0;
            while (i < sentObjects.size()) {
                aftermathObject.addCage((Cage)sentObjects.elementAt(i));
                ++i;
            }
            HashMap primerg = (HashMap)or.ivObject;
            HashSet specialCommands = (HashSet)primerg.get("#soc");
            if (or.isFinished() && or.isCommandUNDOREDORequest() && or.ivClientString.equals(StringHelper.getClientString())) {
                Vector neueKaefigIDs;
                HashMap neueObjekte;
                TableFrameCage.addTouchedCages(sentObjects);
                HashMap newObjectsByGroup = (HashMap)primerg.get("#sno");
                if (newObjectsByGroup != null && (neueObjekte = (HashMap)newObjectsByGroup.get(or.ivGroup)) != null && (neueKaefigIDs = (Vector)neueObjekte.get(new Integer(2))) != null) {
                    Vector<Cage> neueKaefigObjekte = new Vector<Cage>();
                    int i2 = 0;
                    while (i2 < neueKaefigIDs.size()) {
                        Cage kaefig = CageManager.getCage((Long)neueKaefigIDs.elementAt(i2), or.ivGroup);
                        if (kaefig != null) {
                            neueKaefigObjekte.addElement(kaefig);
                        }
                        ++i2;
                    }
                    TableFrameCage.addNewCages(neueKaefigObjekte);
                }
                if (specialCommands != null && specialCommands.contains("CCONTIG")) {
                    TableFrameCage.showCageTable(new MTCage(sentObjects), Babel.get("CHANGEDCAGES"), Babel.get("CHANGEDCAGES"));
                }
            }
        }
    }

    public Vector getMatingsAllGroups() {
        Vector erg = new Vector();
        if (InstallationType.useMatings()) {
            Iterator iter = MATINGS.values().iterator();
            while (iter.hasNext()) {
                erg.add(iter.next());
            }
        }
        return erg;
    }

    public static Vector returnMatureMiceIfMating(Cage targetCage, Vector mice, Vector allMiceCollector) {
        Vector matureMice;
        allMiceCollector.clear();
        if (targetCage != null) {
            allMiceCollector.addAll(targetCage.getActualMice());
        }
        if (mice != null) {
            allMiceCollector.addAll(mice);
        }
        return CageManager.isAMating(allMiceCollector, false, matureMice = new Vector()) != 0 ? matureMice : null;
    }

    public static int isAMating(Vector mice, boolean mitZusatz, Vector matureMice) {
        int res = 0;
        if (InstallationType.useMatings()) {
            boolean hadMales = false;
            boolean hadFemales = false;
            boolean withMissing = false;
            boolean nonFertile = false;
            if (mice != null && !mice.isEmpty()) {
                Iterator iter = mice.iterator();
                while (iter.hasNext()) {
                    Mouse mouse = (Mouse)iter.next();
                    if (!mouse.isPossMatingPartner()) continue;
                    if (mitZusatz) {
                        if (!withMissing && !Mouse.isGenotypeComplete(mouse, -1L)) {
                            withMissing = true;
                        }
                        if (!nonFertile && mouse.isNonFertile()) {
                            nonFertile = true;
                        }
                    }
                    switch (mouse.getSex()) {
                        case 1: {
                            hadMales = true;
                            if (matureMice == null) break;
                            matureMice.add(mouse);
                            break;
                        }
                        case 2: {
                            hadFemales = true;
                            if (matureMice == null) break;
                            matureMice.add(mouse);
                            break;
                        }
                    }
                }
            }
            if (hadMales && hadFemales) {
                res = 1;
                if (withMissing) {
                    res += 2;
                }
                if (nonFertile) {
                    res += 4;
                }
            }
        }
        return res;
    }

    private static boolean containsDeadMice(Cage c) {
        Visit[] arr = (Visit[])c.get("CAG_VISIT");
        if (arr != null) {
            int i = 0;
            while (i < arr.length) {
                if (arr[i].ivEndDate == null) {
                    Mouse mouse = (Mouse)ObjectStore.getObjectDeadOrAlive(1, arr[i].ivMouseID, c.getGroup(), null, false);
                    if (mouse != null) {
                        if (!mouse.isAliveAndVisible()) {
                            return true;
                        }
                    } else {
                        return true;
                    }
                }
                ++i;
            }
        }
        return false;
    }
}

