/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.cage.cagetalker;

import de.hannse.netobjects.java.MCLK;
import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.objectstore.NULLObject;
import de.hannse.netobjects.objectstore.actions.OAGetConfigValue;
import de.hannse.netobjects.tools.FileManager;
import de.hannse.netobjects.tools.StringHelper;
import de.hannse.netobjects.util.Log;
import de.hannse.netobjects.util.MilliSpender;
import de.hannse.netobjects.util.MyDate;
import de.hannse.netobjects.util.RequestManager;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;
import mausoleum.cage.Cage;
import mausoleum.helper.Zeile;
import mausoleum.main.ProcessDefinition;
import mausoleum.mouse.Mouse;
import mausoleum.printing.util.Wurf;
import mausoleum.strain.Strain;
import mausoleum.visit.Visit;

public class CageTalker {
    private static final String DIR = "data/config/cagetalker/";
    private static final String STOCK_CARD_TEMPLATE = FileManager.getStringFromFile("data/config/cagetalker/stockCard.txt");
    private static final String BREEDING_CARD_TEMPLATE = FileManager.getStringFromFile("data/config/cagetalker/breedingCard.txt");
    private static final String ANIMAL_TEMPLATE = FileManager.getStringFromFile("data/config/cagetalker/animal.txt");
    private static final String MALE_ANIMAL_TEMPLATE = FileManager.getStringFromFile("data/config/cagetalker/maleAnimal.txt");
    private static final String FEMALE_ANIMAL_TEMPLATE = FileManager.getStringFromFile("data/config/cagetalker/femaleAnimal.txt");
    private static final String LITTER_TEMPLATE = FileManager.getStringFromFile("data/config/cagetalker/litter.txt");
    private static final String PUP_TEMPLATE = FileManager.getStringFromFile("data/config/cagetalker/pup.txt");
    private static final String NOSEX = "";
    private static final String MALE = "Male";
    private static final String FEMALE = "Female";
    private static final int CAGE_TALKER_UNDEFINED = -1;
    private static final int CAGE_TALKER_NIX = 0;
    private static final int CAGE_TALKER_STD_1 = 1;
    private static final int[] ALLOWED_MODI = new int[]{1};
    private static final HashSet USED_CAGETALKER_IDS = new HashSet();
    private static final String[] MTGT_ARR = new String[14];
    private static final TreeSet STOCK_STRAINS_TREESET = new TreeSet();
    private static final StringBuilder STOCK_MICE_SB = new StringBuilder();
    private static final StringBuilder PUP_SB = new StringBuilder();
    private static final StringBuilder LITTER_SB = new StringBuilder();
    private static final StringBuilder DATE_SB = new StringBuilder();
    private static final StringBuilder DATE_TIME_SB = new StringBuilder();
    private static final Vector MALES_SAMMLER = new Vector();
    private static final Vector FEMALES_SAMMLER = new Vector();
    private static final Vector CAGE_SAMMLER = new Vector();
    public static int cvCageTalker = -1;
    private static int cvKontingent = -1;
    private static int cvMaxDate = -2147483584;
    private static String cvXMLDirName = null;
    static /* synthetic */ Class class$0;

    static {
        String definition = null;
        if (ProcessDefinition.isServer()) {
            cvXMLDirName = FileManager.getStringFromFile("data/cagetalkerdir.txt");
            if (cvXMLDirName != null && cvXMLDirName.trim().length() != 0) {
                cvXMLDirName = StringHelper.gSub(cvXMLDirName, "\\", "/", true).trim();
                definition = MCLK.getDefinedVal("CAGTALK:");
            } else {
                MCLK.removeDefinedVal("CAGTALK:");
            }
        } else if (ProcessDefinition.isClient()) {
            definition = (String)RequestManager.createSendAndGetObjectIfFinished((byte)71, "CAGTALK:", null, OAGetConfigValue.MARK_MCLK_STRING);
        }
        if (definition != null) {
            Zeile z = new Zeile(definition, '|');
            cvCageTalker = z.getInt(0, 0);
            cvKontingent = z.getInt(1, -1);
            cvMaxDate = z.getInt(2, -2147483584);
        } else {
            cvCageTalker = 0;
        }
    }

    public static boolean useCageTalker() {
        return cvCageTalker != 0 && (cvMaxDate == -2147483584 || System.currentTimeMillis() / 86400000L < (long)cvMaxDate);
    }

    public static boolean limitCheckWanted() {
        return cvKontingent > 0;
    }

    public static boolean isLimitExceeded() {
        if (CageTalker.useCageTalker() && cvKontingent != -1) {
            return USED_CAGETALKER_IDS.size() >= cvKontingent;
        }
        return false;
    }

    public static void addUsedCagetalkerID(String id) {
        if (CageTalker.useCageTalker() && id != null) {
            USED_CAGETALKER_IDS.add(id);
        }
    }

    public static void removeUsedCagetalkerID(String id) {
        if (CageTalker.useCageTalker() && id != null) {
            USED_CAGETALKER_IDS.remove(id);
        }
    }

    public static boolean isCageTalkerIdTaken(String id) {
        if (CageTalker.useCageTalker() && id != null) {
            return USED_CAGETALKER_IDS.contains(id);
        }
        return false;
    }

    public static synchronized void handleAfterCommand(Hashtable objectBag) {
        CAGE_SAMMLER.clear();
        Iterator iterator = objectBag.values().iterator();
        while (iterator.hasNext()) {
            Mouse mouse;
            Cage cage;
            IDObject ido = (IDObject)iterator.next();
            if (ido instanceof Cage) {
                Cage cage2 = (Cage)ido;
                if (cage2.get("CAG_CTID") != null && !CAGE_SAMMLER.contains(cage2)) {
                    CAGE_SAMMLER.add(cage2);
                }
                CageTalker.updateCageTalkerBeforeCommit(cage2);
                continue;
            }
            if (!(ido instanceof Mouse) || (cage = (mouse = (Mouse)ido).getActCage()) == null || cage.get("CAG_CTID") == null || CAGE_SAMMLER.contains(cage)) continue;
            CAGE_SAMMLER.add(cage);
        }
        if (!CAGE_SAMMLER.isEmpty()) {
            CageTalker.handleCagesToUpdate(CAGE_SAMMLER);
        }
        CAGE_SAMMLER.clear();
    }

    private static void handleCagesToUpdate(Vector cages) {
        if (cages != null) {
            Iterator iterator = cages.iterator();
            while (iterator.hasNext()) {
                Cage cage = (Cage)iterator.next();
                if (cage.get("CAG_CTID") == null) continue;
                String card = CageTalker.getCard(cage);
                FileManager.prepareDirs(cvXMLDirName);
                String path = String.valueOf(cvXMLDirName) + "/" + MilliSpender.getMillis() + ".xml";
                String string = "Prepared card:\n------------------\n" + card;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("mausoleum.cage.cagetalker.CageTalker");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Log.log(string, clazz);
                FileManager.saveUTF8StringToFile(path, card);
            }
        }
    }

    private static void updateCageTalkerBeforeCommit(Cage cage) {
        if (CageTalker.useCageTalker()) {
            boolean nachherAct;
            Object vorher = CageTalker.getRealValue("CAG_CTID", cage.ivProperties);
            Object nachher = CageTalker.getRealValue("CAG_CTID", cage.ivPropertyMask);
            boolean vorherAct = CageTalker.getRealValue("IDO_END_DATE", cage.ivProperties) == null;
            boolean bl = nachherAct = CageTalker.getRealValue("IDO_END_DATE", cage.ivProperties) == null;
            if (vorher != null || nachher != null) {
                if (vorher != null && nachher == null) {
                    if (vorherAct && nachherAct) {
                        USED_CAGETALKER_IDS.remove(vorher);
                    }
                } else if (vorher == null && nachher != null) {
                    if (vorherAct && nachherAct) {
                        USED_CAGETALKER_IDS.add(nachher);
                    }
                } else if (vorher != null && nachher != null) {
                    if (!vorher.equals(nachher)) {
                        USED_CAGETALKER_IDS.remove(vorher);
                        USED_CAGETALKER_IDS.add(nachher);
                    } else if (vorherAct && !nachherAct) {
                        USED_CAGETALKER_IDS.remove(vorher);
                    } else if (!vorherAct && nachherAct) {
                        USED_CAGETALKER_IDS.add(nachher);
                    }
                }
            }
        }
    }

    private static String getCard(Cage cage) {
        return cage.isMatingCage() ? CageTalker.getMatingCard(cage) : CageTalker.getStockCard(cage);
    }

    private static String getMatingCard(Cage cage) {
        return CageTalker.fillMatingCage(cage, BREEDING_CARD_TEMPLATE, MALE_ANIMAL_TEMPLATE, FEMALE_ANIMAL_TEMPLATE, LITTER_TEMPLATE, PUP_TEMPLATE);
    }

    private static String getStockCard(Cage cage) {
        return CageTalker.fillStockCage(cage, STOCK_CARD_TEMPLATE, ANIMAL_TEMPLATE);
    }

    private static String gsubAllg(Cage cage, String res) {
        res = StringHelper.gSub(res, "_CAGE_CARD_ID_", cage.getString("CAG_CTID", NOSEX));
        res = StringHelper.gSub(res, "_CAGE_ID_", cage.getLongID().toString());
        res = StringHelper.gSub(res, "_CAGE_NUMBER_", cage.getNumber());
        res = StringHelper.gSub(res, "_CURR_TIME_", CageTalker.getDateTime(null, System.currentTimeMillis()));
        res = StringHelper.gSub(res, "_CAGE_START_", CageTalker.getDateTime(cage.getDate("IDO_START_DATE"), -1L));
        res = StringHelper.gSub(res, "_GROUP_", cage.getGroup());
        res = StringHelper.gSub(res, "_SLOT_", cage.getRackPosNameForCageTalker());
        res = StringHelper.gSub(res, "_PROJECT_", cage.getLicenseString(null));
        res = StringHelper.gSub(res, "_WORKERS_", cage.getOwnerStringOnlySingleNamePreferred());
        res = StringHelper.gSub(res, "_RACK_", cage.getRackName());
        return res;
    }

    private static synchronized String fillMatingCage(Cage cage, String template, String maleMiceTemplate, String femaleMiceTemplate, String litterTemplate, String pupsTemplate) {
        String res = CageTalker.gsubAllg(cage, template);
        MALES_SAMMLER.clear();
        FEMALES_SAMMLER.clear();
        Vector wuerfe = Wurf.collectWuerfeForPrinters(cage, MALES_SAMMLER, FEMALES_SAMMLER, false, 100, 200, null, false, false, false, false, true, false, false, false, false, true);
        STOCK_MICE_SB.setLength(0);
        STOCK_STRAINS_TREESET.clear();
        CageTalker.handleMouseVector(cage, MALES_SAMMLER, maleMiceTemplate, STOCK_STRAINS_TREESET);
        res = StringHelper.gSub(res, "_MALE_ANIMALS_", STOCK_MICE_SB.toString());
        STOCK_MICE_SB.setLength(0);
        CageTalker.handleMouseVector(cage, FEMALES_SAMMLER, femaleMiceTemplate, STOCK_STRAINS_TREESET);
        res = StringHelper.gSub(res, "_FEMALE_ANIMALS_", STOCK_MICE_SB.toString());
        STOCK_MICE_SB.setLength(0);
        Iterator iterator = STOCK_STRAINS_TREESET.iterator();
        while (iterator.hasNext()) {
            String name = (String)iterator.next();
            if (STOCK_MICE_SB.length() != 0) {
                STOCK_MICE_SB.append(" ");
            }
            STOCK_MICE_SB.append(name);
        }
        res = StringHelper.gSub(res, "_STRAIN_", STOCK_MICE_SB.toString());
        STOCK_MICE_SB.setLength(0);
        LITTER_SB.setLength(0);
        iterator = wuerfe.iterator();
        while (iterator.hasNext()) {
            Wurf wurf = (Wurf)iterator.next();
            String lres = litterTemplate;
            int weaned = 0;
            int numTotal = 0;
            int numAlive = 0;
            int numDead = 0;
            int numMale = 0;
            int numFemale = 0;
            PUP_SB.setLength(0);
            if (wurf.ivKids != null) {
                Iterator iterator2 = wurf.ivKids.iterator();
                while (iterator2.hasNext()) {
                    String pres = pupsTemplate;
                    Mouse mouse = (Mouse)iterator2.next();
                    if (mouse.isAliveAndVisible()) {
                        ++numTotal;
                        ++numAlive;
                        int sex = mouse.getSex(0);
                        if (sex == 1) {
                            ++numMale;
                        } else if (sex == 2) {
                            ++numFemale;
                        }
                    } else if (mouse.isVisible()) {
                        ++numDead;
                        ++numTotal;
                    }
                    Visit firstVisit = Visit.findFirstVisit((Visit[])mouse.get("MOS_VISIT"), mouse.getID(), cage.getID());
                    Date weanDate = null;
                    if (firstVisit != null && firstVisit.ivEndDate != null && firstVisit.ivEndMode == 2) {
                        weanDate = firstVisit.ivEndDate;
                        ++weaned;
                    }
                    pres = StringHelper.gSub(pres, "_SEX_", CageTalker.getSex(mouse));
                    pres = StringHelper.gSub(pres, "_BIRTH_DATE_", CageTalker.getDate(mouse.getDate("MOS_BIRTHDAY"), -1));
                    pres = StringHelper.gSub(pres, "_MOVEMENT_DATE_", CageTalker.getDate(mouse.getEntryInActCage(cage.getID()), -1));
                    pres = StringHelper.gSub(pres, "_WEANING_DATE_", CageTalker.getDate(weanDate, -1));
                    pres = StringHelper.gSub(pres, "_DEATH_DATE_", CageTalker.getDate(mouse.getDate("IDO_END_DATE"), -1));
                    pres = StringHelper.gSub(pres, "_LINE_", mouse.getCLLWLineStringWithoutPrefix());
                    long motherID = mouse.getLong("MOS_MOTHER", 0L);
                    pres = StringHelper.gSub(pres, "_MOTHER_ID_", motherID > 0L ? Long.toString(motherID) : NOSEX);
                    long fatherID = mouse.getLong("MOS_FATHER", 0L);
                    pres = StringHelper.gSub(pres, "_FATHER_ID_", fatherID > 0L ? Long.toString(fatherID) : NOSEX);
                    PUP_SB.append(pres);
                }
            }
            lres = StringHelper.gSub(lres, "_NUM_PUPS_", Integer.toString(numAlive));
            lres = StringHelper.gSub(lres, "_LITTER_DATE_", CageTalker.getDate(null, wurf.ivDay));
            lres = StringHelper.gSub(lres, "_NUM_BORN_", Integer.toString(numTotal));
            lres = StringHelper.gSub(lres, "_NUM_DEAD_", Integer.toString(numDead));
            lres = StringHelper.gSub(lres, "_NUM_FEMALE_", Integer.toString(numFemale));
            lres = StringHelper.gSub(lres, "_NUM_MALE_", Integer.toString(numMale));
            lres = StringHelper.gSub(lres, "_COMMENT_", NOSEX);
            lres = StringHelper.gSub(lres, "_NUM_WEANED_", Integer.toString(weaned));
            lres = StringHelper.gSub(lres, "_PUPS_", PUP_SB.toString());
            PUP_SB.setLength(0);
            LITTER_SB.append(lres);
        }
        res = StringHelper.gSub(res, "_LITTERS_", LITTER_SB.toString());
        LITTER_SB.setLength(0);
        return res;
    }

    private static void handleMouseVector(Cage cage, Vector mice, String miceTemplate, TreeSet strainTS) {
        if (mice != null && !mice.isEmpty()) {
            Iterator iterator = mice.iterator();
            while (iterator.hasNext()) {
                Mouse mouse = (Mouse)iterator.next();
                STOCK_MICE_SB.append(CageTalker.fillAnimal(mouse, cage, miceTemplate));
                Vector strains = mouse.getStrains();
                if (strains == null || strains.isEmpty()) continue;
                Iterator iterator2 = strains.iterator();
                while (iterator2.hasNext()) {
                    Strain strain = (Strain)iterator2.next();
                    strainTS.add(strain.getBrowseName());
                }
            }
        }
    }

    private static synchronized String fillStockCage(Cage cage, String template, String miceTemplate) {
        String res = CageTalker.gsubAllg(cage, template);
        Vector mice = cage.getActualMice();
        res = StringHelper.gSub(res, "_SEX_", CageTalker.getCommonSex(mice));
        STOCK_MICE_SB.setLength(0);
        STOCK_STRAINS_TREESET.clear();
        CageTalker.handleMouseVector(cage, mice, miceTemplate, STOCK_STRAINS_TREESET);
        res = StringHelper.gSub(res, "_ANIMALS_", STOCK_MICE_SB.toString());
        STOCK_MICE_SB.setLength(0);
        Iterator iterator = STOCK_STRAINS_TREESET.iterator();
        while (iterator.hasNext()) {
            String name = (String)iterator.next();
            if (STOCK_MICE_SB.length() != 0) {
                STOCK_MICE_SB.append(" // ");
            }
            STOCK_MICE_SB.append(name);
        }
        res = StringHelper.gSub(res, "_STRAIN_", STOCK_MICE_SB.toString());
        STOCK_MICE_SB.setLength(0);
        return res;
    }

    private static synchronized String fillAnimal(Mouse mouse, Cage cage, String template) {
        String res = template;
        res = StringHelper.gSub(res, "_BIRTH_DATE_", CageTalker.getDate(mouse.getDate("MOS_BIRTHDAY"), -1));
        res = StringHelper.gSub(res, "_MOVEMENT_DATE_", CageTalker.getDate(mouse.getEntryInActCage(cage.getID()), -1));
        res = StringHelper.gSub(res, "_SEX_", CageTalker.getSex(mouse));
        res = StringHelper.gSub(res, "_SYSID_", Long.toString(mouse.getID()));
        res = StringHelper.gSub(res, "_FOREIGN_ID_", mouse.getString("IDO_FKEY", NOSEX));
        res = StringHelper.gSub(res, "_TAG_", mouse.getCLLWEartagString(NOSEX, true, true));
        int i = 0;
        while (i < MTGT_ARR.length) {
            CageTalker.MTGT_ARR[i] = NOSEX;
            ++i;
        }
        String[] gtArr = mouse.getGenotypeStringArray();
        int i2 = 0;
        while (i2 < 7) {
            String mut = gtArr != null && gtArr.length > 2 * i2 ? gtArr[2 * i2] : NOSEX;
            String gt = gtArr != null && gtArr.length > 2 * i2 ? gtArr[2 * i2 + 1] : NOSEX;
            res = StringHelper.gSub(res, "_MUT_" + (i2 + 1) + "_", mut);
            res = StringHelper.gSub(res, "_GT_" + (i2 + 1) + "_", gt);
            ++i2;
        }
        res = StringHelper.gSub(res, "_STRAIN_", mouse.getCLLWStrainString(false));
        res = StringHelper.gSub(res, "_LINE_", mouse.getCLLWLineStringWithoutPrefix());
        long motherID = mouse.getLong("MOS_MOTHER", 0L);
        res = StringHelper.gSub(res, "_MOTHER_ID_", motherID > 0L ? Long.toString(motherID) : NOSEX);
        long fatherID = mouse.getLong("MOS_FATHER", 0L);
        res = StringHelper.gSub(res, "_FATHER_ID_", fatherID > 0L ? Long.toString(fatherID) : NOSEX);
        return res;
    }

    private static synchronized String getDate(Date date, int days) {
        DATE_SB.setLength(0);
        MyDate md = null;
        if (date != null) {
            md = MyDate.getMyDate(date.getTime());
        } else if (days != -1) {
            md = new MyDate(days);
        }
        if (md != null) {
            DATE_SB.append(md.ivJahr).append("-");
            if (md.ivMonat < 10) {
                DATE_SB.append("0");
            }
            DATE_SB.append(md.ivMonat).append("-");
            if (md.ivTag < 10) {
                DATE_SB.append("0");
            }
            DATE_SB.append(md.ivTag);
        }
        return DATE_SB.toString();
    }

    private static synchronized String getDateTime(Date date, long millis) {
        DATE_TIME_SB.setLength(0);
        MyDate md = null;
        md = date != null ? MyDate.getMyDate(date.getTime()) : MyDate.getMyDate(millis);
        if (md != null) {
            DATE_TIME_SB.append(md.ivJahr).append("-");
            if (md.ivMonat < 10) {
                DATE_TIME_SB.append("0");
            }
            DATE_TIME_SB.append(md.ivMonat).append("-");
            if (md.ivTag < 10) {
                DATE_TIME_SB.append("0");
            }
            DATE_TIME_SB.append(md.ivTag).append(" ");
            if (md.ivStunde < 10) {
                DATE_TIME_SB.append("0");
            }
            DATE_TIME_SB.append(md.ivStunde).append("-");
            if (md.ivMinute < 10) {
                DATE_TIME_SB.append("0");
            }
            DATE_TIME_SB.append(md.ivMinute).append("-");
            if (md.ivSekunde < 10) {
                DATE_TIME_SB.append("0");
            }
            DATE_TIME_SB.append(md.ivSekunde);
        }
        return DATE_TIME_SB.toString();
    }

    private static String getCommonSex(Vector mice) {
        if (mice != null && !mice.isEmpty()) {
            int nM = 0;
            int nF = 0;
            Iterator iterator = mice.iterator();
            while (iterator.hasNext()) {
                Mouse mouse = (Mouse)iterator.next();
                int sex = mouse.getSex(0);
                if (sex == 2) {
                    ++nF;
                }
                if (sex != 1) continue;
                ++nM;
            }
            if (nF == mice.size()) {
                return FEMALE;
            }
            if (nM == mice.size()) {
                return MALE;
            }
        }
        return NOSEX;
    }

    private static String getSex(Mouse mouse) {
        int sex = mouse.getSex(0);
        if (sex == 1) {
            return MALE;
        }
        if (sex == 2) {
            return FEMALE;
        }
        return NOSEX;
    }

    private static Object getRealValue(String key, Hashtable sammel) {
        Object object = null;
        if (sammel != null && (object = sammel.get(key)) instanceof NULLObject) {
            object = null;
        }
        return object;
    }
}

