/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.cage.colors;

import de.hannse.netobjects.util.ArrayHelper;
import de.hannse.netobjects.util.Babel;
import java.awt.Color;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import mausoleum.cage.Cage;
import mausoleum.cage.CageManager;
import mausoleum.cage.colors.AgeColor;
import mausoleum.cage.colors.BreedingPerformance;
import mausoleum.cage.colors.CohortColor;
import mausoleum.cage.colors.ColorMode;
import mausoleum.cage.colors.GroupColor;
import mausoleum.cage.colors.Herzeloyde;
import mausoleum.cage.colors.LicenseColor;
import mausoleum.cage.colors.LineColor;
import mausoleum.cage.colors.LineStrainColor;
import mausoleum.cage.colors.LitterColor;
import mausoleum.cage.colors.MarkColor;
import mausoleum.cage.colors.MatingColor;
import mausoleum.cage.colors.MissingGenoptypesColor;
import mausoleum.cage.colors.MouseCount;
import mausoleum.cage.colors.PregnantColor;
import mausoleum.cage.colors.SexColor;
import mausoleum.cage.colors.StrainColor;
import mausoleum.cage.colors.SymptomColor;
import mausoleum.cage.colors.TaskColor;
import mausoleum.cage.colors.UntaggedColor;
import mausoleum.cage.colors.UserColor;
import mausoleum.cage.colors.WeaningColor;
import mausoleum.main.DefaultManager;
import mausoleum.main.MausoleumClient;
import mausoleum.main.ProcessDefinition;
import mausoleum.requester.preferences.Preferences;
import mausoleum.util.InstallationType;

public class CageColorManager {
    public static final int CAGE_DISPLAY_LINES = 0;
    public static final int CAGE_DISPLAY_MATING = 1;
    public static final int CAGE_DISPLAY_USER = 2;
    public static final int CAGE_DISPLAY_COUNT = 3;
    public static final int CAGE_DISPLAY_WEANING = 4;
    public static final int CAGE_DISPLAY_ALL_AGES = 5;
    public static final int CAGE_DISPLAY_AVERAGE_AGE = 6;
    public static final int CAGE_DISPLAY_MAXIMUM_AGE = 7;
    public static final int CAGE_DISPLAY_UNTAGGED = 8;
    public static final int CAGE_DISPLAY_BREEDING_PERFORMANCE = 9;
    public static final int CAGE_DISPLAY_ALL_TASKS = 10;
    public static final int CAGE_DISPLAY_ACTIVE_TASKS = 11;
    public static final int CAGE_DISPLAY_LICENSE = 12;
    public static final int CAGE_DISPLAY_SEX = 13;
    public static final int CAGE_DISPLAY_MISSING_GENOTYPE = 14;
    public static final int CAGE_DISPLAY_CAGE_MARK = 15;
    public static final int CAGE_DISPLAY_MOUSE_MARK = 16;
    public static final int CAGE_DISPLAY_STRAIN = 17;
    public static final int CAGE_DISPLAY_LINESTRAIN = 18;
    public static final int CAGE_DISPLAY_COHORT = 19;
    public static final int CAGE_DISPLAY_GROUP = 20;
    public static final int CAGE_DISPLAY_HERZELOYDE = 21;
    public static final int CAGE_DISPLAY_SYMPTOM = 22;
    public static final int CAGE_DISPLAY_PREGNANCY = 23;
    public static final int CAGE_DISPLAY_LITTER_COUNT = 24;
    public static final int MAX_POSS_CAGE_COLOR = 25;
    public static final Color NULL_COLOR = new Color(128, 128, 128, 128);
    public static final Color UNDEFINED_COLOR = Color.lightGray;
    public static final int UNTER_VAL = Integer.MIN_VALUE;
    public static final int UEBER_VAL = Integer.MAX_VALUE;
    private static final int[] CAGE_MODE_INTS;
    public static final int[] CAGE_MODE_INTS_FISH;
    private static final int[] CAGE_MODE_INTS_HEAD_OF_SERVICE;
    private static final int[] CAGE_MODE_INTS_HEAD_OF_SERVICE_FISH;
    public static final HashMap BABELS_BY_MODE;
    public static final HashMap COLORMODES_BY_MODE;
    public static final HashMap TOOLTIPS_BY_MODE;
    public static final ComboBoxModel COMBO_NIX_MODEL;
    private static final MouseListener COMBO_MOUSE_LISTENER;
    private static final ComboBoxModel COMBO_MODEL;
    private static final String MUTEX = "Entartet Geschlecht, unwert der Ahnen!";
    public static JComboBox cvColormodeComboRackFrame;
    public static JComboBox cvColormodeComboOverview;
    private static int cvMainMode;
    private static int[] cvModes;
    private static String cvTooltip;

    static {
        int[] nArray = new int[25];
        nArray[0] = 13;
        nArray[2] = 17;
        nArray[3] = 18;
        nArray[4] = 1;
        nArray[5] = 2;
        nArray[6] = 3;
        nArray[7] = 4;
        nArray[8] = 5;
        nArray[9] = 6;
        nArray[10] = 7;
        nArray[11] = 8;
        nArray[12] = 14;
        nArray[13] = 9;
        nArray[14] = 10;
        nArray[15] = 11;
        nArray[16] = 12;
        nArray[17] = 19;
        nArray[18] = 15;
        nArray[19] = 16;
        nArray[20] = 20;
        nArray[21] = 21;
        nArray[22] = 22;
        nArray[23] = 23;
        nArray[24] = 24;
        CAGE_MODE_INTS = nArray;
        int[] nArray2 = new int[19];
        nArray2[0] = 13;
        nArray2[2] = 17;
        nArray2[3] = 18;
        nArray2[4] = 2;
        nArray2[5] = 3;
        nArray2[6] = 5;
        nArray2[7] = 6;
        nArray2[8] = 7;
        nArray2[9] = 8;
        nArray2[10] = 14;
        nArray2[11] = 10;
        nArray2[12] = 11;
        nArray2[13] = 12;
        nArray2[14] = 19;
        nArray2[15] = 15;
        nArray2[16] = 16;
        nArray2[17] = 20;
        nArray2[18] = 22;
        CAGE_MODE_INTS_FISH = nArray2;
        int[] nArray3 = new int[23];
        nArray3[0] = 20;
        nArray3[1] = 18;
        nArray3[3] = 17;
        nArray3[4] = 13;
        nArray3[5] = 1;
        nArray3[6] = 2;
        nArray3[7] = 3;
        nArray3[8] = 4;
        nArray3[9] = 5;
        nArray3[10] = 6;
        nArray3[11] = 7;
        nArray3[12] = 8;
        nArray3[13] = 14;
        nArray3[14] = 11;
        nArray3[15] = 12;
        nArray3[16] = 19;
        nArray3[17] = 15;
        nArray3[18] = 16;
        nArray3[19] = 21;
        nArray3[20] = 22;
        nArray3[21] = 23;
        nArray3[22] = 24;
        CAGE_MODE_INTS_HEAD_OF_SERVICE = nArray3;
        int[] nArray4 = new int[18];
        nArray4[0] = 20;
        nArray4[1] = 18;
        nArray4[3] = 17;
        nArray4[4] = 13;
        nArray4[5] = 2;
        nArray4[6] = 3;
        nArray4[7] = 5;
        nArray4[8] = 6;
        nArray4[9] = 7;
        nArray4[10] = 8;
        nArray4[11] = 14;
        nArray4[12] = 11;
        nArray4[13] = 12;
        nArray4[14] = 19;
        nArray4[15] = 15;
        nArray4[16] = 16;
        nArray4[17] = 22;
        CAGE_MODE_INTS_HEAD_OF_SERVICE_FISH = nArray4;
        BABELS_BY_MODE = new HashMap();
        COLORMODES_BY_MODE = new HashMap();
        TOOLTIPS_BY_MODE = new HashMap();
        COMBO_NIX_MODEL = new DefaultComboBoxModel();
        COMBO_MOUSE_LISTENER = new MouseAdapter(){

            public void mouseEntered(MouseEvent e) {
                ((JComboBox)e.getSource()).setToolTipText(cvTooltip);
            }

            public void mouseExited(MouseEvent e) {
                ((JComboBox)e.getSource()).setToolTipText(null);
            }
        };
        COMBO_MODEL = new DefaultComboBoxModel(){
            private static final long serialVersionUID = 1453L;

            public Object getElementAt(int row) {
                if (cvModes != null && row >= 0 && row < cvModes.length) {
                    return CageColorManager.getName(cvModes[row]);
                }
                return null;
            }

            public int getSize() {
                return cvModes != null ? cvModes.length : 0;
            }
        };
        cvColormodeComboRackFrame = null;
        cvColormodeComboOverview = null;
        cvMainMode = -1;
        cvModes = null;
        cvTooltip = null;
        if (ProcessDefinition.isServer()) {
            cvModes = CageColorManager.getAllPossibleCageColorModes();
            CageColorManager.enterModes();
            cvColormodeComboRackFrame = null;
            cvColormodeComboOverview = null;
        }
    }

    public static void destroy() {
        if (cvColormodeComboRackFrame != null) {
            cvColormodeComboRackFrame.removeMouseListener(COMBO_MOUSE_LISTENER);
            cvColormodeComboRackFrame = null;
        }
        if (cvColormodeComboOverview != null) {
            cvColormodeComboOverview.removeMouseListener(COMBO_MOUSE_LISTENER);
            cvColormodeComboOverview = null;
        }
    }

    public static int[] getAllPossibleCageColorModes() {
        if (ProcessDefinition.isServer()) {
            return InstallationType.isMouse() ? CAGE_MODE_INTS_HEAD_OF_SERVICE : CAGE_MODE_INTS_HEAD_OF_SERVICE_FISH;
        }
        if (MausoleumClient.isHeadOfService()) {
            return InstallationType.isMouse() ? CAGE_MODE_INTS_HEAD_OF_SERVICE : CAGE_MODE_INTS_HEAD_OF_SERVICE_FISH;
        }
        return InstallationType.isMouse() ? CAGE_MODE_INTS : CAGE_MODE_INTS_FISH;
    }

    public static void startUpClient1() {
        cvModes = CageColorManager.getAllPossibleCageColorModes();
        CageColorManager.enterModes();
        if (MausoleumClient.isHeadOfService()) {
            cvMainMode = 20;
            cvColormodeComboOverview = null;
        } else {
            cvColormodeComboOverview = new JComboBox(COMBO_MODEL);
            cvColormodeComboOverview.addMouseListener(COMBO_MOUSE_LISTENER);
        }
        cvColormodeComboRackFrame = new JComboBox(COMBO_MODEL);
        cvColormodeComboRackFrame.addMouseListener(COMBO_MOUSE_LISTENER);
        CageColorManager.adaptCombos(true);
    }

    public static void startUpClient2() {
        CageColorManager.manageCageColors(cvMainMode, cvModes);
        CageColorManager.modeSelected(true);
    }

    private static void enterModes() {
        CageColorManager.enter(13, "CAG_COL_MODE_SEX", SexColor.INSTANCE);
        CageColorManager.enter(0, "CAG_COL_MODE_LINE", LineColor.INSTANCE);
        CageColorManager.enter(17, "CAG_COL_MODE_STRAIN", StrainColor.INSTANCE);
        CageColorManager.enter(18, "CAG_COL_MODE_LINESTRAIN", LineStrainColor.INSTANCE);
        CageColorManager.enter(1, "CAG_COL_MODE_MATING", MatingColor.INSTANCE);
        CageColorManager.enter(2, "CAG_COL_MODE_USER", UserColor.INSTANCE);
        CageColorManager.enter(3, "CAG_COL_MODE_MOUSECOUNT", MouseCount.INSTANCE);
        CageColorManager.enter(4, "CAG_COL_MODE_WEANING", WeaningColor.INSTANCE);
        CageColorManager.enter(5, "CAG_COL_MODE_ALL_AGE", AgeColor.INSTANCE_ALLES);
        CageColorManager.enter(6, "CAG_COL_MODE_AVE_AGE", AgeColor.INSTANCE_DURCHSCHNITT);
        CageColorManager.enter(7, "CAG_COL_MODE_MAX_AGE", AgeColor.INSTANCE_MAXIMUM);
        CageColorManager.enter(8, "CAG_COL_MODE_MISSING_TAGS", UntaggedColor.INSTANCE);
        CageColorManager.enter(14, "CAG_COL_MODE_MISSING_GENOTYPES", MissingGenoptypesColor.INSTANCE);
        CageColorManager.enter(9, "CAG_COL_MODE_BREEDING_PERFORMNACE", BreedingPerformance.INSTANCE);
        CageColorManager.enter(10, "CAG_COL_MODE_TASKS", TaskColor.INSTANCE_MIT_FERTIG);
        CageColorManager.enter(11, "CAG_COL_MODE_TASKS_OHNE_FERTIGE", TaskColor.INSTANCE_OHNE_FERTIG);
        CageColorManager.enter(12, "CAG_COL_MODE_LICENSE", LicenseColor.INSTANCE);
        CageColorManager.enter(15, "CAG_COL_MODE_CAGEMARK", MarkColor.INSTANCE_CAGES);
        CageColorManager.enter(16, "CAG_COL_MODE_MOUSEMARK", MarkColor.INSTANCE_MICE);
        CageColorManager.enter(19, "CAG_COL_MODE_COHORT", CohortColor.INSTANCE);
        CageColorManager.enter(20, "CAG_COL_MODE_GROUP", GroupColor.INSTANCE);
        CageColorManager.enter(21, "CAG_COL_MODE_HERZELOYDE", Herzeloyde.INSTANCE);
        CageColorManager.enter(22, "CAG_COL_MODE_SYMPTOM", SymptomColor.INSTANCE);
        CageColorManager.enter(23, "CAG_COL_MODE_PREGNANCY", PregnantColor.INSTANCE);
        CageColorManager.enter(24, "CAG_COL_LITTER_COUNT", LitterColor.INSTANCE);
    }

    public static boolean needsMattColor(int mattierModus) {
        return mattierModus == 3;
    }

    private static void enter(int modeInt, String babel, ColorMode mode) {
        int i = 0;
        while (i < cvModes.length) {
            if (cvModes[i] == modeInt) {
                mode.ivModeInt = modeInt;
                Integer key = new Integer(modeInt);
                BABELS_BY_MODE.put(key, babel);
                COLORMODES_BY_MODE.put(key, mode);
                if (ProcessDefinition.isClient()) {
                    TOOLTIPS_BY_MODE.put(key, mode.getTooltip());
                }
            }
            ++i;
        }
    }

    public static Vector getDefinedModes() {
        Vector<ColorMode> res = new Vector<ColorMode>();
        int i = 0;
        while (i < cvModes.length) {
            res.add(CageColorManager.getColorMode(cvModes[i]));
            ++i;
        }
        return res;
    }

    public static void adaptCombos(boolean isDuringInit) {
        if (ProcessDefinition.isClient() && !MausoleumClient.isHeadOfService()) {
            Vector<String> values = new Vector<String>();
            Vector<Integer> modesI = new Vector<Integer>();
            int index = 0;
            int[] allPossibles = CageColorManager.getAllPossibleCageColorModes();
            int newMainMode = DefaultManager.getCageDisplayMode();
            int[] modes = DefaultManager.getColorModes();
            int i = 0;
            while (i < modes.length) {
                if (ArrayHelper.findIndexInArray(modes[i], allPossibles) != -1) {
                    modesI.add(new Integer(modes[i]));
                    values.add(CageColorManager.getName(modes[i]));
                    if (modes[i] == newMainMode) {
                        index = values.size() - 1;
                    }
                }
                ++i;
            }
            modes = new int[modesI.size()];
            i = 0;
            while (i < modes.length) {
                modes[i] = (Integer)modesI.elementAt(i);
                ++i;
            }
            HashSet<Integer> bekannte = new HashSet<Integer>();
            if (cvMainMode != -1) {
                int i2 = 0;
                while (i2 < cvModes.length) {
                    bekannte.add(new Integer(cvModes[i2]));
                    ++i2;
                }
            }
            HashSet<Integer> unbekannte = new HashSet<Integer>();
            int i3 = 0;
            while (i3 < modes.length) {
                Integer val = new Integer(modes[i3]);
                if (!bekannte.contains(val)) {
                    unbekannte.add(val);
                }
                ++i3;
            }
            if (!unbekannte.isEmpty()) {
                int nmmToSend = newMainMode;
                Integer nmmVal = new Integer(newMainMode);
                if (unbekannte.contains(nmmVal)) {
                    unbekannte.remove(nmmVal);
                } else {
                    nmmToSend = -1;
                }
                int[] modesToSend = null;
                if (!unbekannte.isEmpty()) {
                    modesToSend = new int[unbekannte.size()];
                    int pos = 0;
                    Iterator iter = unbekannte.iterator();
                    while (iter.hasNext()) {
                        Integer val = (Integer)iter.next();
                        modesToSend[pos++] = val;
                    }
                }
                if (!isDuringInit) {
                    try {
                        CageColorManager.manageCageColors(nmmToSend, modesToSend);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            cvModes = new int[modes.length];
            i3 = 0;
            while (i3 < cvModes.length) {
                CageColorManager.cvModes[i3] = modes[i3];
                ++i3;
            }
            cvMainMode = newMainMode;
            CageColorManager.changeCombos(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void changeCombos(int index) {
        String string = MUTEX;
        synchronized (MUTEX) {
            CageColorManager.manageComboChange(cvColormodeComboRackFrame, index);
            CageColorManager.manageComboChange(cvColormodeComboOverview, index);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private static void manageComboChange(JComboBox combo, int index) {
        if (combo != null) {
            boolean merk = combo.isEnabled();
            combo.setEnabled(false);
            ComboBoxModel cbm = combo.getModel();
            combo.setModel(COMBO_NIX_MODEL);
            combo.setModel(cbm);
            combo.setEnabled(merk);
            if (combo.getModel().getSize() - 1 >= index) {
                combo.setSelectedIndex(index);
            }
        }
    }

    public static void prepareCage(Cage c) {
        if (c != null) {
            c.prepareColorsForMode(DefaultManager.getCageDisplayMode(), c.itsMine(null), c.getActualMice(), null);
        }
    }

    public static void createCageColorsForLogChange() {
        if (ProcessDefinition.isClient()) {
            CageColorManager.manageCageColors(DefaultManager.getCageDisplayMode(), cvModes);
            CageColorManager.manageTooltips();
        }
    }

    private static synchronized void manageCageColors(int mainMode, int[] modes) {
        if (ProcessDefinition.isClient() && CageManager.cvInstance != null && mainMode != -1) {
            HashMap merker = new HashMap();
            Enumeration en = CageManager.cvInstance.getActualObjectEnumerationAllGroups();
            while (en.hasMoreElements()) {
                Cage c = (Cage)en.nextElement();
                c.prepareColorsForMode(mainMode, c.itsMine(null), c.getActualMice(), merker);
            }
            merker.clear();
            Object var2_2 = null;
        }
    }

    public static void manageTooltips() {
        cvTooltip = CageColorManager.getToolTip(DefaultManager.getCageDisplayMode());
    }

    public static int getIndexOfMainMode() {
        int i = 0;
        while (i < cvModes.length) {
            if (cvModes[i] == cvMainMode) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static void modeSelected(boolean fromRackframe) {
        if (ProcessDefinition.isClient()) {
            int ind = 0;
            if (fromRackframe && cvColormodeComboRackFrame != null) {
                ind = cvColormodeComboRackFrame.getSelectedIndex();
            } else if (cvColormodeComboOverview != null) {
                ind = cvColormodeComboOverview.getSelectedIndex();
            }
            if (ind < 0 || ind >= cvModes.length) {
                ind = 0;
            }
            cvMainMode = cvModes[ind];
            CageManager.prepareSingleColorsOfAllCages(cvMainMode, null);
            Preferences.setCageDisplayMode(cvMainMode);
        }
    }

    public static Color[] prepareColor(int modus, Cage cage, Vector cageMice, HashMap merker) {
        ColorMode cm = (ColorMode)COLORMODES_BY_MODE.get(new Integer(modus));
        return cm != null ? cm.getCageColor(cage, null, cageMice, merker) : null;
    }

    public static ColorMode getColorMode(int modus) {
        return (ColorMode)COLORMODES_BY_MODE.get(new Integer(modus));
    }

    public static String getName(int modus) {
        String babel = (String)BABELS_BY_MODE.get(new Integer(modus));
        return babel != null ? Babel.get(babel) : null;
    }

    public static String getToolTip(int modus) {
        return (String)TOOLTIPS_BY_MODE.get(new Integer(modus));
    }

    public static boolean showsColorForEmptyCages(int modus) {
        ColorMode cm = (ColorMode)COLORMODES_BY_MODE.get(new Integer(modus));
        return cm != null ? cm.showColorsForEmptyCage() : false;
    }
}

