/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.cage.colors;

import de.hannse.netobjects.util.Babel;
import java.awt.Color;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import mausoleum.cage.Cage;
import mausoleum.cage.colors.CageColorManager;
import mausoleum.cage.colors.MultiColorMode;
import mausoleum.cage.colors.StrainColor;
import mausoleum.gui.PralineColor;
import mausoleum.line.Line;
import mausoleum.mouse.Mouse;
import mausoleum.ui.UIDef;

public class LineColor
extends MultiColorMode {
    public static final LineColor INSTANCE = new LineColor();

    public String getInnerTooltip() {
        return Babel.get("TT_CC_LINES");
    }

    public void fillColors(Cage cage, HashSet colors, HashMap legendsByColor, Vector cageMice, HashMap merker) {
        Iterator iter = cageMice.iterator();
        while (iter.hasNext()) {
            Color c = null;
            Mouse mouse = (Mouse)iter.next();
            Line line = mouse.getLine();
            if (line != null) {
                Color lineColor = (Color)line.get("LIN_COLOR", UIDef.OBJECT_DEFAULT_COLOR);
                if (line.getBoolean("LIN_ALPRAL", false)) {
                    Color strainColor = StrainColor.INSTANCE.getColorForMouse(mouse, legendsByColor);
                    if (strainColor == null) {
                        strainColor = CageColorManager.NULL_COLOR;
                    }
                    c = new PralineColor(strainColor, lineColor);
                } else {
                    c = lineColor;
                }
                LineColor.manageLegend(c, line.getBrowseName(), legendsByColor);
            }
            colors.add(c == null ? CageColorManager.NULL_COLOR : c);
        }
    }

    public boolean hasVaryingColorColorCodes() {
        return true;
    }

    public Color[] getColorsForDefaultLegend() {
        return null;
    }

    public String[] getStringsForDefaultLegend() {
        return null;
    }
}

