/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.cage.colors;

import de.hannse.netobjects.util.Babel;
import java.awt.Color;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;
import mausoleum.cage.Cage;
import mausoleum.cage.colors.CageColorManager;
import mausoleum.cage.colors.MixColorMode;
import mausoleum.gui.ColorManager;
import mausoleum.mouse.Mouse;
import mausoleum.printing.util.Wurf;

public class LitterColor
extends MixColorMode {
    private static final int NIX_WERT = Integer.MIN_VALUE;
    private static final Color NIX_COL = CageColorManager.UNDEFINED_COLOR;
    private static final Color COL_0 = ColorManager.getColorFromString("lightsteelblue");
    private static final Color COL_1 = ColorManager.getColorFromString("lightgreen");
    private static final Color COL_2 = ColorManager.getColorFromString("lightgreen");
    private static final Color COL_3 = Color.green;
    private static final Color COL_5 = Color.yellow;
    private static final Color COL_8 = Color.orange;
    private static final Color COL_10 = Color.red;
    private static final Color COL_12 = ColorManager.getColorFromString("darkred");
    private static final Color COL_P12 = Color.black;
    private static final Color[] COLORS = new Color[]{COL_0, COL_1, COL_2, COL_3, COL_5, COL_8, COL_10, COL_12, COL_P12};
    private static final int[] VALUES;
    private static final Color[] TT_COLORS;
    private static final String[] TT_STRINGS;
    public static final LitterColor INSTANCE;

    static {
        int[] nArray = new int[9];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 5;
        nArray[5] = 8;
        nArray[6] = 10;
        nArray[7] = 12;
        nArray[8] = 12;
        VALUES = nArray;
        TT_COLORS = new Color[]{CageColorManager.UNDEFINED_COLOR, COL_0, COL_1, COL_2, COL_3, COL_5, COL_8, COL_10, COL_12, COL_P12};
        TT_STRINGS = new String[]{Babel.get("UNDEFINED"), "0", "1", "2", "3", "5", "8", "10", "12", "> 12"};
        INSTANCE = new LitterColor();
    }

    public static final Color getLitterColor(int litterCount) {
        return LitterColor.getColor(litterCount, VALUES, COLORS);
    }

    public static final Color getLitterColor(Mouse m) {
        return LitterColor.getColor(Wurf.getWurfCount(m, Integer.MIN_VALUE), VALUES, COLORS);
    }

    public Color[] getColorsForDefaultLegend() {
        return TT_COLORS;
    }

    public String[] getStringsForDefaultLegend() {
        return TT_STRINGS;
    }

    public String getInnerTooltip() {
        return LitterColor.createHTML(TT_COLORS, TT_STRINGS, false, 5);
    }

    public Color[] getColors() {
        return COLORS;
    }

    public int[] getValues() {
        return VALUES;
    }

    public boolean hasVaryingColorColorCodes() {
        return false;
    }

    public Color[] getCageColor(Cage cage, HashMap legendByColor, Vector cageMice, HashMap merker) {
        if (cage.getNumberOfMice() != 0) {
            TreeSet litterCounts = new TreeSet();
            this.fillValues(cage, litterCounts, cageMice);
            Color[] erg = new Color[litterCounts.size()];
            int i = 0;
            Iterator iter = litterCounts.iterator();
            while (iter.hasNext()) {
                Integer dayKey = (Integer)iter.next();
                int day = dayKey;
                erg[i++] = day == Integer.MIN_VALUE ? NIX_COL : this.getColor(day);
            }
            return erg;
        }
        return null;
    }

    public int getValue(Cage cage, Vector cageMice) {
        return 0;
    }

    public void fillValues(Cage cage, TreeSet litterCounts, Vector cageMice) {
        Iterator iter = cageMice.iterator();
        while (iter.hasNext()) {
            Mouse mouse = (Mouse)iter.next();
            litterCounts.add(new Integer(Wurf.getWurfCount(mouse, Integer.MIN_VALUE)));
        }
    }
}

