/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.cage.colors;

import java.awt.Color;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import mausoleum.cage.Cage;
import mausoleum.cage.colors.CageColorManager;
import mausoleum.cage.colors.ColorMode;
import mausoleum.gui.ColorManager;
import mausoleum.gui.MusterColor;
import mausoleum.mouse.Mouse;

public class SexColor
extends ColorMode {
    public static final SexColor INSTANCE = new SexColor();
    private static final Color NO_SEX = CageColorManager.UNDEFINED_COLOR;
    private static final Color FEMALE_MATURE = ColorManager.getColorFromString("salmon");
    private static final Color FEMALE_NON_MATURE = ColorManager.getLighterColor(FEMALE_MATURE);
    private static final Color MALE_MATURE = ColorManager.getColorFromString("royalblue");
    private static final Color MALE_NON_MATURE = ColorManager.getLighterColor(MALE_MATURE);
    private static final Color FEMALE_MATURE_ST = SexColor.getSterileColor(FEMALE_MATURE);
    private static final Color FEMALE_NON_MATURE_ST = SexColor.getSterileColor(FEMALE_NON_MATURE);
    private static final Color MALE_MATURE_ST = SexColor.getSterileColor(MALE_MATURE);
    private static final Color MALE_NON_MATURE_ST = SexColor.getSterileColor(MALE_NON_MATURE);
    private static final Color MALE_MATURE_VE = SexColor.getVasectomizedColor(MALE_MATURE);
    private static final Color MALE_NON_MATURE_VE = SexColor.getVasectomizedColor(MALE_NON_MATURE);
    public static final Color FEMALE_VERY_LIGHT = ColorManager.getLighterColor(FEMALE_NON_MATURE);
    public static final Color MALE_VERY_LIGHT = ColorManager.getLighterColor(MALE_NON_MATURE);
    public static final Color FEMALE_EXTREME_LIGHT = ColorManager.getLighterColor(FEMALE_VERY_LIGHT);
    public static final Color MALE_EXTREME_LIGHT = ColorManager.getLighterColor(MALE_VERY_LIGHT);
    private static final Color[] ALL_MOUSE_COLORS = new Color[]{FEMALE_MATURE, FEMALE_MATURE_ST, FEMALE_NON_MATURE, FEMALE_NON_MATURE_ST, MALE_MATURE, MALE_MATURE_ST, MALE_NON_MATURE, MALE_NON_MATURE_ST, MALE_MATURE_VE, MALE_NON_MATURE_VE, NO_SEX};
    private static final Color[] TT_COLORS = new Color[]{NO_SEX, FEMALE_MATURE, FEMALE_NON_MATURE, MALE_MATURE, MALE_NON_MATURE, FEMALE_MATURE_ST, FEMALE_NON_MATURE_ST, MALE_MATURE_ST, MALE_NON_MATURE_ST, MALE_MATURE_VE, MALE_NON_MATURE_VE};
    private static final String[] TT_STRINGS = new String[]{"TT_CC_NO_SEX", "TT_CC_FEMALE_MATURE", "TT_CC_FEMALE_NON_MATURE", "TT_CC_MALE_MATURE", "TT_CC_MALE_NON_MATURE", "TT_CC_FEMALE_MATURE_STERILE", "TT_CC_FEMALE_NON_MATURE_STERILE", "TT_CC_MALE_MATURE_STERILE", "TT_CC_MALE_NON_MATURE_STERILE", "TT_CC_MALE_MATURE_VASECTOMIZED", "TT_CC_MALE_NON_MATURE_VASECTOMIZED"};
    private static final Color[] TT_COLORS_FOR_HTML;
    private static final String[] TT_STRINGS_FOR_HTML;

    static {
        Color[] colorArray = new Color[6];
        colorArray[0] = NO_SEX;
        colorArray[1] = FEMALE_MATURE;
        colorArray[2] = FEMALE_NON_MATURE;
        colorArray[3] = MALE_MATURE;
        colorArray[4] = MALE_NON_MATURE;
        TT_COLORS_FOR_HTML = colorArray;
        TT_STRINGS_FOR_HTML = new String[]{"TT_CC_NO_SEX", "TT_CC_FEMALE_MATURE", "TT_CC_FEMALE_NON_MATURE", "TT_CC_MALE_MATURE", "TT_CC_MALE_NON_MATURE", "TT_CC_STERILE_HATCH"};
    }

    public static Color getColor(Mouse mouse) {
        int sex = mouse.getSex();
        int sexVariant = mouse.getSexVariant(0);
        if (sex == 1) {
            boolean act = mouse.isSexActive();
            switch (sexVariant) {
                case 128: {
                    return act ? MALE_MATURE_ST : MALE_NON_MATURE_ST;
                }
                case 64: {
                    return act ? MALE_MATURE_VE : MALE_NON_MATURE_VE;
                }
            }
            return act ? MALE_MATURE : MALE_NON_MATURE;
        }
        if (sex == 2) {
            if (mouse.isSexActive()) {
                return sexVariant != 0 ? FEMALE_MATURE_ST : FEMALE_MATURE;
            }
            return sexVariant != 0 ? FEMALE_NON_MATURE_ST : FEMALE_NON_MATURE;
        }
        return NO_SEX;
    }

    private static MusterColor getSterileColor(Color orig) {
        return new MusterColor(Color.black, orig, 2);
    }

    private static MusterColor getVasectomizedColor(Color orig) {
        return new MusterColor(Color.black, orig, 15);
    }

    public Color[] getColorsForDefaultLegend() {
        return TT_COLORS;
    }

    public String[] getStringsForDefaultLegend() {
        return this.getBabelisierteTooltips(TT_STRINGS);
    }

    public String getInnerTooltip() {
        return SexColor.createHTML(TT_COLORS_FOR_HTML, TT_STRINGS_FOR_HTML, true, 0);
    }

    public Color[] getCageColor(Cage cage, HashMap legendByColor, Vector cageMice, HashMap merker) {
        Color[] res = null;
        HashSet<Color> colHT = new HashSet<Color>();
        Iterator iter = cageMice.iterator();
        while (iter.hasNext()) {
            Mouse mouse = (Mouse)iter.next();
            colHT.add(SexColor.getColor(mouse));
        }
        if (colHT.size() != 0) {
            res = new Color[colHT.size()];
            int pos = 0;
            int i = 0;
            while (i < ALL_MOUSE_COLORS.length) {
                if (colHT.contains(ALL_MOUSE_COLORS[i])) {
                    res[pos++] = ALL_MOUSE_COLORS[i];
                }
                ++i;
            }
        }
        return res;
    }

    public boolean hasVaryingColorColorCodes() {
        return false;
    }
}

