/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.cage.colors;

import de.hannse.netobjects.objectstore.IndexObject;
import de.hannse.netobjects.objectstore.ObjectStore;
import de.hannse.netobjects.util.Babel;
import java.awt.Color;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import mausoleum.cage.Cage;
import mausoleum.cage.colors.CageColorManager;
import mausoleum.cage.colors.MultiColorMode;
import mausoleum.mouse.Mouse;
import mausoleum.strain.Strain;
import mausoleum.ui.UIDef;

public class StrainColor
extends MultiColorMode {
    public static final StrainColor INSTANCE = new StrainColor();

    public String getInnerTooltip() {
        return Babel.get("TT_CC_STRAINS");
    }

    public void fillColors(Cage cage, HashSet colors, HashMap legendsByColor, Vector cageMice, HashMap merker) {
        Iterator iter = cageMice.iterator();
        while (iter.hasNext()) {
            Color c = this.getColorForMouse((Mouse)iter.next(), legendsByColor);
            if (c == null) continue;
            colors.add(c);
        }
    }

    public Color getColorForMouse(Mouse m, HashMap legendsByColor) {
        Color c = null;
        if (m != null) {
            IndexObject[] ioarr = (IndexObject[])m.get("MOS_STRAIN");
            if (ioarr != null) {
                double rsum = 0.0;
                double gsum = 0.0;
                double bsum = 0.0;
                double anteilSum = 0.0;
                int j = 0;
                while (j < ioarr.length) {
                    Strain strain = (Strain)ObjectStore.getObjectDeadOrAlive(8, ioarr[j].ivObjectID, m.getGroup(), null, false);
                    if (strain != null) {
                        double a = ioarr[j].ivNumber;
                        anteilSum += a;
                        Color sc = (Color)strain.get("STR_COLOR", UIDef.OBJECT_DEFAULT_COLOR);
                        rsum += a * (double)sc.getRed();
                        gsum += a * (double)sc.getGreen();
                        bsum += a * (double)sc.getBlue();
                    }
                    ++j;
                }
                c = new Color((int)(rsum / anteilSum), (int)(gsum / anteilSum), (int)(bsum / anteilSum));
                if (legendsByColor != null) {
                    StrainColor.manageLegend(c, m.getCLLWStrainString(true, true, true), legendsByColor);
                }
            } else {
                c = CageColorManager.NULL_COLOR;
                if (legendsByColor != null) {
                    StrainColor.manageLegend(c, Babel.get("NOSTRAINASSIGNED"), legendsByColor);
                }
            }
        }
        return c;
    }

    public boolean hasVaryingColorColorCodes() {
        return true;
    }

    public Color[] getColorsForDefaultLegend() {
        return null;
    }

    public String[] getStringsForDefaultLegend() {
        return null;
    }
}

