/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.cage.colors;

import java.awt.Color;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import mausoleum.cage.Cage;
import mausoleum.cage.colors.CageColorManager;
import mausoleum.cage.colors.ColorMode;
import mausoleum.mouse.Mouse;
import mausoleum.result.MResult;

public class SymptomColor
extends ColorMode {
    public static final int NO_SYMPTOM_INT = 1;
    public static final int HAS_SYMPTOM_INT = 2;
    public static final int HAS_OB_SYMPTOM_INT = 3;
    private static final Color NO_SYMPTOM = CageColorManager.UNDEFINED_COLOR;
    private static final Color SYMPTOM = Color.red;
    private static final Color SYMPTOM_OB = Color.green;
    private static final Color[] ARR_NIX = new Color[]{NO_SYMPTOM};
    private static final Color[] ARR_HAS = new Color[]{SYMPTOM};
    private static final Color[] ARR_HAS_OB = new Color[]{SYMPTOM_OB};
    private static final Color[] ARR_NO_HAS = new Color[]{NO_SYMPTOM, SYMPTOM};
    private static final Color[] ARR_NO_HAS_OB = new Color[]{NO_SYMPTOM, SYMPTOM_OB};
    private static final Color[] ARR_HAS_HAS_OB = new Color[]{SYMPTOM, SYMPTOM_OB};
    private static final Color[] ARR_ALL = new Color[]{NO_SYMPTOM, SYMPTOM, SYMPTOM_OB};
    public static final SymptomColor INSTANCE = new SymptomColor();
    private static final Color[] TT_COLORS = new Color[]{NO_SYMPTOM, SYMPTOM, SYMPTOM_OB};
    private static final String[] TT_STRINGS = new String[]{"TT_CC_NO_SYMPTOM", "TT_CC_SYMPTOM", "TT_CC_SYMPTOM_OB"};

    public String getInnerTooltip() {
        return SymptomColor.createHTML(TT_COLORS, TT_STRINGS, true, 0);
    }

    public Color[] getColorsForDefaultLegend() {
        return TT_COLORS;
    }

    public String[] getStringsForDefaultLegend() {
        return this.getBabelisierteTooltips(TT_STRINGS);
    }

    public static Color getBackgroundColorForMouse(Mouse mouse) {
        switch (MResult.getSymptomListType(mouse)) {
            case 2: {
                return SYMPTOM;
            }
            case 3: {
                return SYMPTOM_OB;
            }
        }
        return null;
    }

    public Color[] getCageColor(Cage cage, HashMap legendByColor, Vector cageMice, HashMap merker) {
        boolean noSyptom = false;
        boolean hasSyptom = false;
        boolean hasOBSyptom = false;
        Iterator iter = cageMice.iterator();
        while (iter.hasNext()) {
            int res = MResult.getSymptomListType((Mouse)iter.next());
            noSyptom |= res == 1;
            hasSyptom |= res == 2;
            hasOBSyptom |= res == 3;
        }
        if (noSyptom && hasSyptom && hasOBSyptom) {
            return ARR_ALL;
        }
        if (!noSyptom && hasSyptom && hasOBSyptom) {
            return ARR_HAS_HAS_OB;
        }
        if (noSyptom && !hasSyptom && hasOBSyptom) {
            return ARR_NO_HAS_OB;
        }
        if (noSyptom && hasSyptom && !hasOBSyptom) {
            return ARR_NO_HAS;
        }
        if (!noSyptom && !hasSyptom && hasOBSyptom) {
            return ARR_HAS_OB;
        }
        if (!noSyptom && hasSyptom && !hasOBSyptom) {
            return ARR_HAS;
        }
        return ARR_NIX;
    }

    public boolean hasVaryingColorColorCodes() {
        return false;
    }
}

