/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.cage.colors;

import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.objectstore.ObjectStore;
import de.hannse.netobjects.util.Babel;
import java.awt.Color;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import mausoleum.cage.Cage;
import mausoleum.cage.colors.CageColorManager;
import mausoleum.cage.colors.MultiColorMode;
import mausoleum.mouse.Mouse;
import mausoleum.ui.UIDef;

public class UserColor
extends MultiColorMode {
    public static final UserColor INSTANCE = new UserColor();
    private static final Long THS_KEY = new Long(-1L);

    public String getInnerTooltip() {
        return Babel.get("TT_CC_USERS");
    }

    public void fillColors(Cage cage, HashSet colors, HashMap legendsByColor, Vector cageMice, HashMap merker) {
        String group = cage.getGroup();
        HashSet ths = null;
        if (merker != null) {
            ths = (HashSet)merker.get(THS_KEY);
            if (ths == null) {
                ths = new HashSet();
                merker.put(THS_KEY, ths);
            }
            ths.clear();
        }
        Iterator iter = cageMice.iterator();
        while (iter.hasNext()) {
            Mouse mouse = (Mouse)iter.next();
            long[] owners = (long[])mouse.get("MOS_OWNER");
            long[] ownerGroups = (long[])mouse.get("MOS_OWNERGROUPS");
            if (owners == null && ownerGroups == null) {
                colors.add(CageColorManager.NULL_COLOR);
                continue;
            }
            if (merker != null) {
                UserColor.manageArrayWithMerker(owners, ths, merker, colors, legendsByColor, 6, "USR_COLOR", group, 0L);
                UserColor.manageArrayWithMerker(ownerGroups, ths, merker, colors, legendsByColor, 19, "IOG_COL", group, 1000000L);
                continue;
            }
            UserColor.manageArray(owners, 6, group, "USR_COLOR", colors, legendsByColor);
            UserColor.manageArray(ownerGroups, 19, group, "IOG_COL", colors, legendsByColor);
        }
    }

    private static void manageArrayWithMerker(long[] arr, HashSet ths, HashMap merker, HashSet colors, HashMap legendsByColor, int type, String tag, String group, long aufschlag) {
        if (arr != null && arr.length != 0) {
            int i = 0;
            while (i < arr.length) {
                Long key;
                if (arr[i] > 0L && !ths.contains(key = new Long(aufschlag + arr[i]))) {
                    ths.add(key);
                    Color col = (Color)merker.get(key);
                    if (col == null) {
                        merker.put(key, UserColor.manageSingle(arr[i], type, group, tag, colors, legendsByColor));
                    } else {
                        colors.add(col);
                    }
                }
                ++i;
            }
        }
    }

    private static void manageArray(long[] arr, int type, String group, String colorTag, HashSet colors, HashMap legendsByColor) {
        if (arr != null && arr.length != 0) {
            int j = 0;
            while (j < arr.length) {
                UserColor.manageSingle(arr[j], type, group, colorTag, colors, legendsByColor);
                ++j;
            }
        }
    }

    private static Color manageSingle(long id, int type, String group, String colorTag, HashSet colors, HashMap legendsByColor) {
        Color ownerColor;
        IDObject colorOwner = ObjectStore.getObjectDeadOrAlive(type, id, group, null, true);
        Color color = ownerColor = colorOwner == null ? null : (Color)colorOwner.get(colorTag);
        if (colorOwner != null && legendsByColor != null) {
            UserColor.manageLegend(ownerColor, String.valueOf(colorOwner.getBrowseName()) + " [" + colorOwner.getGroup() + "]", legendsByColor);
        }
        if (ownerColor == null) {
            ownerColor = UIDef.OBJECT_DEFAULT_COLOR;
        }
        colors.add(ownerColor);
        return ownerColor;
    }

    public boolean hasVaryingColorColorCodes() {
        return true;
    }

    public Color[] getColorsForDefaultLegend() {
        return null;
    }

    public String[] getStringsForDefaultLegend() {
        return null;
    }
}

