/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.dataimport;

import de.hannse.netobjects.objectstore.IndexObject;
import java.awt.Color;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import jxl.Cell;
import jxl.CellType;
import jxl.Sheet;
import mausoleum.dataimport.DataImporter;
import mausoleum.helper.DatumsParser;
import mausoleum.helper.Zeile;

public abstract class DIHelper {
    public static HashMap firstRowDefs(Sheet sheet, HashSet possibles, HashSet musts, StringBuffer bruddel) {
        HashMap<String, Integer> res = new HashMap<String, Integer>();
        Cell[] firstRow = sheet.getRow(0);
        if (firstRow != null && firstRow.length != 0) {
            int i = 0;
            while (i < firstRow.length) {
                String name = firstRow[i].getContents().toUpperCase().trim();
                if (possibles.contains(name)) {
                    res.put(name, new Integer(i));
                }
                ++i;
            }
        }
        Iterator iter = musts.iterator();
        while (iter.hasNext()) {
            String must = (String)iter.next();
            if (res.containsKey(must)) continue;
            bruddel.append("Sheet <" + sheet.getName() + ">: Mandatory column " + must + " not found\r\n");
        }
        return res;
    }

    public static HashMap collectOneRow(Sheet sheet, int row, HashMap colDefs, HashSet musts, StringBuffer bruddel) {
        HashMap<String, String> res = new HashMap<String, String>();
        Cell[] cells = sheet.getRow(row);
        if (cells != null && cells.length != 0) {
            Iterator iter = colDefs.keySet().iterator();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                Integer col = (Integer)colDefs.get(key);
                String val = DIHelper.getContent(sheet, cells, col, null);
                if (val == null) continue;
                res.put(key, val);
            }
        }
        if (!res.isEmpty()) {
            boolean mustMissing = false;
            Iterator iter = musts.iterator();
            while (iter.hasNext()) {
                String must = (String)iter.next();
                if (res.containsKey(must)) continue;
                bruddel.append("Sheet <" + sheet.getName() + "> row:" + (row + 1) + " Mandatory value " + must + " not found\r\n");
                mustMissing = true;
            }
            if (mustMissing) {
                res.clear();
            }
        }
        return res;
    }

    private static String getContent(Sheet sheet, Cell[] cells, int col, String defVal) {
        String s;
        if (col >= 0 && col < cells.length && cells[col] != null && cells[col].getType() != CellType.ERROR && (s = cells[col].getContents()) != null && (s = s.trim()).length() != 0) {
            return s;
        }
        return defVal;
    }

    public static void polishHashMap(HashMap hm, String[] dict) {
        int i = 0;
        while (i < dict.length) {
            if (hm.get(dict[i]) != null) {
                hm.put(dict[i + 1], hm.get(dict[i]));
                hm.remove(dict[i]);
            }
            i += 2;
        }
    }

    public static boolean polishToStringArray(HashMap hm, String srcTag, String targetTag, char trenner, Sheet sheet, int row, DataImporter di) {
        String s = (String)hm.get(srcTag);
        String[] arr = null;
        if (s != null && (s = s.trim()).length() != 0) {
            arr = new Zeile(s, trenner).toStringArray(null, false);
        }
        if (arr == null) {
            di.ivBruddel.append("Sheet <" + sheet.getName() + "> row:" + (row + 1) + " Missing or malformed definition <" + s + ">\r\n");
            return false;
        }
        hm.put(targetTag, arr);
        hm.remove(srcTag);
        return true;
    }

    public static boolean polishToColor(HashMap hm, String srcTag, String targetTag, char trenner, Sheet sheet, int row, DataImporter di) {
        String s = (String)hm.get(srcTag);
        Color col = null;
        if (s != null && (s = s.trim()).length() != 0) {
            String[] arr = new Zeile(s, trenner).toStringArray(null, false);
            if (arr == null || arr.length != 3) {
                di.ivBruddel.append("Sheet <" + sheet.getName() + "> row:" + (row + 1) + "  Malformed (missing columns) color definition <" + s + ">\r\n");
                return false;
            }
            try {
                col = new Color(Integer.parseInt(arr[0]), Integer.parseInt(arr[1]), Integer.parseInt(arr[2]));
            }
            catch (Exception e) {
                di.ivBruddel.append("Sheet <" + sheet.getName() + "> row:" + (row + 1) + "  Malformed (not integer) color definition <" + s + ">\r\n");
                return false;
            }
        }
        if (col != null) {
            hm.put(targetTag, col);
        }
        hm.remove(srcTag);
        return true;
    }

    public static boolean polishToDate(HashMap hm, String srcTag, String targetTag, Sheet sheet, int row, DataImporter di) {
        String s = (String)hm.get(srcTag);
        Date date = null;
        if (s != null && (s = s.trim()).length() != 0) {
            try {
                date = new Date((long)DatumsParser.getDatum(s) * 86400000L);
            }
            catch (Exception e) {
                di.ivBruddel.append("Sheet <" + sheet.getName() + "> row:" + (row + 1) + "  Malformed date definition <" + s + ">\r\n");
                return false;
            }
        }
        if (date != null) {
            hm.put(targetTag, date);
        }
        hm.remove(srcTag);
        return true;
    }

    public static boolean polishToInt(HashMap hm, String srcTag, String targetTag, Sheet sheet, int row, DataImporter di, Integer nullVal) {
        String s = (String)hm.get(srcTag);
        if (s != null) {
            try {
                Integer wert = new Integer(s);
                if (nullVal == null || !nullVal.equals(wert)) {
                    hm.put(targetTag, wert);
                }
            }
            catch (Exception e) {
                di.ivBruddel.append("Sheet <" + sheet.getName() + "> row:" + (row + 1) + " col: " + srcTag + " Malformed definition <" + s + ">\r\n");
                return false;
            }
        }
        hm.remove(srcTag);
        return true;
    }

    public static boolean getIntegerFromString(HashMap hm, Object[] dict, String srcTag, String targetTag, Sheet sheet, int row, DataImporter di) {
        String s = (String)hm.get(srcTag);
        hm.remove(srcTag);
        if (s != null) {
            s = s.toLowerCase().trim();
            int i = 0;
            while (i < dict.length) {
                if (((HashSet)dict[i + 1]).contains(s)) {
                    hm.put(targetTag, dict[i]);
                    return true;
                }
                i += 2;
            }
            di.ivBruddel.append("Sheet <" + sheet.getName() + "> row:" + (row + 1) + " col: " + srcTag + " Malformed definition <" + s + ">\r\n");
            return false;
        }
        return true;
    }

    public static boolean getSingleObjectsReference(HashMap hm, String srcTag, String targetTag, Integer objectType, Sheet sheet, int row, DataImporter di) {
        boolean res = true;
        String s = (String)hm.get(srcTag);
        if (s != null) {
            HashMap targetObject = di.getObject(objectType, s);
            if (targetObject != null && !targetObject.isEmpty()) {
                hm.put(targetTag, targetObject.get("IDO_ID"));
            } else {
                di.ivBruddel.append("Sheet <" + sheet.getName() + "> row:" + (row + 1) + " <" + srcTag + "> definition without matching object\r\n");
                res = false;
            }
        }
        hm.remove(srcTag);
        return res;
    }

    public static boolean getObjectsLongArrayReference(HashMap hm, String srcTag, String targetTag, Integer objectType, Sheet sheet, int row, DataImporter di) {
        boolean res = true;
        String s = (String)hm.get(srcTag);
        if (s != null) {
            Zeile z = new Zeile(s, '|');
            Vector objects = new Vector(z.size());
            int i = 0;
            while (i < z.size()) {
                String id = z.getStringNONEmpty(i, null);
                if (id != null) {
                    HashMap targetObject = di.getObject(objectType, s);
                    if (targetObject != null && !targetObject.isEmpty()) {
                        objects.add(targetObject.get("IDO_ID"));
                    } else {
                        di.ivBruddel.append("Sheet <" + sheet.getName() + "> row:" + (row + 1) + " <" + srcTag + "> definition without matching object\r\n");
                        res = false;
                    }
                }
                ++i;
            }
            if (!objects.isEmpty()) {
                long[] arr = new long[objects.size()];
                int i2 = 0;
                while (i2 < arr.length) {
                    Long idl = (Long)objects.elementAt(i2);
                    arr[i2] = idl;
                    ++i2;
                }
                hm.put(targetTag, arr);
            }
        }
        hm.remove(srcTag);
        return res;
    }

    public static boolean getStrainReference(HashMap hm, String srcTag, String targetTag, Integer objectType, Sheet sheet, int row, DataImporter di) {
        boolean res = true;
        String s = (String)hm.get(srcTag);
        if (s != null) {
            Zeile z = new Zeile(s, '|');
            Vector<IndexObject> objects = new Vector<IndexObject>(z.size());
            int i = 0;
            while (i < z.size()) {
                String id = z.getStringNONEmpty(i, null);
                if (id != null) {
                    IndexObject indo = DIHelper.getStrainObject(id, objectType, srcTag, sheet, row, di);
                    if (indo != null) {
                        objects.add(indo);
                    } else {
                        di.ivBruddel.append("Sheet <" + sheet.getName() + "> row:" + (row + 1) + " <" + srcTag + "> definition without matching object\r\n");
                        res = false;
                    }
                }
                ++i;
            }
            if (!objects.isEmpty()) {
                IndexObject[] arr = new IndexObject[objects.size()];
                int i2 = 0;
                while (i2 < arr.length) {
                    arr[i2] = (IndexObject)objects.elementAt(i2);
                    ++i2;
                }
                hm.put(targetTag, arr);
            }
        }
        hm.remove(srcTag);
        return res;
    }

    private static IndexObject getStrainObject(String s, Integer objectType, String srcTag, Sheet sheet, int row, DataImporter di) {
        block8: {
            try {
                String foreignID = null;
                double val = 1.0;
                int ind = s.indexOf(";");
                if (ind == -1) {
                    foreignID = s;
                } else {
                    foreignID = s.substring(0, ind).trim();
                    double div = 1.0;
                    String vals = s.substring(ind + 1, s.length()).trim();
                    if (vals.endsWith("%")) {
                        vals = vals.substring(0, vals.length() - 1);
                        div = 100.0;
                    }
                    vals = vals.replaceAll(",", ".");
                    try {
                        val = Double.parseDouble(vals) / div;
                    }
                    catch (Exception e) {
                        val = Double.NaN;
                    }
                }
                if (foreignID == null || Double.isNaN(val)) break block8;
                HashMap strain = di.getObject(objectType, foreignID);
                if (strain == null) {
                    di.ivBruddel.append("Sheet <" + sheet.getName() + "> row:" + (row + 1) + " <" + srcTag + "> unknown strain <" + foreignID + ">\r\n");
                    break block8;
                }
                return new IndexObject(8, (Long)strain.get("IDO_ID"), val);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }
}

