/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.dataimport;

import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import jxl.Sheet;
import mausoleum.dataimport.DIHelper;
import mausoleum.dataimport.DISheetImporter;
import mausoleum.dataimport.DataImporter;

public class DISCage
implements DISheetImporter {
    private static final String NAME = "cages";
    private static final String TAG_ID = "FOREIGN_ID";
    private static final String TAG_START = "START_DATE";
    private static final String TAG_END = "END_DATE";
    private static final String TAG_NUMBER = "CAGE_NUMBER";
    private static final String TAG_TAG = "TAG";
    private static final HashSet POSSIBLES = new HashSet<String>(Arrays.asList("FOREIGN_ID", "START_DATE", "END_DATE", "CAGE_NUMBER", "TAG"));
    private static final HashSet MUSTS = new HashSet<String>(Arrays.asList("FOREIGN_ID", "START_DATE"));
    private static String[] DICT = new String[]{"FOREIGN_ID", "IDO_FKEY"};
    private static final Integer MY_TYPE = new Integer(2);

    public HashSet getMusts() {
        return MUSTS;
    }

    public Integer getObjectType() {
        return MY_TYPE;
    }

    public String[] getPolishDict() {
        return DICT;
    }

    public HashSet getPossibles() {
        return POSSIBLES;
    }

    public String[] getSheetNames() {
        return new String[]{NAME};
    }

    public boolean ownPolish(HashMap hm, DataImporter di, Sheet sheet, int row) {
        boolean res = true;
        res &= DIHelper.polishToDate(hm, TAG_START, "IDO_START_DATE", sheet, row, di);
        res &= DIHelper.polishToDate(hm, TAG_END, "IDO_END_DATE", sheet, row, di);
        Date startDate = (Date)hm.get("IDO_START_DATE");
        Date endDate = (Date)hm.get("IDO_END_DATE");
        if (startDate == null) {
            di.ivBruddel.append("Sheet <" + sheet.getName() + "> row:" + (row + 1) + "  Missing Startdate definition\r\n");
            res = false;
        } else if (endDate != null && startDate.getTime() > endDate.getTime()) {
            di.ivBruddel.append("Sheet <" + sheet.getName() + "> row:" + (row + 1) + "  Enddate is before Startdate definition\r\n");
            res = false;
        }
        res &= DIHelper.polishToInt(hm, TAG_NUMBER, "CAG_PSEUDOID", sheet, row, di, null);
        String s = (String)hm.get(TAG_TAG);
        if (s != null) {
            hm.put("CAG_ANTAG", s);
            hm.remove(TAG_TAG);
        }
        return res;
    }

    public boolean check(DataImporter di) {
        return true;
    }
}

