/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.dataimport;

import de.hannse.netobjects.util.ArrayHelper;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import jxl.Sheet;
import mausoleum.dataimport.DIHelper;
import mausoleum.dataimport.DISheetImporter;
import mausoleum.dataimport.DataImporter;
import mausoleum.helper.Zeile;
import mausoleum.locus.LocusAndAlleles;

public class DISLine
implements DISheetImporter {
    private static final String NAME = "lines";
    public static final String TAG_ID = "FOREIGN_ID";
    private static final String TAG_NAME = "NAME";
    private static final String TAG_COLOR = "COLOR";
    private static final String TAG_LOCI = "LOCI";
    private static final String TAG_COMMENT = "COMMENT";
    private static final HashSet POSSIBLES = new HashSet<String>(Arrays.asList("FOREIGN_ID", "NAME", "COLOR", "LOCI", "COMMENT"));
    private static final HashSet MUSTS = new HashSet<String>(Arrays.asList("FOREIGN_ID", "NAME", "LOCI"));
    private static String[] DICT = new String[]{"FOREIGN_ID", "IDO_FKEY", "NAME", "LIN_NAME", "COMMENT", "LIN_DESCRIPTION"};
    private static final Integer MY_TYPE = new Integer(7);
    private static final Integer LOCUS_TYPE = new Integer(14);

    public HashSet getMusts() {
        return MUSTS;
    }

    public Integer getObjectType() {
        return MY_TYPE;
    }

    public String[] getPolishDict() {
        return DICT;
    }

    public HashSet getPossibles() {
        return POSSIBLES;
    }

    public String[] getSheetNames() {
        return new String[]{NAME};
    }

    public boolean ownPolish(HashMap hm, DataImporter di, Sheet sheet, int row) {
        boolean res = true;
        String s = (String)hm.get(TAG_LOCI);
        if (s != null) {
            HashMap<Long, String[]> lals = new HashMap<Long, String[]>();
            boolean alleLociDefined = true;
            Zeile z1 = new Zeile(s, '|');
            int i = 0;
            while (i < z1.size()) {
                String sl = z1.getStringNONEmpty(i, null);
                if (sl != null) {
                    Zeile z2 = new Zeile(sl, ';');
                    if (z2.size() > 1) {
                        String locusForeignID = z2.getString(0, "");
                        HashMap locus = di.getObject(LOCUS_TYPE, locusForeignID);
                        if (locus != null) {
                            Long locusID = (Long)locus.get("IDO_ID");
                            boolean alleAlleleDefined = true;
                            Object[] locAlleles = (String[])locus.get("LOC_ALLELES");
                            if (locAlleles != null) {
                                String[] alleles = new String[z2.size() - 1];
                                int j = 1;
                                while (j < z2.size()) {
                                    alleles[j - 1] = z2.getStringNONEmpty(j, null);
                                    if (alleles[j - 1] != null) {
                                        this.specAllelCheck(locusForeignID, alleles, j - 1, (String[])locAlleles);
                                        if (!ArrayHelper.contained(alleles[j - 1], locAlleles)) {
                                            di.ivBruddel.append("Sheet <" + sheet.getName() + "> row:" + (row + 1) + "  Allele <" + alleles[j - 1] + "> not defined in locus [" + locus + "]\r\n");
                                            res = false;
                                            alleAlleleDefined = false;
                                        }
                                    } else {
                                        di.ivBruddel.append("Sheet <" + sheet.getName() + "> row:" + (row + 1) + "  Empty allele definition <" + locusForeignID + ">\r\n");
                                        res = false;
                                        alleAlleleDefined = false;
                                    }
                                    ++j;
                                }
                                if (alleAlleleDefined) {
                                    lals.put(locusID, alleles);
                                } else {
                                    alleLociDefined = false;
                                }
                            } else {
                                di.ivBruddel.append("Sheet <" + sheet.getName() + "> row:" + (row + 1) + "  Locus without alleles <" + locusForeignID + ">\r\n");
                                res = false;
                                alleLociDefined = false;
                            }
                        } else {
                            di.ivBruddel.append("Sheet <" + sheet.getName() + "> row:" + (row + 1) + "  Unknown locus definition <" + locusForeignID + ">\r\n");
                            res = false;
                            alleLociDefined = false;
                        }
                    } else {
                        di.ivBruddel.append("Sheet <" + sheet.getName() + "> row:" + (row + 1) + "  Unsufficient locus definition <" + sl + ">\r\n");
                        res = false;
                        alleLociDefined = false;
                    }
                } else {
                    di.ivBruddel.append("Sheet <" + sheet.getName() + "> row:" + (row + 1) + "  Empty locus definition <" + sl + ">\r\n");
                    res = false;
                    alleLociDefined = false;
                }
                ++i;
            }
            if (!lals.isEmpty() && alleLociDefined) {
                LocusAndAlleles[] lalarr = new LocusAndAlleles[lals.size()];
                int pos = 0;
                Iterator iter = lals.keySet().iterator();
                while (iter.hasNext()) {
                    Long locusID = (Long)iter.next();
                    String[] allels = (String[])lals.get(locusID);
                    lalarr[pos++] = new LocusAndAlleles((long)locusID, allels);
                }
                hm.put("LIN_LOCIALLELES", lalarr);
            }
        } else {
            di.ivBruddel.append("Sheet <" + sheet.getName() + "> row:" + (row + 1) + "  Missing loci definition\r\n");
            res = false;
        }
        hm.remove(TAG_LOCI);
        if (res) {
            hm.put("LIN_CHANGE", new Boolean(true));
            res &= DIHelper.polishToColor(hm, TAG_COLOR, "LIN_COLOR", '|', sheet, row, di);
        }
        return res;
    }

    public void specAllelCheck(String locusForeignID, String[] alleles, int pos, String[] locAlleles) {
    }

    public boolean check(DataImporter di) {
        return true;
    }
}

