/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.dataimport;

import de.hannse.netobjects.util.Log;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import jxl.Sheet;
import mausoleum.dataimport.DIHelper;
import mausoleum.dataimport.DISheetImporter;
import mausoleum.dataimport.DataImporter;
import mausoleum.mouse.Mouse;

public class DISMouseLimes
implements DISheetImporter {
    private static final String NAME = "mice";
    public static final String TAG_ID = "FOREIGN_ID";
    public static final String TAG_EARTAG = "EARTAG";
    public static final String TAG_EARTAG_PREFIX = "EARTAG_PREFIX";
    public static final String TAG_SEX = "SEX";
    public static final String TAG_FATHER = "FATHER";
    public static final String TAG_MOTHER = "MOTHER";
    public static final String TAG_START_DATE = "START_DATE";
    public static final String TAG_START_MODE = "START_MODE";
    public static final String TAG_END_DATE = "END_DATE";
    public static final String TAG_END_MODE = "END_MODE";
    public static final String TAG_COAT_COLOR = "COAT_COLOR";
    public static final String TAG_STRAIN = "STRAIN";
    public static final String TAG_LINE = "LINE";
    public static final String TAG_GENOTYPE = "GENOTYPE";
    public static final String TAG_OWNERS = "OWNERS";
    public static final String TAG_GENERATION = "GENERATION";
    public static final String TAG_COMMENT = "COMMENT";
    public static final String TAG_ANTAG = "ANTAG";
    public static final String TAG_GROUP = "GROUP";
    public static final String TAG_RACK_POSITION = "RACK_POSITION";
    private static final HashSet POSSIBLES = new HashSet<String>(Arrays.asList("FOREIGN_ID", "EARTAG", "EARTAG_PREFIX", "SEX", "FATHER", "MOTHER", "START_DATE", "START_MODE", "END_DATE", "END_MODE", "COAT_COLOR", "STRAIN", "LINE", "GENOTYPE", "OWNERS", "GENERATION", "COMMENT", "ANTAG", "GROUP", "RACK_POSITION"));
    private static final HashSet MUSTS = new HashSet<String>(Arrays.asList("FOREIGN_ID", "START_DATE", "START_MODE"));
    private static String[] DICT = new String[]{"FOREIGN_ID", "IDO_FKEY", "COMMENT", "MOS_COMMENT", "ANTAG", "MOS_ANTAG", "EARTAG_PREFIX", "MOS_ETPF"};
    private static final Integer BIRTH = new Integer(1);
    private static Object[] SEX_MODE_DICT = new Object[]{new Integer(1), new HashSet<String>(Arrays.asList("male", "m", "maennchen", "bock", "mann")), new Integer(2), new HashSet<String>(Arrays.asList("female", "f", "w", "weibchen", "frau"))};
    private static Object[] START_MODE_DICT = new Object[]{new Integer(1), new HashSet<String>(Arrays.asList("birth", "b", "geburt")), new Integer(3), new HashSet<String>(Arrays.asList("import", "i"))};
    private static Object[] END_MODE_DICT = new Object[]{new Integer(4), new HashSet<String>(Arrays.asList("death", "d", "tod")), new Integer(6), new HashSet<String>(Arrays.asList("export", "x")), new Integer(5), new HashSet<String>(Arrays.asList("sacrifice", "s", "experiment"))};
    private static Object[] COAT_COLOR_DICT = new Object[]{new Integer(1), new HashSet<String>(Arrays.asList("black", "bl", "schwarz")), new Integer(9), new HashSet<String>(Arrays.asList("agouti", "ag", "a")), new Integer(4), new HashSet<String>(Arrays.asList("brown", "br", "braun")), new Integer(5), new HashSet<String>(Arrays.asList("dark brown", "dbr", "dunkelbraun")), new Integer(8), new HashSet<String>(Arrays.asList("dark gray", "dark grey", "dgr", "dunkelgrau")), new Integer(7), new HashSet<String>(Arrays.asList("gray", "grey", "gr", "grau")), new Integer(3), new HashSet<String>(Arrays.asList("light brown", "lbr", "hellbraun", "hbr")), new Integer(6), new HashSet<String>(Arrays.asList("light gray", "light grey", "lgr", "hellgrau", "hgr")), new Integer(2), new HashSet<String>(Arrays.asList("white", "w", "wei\u00df", "weiss")), new Integer(10), new HashSet<String>(Arrays.asList("chimaera", "chim", "chim\u00e4r", "chimaer"))};
    private static final Integer MY_TYPE = new Integer(1);
    private static final Integer NULL_INT = new Integer(0);

    public HashSet getMusts() {
        return MUSTS;
    }

    public Integer getObjectType() {
        return MY_TYPE;
    }

    public String[] getPolishDict() {
        return DICT;
    }

    public HashSet getPossibles() {
        return POSSIBLES;
    }

    public String[] getSheetNames() {
        return new String[]{NAME, "mice1", "mice2", "mice3", "mice4", "mice5", "mice6", "mice7"};
    }

    public boolean ownPolish(HashMap hm, DataImporter di, Sheet sheet, int row) {
        boolean res = true;
        res &= DIHelper.polishToInt(hm, TAG_EARTAG, "MOS_EARTAG", sheet, row, di, NULL_INT);
        res &= DIHelper.getIntegerFromString(hm, SEX_MODE_DICT, TAG_SEX, Mouse.getSexTag(), sheet, row, di);
        res &= DIHelper.polishToDate(hm, TAG_START_DATE, "IDO_START_DATE", sheet, row, di);
        if (hm.get("IDO_START_DATE") != null && (res &= DIHelper.getIntegerFromString(hm, START_MODE_DICT, TAG_START_MODE, "MOS_STARTMODE", sheet, row, di)) && BIRTH.equals(hm.get("MOS_STARTMODE"))) {
            hm.put("MOS_BIRTHDAY", hm.get("IDO_START_DATE"));
        }
        res &= DIHelper.polishToDate(hm, TAG_END_DATE, "IDO_END_DATE", sheet, row, di);
        if (hm.get("IDO_END_DATE") != null) {
            res &= DIHelper.getIntegerFromString(hm, END_MODE_DICT, TAG_END_MODE, "MOS_ENDMODE", sheet, row, di);
            if (hm.get("MOS_ENDMODE") == null) {
                hm.put("MOS_ENDMODE", new Integer(4));
            }
        }
        hm.remove(TAG_END_MODE);
        res &= DIHelper.getIntegerFromString(hm, COAT_COLOR_DICT, TAG_COAT_COLOR, "MOS_COAT_COLOR", sheet, row, di);
        String genS = (String)hm.get(TAG_GENERATION);
        if (genS != null) {
            int ind = genS.indexOf(" ");
            if (ind != -1) {
                genS = genS.substring(0, ind).trim();
            }
            int plus = 0;
            if (genS.startsWith("F")) {
                plus = 1;
                genS = genS.substring(1, genS.length());
            } else if (!Character.isDigit(genS.charAt(0))) {
                genS = genS.substring(1, genS.length());
            }
            try {
                hm.put("MOS_GENMAN", new Integer(Integer.parseInt(genS) + plus));
            }
            catch (Exception e) {
                Log.error("Problem with generation definition " + hm.get(TAG_GENERATION), e, this);
            }
            hm.remove(TAG_GENERATION);
        }
        return res;
    }

    public boolean check(DataImporter di) {
        return true;
    }
}

