/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.dataimport;

import de.hannse.netobjects.util.MyDate;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import jxl.Sheet;
import mausoleum.dataimport.DISheetImporter;
import mausoleum.dataimport.DataImporter;
import mausoleum.helper.DatumsParser;
import mausoleum.helper.Zeile;
import mausoleum.visit.Visit;

public class DISVisit
implements DISheetImporter {
    private static final String NAME = "mice";
    private static final String TAG_ID = "FOREIGN_ID";
    private static final String TAG_VISITS = "VISITS";
    private static final HashSet POSSIBLES = new HashSet<String>(Arrays.asList("FOREIGN_ID", "VISITS"));
    private static final HashSet MUSTS = new HashSet<String>(Arrays.asList("FOREIGN_ID"));
    private static String[] DICT = new String[]{"FOREIGN_ID", "IDO_FKEY"};
    private static final Integer MY_TYPE = new Integer(9);
    private static final Integer CAGE_TYPE = new Integer(2);
    private static final Integer MOUSE_TYPE = new Integer(1);
    private static int AP_CAGE_ID = 0;
    private static int AP_START = 1;
    private static int AP_END = 2;
    private static Comparator VISIT_ARR_COMPARER = new Comparator(){

        public int compare(Object arg0, Object arg1) {
            if (arg0 instanceof Object[] && arg1 instanceof Object[]) {
                int s1;
                Object[] oarr0 = (Object[])arg0;
                Object[] oarr1 = (Object[])arg1;
                int s0 = (Integer)oarr0[1];
                if (s0 < (s1 = ((Integer)oarr1[1]).intValue())) {
                    return -1;
                }
                if (s0 > s1) {
                    return 1;
                }
            }
            return 0;
        }
    };

    public static boolean distributeVisits(DataImporter di) {
        boolean res = true;
        HashMap visitHashMap = (HashMap)di.ivObjectMapsByType.get(MY_TYPE);
        if (visitHashMap != null) {
            if (!visitHashMap.isEmpty()) {
                Iterator iter = visitHashMap.keySet().iterator();
                while (iter.hasNext()) {
                    String mouseForeignID = (String)iter.next();
                    HashMap visitEntryHM = (HashMap)visitHashMap.get(mouseForeignID);
                    Vector mouseVisits = (Vector)visitEntryHM.get("MOS_VISIT");
                    if (mouseVisits == null || mouseVisits.isEmpty()) continue;
                    Iterator iterator = mouseVisits.iterator();
                    while (iterator.hasNext()) {
                        Object[] arr = (Object[])iterator.next();
                        String cageForeignID = (String)arr[AP_CAGE_ID];
                        HashMap mouse = di.getObject(MOUSE_TYPE, mouseForeignID);
                        HashMap cage = di.getObject(CAGE_TYPE, cageForeignID);
                        if (mouse == null || cage == null) continue;
                        Visit visit = new Visit();
                        visit.ivMouseID = (Long)mouse.get("IDO_ID");
                        visit.ivCageID = (Long)cage.get("IDO_ID");
                        visit.ivStartDate = new Date(new MyDate((Integer)arr[AP_START]).getTime());
                        boolean isBirth = false;
                        Date date = (Date)mouse.get("MOS_BIRTHDAY");
                        if (date != null) {
                            isBirth = (int)(date.getTime() / 86400000L) == (Integer)arr[AP_START];
                        }
                        visit.ivStartMode = isBirth ? 1 : 2;
                        Date date2 = visit.ivEndDate = arr[AP_END] == null ? null : new Date(new MyDate((Integer)arr[AP_END]).getTime());
                        if (visit.ivEndDate != null) {
                            visit.ivEndMode = iterator.hasNext() ? 2 : 8;
                        }
                        Visit[] visitArray = (Visit[])mouse.get("MOS_VISIT");
                        visitArray = Visit.addVisitToArray(visitArray, visit);
                        mouse.put("MOS_VISIT", visitArray);
                        visit = new Visit(visit);
                        visitArray = (Visit[])cage.get("CAG_VISIT");
                        visitArray = Visit.addVisitToArray(visitArray, visit);
                        cage.put("CAG_VISIT", visitArray);
                    }
                }
                visitHashMap.clear();
            }
            di.ivObjectMapsByType.remove(MY_TYPE);
        }
        return res;
    }

    public HashSet getMusts() {
        return MUSTS;
    }

    public Integer getObjectType() {
        return MY_TYPE;
    }

    public String[] getPolishDict() {
        return DICT;
    }

    public HashSet getPossibles() {
        return POSSIBLES;
    }

    public String[] getSheetNames() {
        return new String[]{NAME};
    }

    public boolean ownPolish(HashMap hm, DataImporter di, Sheet sheet, int row) {
        boolean res = true;
        String s = (String)hm.get(TAG_VISITS);
        if (s != null) {
            hm.remove(TAG_VISITS);
            Zeile z = new Zeile(s, '|');
            Vector<Object[]> visits = new Vector<Object[]>();
            int i = 0;
            while (i < z.size()) {
                Object[] varr = this.getSingleVisit(z.getStringNONEmpty(i, null), di, sheet, row);
                if (varr != null) {
                    visits.add(varr);
                } else {
                    res = false;
                }
                ++i;
            }
            if (res && !visits.isEmpty()) {
                Collections.sort(visits, VISIT_ARR_COMPARER);
                if (!this.checkForMoreUnfinisheds(visits)) {
                    di.ivBruddel.append("Sheet <" + sheet.getName() + "> row:" + (row + 1) + " Too many unfinished visits<" + s + ">\r\n");
                    res = false;
                } else if (!this.checkForOnlyLastUnfinished(visits)) {
                    di.ivBruddel.append("Sheet <" + sheet.getName() + "> row:" + (row + 1) + " Only last visit may be unfinished<" + s + ">\r\n");
                    res = false;
                } else if (!this.checkForOverlaps(visits)) {
                    di.ivBruddel.append("Sheet <" + sheet.getName() + "> row:" + (row + 1) + " Overlapping visits <" + s + ">\r\n");
                    res = false;
                } else {
                    hm.put("MOS_VISIT", visits);
                }
            }
        }
        return res;
    }

    private boolean checkForMoreUnfinisheds(Vector visarrs) {
        int sum = 0;
        Iterator iter = visarrs.iterator();
        while (iter.hasNext()) {
            Object[] vis = (Object[])iter.next();
            if (vis[AP_END] != null || ++sum <= 1) continue;
            return false;
        }
        return true;
    }

    private boolean checkForOnlyLastUnfinished(Vector visarrs) {
        if (visarrs.size() > 1) {
            int i = 0;
            while (i < visarrs.size() - 1) {
                Object[] vis = (Object[])visarrs.elementAt(i);
                if (vis[AP_END] == null) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    private boolean checkForOverlaps(Vector visarrs) {
        if (visarrs.size() > 1) {
            Object[] parr = (Object[])visarrs.firstElement();
            int i = 1;
            while (i < visarrs.size()) {
                int s1;
                Object[] aarr = (Object[])visarrs.elementAt(i);
                int e0 = (Integer)parr[AP_END];
                if (e0 > (s1 = ((Integer)aarr[AP_START]).intValue())) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    private Object[] getSingleVisit(String s, DataImporter di, Sheet sheet, int row) {
        if (s != null) {
            Zeile z = new Zeile(s, ';');
            if (z.size() != 3) {
                di.ivBruddel.append("Sheet <" + sheet.getName() + "> row:" + (row + 1) + " Malformed visit definition <" + s + ">\r\n");
            } else {
                String cageForeignID = z.getStringNONEmpty(0, null);
                if (cageForeignID == null) {
                    di.ivBruddel.append("Sheet <" + sheet.getName() + "> row:" + (row + 1) + " Malformed visit definition (empty cage ID) <" + s + ">\r\n");
                } else if (di.getObject(CAGE_TYPE, cageForeignID) == null) {
                    di.ivBruddel.append("Sheet <" + sheet.getName() + "> row:" + (row + 1) + " Malformed visit definition (unknown cage ID) <" + s + ">\r\n");
                } else {
                    String sd = z.getStringNONEmpty(1, null);
                    if (sd == null) {
                        di.ivBruddel.append("Sheet <" + sheet.getName() + "> row:" + (row + 1) + " Malformed visit definition (missing startDate) <" + s + ">\r\n");
                    } else {
                        int startTage = DatumsParser.getDatum(sd, Integer.MIN_VALUE);
                        if (startTage == Integer.MIN_VALUE) {
                            di.ivBruddel.append("Sheet <" + sheet.getName() + "> row:" + (row + 1) + " Malformed visit definition (malformed [not d.m.yyyy] start date) <" + s + ">\r\n");
                        } else {
                            int endTage = Integer.MIN_VALUE;
                            boolean endOK = true;
                            String ed = z.getStringNONEmpty(2, null);
                            if (ed != null && (endTage = DatumsParser.getDatum(ed, Integer.MIN_VALUE)) == Integer.MIN_VALUE) {
                                di.ivBruddel.append("Sheet <" + sheet.getName() + "> row:" + (row + 1) + " Malformed visit definition (malformed [not d.m.yyyy] end date) <" + s + ">\r\n");
                                endOK = false;
                            }
                            if (endOK) {
                                return new Object[]{cageForeignID, new Integer(startTage), endTage == Integer.MIN_VALUE ? null : new Integer(endTage)};
                            }
                            di.ivBruddel.append("Sheet <" + sheet.getName() + "> row:" + (row + 1) + " Malformed visit definition (malformed [not d.m.yyyy] date) <" + s + ">\r\n");
                        }
                    }
                }
            }
        }
        di.ivBruddel.append("Sheet <" + sheet.getName() + "> row:" + (row + 1) + " empty visit definition <" + s + ">\r\n");
        return null;
    }

    public boolean check(DataImporter di) {
        return true;
    }
}

