/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.datalayer;

import de.hannse.netobjects.datalayer.DataFile;
import de.hannse.netobjects.datalayer.DataLayer;
import de.hannse.netobjects.datalayer.GroupFileManager;
import de.hannse.netobjects.datalayer.SearchObject;
import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.objectstore.ObjectConsumer;
import de.hannse.netobjects.objectstore.ObjectIndex;
import de.hannse.netobjects.objectstore.SearchProcess;
import de.hannse.netobjects.tools.FileManager;
import de.hannse.netobjects.user.User;
import de.hannse.netobjects.util.Log;
import java.io.File;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import mausoleum.line.Line;
import mausoleum.mouse.Mouse;
import mausoleum.util.InstallationType;

public class DataLayerMausoleum
extends DataLayer {
    private final HashMap ivGroupDatafileHTs = new HashMap(10);
    static /* synthetic */ Class class$0;

    public DataLayerMausoleum() {
        Iterator iterator = this.getGroups(false).iterator();
        while (iterator.hasNext()) {
            this.initSingleGroupData((String)iterator.next());
        }
        if (InstallationType.hasNormalMode()) {
            try {
                this.addGroup("service", null);
            }
            catch (Exception e1) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("mausoleum.datalayer.DataLayerMausoleum");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Log.error("Problem creating service group", e1, clazz);
            }
        }
        if (InstallationType.hasTGMode()) {
            try {
                this.addGroup("tgservice", null);
            }
            catch (Exception e1) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("mausoleum.datalayer.DataLayerMausoleum");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Log.error("Problem creating transgenics service group", e1, clazz);
            }
        }
        new Thread(new Runnable(){

            public void run() {
                while (true) {
                    DataLayerMausoleum.clearOldBackupFiles(GroupFileManager.getBackupsPath());
                    try {
                        Thread.sleep(43200000L);
                    }
                    catch (Exception exception) {
                    }
                }
            }
        }).start();
    }

    public DataLayerMausoleum(String singleGroup) {
        File f = new File(GroupFileManager.getGroupDir(singleGroup));
        if (!f.exists() || !f.isDirectory()) {
            throw new IllegalArgumentException();
        }
        this.setSingleGroupName(singleGroup);
        this.initSingleGroupData(singleGroup);
    }

    public boolean addGroup(String groupname, User usi) throws Exception {
        boolean res = false;
        if (groupname != null && !this.getGroups(false).contains(groupname)) {
            String newGroupDir = GroupFileManager.getGroupDir(groupname);
            File of = new File(newGroupDir);
            if (!of.exists()) {
                GroupFileManager.prepareGroupDir(groupname);
                int[] types = DataLayerMausoleum.getTypen(groupname);
                int i = 0;
                while (i < types.length) {
                    this.addDataFile(groupname, types[i]);
                    ++i;
                }
                res = true;
                if (!groupname.equalsIgnoreCase("service")) {
                    if (groupname.equalsIgnoreCase("tgservice")) {
                        res = this.saveIDObject(Line.getBreederLine(groupname));
                    } else {
                        if (usi != null) {
                            User guru = new User();
                            guru.set("IDO_START_DATE", new Date());
                            guru.setInt("USR_MODE", 42);
                            guru.set("USR_PASSWORD", usi.get("USR_PASSWORD"));
                            guru.set("USR_NAME", usi.get("USR_NAME"));
                            guru.set("IDO_ID", new Long(1L));
                            guru.set("IDO_GROUP", groupname);
                            guru.commit(true);
                            res = this.saveIDObject(guru);
                        }
                        if (res) {
                            res = this.saveIDObject(Line.getBreederLine(groupname));
                        }
                    }
                }
            }
            if (!res) {
                FileManager.deleteDir(newGroupDir, true);
            }
        }
        if (res) {
            this.storeGroupName(groupname);
            GroupFileManager.prepareGroupDir(groupname);
        }
        return res;
    }

    public void initSingleGroupData(String group) {
        int[] types = DataLayerMausoleum.getTypen(group);
        int i = 0;
        while (i < types.length) {
            this.addDataFile(group, types[i]);
            ++i;
        }
        this.enterFromSafeties(group);
    }

    public boolean hasActualObjects(String groupname, int type) throws Exception {
        DataFile df = this.getDataFile(groupname, type);
        if (df != null) {
            return df.hasActiveEntries();
        }
        return false;
    }

    public int getLastID(String group, int type) throws Exception {
        DataFile df = this.getDataFile(group, type);
        if (df == null) {
            throw new Exception("No Datafile");
        }
        return df.getLastID();
    }

    public void performSearch(SearchObject so, SearchProcess sp) throws Exception {
        DataFile df = this.getDataFile(so.getGroup(), so.getType());
        if (df != null && (so.wantsAllObjects() || so.wantsOnlyDeadObjects())) {
            so.prepareForSearch(true);
            boolean checkObject = so.afterIndexCheckNecessary();
            boolean onlyDead = so.wantsOnlyDeadObjects();
            int oneBunch = 100;
            Vector<Long> erg = new Vector<Long>(oneBunch + 1);
            Enumeration en = df.getIDs();
            while (en.hasMoreElements() && sp.stillRunning()) {
                boolean useIt;
                Integer inti = (Integer)en.nextElement();
                boolean bl = useIt = !onlyDead || !df.getEntry((Object)inti).ivAlive;
                if (!useIt) continue;
                Long idL = new Long(inti.longValue());
                if (!(useIt &= so.checkWithIndex(so.getGroup(), idL))) continue;
                if (checkObject) {
                    IDObject iob = df.getObject(inti.longValue());
                    boolean bl2 = useIt = iob == null ? false : so.checkAfterIndex((Mouse)iob);
                }
                if (!useIt) continue;
                erg.addElement(idL);
                if (erg.size() < oneBunch) continue;
                sp.sendIntermediate(erg);
                erg.clear();
            }
            if (!erg.isEmpty()) {
                sp.sendIntermediate(erg);
                erg.clear();
            }
            so.searchFinished(true);
        }
    }

    public void deleteGroup(String groupname) {
        String dirName = GroupFileManager.getGroupDir(groupname);
        File dir = new File(dirName);
        if (dir.exists()) {
            FileManager.deleteDir(dirName, true);
        }
    }

    private void addDataFile(String group, int type) {
        Integer key;
        DataFile df;
        HashMap<Integer, DataFile> datafiles = (HashMap<Integer, DataFile>)this.ivGroupDatafileHTs.get(group);
        if (datafiles == null) {
            datafiles = new HashMap<Integer, DataFile>(15);
            this.ivGroupDatafileHTs.put(group, datafiles);
        }
        if ((df = (DataFile)datafiles.get(key = new Integer(type))) == null) {
            df = new DataFile(group, IDObject.getFilenameForTypeServerSide(type), type);
            datafiles.put(key, df);
        }
    }

    public boolean saveIDObject(IDObject iob) {
        DataFile df;
        if (cvActive && (df = this.getDataFile(iob.getGroup(), iob.getTyp())) != null) {
            ObjectIndex.HANDLER.handleNewObject(iob);
            return df.putObject(iob);
        }
        return false;
    }

    public DataFile getDataFile(String group, int type) {
        HashMap datafiles;
        if (group != null && (datafiles = (HashMap)this.ivGroupDatafileHTs.get(group)) != null) {
            return (DataFile)datafiles.get(new Integer(type));
        }
        return null;
    }

    public boolean provideNewIDToIDObject(IDObject iob) {
        DataFile df = this.getDataFile(iob.getGroup(), iob.getTyp());
        if (df == null) {
            return false;
        }
        iob.set("IDO_ID", new Long(df.getNewID()));
        return true;
    }

    public IDObject getObject(String group, int type, long id, boolean onlyActual) {
        DataFile df = this.getDataFile(group, type);
        if (df == null) {
            return null;
        }
        IDObject iob = df.getObject(id);
        if (onlyActual && iob.isDead()) {
            return null;
        }
        return iob;
    }

    public Hashtable getAllActualObjects(String group, int type) {
        DataFile df = this.getDataFile(group, type);
        if (df == null) {
            return new Hashtable();
        }
        return df.getAllActualObjects();
    }

    public Hashtable getAllObjects(String group, int type) {
        DataFile df = this.getDataFile(group, type);
        if (df == null) {
            return new Hashtable();
        }
        return df.getAllObjects();
    }

    public Vector getSortedIDs(String group, int type) {
        DataFile df = this.getDataFile(group, type);
        return df != null ? df.getSortedIDs() : new Vector();
    }

    public Vector getSortedActualIDs(String group, int type) {
        DataFile df = this.getDataFile(group, type);
        return df != null ? df.getSortedActualIDs() : new Vector();
    }

    public void giveSuccesivelyAllObjectsForCheck(String group, int type, ObjectConsumer consumer) {
        DataFile df = this.getDataFile(group, type);
        if (df != null) {
            df.giveAllObjectsToConsumerForCheck(consumer);
        }
    }
}

