/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.db;

import de.hannse.netobjects.tools.FileManager;
import de.hannse.netobjects.tools.StringHelper;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;

public class DBTest1 {
    public static void main(String[] args) {
        try {
            Class.forName("org.sqlite.JDBC");
            File f = new File(".");
            String fullPath = f.getAbsolutePath();
            fullPath = StringHelper.gSub(fullPath, "\\", "/");
            fullPath = String.valueOf(fullPath) + "/db";
            FileManager.prepareDirs("db");
            Connection conn = DriverManager.getConnection("jdbc:sqlite:" + fullPath + "/test.db");
            String sql = "CREATE TABLE IF NOT EXISTS test1 (ID BIGINT UNIQUE, NAME);";
            Statement stat = conn.createStatement();
            stat.executeUpdate(sql);
            PreparedStatement prep = conn.prepareStatement("insert into test1 values (?, ?);");
            long maxID = DBTest1.getMaxID(conn, "test1", "ID");
            long id = maxID == -1L ? 1L : maxID + 1L;
            prep.setLong(1, id);
            prep.setString(2, "Hanns-Eugen St\u00f6ffler");
            prep.addBatch();
            prep.setLong(1, ++id);
            prep.setString(2, "Sabine St\u00f6ffler");
            prep.addBatch();
            conn.setAutoCommit(false);
            prep.executeBatch();
            ResultSet rs = stat.executeQuery("select max(id) from test1;");
            while (rs.next()) {
                System.out.println("max(id) " + rs.getInt(1));
            }
            rs.close();
            conn.setAutoCommit(true);
            rs = stat.executeQuery("select * from test1;");
            while (rs.next()) {
                System.out.println("ID = " + rs.getInt("ID"));
                System.out.println("name = " + rs.getString("name"));
            }
            rs.close();
            conn.close();
        }
        catch (Exception e) {
            System.out.println("MURKS:" + e);
        }
    }

    private static long getMaxID(Connection conn, String table, String idTag) {
        long maxID = -1L;
        try {
            Statement stat = conn.createStatement();
            ResultSet rs = stat.executeQuery("select max(" + idTag + ") from " + table + ";");
            rs.next();
            maxID = rs.getLong(1);
            rs.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return maxID;
    }
}

