/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.extras;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class CTabbedPane
extends JTabbedPane {
    private static final long serialVersionUID = 1234234L;
    private int ivAktSel = -1;
    private int ivLastSel = -1;

    public static void main(String[] args) {
        JFrame jf = new JFrame();
        CTabbedPane ctb = new CTabbedPane();
        ctb.addTab("Sowas 1", (Component)new JPanel(), true);
        ctb.addTab("Sowas 2", (Component)new JPanel(), true);
        ctb.addTab("Sowas 3", (Component)new JPanel(), true);
        ctb.addTab("Sowas 4", (Component)new JPanel(), true);
        jf.getContentPane().add(ctb);
        jf.setBounds(10, 10, 600, 400);
        jf.setVisible(true);
    }

    public CTabbedPane() {
        this.setOpaque(false);
        this.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent e) {
                int tabNumber = CTabbedPane.this.getTabNummerIfIconHit(e);
                if (CTabbedPane.this.ivAktSel == -1 && tabNumber >= 0 && tabNumber == CTabbedPane.this.ivLastSel) {
                    CTabbedPane.this.ivAktSel = CTabbedPane.this.ivLastSel;
                    CTabbedPane.this.setArmed(CTabbedPane.this.ivAktSel, true);
                } else if (CTabbedPane.this.ivAktSel != -1 && tabNumber != CTabbedPane.this.ivAktSel) {
                    CTabbedPane.this.unarm();
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            public void mouseEntered(MouseEvent e) {
                int tabNumber;
                if (CTabbedPane.this.ivLastSel != -1 && (tabNumber = CTabbedPane.this.getTabNummerIfIconHit(e)) >= 0 && tabNumber == CTabbedPane.this.ivLastSel) {
                    CTabbedPane.this.ivAktSel = CTabbedPane.this.ivLastSel;
                    CTabbedPane.this.setArmed(CTabbedPane.this.ivAktSel, true);
                }
            }

            public void mouseExited(MouseEvent e) {
                CTabbedPane.this.unarm();
            }

            public void mousePressed(MouseEvent e) {
                if (e.getSource() instanceof JTabbedPane) {
                    int tabNumber;
                    boolean repaint = false;
                    if (CTabbedPane.this.ivAktSel != -1) {
                        CloseTabIcon cti = (CloseTabIcon)CTabbedPane.this.getIconAt(CTabbedPane.this.ivAktSel);
                        cti.ivIsArmed = false;
                        repaint = true;
                    }
                    if ((tabNumber = CTabbedPane.this.getTabNummerIfIconHit(e)) >= 0) {
                        CTabbedPane.this.ivAktSel = tabNumber;
                        CTabbedPane.this.ivLastSel = tabNumber;
                        CloseTabIcon cti = (CloseTabIcon)CTabbedPane.this.getIconAt(CTabbedPane.this.ivAktSel);
                        cti.ivIsArmed = true;
                        repaint = true;
                    }
                    if (repaint) {
                        CTabbedPane.this.repaint();
                    }
                }
            }

            public void mouseReleased(MouseEvent e) {
                if (CTabbedPane.this.ivAktSel != -1) {
                    int tabNumber;
                    boolean repaint = false;
                    CloseTabIcon cti = (CloseTabIcon)CTabbedPane.this.getIconAt(CTabbedPane.this.ivAktSel);
                    if (cti.ivIsArmed) {
                        cti.ivIsArmed = false;
                        repaint = true;
                    }
                    if ((tabNumber = CTabbedPane.this.getTabNummerIfIconHit(e)) == CTabbedPane.this.ivAktSel) {
                        CTabbedPane.this.removeTabAt(tabNumber);
                        repaint = true;
                    }
                    CTabbedPane.this.ivAktSel = -1;
                    CTabbedPane.this.ivLastSel = -1;
                    if (repaint) {
                        CTabbedPane.this.repaint();
                    }
                }
            }
        });
    }

    private void unarm() {
        if (this.ivAktSel != -1) {
            this.setArmed(this.ivAktSel, false);
            this.ivAktSel = -1;
        }
    }

    private void setArmed(int index, boolean armed) {
        CloseTabIcon cti = (CloseTabIcon)this.getIconAt(index);
        if (cti != null && cti.ivIsArmed != armed) {
            cti.ivIsArmed = armed;
            this.repaint();
        }
    }

    private int getTabNummerIfIconHit(MouseEvent e) {
        Rectangle rect;
        CloseTabIcon cti;
        int tabNumber = this.getUI().tabForCoordinate(this, e.getX(), e.getY());
        if (tabNumber >= 0 && (cti = (CloseTabIcon)this.getIconAt(tabNumber)) != null && (rect = cti.getBounds()).contains(e.getX(), e.getY())) {
            return tabNumber;
        }
        return -1;
    }

    public void addTab(String title, Component component) {
        this.addTab(title, component, null);
    }

    public void addTab(String title, Component component, boolean withCloseIcon) {
        if (withCloseIcon) {
            this.addTab(title, component, null);
        } else {
            super.addTab(title, component);
        }
    }

    public void addTab(String title, Component component, Icon extraIcon) {
        super.addTab(title, new CloseTabIcon(extraIcon), component);
    }

    public void selectLastTab() {
        int anz = this.getComponentCount();
        if (anz > 0) {
            this.setSelectedIndex(anz - 1);
        }
    }

    public Component[] getAllTabComponents() {
        return this.getComponents();
    }

    public static Color getLighterColor(Color c) {
        int r = (255 + c.getRed()) / 2;
        int g = (255 + c.getGreen()) / 2;
        int b = (255 + c.getBlue()) / 2;
        return new Color(r, g, b);
    }

    public static Color getDarkerColor(Color c) {
        int r = c.getRed() / 2;
        int g = c.getGreen() / 2;
        int b = c.getBlue() / 2;
        return new Color(r, g, b);
    }

    class CloseTabIcon
    implements Icon {
        private int x_pos;
        private int y_pos;
        private int width;
        private int height;
        private Icon fileIcon;
        public boolean ivIsArmed = false;

        public CloseTabIcon(Icon fileIcon) {
            this.fileIcon = fileIcon;
            this.width = 16;
            this.height = 16;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            this.x_pos = x;
            this.y_pos = y;
            Color orahmenCol = Color.white;
            Color urahmenCol = Color.black;
            Color kreuzCol = Color.white;
            Color fillCol = new Color(255, 90, 90, 220);
            if (this.ivIsArmed) {
                orahmenCol = Color.black;
                urahmenCol = Color.white;
                kreuzCol = Color.lightGray;
                fillCol = CTabbedPane.getDarkerColor(fillCol);
            }
            Color col = g.getColor();
            int y_p = y + 2;
            if (fillCol != null) {
                g.setColor(fillCol);
                g.fillRect(x + 1, y_p + 1, 12, 12);
            }
            g.setColor(orahmenCol);
            g.drawLine(x + 1, y_p, x + 12, y_p);
            g.drawLine(x, y_p + 1, x, y_p + 12);
            g.setColor(urahmenCol);
            g.drawLine(x + 1, y_p + 13, x + 12, y_p + 13);
            g.drawLine(x + 13, y_p + 1, x + 13, y_p + 12);
            if (fillCol != null) {
                if (this.ivIsArmed) {
                    g.setColor(CTabbedPane.getLighterColor(fillCol));
                } else {
                    g.setColor(CTabbedPane.getDarkerColor(fillCol));
                }
                g.drawLine(x + 1, y_p + 12, x + 12, y_p + 12);
                g.drawLine(x + 12, y_p + 1, x + 12, y_p + 12);
                if (this.ivIsArmed) {
                    g.setColor(CTabbedPane.getDarkerColor(fillCol));
                } else {
                    g.setColor(CTabbedPane.getLighterColor(fillCol));
                }
                g.drawLine(x + 1, y_p + 1, x + 12, y_p + 1);
                g.drawLine(x + 1, y_p + 1, x + 1, y_p + 12);
            }
            g.setColor(kreuzCol);
            g.drawLine(x + 3, y_p + 3, x + 10, y_p + 10);
            g.drawLine(x + 3, y_p + 4, x + 9, y_p + 10);
            g.drawLine(x + 4, y_p + 3, x + 10, y_p + 9);
            g.drawLine(x + 10, y_p + 3, x + 3, y_p + 10);
            g.drawLine(x + 10, y_p + 4, x + 4, y_p + 10);
            g.drawLine(x + 9, y_p + 3, x + 3, y_p + 9);
            g.setColor(col);
            if (this.fileIcon != null) {
                this.fileIcon.paintIcon(c, g, x + this.width, y_p);
            }
        }

        public int getIconWidth() {
            return this.width + (this.fileIcon != null ? this.fileIcon.getIconWidth() : 0);
        }

        public int getIconHeight() {
            return this.height;
        }

        public Rectangle getBounds() {
            return new Rectangle(this.x_pos, this.y_pos, this.width, this.height);
        }
    }
}

