/*
 * Decompiled with CFR 0.152.
 */
package mausoleum.extras;

import de.hannse.netobjects.datalayer.DataFile;
import de.hannse.netobjects.datalayer.GroupFileManager;
import de.hannse.netobjects.objectstore.IDObject;
import de.hannse.netobjects.objectstore.ObjectConsumer;
import de.hannse.netobjects.objectstore.ObjectIndex;
import de.hannse.netobjects.session.Session;
import de.hannse.netobjects.tools.FileManager;
import de.hannse.netobjects.tools.StringHelper;
import de.hannse.netobjects.user.User;
import de.hannse.netobjects.util.Babel;
import de.hannse.netobjects.util.MyDate;
import java.io.File;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import mausoleum.building.Building;
import mausoleum.cage.Cage;
import mausoleum.experiment.Experiment;
import mausoleum.idobjectgroup.IDObjectGroup;
import mausoleum.license.License;
import mausoleum.line.Line;
import mausoleum.locus.Locus;
import mausoleum.mail.Mail;
import mausoleum.mouse.Mouse;
import mausoleum.mouse.TaskExtended;
import mausoleum.rack.Rack;
import mausoleum.result.MResult;
import mausoleum.room.Room;
import mausoleum.strain.Strain;
import mausoleum.visit.Visit;

public class FilesToTester {
    private static final String SERVICE = "service";
    private static final String DATA = "data";
    private static final String DATA_SL = "/data/";
    private static final String TESTER2 = "tester2";
    private static final String DEMODATA = "demodata";
    private static final String TEMP = "temp";
    private static final String STANDARDTASKS = "standardtasks.stxt";
    private static final String ZTRE = "------------------------------------------------";
    private static final int LINE_LENGTH = 79;
    private static final int SUB_LINE_LENGTH = 69;
    private static final String SUB_LINE_PREFIX = "          ";
    private static final String[] DONT_COPY_DIRS = new String[]{"/protocols/", "/misc/", "/docs/", "/reports/", "/tasks/"};
    private static final String[] DELETE_IN_FILES = new String[]{"client", "log", "mros", "server", "windows"};
    private static final String[] DONT_COPY_FILES = new String[]{"Thumbs.db", ".DS_Store"};
    private static HashMap cvNewUserNames = new HashMap();
    private static long cvMillisOffset = 0L;
    private static int cvTageOffset = 0;
    private static boolean cvMitDebug = false;
    private static String cvLang = "en";
    private static HashMap cvZipEntries;
    private static String cvGroupOutput;

    public static void main(String[] args) {
        HashMap props = FilesToTester.screenArgs(args);
        cvMitDebug = FilesToTester.getProp(props, "debug", "false").equals("true");
        String outputDir = FilesToTester.getGroupTarget(props);
        cvLang = FilesToTester.getProp(props, "lang", cvLang);
        FileManager.prepareDirs(TEMP);
        IDObject.init();
        HashMap newsByOld = FilesToTester.getNewGroupsByOldGroup(props);
        Iterator iterator = newsByOld.keySet().iterator();
        while (iterator.hasNext()) {
            String oldGroup = (String)iterator.next();
            FilesToTester.createNewFromOld(outputDir, oldGroup, (String)newsByOld.get(oldGroup));
        }
        FilesToTester.print("Group change done");
        FilesToTester.makeTester2Group(outputDir);
        FilesToTester.makeServiceGroup(outputDir);
        System.exit(0);
    }

    private static HashMap screenArgs(String[] args) {
        HashMap<String, String> props = new HashMap<String, String>();
        int i = 0;
        while (i < args.length) {
            String s = args[i];
            int ind = s.indexOf("=");
            if (ind != -1) {
                String s1 = s.substring(0, ind).trim().toLowerCase();
                String s2 = s.substring(ind + 1, s.length()).trim();
                props.put(s1, s2);
            }
            ++i;
        }
        return props;
    }

    private static String getProp(HashMap props, String key, String defVal) {
        String res;
        if (props != null && key != null && (res = (String)props.get(key)) != null) {
            return res;
        }
        return defVal;
    }

    private static HashMap getNewGroupsByOldGroup(HashMap props) {
        HashMap<String, String> res = new HashMap<String, String>();
        int i = 0;
        while (i < 10) {
            String def = FilesToTester.getProp(props, "group" + i, null);
            if (def != null) {
                int ind = def.indexOf("#");
                if (ind != -1) {
                    String oldGroup = def.substring(0, ind).trim();
                    String newGroup = def.substring(ind + 1, def.length()).trim();
                    if (SERVICE.equals(oldGroup)) {
                        System.out.println("Service group cannot be transferred");
                        System.exit(1);
                    } else {
                        String zipName = "demodata/" + oldGroup + ".zip";
                        if (!new File(zipName).exists()) {
                            System.out.println("Invalid group directory");
                            System.exit(1);
                        } else if (TESTER2.equalsIgnoreCase(newGroup)) {
                            System.out.println("tester2 must be empty");
                            System.exit(1);
                        } else {
                            res.put(oldGroup, newGroup);
                        }
                    }
                } else {
                    System.out.println("Invalid group definition: " + def);
                    System.exit(1);
                }
            }
            ++i;
        }
        if (res.isEmpty()) {
            System.out.println("Group definitions are missing!");
            System.exit(1);
        }
        return res;
    }

    private static void createNewFromOld(String outputDir, String oldGroup, String newGroup) {
        cvGroupOutput = String.valueOf(outputDir) + newGroup;
        FileManager.prepareDirs(cvGroupOutput);
        int i = 0;
        while (i < DONT_COPY_DIRS.length) {
            FileManager.prepareDirs(String.valueOf(cvGroupOutput) + DONT_COPY_DIRS[i]);
            ++i;
        }
        String zipName = "demodata/" + oldGroup + ".zip";
        cvZipEntries = FileManager.digestZIPBytes(FileManager.getBytesFromFile(zipName));
        SessChecker sc = new SessChecker(oldGroup);
        cvTageOffset = sc.ivDaysOffset;
        cvMillisOffset = sc.ivMillisOffset;
        Iterator iterator = cvZipEntries.keySet().iterator();
        while (iterator.hasNext()) {
            String path = (String)iterator.next();
            if (path.contains(DATA_SL)) continue;
            boolean takeit = true;
            int i2 = 0;
            while (i2 < DONT_COPY_DIRS.length && takeit) {
                if (path.contains(DONT_COPY_DIRS[i2])) {
                    takeit = false;
                }
                ++i2;
            }
            i2 = 0;
            while (i2 < DONT_COPY_FILES.length && takeit) {
                if (path.endsWith(DONT_COPY_FILES[i2])) {
                    takeit = false;
                }
                ++i2;
            }
            if (!takeit) continue;
            String tpath = FilesToTester.makeTesterPath(path);
            FilesToTester.print("copy file " + path);
            FilesToTester.print("       to " + tpath);
            FileManager.saveBytesToFile(tpath, (byte[])cvZipEntries.get(path));
        }
        FilesToTester.print("files copied starting Wandler");
        new Wandler(oldGroup, outputDir, newGroup);
        FilesToTester.print("Wandler done");
    }

    private static String getGroupTarget(HashMap props) {
        String outputMausoleumDir = FilesToTester.getProp(props, "target", "D:\\Developer\\Projekte\\EMBL\\MausoleumDemo");
        outputMausoleumDir = StringHelper.gSub(outputMausoleumDir, "\\", "/");
        String outputFilesDir = String.valueOf(outputMausoleumDir) + "/files";
        int i = 0;
        while (i < DELETE_IN_FILES.length) {
            String potDir = String.valueOf(outputFilesDir) + "/" + DELETE_IN_FILES[i];
            if (new File(potDir).exists()) {
                FileManager.deleteDir(potDir, true);
            }
            ++i;
        }
        String outputDir = String.valueOf(outputMausoleumDir) + "/files/server/";
        if (new File(outputDir).exists()) {
            FileManager.deleteDir(outputDir, true);
        }
        FileManager.prepareDirs(outputDir);
        return outputDir;
    }

    private static void makeTester2Group(String outputDir) {
        FilesToTester.print("makeTester2Group start");
        DataFile newFile = FilesToTester.initGroupAndGetUserFile(outputDir, TESTER2);
        FilesToTester.createUser(newFile, 1L, TESTER2, 42);
        FilesToTester.print("makeTester2Group done");
    }

    private static void makeServiceGroup(String outputDir) {
        FilesToTester.print("makeServiceGroup start");
        DataFile newFile = FilesToTester.initGroupAndGetUserFile(outputDir, SERVICE);
        FilesToTester.createUser(newFile, 1L, "head123", 500);
        FilesToTester.createUser(newFile, 2L, "aaa123", 550);
        String tasksPath = String.valueOf(outputDir) + SERVICE + "/tasks";
        FileManager.prepareDirs(tasksPath);
        FileManager.copy("demodata/standardtasks.stxt", String.valueOf(tasksPath) + "/" + STANDARDTASKS);
        FilesToTester.print("makeServiceGroup done");
    }

    private static DataFile initGroupAndGetUserFile(String outputDir, String group) {
        String dataNDir = String.valueOf(outputDir) + group + "/" + DATA;
        FileManager.prepareDirs(dataNDir);
        DataFile newFile = new DataFile(group, 6, String.valueOf(dataNDir) + "/" + IDObject.getFilenameForTypeServerSide(6) + ".data");
        newFile.ivWriteProtocol = false;
        return newFile;
    }

    private static void createUser(DataFile newFile, long id, String name, int mode) {
        User user = new User();
        user.set("IDO_ID", new Long(id));
        user.set("IDO_START_DATE", new Date());
        user.set("IDO_TYPE_ID", new Integer(6));
        user.set("IDO_GROUP", newFile.getGroup());
        user.set("USR_NAME", name);
        user.set("USR_PASSWORD", StringHelper.encrypt(name));
        user.set("USR_MODE", new Integer(mode));
        user.commit(true);
        newFile.putObject(user);
    }

    private static String makeTesterPath(String path) {
        int ind = path.indexOf("/");
        return String.valueOf(cvGroupOutput) + "/" + path.substring(ind + 1, path.length());
    }

    private static void print(String s) {
        if (cvMitDebug) {
            if (s.length() < 79) {
                System.out.println(s);
            } else {
                System.out.println(s.substring(0, 79));
                s = s.substring(79, s.length());
                while (s.length() > 69) {
                    System.out.println(SUB_LINE_PREFIX + s.substring(0, 69));
                    s = s.substring(69, s.length());
                }
                System.out.println(SUB_LINE_PREFIX + s);
            }
        }
    }

    public static class SessChecker
    implements ObjectConsumer {
        private long ivLastMillis = -1L;
        public long ivMillisOffset;
        public int ivDaysOffset;
        private int ivCheckedObjects = 0;
        private int ivCheckedDates = 0;

        public SessChecker(String groupName) {
            long aktMillis = System.currentTimeMillis();
            int aktTag = (int)(aktMillis / 86400000L);
            FilesToTester.print(FilesToTester.ZTRE);
            FilesToTester.print("SessChecker mit groupDir: " + groupName);
            String sessionPath = String.valueOf(groupName) + "/" + FilesToTester.DATA + "/session.data";
            FilesToTester.print("             sessionPath: " + sessionPath);
            byte[] arr = (byte[])cvZipEntries.get(sessionPath);
            if (arr != null) {
                String path = "temp/session.data";
                FileManager.saveBytesToFile(path, arr);
                DataFile sessFile = new DataFile(groupName, 5, path);
                sessFile.giveAllObjectsToConsumer(this);
                FilesToTester.print("         checked Objects: " + this.ivCheckedObjects);
                FilesToTester.print("           checked Dates: " + this.ivCheckedDates);
                FilesToTester.print("               last Date: " + new Date(this.ivLastMillis));
                FileManager.deleteFile(path);
            } else {
                FilesToTester.print("            Datei fehlt!: " + sessionPath);
            }
            if (this.ivLastMillis == -1L) {
                this.ivLastMillis = aktMillis;
            }
            int lastTag = (int)(this.ivLastMillis / 86400000L);
            FilesToTester.print("                last Tag: " + new MyDate(lastTag));
            this.ivDaysOffset = aktTag - lastTag;
            this.ivMillisOffset = 86400000L * (long)this.ivDaysOffset;
            FilesToTester.print("             Tage Offset: " + this.ivDaysOffset);
            FilesToTester.print("           Millis Offset: " + this.ivMillisOffset);
        }

        public void handleNewObjects(Vector idObjects) {
            Iterator iterator = idObjects.iterator();
            while (iterator.hasNext()) {
                this.handleNewObject((IDObject)iterator.next());
            }
        }

        public void handleNewObject(IDObject obj) {
            ++this.ivCheckedObjects;
            Date d = obj.getDate("IDO_END_DATE");
            if (d != null) {
                ++this.ivCheckedDates;
                long end = d.getTime();
                if (end > this.ivLastMillis) {
                    this.ivLastMillis = end;
                }
            }
        }

        public void objectLeftServiceRoom(int objectTyp, String group, HashSet objectIDs) {
        }
    }

    public static class Wandler
    implements ObjectConsumer {
        private DataFile ivOldFile;
        private DataFile ivNewFile;
        private String ivOldGroup;
        private String ivNewGroup;
        private final String ivIndexPath;
        private int ivObjCount = 0;
        private int ivGuruCount = 0;
        private int ivMasterCount = 0;
        private int ivSHeadCount = 0;
        private int ivSCTCount = 0;
        private int ivBreederCount = 0;
        private String[] ivTagAndPrefix = null;

        public Wandler(String oldGroup, String targetOhneGroup, String newGroup) {
            FilesToTester.print("Wandler " + oldGroup + " to " + newGroup);
            this.ivOldGroup = oldGroup;
            this.ivNewGroup = newGroup;
            String dataNDir = String.valueOf(targetOhneGroup) + newGroup + "/" + FilesToTester.DATA;
            FileManager.prepareDirs(dataNDir);
            this.ivIndexPath = String.valueOf(dataNDir) + "/" + GroupFileManager.getIndexFilename();
            FileManager.pureAppend(this.ivIndexPath, String.valueOf(ObjectIndex.getAktVerion()) + "\n");
            Iterator iterator = cvZipEntries.keySet().iterator();
            while (iterator.hasNext()) {
                String path = (String)iterator.next();
                if (!path.contains(FilesToTester.DATA_SL)) continue;
                FilesToTester.print(FilesToTester.ZTRE);
                FilesToTester.print("check pot data file " + path);
                if (path.endsWith(".data")) {
                    int type;
                    String fileName = path;
                    int ind = path.lastIndexOf("/");
                    if (ind != -1) {
                        fileName = path.substring(ind + 1, path.length());
                    }
                    if (fileName.startsWith("mail") || (type = IDObject.getTypeForStringServerSide(fileName.substring(0, fileName.length() - 5))) <= 0) continue;
                    String tempPath = "temp/" + fileName;
                    FileManager.saveBytesToFile(tempPath, (byte[])cvZipEntries.get(path));
                    FilesToTester.print("copy data file " + path);
                    String nfPath = String.valueOf(dataNDir) + "/" + fileName;
                    FilesToTester.print("            to " + nfPath);
                    this.ivOldFile = new DataFile(oldGroup, type, tempPath);
                    this.ivNewFile = new DataFile(newGroup, type, nfPath);
                    this.ivOldFile.ivCheckMice = false;
                    this.ivNewFile.ivCheckMice = false;
                    this.ivOldFile.ivWriteProtocol = false;
                    this.ivNewFile.ivWriteProtocol = false;
                    this.ivTagAndPrefix = this.getNameKeyAndPrefix(type);
                    this.ivObjCount = 0;
                    this.ivOldFile.giveAllObjectsToConsumer(this);
                    this.ivOldFile.dispose();
                    this.ivNewFile.dispose();
                    FileManager.deleteFile(tempPath);
                    continue;
                }
                if (path.endsWith(GroupFileManager.getIndexFilename())) {
                    FilesToTester.print("dont copy  " + path);
                    continue;
                }
                if (path.endsWith(".sat")) {
                    FilesToTester.print("dont copy  " + path);
                    continue;
                }
                boolean takeit = true;
                int i = 0;
                while (i < DONT_COPY_FILES.length && takeit) {
                    if (path.endsWith(DONT_COPY_FILES[i])) {
                        takeit = false;
                    }
                    ++i;
                }
                if (takeit) {
                    String tpath = FilesToTester.makeTesterPath(path);
                    FilesToTester.print("copy non data " + path);
                    FilesToTester.print("           to " + tpath);
                    FileManager.saveBytesToFile(tpath, (byte[])cvZipEntries.get(path));
                    continue;
                }
                FilesToTester.print("dont copy  " + path);
            }
            FilesToTester.print("Wandler zipEntries durch");
        }

        public void handleNewObjects(Vector idObjects) {
            Iterator iterator = idObjects.iterator();
            while (iterator.hasNext()) {
                this.handleNewObject((IDObject)iterator.next());
            }
        }

        public void handleNewObject(IDObject obj) {
            ++this.ivObjCount;
            obj.set("IDO_GROUP", this.ivNewGroup);
            obj.set("IDO_SERVID", null);
            obj.set("IDO_DOK", null);
            obj.set("IDO_FKEY", null);
            this.manageDate(obj, "IDO_START_DATE", this.ivNewGroup);
            this.manageDate(obj, "IDO_END_DATE", this.ivNewGroup);
            if (this.ivTagAndPrefix != null) {
                long relevantNumber = this.getRelevantNumber(obj);
                String relNum = String.valueOf(relevantNumber < 10L ? "0" : "") + relevantNumber;
                obj.set(this.ivTagAndPrefix[0], String.valueOf(Babel.get(this.ivTagAndPrefix[1], cvLang).toLowerCase()) + "_" + relNum);
            }
            if (obj instanceof User) {
                User user = (User)obj;
                int typ = user.getInt("USR_MODE", 0);
                String oldname = user.getName();
                String name = "user" + this.ivObjCount;
                if (typ == 500) {
                    name = "head" + this.ivSHeadCount;
                    ++this.ivSHeadCount;
                } else if (typ == 550) {
                    name = "sct" + this.ivSCTCount;
                    ++this.ivSCTCount;
                } else if (typ == 42) {
                    name = this.ivGuruCount == 0 ? "tester" : "guru" + this.ivGuruCount;
                    ++this.ivGuruCount;
                } else if (typ == 2) {
                    name = "master" + this.ivMasterCount;
                    ++this.ivMasterCount;
                }
                obj.set("USR_NAME", name);
                obj.set("USR_PASSWORD", StringHelper.encrypt(name));
                cvNewUserNames.put(String.valueOf(this.ivOldGroup) + "#" + oldname, name);
                obj.set("USR_EMAIL", null);
                obj.set("USR_LANGUAGE", cvLang);
            } else if (!(obj instanceof Mail)) {
                if (obj instanceof Mouse) {
                    this.manageDate(obj, "MOS_BIRTHDAY", this.ivNewGroup);
                    this.manageDate(obj, "MOS_VISIT", this.ivNewGroup);
                    this.manageDate(obj, "MOS_PLUGDATE", this.ivNewGroup);
                    this.manageDate(obj, "MOS_ALLPLUGDATES", this.ivNewGroup);
                    this.manageDate(obj, "MOS_KID_BD", this.ivNewGroup);
                    this.manageDate(obj, "MOS_TASKSEXT", this.ivNewGroup);
                    this.manageDate(obj, "MOS_MRESULTS", this.ivNewGroup);
                    obj.set("MOS_COMMENT", null);
                    FileManager.pureAppend(this.ivIndexPath, String.valueOf(obj.getID()) + "#" + ObjectIndex.getIndexInfo((Mouse)obj) + "\n");
                } else if (obj instanceof Cage) {
                    this.manageDate(obj, "CAG_VISIT", this.ivNewGroup);
                    this.manageDate(obj, "CAG_TASKS", this.ivNewGroup);
                    obj.set("CAG_COMMENT", null);
                } else if (obj instanceof Rack) {
                    obj.set("RCK_OCC", null);
                } else if (obj instanceof Session) {
                    Vector coms = (Vector)obj.get("SES_COMMAND");
                    if (coms != null) {
                        Vector<String> v = new Vector<String>(coms.size());
                        Iterator iterator = coms.iterator();
                        while (iterator.hasNext()) {
                            String com = (String)iterator.next();
                            if (com.startsWith("[")) {
                                try {
                                    int ind = com.indexOf("]");
                                    if (ind != -1) {
                                        String hinten = com.substring(ind + 1, com.length());
                                        String vorne = com.substring(1, ind);
                                        long millis = 0L;
                                        int ind2 = vorne.indexOf("|");
                                        millis = ind2 != -1 ? Long.parseLong(vorne.substring(0, ind2)) + cvMillisOffset : Long.parseLong(vorne) + cvMillisOffset;
                                        com = "[" + millis + "]" + hinten;
                                    }
                                }
                                catch (Exception e) {
                                    FilesToTester.print("problem com " + com + " -> " + e);
                                }
                            }
                            v.add(com);
                        }
                        obj.set("SES_COMMAND", v);
                    }
                } else if (obj instanceof Line) {
                    obj.set("LIN_DESCRIPTION", null);
                    obj.set("LIN_ETPREFIX", null);
                    Line line = (Line)obj;
                    if (line.isBreeder()) {
                        if (this.ivBreederCount == 0) {
                            line.set("LIN_NAME", "breeder");
                        } else {
                            line.set("LIN_NAME", "breeder_" + this.ivBreederCount);
                        }
                        ++this.ivBreederCount;
                    }
                } else if (obj instanceof Strain) {
                    obj.set("STR_DESCRIPTION", null);
                    obj.set("STR_ETPREFIX", null);
                } else if (obj instanceof Room) {
                    obj.set("ROM_DESC", null);
                } else if (obj instanceof Experiment) {
                    obj.set("EXP_DESC", null);
                } else if (obj instanceof Locus) {
                    obj.set("LOC_ENSEMBL_NAME", null);
                    obj.set("LOC_MGI_NAME", null);
                    obj.set("LOC_DESCRIPTION", null);
                    obj.set("LOC_ALLEL_DESC", null);
                } else if (obj instanceof License) {
                    obj.set("LIC_LH", "The License-Holder");
                    obj.set("LIC_CO", null);
                    this.manageDate(obj, "LIC_SD", this.ivNewGroup);
                    this.manageDate(obj, "LIC_ED", this.ivNewGroup);
                } else if (obj instanceof IDObjectGroup) {
                    obj.set("IOG_COM", null);
                } else if (obj instanceof Building) {
                    obj.set("BLD_DESC", null);
                }
            }
            obj.commit(false);
            this.ivNewFile.putObject(obj);
        }

        private long getRelevantNumber(IDObject ido) {
            long sid;
            if (!ido.getGroup().equals(FilesToTester.SERVICE) && (sid = ido.getLong("IDO_SERVID", -1L)) != -1L) {
                return sid;
            }
            return ido.getID();
        }

        private String[] getNameKeyAndPrefix(int type) {
            if (type == 3) {
                return new String[]{"RCK_NAME", "rack"};
            }
            if (type == 7) {
                return new String[]{"LIN_NAME", "line"};
            }
            if (type == 8) {
                return new String[]{"STR_NAME", "strain"};
            }
            if (type == 10) {
                return new String[]{"ROM_NAME", "room"};
            }
            if (type == 12) {
                return new String[]{"EXP_NAME", "experiment"};
            }
            if (type == 14) {
                return new String[]{"LOC_NAME", "locus"};
            }
            if (type == 16) {
                return new String[]{"LIC_NAME", "license"};
            }
            if (type == 22) {
                return new String[]{"BLD_NAME", "building"};
            }
            if (type == 19) {
                return new String[]{"IOG_N", "coll"};
            }
            return null;
        }

        private void manageDate(IDObject ido, String tag, String newGroup) {
            Object ooo = ido.get(tag);
            if (ooo != null) {
                if (ooo instanceof Date) {
                    Date date = (Date)ooo;
                    ido.set(tag, new Date(date.getTime() + cvMillisOffset));
                } else if (ooo instanceof Integer) {
                    Integer day = (Integer)ooo;
                    ido.set(tag, new Integer(day + cvTageOffset));
                } else if (ooo instanceof Long) {
                    Long millis = (Long)ooo;
                    ido.set(tag, new Long(millis + cvMillisOffset));
                } else if (ooo instanceof Visit[]) {
                    Visit[] arr = (Visit[])ooo;
                    Visit[] nrr = new Visit[arr.length];
                    int i = 0;
                    while (i < arr.length) {
                        Visit v = new Visit(arr[i]);
                        v.ivStartDate = v.ivStartDate == null ? null : new Date(v.ivStartDate.getTime() + cvMillisOffset);
                        v.ivEndDate = v.ivEndDate == null ? null : new Date(v.ivEndDate.getTime() + cvMillisOffset);
                        nrr[i] = v;
                        ++i;
                    }
                    ido.set(tag, nrr);
                } else if (ooo instanceof int[]) {
                    int[] arr = (int[])ooo;
                    int[] nrr = new int[arr.length];
                    int i = 0;
                    while (i < arr.length) {
                        nrr[i] = arr[i] == 0 ? 0 : arr[i] + cvTageOffset;
                        ++i;
                    }
                    ido.set(tag, nrr);
                } else if (ooo instanceof TaskExtended[]) {
                    TaskExtended[] arr = (TaskExtended[])ooo;
                    TaskExtended[] nrr = null;
                    Vector<TaskExtended> v = new Vector<TaskExtended>(arr.length);
                    int i = 0;
                    while (i < arr.length) {
                        if (arr[i].ivProcType < 5001) {
                            v.add(arr[i]);
                        }
                        ++i;
                    }
                    if (!v.isEmpty()) {
                        nrr = new TaskExtended[v.size()];
                        i = 0;
                        while (i < nrr.length) {
                            nrr[i] = new TaskExtended((TaskExtended)v.elementAt(i));
                            if (nrr[i].ivDatum != 0) {
                                nrr[i].ivDatum += cvTageOffset;
                            }
                            if (nrr[i].ivIssueMillis != 0L) {
                                nrr[i].ivIssueMillis += cvMillisOffset;
                            }
                            if (this.ivOldGroup.equals(nrr[i].ivIssuerGroup)) {
                                nrr[i].ivIssuerGroup = newGroup;
                            } else {
                                nrr[i].ivIssuerGroup = null;
                                nrr[i].ivIssuerID = 0L;
                            }
                            if (this.ivOldGroup.equals(nrr[i].ivErledigerGroup)) {
                                nrr[i].ivErledigerGroup = newGroup;
                            } else {
                                nrr[i].ivErledigerGroup = null;
                                nrr[i].ivErledigerID = 0L;
                            }
                            if (this.ivOldGroup.equals(nrr[i].ivFavoritGroup)) {
                                nrr[i].ivFavoritGroup = newGroup;
                            } else {
                                nrr[i].ivFavoritGroup = null;
                                nrr[i].ivFavoritID = 0L;
                            }
                            nrr[i].ivComment = null;
                            if (nrr[i].ivFinishMillis != 0L) {
                                nrr[i].ivFinishMillis += cvMillisOffset;
                            }
                            if (nrr[i].ivPeriodEnd != Integer.MIN_VALUE) {
                                nrr[i].ivPeriodEnd += cvTageOffset;
                            }
                            ++i;
                        }
                    }
                    ido.set(tag, nrr);
                } else if (ooo instanceof Vector) {
                    Vector oldVec = (Vector)ooo;
                    Vector<MResult> newVec = new Vector<MResult>(oldVec.size());
                    Iterator iterator = oldVec.iterator();
                    while (iterator.hasNext()) {
                        Object vo = iterator.next();
                        if (!(vo instanceof MResult)) continue;
                        MResult mres = (MResult)vo;
                        newVec.add(new MResult(mres, mres.ivDate + cvTageOffset, "Scientist"));
                    }
                    ido.set(tag, newVec);
                }
            }
        }

        public void objectLeftServiceRoom(int objectTyp, String group, HashSet objectIDs) {
        }
    }
}

